/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private Writer out;
    char[] buffer;
    int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.localFlush();
            this.out.close();
            this.buffer = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new IOException("Stream closed");
            }
            this.localFlush();
            this.out.flush();
            return;
        }
    }

    public void newLine() throws IOException {
        this.write(System.getProperty("line.separator"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new IOException("Stream closed");
            }
            this.buffer[this.count++] = (char)n;
            if (this.count == this.buffer.length) {
                this.localFlush();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new IOException("Stream closed");
            }
            if (this.count + n2 > this.buffer.length) {
                this.localFlush();
                this.out.write(cArray, n, n2);
            } else {
                System.arraycopy(cArray, n, this.buffer, this.count, n2);
                this.count += n2;
                if (this.count == this.buffer.length) {
                    this.localFlush();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new IOException("Stream closed");
            }
            if (this.count + n2 > this.buffer.length) {
                this.localFlush();
                this.out.write(string, n, n2);
            } else {
                string.getChars(n, n + n2, this.buffer, this.count);
                this.count += n2;
                if (this.count == this.buffer.length) {
                    this.localFlush();
                }
            }
            return;
        }
    }

    private final void localFlush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }

    public BufferedWriter(Writer writer) {
        this(writer, 8192);
    }

    public BufferedWriter(Writer writer, int n) {
        super(writer.lock);
        this.out = writer;
        this.buffer = new char[n];
        this.count = 0;
    }
}

