/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.classpath.SystemProperties;
import gnu.java.security.OID;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class X509CertSelector
implements CertSelector,
Cloneable {
    private static final String AUTH_KEY_ID = "2.5.29.35";
    private static final String SUBJECT_KEY_ID = "2.5.29.14";
    private static final String NAME_CONSTRAINTS_ID = "2.5.29.30";
    private int basicConstraints = -1;
    private X509Certificate cert;
    private BigInteger serialNo;
    private X500Principal issuer;
    private X500Principal subject;
    private byte[] subjectKeyId;
    private byte[] authKeyId;
    private boolean[] keyUsage;
    private Date certValid;
    private OID sigId;
    private PublicKey subjectKey;
    private X509EncodedKeySpec subjectKeySpec;
    private Set keyPurposeSet;
    private List altNames;
    private boolean matchAllNames;
    private byte[] nameConstraints;
    private Set policy;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$cert$X509CertSelector;

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNo = bigInteger;
    }

    public String getIssuerAsString() {
        if (this.issuer != null) {
            return this.issuer.getName();
        }
        return null;
    }

    public byte[] getIssuerAsBytes() throws IOException {
        if (this.issuer != null) {
            return this.issuer.getEncoded();
        }
        return null;
    }

    public void setIssuer(String string) throws IOException {
        if (string != null) {
            try {
                this.issuer = new X500Principal(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        } else {
            this.issuer = null;
        }
    }

    public void setIssuer(byte[] byArray) throws IOException {
        if (byArray != null) {
            try {
                this.issuer = new X500Principal(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        } else {
            this.issuer = null;
        }
    }

    public String getSubjectAsString() {
        if (this.subject != null) {
            return this.subject.getName();
        }
        return null;
    }

    public byte[] getSubjectAsBytes() throws IOException {
        if (this.subject != null) {
            return this.subject.getEncoded();
        }
        return null;
    }

    public void setSubject(String string) throws IOException {
        if (string != null) {
            try {
                this.subject = new X500Principal(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        } else {
            this.subject = null;
        }
    }

    public void setSubject(byte[] byArray) throws IOException {
        if (byArray != null) {
            try {
                this.subject = new X500Principal(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        } else {
            this.subject = null;
        }
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.subjectKeyId != null) {
            return (byte[])this.subjectKeyId.clone();
        }
        return null;
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.subjectKeyId = byArray != null ? (byte[])byArray.clone() : null;
    }

    public byte[] getAuthorityKeyIdentifier() {
        if (this.authKeyId != null) {
            return (byte[])this.authKeyId.clone();
        }
        return null;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.authKeyId = byArray != null ? (byte[])byArray.clone() : null;
    }

    public Date getCertificateValid() {
        if (this.certValid != null) {
            return (Date)this.certValid.clone();
        }
        return null;
    }

    public void setCertificateValid(Date date) {
        this.certValid = date != null ? (Date)date.clone() : null;
    }

    public Date getPrivateKeyValid() {
        return null;
    }

    public void setPrivateKeyValid(Date date) {
    }

    public String getSubjectPublicKeyAlgID() {
        return String.valueOf(this.sigId);
    }

    public void setSubjectPublicKeyAlgID(String string) throws IOException {
        if (string != null) {
            try {
                OID oID = new OID(string);
                int[] nArray = oID.getIDs();
                if (!X509CertSelector.checkOid(nArray)) {
                    throw new IOException("malformed OID: " + string);
                }
                this.sigId = oID;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IOException iOException = new IOException("malformed OID: " + string);
                iOException.initCause(illegalArgumentException);
                throw iOException;
            }
        } else {
            this.sigId = null;
        }
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectKey;
    }

    public void setSubjectPublicKey(PublicKey publicKey) {
        this.subjectKey = publicKey;
        if (publicKey == null) {
            this.subjectKeySpec = null;
            return;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("X.509");
            Class clazz = class$java$security$spec$X509EncodedKeySpec;
            if (clazz == null) {
                clazz = class$java$security$spec$X509EncodedKeySpec = X509CertSelector.class("[Ljava.security.spec.X509EncodedKeySpec;", false);
            }
            this.subjectKeySpec = (X509EncodedKeySpec)keyFactory.getKeySpec(publicKey, clazz);
        }
        catch (Exception exception) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
        }
    }

    public void setSubjectPublicKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
            return;
        }
        try {
            this.subjectKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("X.509");
            this.subjectKey = keyFactory.generatePublic(this.subjectKeySpec);
        }
        catch (Exception exception) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage != null) {
            return (boolean[])this.keyUsage.clone();
        }
        return null;
    }

    public void setKeyUsage(boolean[] blArray) {
        this.keyUsage = blArray != null ? (boolean[])blArray.clone() : null;
    }

    public Set getExtendedKeyUsage() {
        if (this.keyPurposeSet != null) {
            return Collections.unmodifiableSet(this.keyPurposeSet);
        }
        return null;
    }

    public void setExtendedKeyUsage(Set set) throws IOException {
        if (set == null) {
            this.keyPurposeSet = null;
            return;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2 = iterator.next();
            if (!(object2 instanceof String)) {
                throw new IOException("not a string: " + object2);
            }
            try {
                OID oID = new OID((String)object2);
                object = oID.getIDs();
                if (X509CertSelector.checkOid((int[])object)) continue;
                throw new IOException("malformed OID: " + object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = new IOException("malformed OID: " + object2);
                ((Throwable)object).initCause(illegalArgumentException);
                throw object;
            }
        }
        this.keyPurposeSet = hashSet;
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllNames;
    }

    public void setMatchAllSubjectAltNames(boolean bl) {
        this.matchAllNames = bl;
    }

    public void setSubjectAlternativeNames(Collection collection) throws IOException {
        if (collection == null) {
            this.altNames = null;
            return;
        }
        ArrayList arrayList = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof List && ((List)object).size() == 2 && ((List)object).get(0) instanceof Integer && ((List)object).get(1) instanceof String && ((List)object).get(1) instanceof byte[])) {
                throw new IOException("illegal alternative name: " + object);
            }
            Integer n = (Integer)((List)object).get(0);
            if (n < 0 || n > 8) {
                throw new IOException("illegal alternative name: " + object + ", bad id: " + n);
            }
            arrayList.add(new ArrayList((List)object));
        }
        this.altNames = arrayList;
    }

    public void addSubjectAlternativeName(int n, String string) throws IOException {
        if (n < 0 || n > 8 || string == null) {
            throw new IOException("illegal alternative name");
        }
        if (this.altNames == null) {
            this.altNames = new LinkedList();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Integer(n));
        arrayList.add(string);
        this.altNames.add(arrayList);
    }

    public void addSubjectAlternativeName(int n, byte[] byArray) throws IOException {
        if (n < 0 || n > 8 || byArray == null) {
            throw new IOException("illegal alternative name");
        }
        if (this.altNames == null) {
            this.altNames = new LinkedList();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Integer(n));
        arrayList.add(byArray);
        this.altNames.add(arrayList);
    }

    public byte[] getNameConstraints() {
        if (this.nameConstraints != null) {
            return (byte[])this.nameConstraints.clone();
        }
        return null;
    }

    public void setNameConstraints(byte[] byArray) throws IOException {
        this.nameConstraints = byArray != null ? (byte[])byArray.clone() : null;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public void setBasicConstraints(int n) {
        if (n < -1) {
            n = -1;
        }
        this.basicConstraints = n;
    }

    public boolean match(Certificate certificate) {
        Object object;
        Object object2;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (this.cert != null) {
            try {
                object2 = this.cert.getEncoded();
                object = x509Certificate.getEncoded();
                if (!Arrays.equals((byte[])object2, (byte[])object)) {
                    return false;
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return false;
            }
        }
        if (this.serialNo != null && !this.serialNo.equals(x509Certificate.getSerialNumber())) {
            return false;
        }
        if (this.certValid != null) {
            try {
                x509Certificate.checkValidity(this.certValid);
            }
            catch (CertificateException certificateException) {
                return false;
            }
        }
        if (this.issuer != null && !this.issuer.equals(x509Certificate.getIssuerX500Principal())) {
            return false;
        }
        if (this.subject != null && !this.subject.equals(x509Certificate.getSubjectX500Principal())) {
            return false;
        }
        if (this.sigId != null && !this.sigId.toString().equals(x509Certificate.getSigAlgOID())) {
            return false;
        }
        if (this.subjectKeyId != null && !Arrays.equals((byte[])(object2 = x509Certificate.getExtensionValue(SUBJECT_KEY_ID)), this.subjectKeyId)) {
            return false;
        }
        if (this.authKeyId != null && !Arrays.equals((byte[])(object2 = x509Certificate.getExtensionValue(AUTH_KEY_ID)), this.authKeyId)) {
            return false;
        }
        if (this.keyUsage != null && !Arrays.equals((boolean[])(object2 = (Object)x509Certificate.getKeyUsage()), this.keyUsage)) {
            return false;
        }
        if (this.basicConstraints >= 0 && x509Certificate.getBasicConstraints() != this.basicConstraints) {
            return false;
        }
        if (this.keyPurposeSet != null) {
            object2 = null;
            try {
                object2 = x509Certificate.getExtendedKeyUsage();
            }
            catch (CertificateParsingException certificateParsingException) {
                return false;
            }
            if (object2 == null) {
                return false;
            }
            object = this.keyPurposeSet.iterator();
            while (object.hasNext()) {
                if (object2.contains(object.next())) continue;
                return false;
            }
        }
        if (this.altNames != null) {
            object2 = null;
            try {
                object2 = x509Certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {
                return false;
            }
            if (object2 == null) {
                return false;
            }
            int n = 0;
            Iterator iterator = this.altNames.iterator();
            while (iterator.hasNext()) {
                List list2 = (List)iterator.next();
                Integer n2 = (Integer)list2.get(0);
                String string = null;
                byte[] byArray = null;
                if (list2.get(1) instanceof String) {
                    string = (String)list2.get(1);
                } else if (list2.get(1) instanceof byte[]) {
                    byArray = (byte[])list2.get(1);
                } else {
                    return false;
                }
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    List list3;
                    Object object3 = iterator2.next();
                    if (!(object3 instanceof List) || (list3 = (List)object3).size() != 2 || !n2.equals(list3.get(0))) continue;
                    if (string != null && list3.get(1) instanceof String && string.equals(list3.get(1))) {
                        ++n;
                        continue;
                    }
                    if (byArray == null || !(list3.get(1) instanceof byte[]) || !Arrays.equals(byArray, (byte[])list3.get(1))) continue;
                    ++n;
                }
                if (n != 0 && (!this.matchAllNames || n == this.altNames.size())) continue;
                return false;
            }
        }
        return this.nameConstraints == null || Arrays.equals(this.nameConstraints, (byte[])(object2 = x509Certificate.getExtensionValue(NAME_CONSTRAINTS_ID)));
    }

    public String toString() {
        int n;
        Class clazz = class$java$security$cert$X509CertSelector;
        if (clazz == null) {
            clazz = class$java$security$cert$X509CertSelector = X509CertSelector.class("[Ljava.security.cert.X509CertSelector;", false);
        }
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        String string = SystemProperties.getProperty("line.separator");
        String string2 = ";" + string;
        stringBuffer.append(" {").append(string);
        if (this.cert != null) {
            stringBuffer.append("  certificate = ").append(this.cert).append(string2);
        }
        if (this.basicConstraints >= 0) {
            stringBuffer.append("  basic constraints = ").append(this.basicConstraints).append(string2);
        }
        if (this.serialNo != null) {
            stringBuffer.append("  serial number = ").append(this.serialNo).append(string2);
        }
        if (this.certValid != null) {
            stringBuffer.append("  valid date = ").append(this.certValid).append(string2);
        }
        if (this.issuer != null) {
            stringBuffer.append("  issuer = ").append(this.issuer).append(string2);
        }
        if (this.subject != null) {
            stringBuffer.append("  subject = ").append(this.subject).append(string2);
        }
        if (this.sigId != null) {
            stringBuffer.append("  signature OID = ").append(this.sigId).append(string2);
        }
        if (this.subjectKey != null) {
            stringBuffer.append("  subject public key = ").append(this.subjectKey).append(string2);
        }
        if (this.subjectKeyId != null) {
            stringBuffer.append("  subject key ID = ");
            n = 0;
            while (n < this.subjectKeyId.length) {
                stringBuffer.append(Character.forDigit((this.subjectKeyId[n] & 0xF0) >>> 8, 16));
                stringBuffer.append(Character.forDigit(this.subjectKeyId[n] & 0xF, 16));
                if (n < this.subjectKeyId.length - 1) {
                    stringBuffer.append(':');
                }
                ++n;
            }
            stringBuffer.append(string2);
        }
        if (this.authKeyId != null) {
            stringBuffer.append("  authority key ID = ");
            n = 0;
            while (n < this.authKeyId.length) {
                stringBuffer.append(Character.forDigit((this.authKeyId[n] & 0xF0) >>> 8, 16));
                stringBuffer.append(Character.forDigit(this.authKeyId[n] & 0xF, 16));
                if (n < this.authKeyId.length - 1) {
                    stringBuffer.append(':');
                }
                ++n;
            }
            stringBuffer.append(string2);
        }
        if (this.keyUsage != null) {
            stringBuffer.append("  key usage = ");
            n = 0;
            while (n < this.keyUsage.length) {
                stringBuffer.append(this.keyUsage[n] + 48);
                ++n;
            }
            stringBuffer.append(string2);
        }
        if (this.keyPurposeSet != null) {
            stringBuffer.append("  key purpose = ").append(this.keyPurposeSet).append(string2);
        }
        if (this.altNames != null) {
            stringBuffer.append("  alternative names = ").append(this.altNames).append(string2);
        }
        if (this.nameConstraints != null) {
            stringBuffer.append("  name constraints = <blob of data>").append(string2);
        }
        stringBuffer.append("}").append(string);
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    private static final boolean checkOid(int[] nArray) {
        boolean bl = false;
        if (nArray != null && nArray.length > 2 && nArray[0] >= 0 && nArray[0] <= 2 && nArray[1] >= 0 && nArray[1] <= 39) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

