/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class BasicToolTipUI
extends ToolTipUI {
    private static BasicToolTipUI shared;
    private String text;

    public static ComponentUI createUI(JComponent jComponent) {
        if (shared == null) {
            shared = new BasicToolTipUI();
        }
        return shared;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JToolTip jToolTip = (JToolTip)jComponent;
        Toolkit toolkit = jToolTip.getToolkit();
        this.text = jToolTip.getTipText();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Insets insets = jToolTip.getInsets();
        FontMetrics fontMetrics = toolkit.getFontMetrics(jToolTip.getFont());
        SwingUtilities.layoutCompoundLabel(jToolTip, fontMetrics, this.text, null, 0, 0, 0, 0, rectangle, rectangle2, rectangle3, 0);
        return new Dimension(insets.left + rectangle3.width + insets.right, insets.top + rectangle3.height + insets.bottom);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(jComponent, "ToolTip.border");
    }

    protected void installListeners(JComponent jComponent) {
    }

    public void installUI(JComponent jComponent) {
        jComponent.setOpaque(true);
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JToolTip jToolTip = (JToolTip)jComponent;
        String string = jToolTip.getTipText();
        Toolkit toolkit = jToolTip.getToolkit();
        if (string == null) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        rectangle = SwingUtilities.calculateInnerArea(jToolTip, rectangle);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        FontMetrics fontMetrics = toolkit.getFontMetrics(jToolTip.getFont());
        int n = fontMetrics.getAscent();
        SwingUtilities.layoutCompoundLabel(jToolTip, fontMetrics, string, null, 0, 0, 0, 0, rectangle, rectangle2, rectangle3, 0);
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawString(string, rectangle.x, rectangle.y + n);
        graphics.setColor(color);
    }

    protected void uninstallDefaults(JComponent jComponent) {
        jComponent.setForeground(null);
        jComponent.setBackground(null);
        jComponent.setFont(null);
        jComponent.setBorder(null);
    }

    protected void uninstallListeners(JComponent jComponent) {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        this.uninstallListeners(jComponent);
    }
}

