/*
 * Decompiled with CFR 0.152.
 */
package lts;

import lts.MyHashStackEntry;
import lts.StackCheck;
import lts.StateCodec;

public class MyHashStack
implements StackCheck {
    private MyHashStackEntry[] table;
    private int count = 0;
    private int depth = 0;
    private MyHashStackEntry head = null;

    public MyHashStack(int n) {
        this.table = new MyHashStackEntry[n];
    }

    public void pushPut(byte[] byArray) {
        MyHashStackEntry myHashStackEntry = new MyHashStackEntry(byArray);
        int n = StateCodec.hash(byArray) % this.table.length;
        myHashStackEntry.next = this.table[n];
        this.table[n] = myHashStackEntry;
        ++this.count;
        myHashStackEntry.link = this.head;
        this.head = myHashStackEntry;
        ++this.depth;
    }

    public void pop() {
        if (this.head == null) {
            return;
        }
        this.head.marked = false;
        this.head = this.head.link;
        --this.depth;
    }

    public byte[] peek() {
        return this.head.key;
    }

    public void mark(int n) {
        this.head.marked = true;
        this.head.stateNumber = n;
    }

    public boolean marked() {
        return this.head.marked;
    }

    public boolean empty() {
        return this.head == null;
    }

    public boolean containsKey(byte[] byArray) {
        int n = StateCodec.hash(byArray) % this.table.length;
        MyHashStackEntry myHashStackEntry = this.table[n];
        while (myHashStackEntry != null) {
            if (StateCodec.equals(myHashStackEntry.key, byArray)) {
                return true;
            }
            myHashStackEntry = myHashStackEntry.next;
        }
        return false;
    }

    public boolean onStack(byte[] byArray) {
        int n = StateCodec.hash(byArray) % this.table.length;
        MyHashStackEntry myHashStackEntry = this.table[n];
        while (myHashStackEntry != null) {
            if (StateCodec.equals(myHashStackEntry.key, byArray)) {
                return myHashStackEntry.marked;
            }
            myHashStackEntry = myHashStackEntry.next;
        }
        return false;
    }

    public int get(byte[] byArray) {
        int n = StateCodec.hash(byArray) % this.table.length;
        MyHashStackEntry myHashStackEntry = this.table[n];
        while (myHashStackEntry != null) {
            if (StateCodec.equals(myHashStackEntry.key, byArray)) {
                return myHashStackEntry.stateNumber;
            }
            myHashStackEntry = myHashStackEntry.next;
        }
        return -99999;
    }

    public int size() {
        return this.count;
    }

    public int getDepth() {
        return this.depth;
    }
}

