##
# Borges::DispatchCallback is used by Borges::CallbackStore and
# Borges::HtmlRenderer to dispatch for <select> and radio
# buttons.
#
# DispatchCallbacks act as a placeholder for a ValueCallback.

class Borges::DispatchCallback < Borges::Callback

  ##
  # Invokes Callback +key+ from +store+.

  def evaluate(key, store)
    store.evaluate key.to_i, nil
  end

  ##
  # Is this a DispatchCallback?

  def dispatch_callback?
    true
  end

end # class Borges::DispatchCallback

