/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ConcurrencyUtils {
    public static ExecutorService threadPool = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
    private static int THREADS_BEGIN_N_1D_FFT_2THREADS = 8192;
    private static int THREADS_BEGIN_N_1D_FFT_4THREADS = 65536;
    private static int THREADS_BEGIN_N_2D = 65536;
    private static int THREADS_BEGIN_N_3D = 65536;
    private static int np = ConcurrencyUtils.concurrency();

    private ConcurrencyUtils() {
    }

    public static int concurrency() {
        int n = Runtime.getRuntime().availableProcessors();
        if (n > 1) {
            return ConcurrencyUtils.prevPow2(n);
        }
        return 1;
    }

    public static int getNumberOfProcessors() {
        return np;
    }

    public static int setNumberOfProcessors(int n) {
        np = ConcurrencyUtils.isPowerOf2(n) ? n : ConcurrencyUtils.prevPow2(n);
        return np;
    }

    public static int getThreadsBeginN_1D_FFT_2Threads() {
        return THREADS_BEGIN_N_1D_FFT_2THREADS;
    }

    public static int getThreadsBeginN_1D_FFT_4Threads() {
        return THREADS_BEGIN_N_1D_FFT_4THREADS;
    }

    public static int getThreadsBeginN_2D() {
        return THREADS_BEGIN_N_2D;
    }

    public static int getThreadsBeginN_3D() {
        return THREADS_BEGIN_N_3D;
    }

    public static void setThreadsBeginN_1D_FFT_2Threads(int n) {
        THREADS_BEGIN_N_1D_FFT_2THREADS = n < 512 ? 512 : n;
    }

    public static void setThreadsBeginN_1D_FFT_4Threads(int n) {
        THREADS_BEGIN_N_1D_FFT_4THREADS = n < 512 ? 512 : n;
    }

    public static void setThreadsBeginN_2D(int n) {
        THREADS_BEGIN_N_2D = n;
    }

    public static void setThreadsBeginN_3D(int n) {
        THREADS_BEGIN_N_3D = n;
    }

    public static void resetThreadsBeginN_FFT() {
        THREADS_BEGIN_N_1D_FFT_2THREADS = 8192;
        THREADS_BEGIN_N_1D_FFT_4THREADS = 65536;
    }

    public static void resetThreadsBeginN() {
        THREADS_BEGIN_N_2D = 65536;
        THREADS_BEGIN_N_3D = 65536;
    }

    public static int nextPow2(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n |= n >>> 32;
        return n + 1;
    }

    public static int prevPow2(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(n) / Math.log(2.0)));
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final Thread.UncaughtExceptionHandler handler;

        CustomThreadFactory(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.handler = uncaughtExceptionHandler;
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = defaultFactory.newThread(runnable);
            thread.setUncaughtExceptionHandler(this.handler);
            return thread;
        }
    }

    private static class CustomExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CustomExceptionHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

