/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QMatrix;
import gnu.java.awt.peer.qt.QtComponentPeer;
import gnu.java.awt.peer.qt.QtGraphics;
import gnu.java.awt.peer.qt.QtImageConsumer;
import gnu.java.awt.peer.qt.QtImageDirectGraphics;
import gnu.java.awt.peer.qt.QtImageGraphics;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QtImage
extends Image {
    static ColorModel nativeModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    int width;
    int height;
    Hashtable props;
    boolean isLoaded;
    long nativeObject;
    Vector observers;
    boolean errorLoading;
    ImageProducer source;
    WeakHashMap painters;
    boolean killFlag;

    public native void clear();

    private final native int[] getPixels();

    private final native void setPixels(int[] var1);

    private final native boolean loadImage(String var1);

    private final native boolean loadImageFromData(byte[] var1);

    private final native void createImage();

    private final synchronized native void freeImage();

    private final native void createScaledImage(QtImage var1, int var2);

    native void drawPixels(QtGraphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private final native void drawPixelsScaled(QtGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private final native void drawPixelsTransformed(QtGraphics var1, QMatrix var2);

    native void drawPixelsScaledFlipped(QtGraphics var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, boolean var15);

    public void setImage(int n, int n2, int[] nArray, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        Hashtable hashtable2 = this.props = hashtable != null ? hashtable : new Hashtable();
        if (n <= 0 || n2 <= 0 || nArray == null) {
            this.errorLoading = true;
            return;
        }
        this.isLoaded = true;
        this.deliver();
        this.createImage();
        this.setPixels(nArray);
    }

    public int getWidth(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return -1;
        }
        return this.width;
    }

    public int getHeight(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return -1;
        }
        return this.height;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return UndefinedProperty;
        }
        Object object = this.props.get(string);
        return object == null ? UndefinedProperty : object;
    }

    public ImageProducer getSource() {
        if (!this.isLoaded) {
            return null;
        }
        return new MemoryImageSource(this.width, this.height, nativeModel, this.getPixels(), 0, this.width);
    }

    void putPainter(QtImageGraphics qtImageGraphics) {
        if (this.painters == null) {
            this.painters = new WeakHashMap();
        }
        this.painters.put(qtImageGraphics, "dummy");
    }

    void removePainter(QtImageGraphics qtImageGraphics) {
        this.painters.remove(qtImageGraphics);
        if (this.killFlag && this.painters.isEmpty()) {
            this.freeImage();
        }
    }

    public Graphics getGraphics() {
        if (!this.isLoaded || this.killFlag) {
            return null;
        }
        return new QtImageGraphics(this);
    }

    Graphics getDirectGraphics(QtComponentPeer qtComponentPeer) {
        if (!this.isLoaded) {
            return null;
        }
        return new QtImageDirectGraphics(this, qtComponentPeer);
    }

    public Image getScaledInstance(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new QtImage(this, n, n2, n3);
    }

    public synchronized void flush() {
        if (this.isLoaded && this.source != null) {
            this.observers = new Vector();
            this.isLoaded = false;
            this.freeImage();
            this.source.startProduction(new QtImageConsumer(this, this.source));
        }
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.isLoaded) {
            if (this.painters == null || this.painters.isEmpty()) {
                this.freeImage();
            } else {
                this.killFlag = true;
            }
        }
    }

    public int checkImage(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            if (this.errorLoading) {
                return 64;
            }
            return 0;
        }
        return 35;
    }

    public boolean drawImage(QtGraphics qtGraphics, QMatrix qMatrix, ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return false;
        }
        this.drawPixelsTransformed(qtGraphics, qMatrix);
        return true;
    }

    public boolean drawImage(QtGraphics qtGraphics, int n, int n2, Color color, ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return false;
        }
        if (color != null) {
            this.drawPixels(qtGraphics, color.getRed(), color.getGreen(), color.getBlue(), n, n2, true);
        } else {
            this.drawPixels(qtGraphics, 0, 0, 0, n, n2, false);
        }
        return true;
    }

    public boolean drawImage(QtGraphics qtGraphics, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return false;
        }
        if (color != null) {
            this.drawPixelsScaled(qtGraphics, color.getRed(), color.getGreen(), color.getBlue(), n, n2, n3, n4, true);
        } else {
            this.drawPixelsScaled(qtGraphics, 0, 0, 0, n, n2, n3, n4, false);
        }
        return true;
    }

    public boolean drawImage(QtGraphics qtGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9;
        if (this.addObserver(imageObserver)) {
            return false;
        }
        boolean bl = false;
        if (n > n3) {
            bl = true;
        }
        boolean bl2 = false;
        if (n5 > n7) {
            bl2 = true;
        }
        boolean bl3 = bl ^ bl2;
        boolean bl4 = false;
        if (n2 > n4) {
            bl4 = true;
        }
        boolean bl5 = false;
        if (n6 > n8) {
            bl5 = true;
        }
        boolean bl6 = bl4 ^ bl5;
        int n10 = Math.abs(n3 - n);
        int n11 = Math.abs(n4 - n2);
        int n12 = Math.abs(n7 - n5);
        int n13 = Math.abs(n8 - n6);
        int n14 = n5 < n7 ? n5 : n7;
        int n15 = n6 < n8 ? n6 : n8;
        int n16 = n < n3 ? n : n3;
        int n17 = n9 = n2 < n4 ? n2 : n4;
        if (n12 > this.width) {
            n10 = (int)((double)n10 * ((double)this.width / (double)n12));
            n12 = this.width - n14;
        }
        if (n13 > this.height) {
            n11 = (int)((double)n11 * ((double)this.height / (double)n13));
            n13 = this.height - n15;
        }
        if (n12 + n14 > this.width) {
            n10 = (int)((double)n10 * (double)(this.width - n14) / (double)n12);
            n12 = this.width - n14;
        }
        if (n13 + n15 > this.height) {
            n11 = (int)((double)n11 * (double)(this.width - n15) / (double)n13);
            n13 = this.height - n15;
        }
        if (n12 <= 0 || n13 <= 0 || n10 <= 0 || n11 <= 0) {
            return true;
        }
        if (color != null) {
            this.drawPixelsScaledFlipped(qtGraphics, color.getRed(), color.getGreen(), color.getBlue(), bl3, bl6, n14, n15, n12, n13, n16, n9, n10, n11, true);
        } else {
            this.drawPixelsScaledFlipped(qtGraphics, 0, 0, 0, bl3, bl6, n14, n15, n12, n13, n16, n9, n10, n11, false);
        }
        return true;
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    private final void deliver() {
        int n = 39;
        if (this.observers != null) {
            int n2 = 0;
            while (n2 < this.observers.size()) {
                ((ImageObserver)this.observers.elementAt(n2)).imageUpdate(this, n, 0, 0, this.width, this.height);
                ++n2;
            }
        }
        this.observers = null;
    }

    private final boolean addObserver(ImageObserver imageObserver) {
        if (!this.isLoaded) {
            if (imageObserver != null && !this.observers.contains(imageObserver)) {
                this.observers.addElement(imageObserver);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "QtImage [isLoaded=" + this.isLoaded + ", width=" + this.width + ", height=" + this.height + ']';
    }

    private final /* synthetic */ void this() {
        this.width = -1;
        this.height = -1;
    }

    public QtImage(ImageProducer imageProducer) {
        this.this();
        this.killFlag = false;
        this.isLoaded = false;
        this.observers = new Vector();
        this.source = imageProducer;
        this.errorLoading = false;
        if (imageProducer != null) {
            this.source.startProduction(new QtImageConsumer(this, this.source));
        }
    }

    public QtImage(URL uRL) {
        this.this();
        this.killFlag = false;
        this.isLoaded = false;
        this.observers = new Vector();
        this.errorLoading = false;
        if (uRL == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(5000);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            byte[] byArray = new byte[5000];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        if (!this.loadImageFromData(byteArrayOutputStream.toByteArray())) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    public QtImage(String string) {
        this.this();
        this.killFlag = false;
        File file = new File(string);
        this.observers = null;
        this.props = new Hashtable();
        try {
            String string2 = file.getCanonicalPath();
            if (!this.loadImage(string2)) {
                this.errorLoading = true;
                this.isLoaded = false;
                return;
            }
        }
        catch (IOException iOException) {
            this.errorLoading = true;
            this.isLoaded = false;
            return;
        }
        this.errorLoading = false;
        this.isLoaded = true;
    }

    public QtImage(byte[] byArray) {
        this.this();
        if (!this.loadImageFromData(byArray)) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        this.killFlag = false;
        this.isLoaded = true;
        this.observers = null;
        this.errorLoading = false;
        this.props = new Hashtable();
    }

    public QtImage(int n, int n2) {
        this.this();
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.killFlag = false;
        this.observers = null;
        this.errorLoading = false;
        this.createImage();
        this.clear();
    }

    private QtImage(QtImage qtImage, int n, int n2, int n3) {
        this.this();
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.killFlag = false;
        this.observers = null;
        this.errorLoading = false;
        this.createScaledImage(qtImage, n3);
    }
}

