/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

final class ParameterNode
extends TemplateNode
implements Comparable {
    final QName name;
    final Expr select;
    final int type;

    final TemplateNode clone(Stylesheet stylesheet) {
        ParameterNode parameterNode = new ParameterNode(this.name, this.select.clone(stylesheet), this.type);
        if (this.children != null) {
            parameterNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            parameterNode.next = this.next.clone(stylesheet);
        }
        return parameterNode;
    }

    final void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        stylesheet.bindings.push(this.type);
        Object object = this.getValue(stylesheet, qName, node2, n, n2);
        if (object != null) {
            stylesheet.bindings.set(this.name, object, this.type);
            if (stylesheet.debug) {
                System.err.println(this + ": set to " + object);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
        stylesheet.bindings.pop(this.type);
    }

    final Object getValue(Stylesheet stylesheet, QName qName, Node node2, int n, int n2) throws TransformerException {
        if (this.select != null) {
            return this.select.evaluate(node2, n, n2);
        }
        if (this.children != null) {
            Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            this.children.apply(stylesheet, qName, node2, n, n2, documentFragment, null);
            return Collections.singleton(documentFragment);
        }
        return null;
    }

    public final boolean references(QName qName) {
        if (this.select != null && this.select.references(qName)) {
            return true;
        }
        return super.references(qName);
    }

    public final int compareTo(Object object) {
        if (object instanceof ParameterNode) {
            ParameterNode parameterNode = (ParameterNode)object;
            boolean bl = this.references(parameterNode.name);
            boolean bl2 = parameterNode.references(this.name);
            if (bl && bl2) {
                throw new IllegalArgumentException("circular definitions");
            }
            if (bl) {
                return 1;
            }
            if (bl2) {
                return -1;
            }
        }
        return 0;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append("variable");
                break;
            }
            case 1: {
                stringBuffer.append("param");
                break;
            }
            case 2: {
                stringBuffer.append("with-param");
                break;
            }
        }
        stringBuffer.append('[');
        stringBuffer.append("name=");
        stringBuffer.append(this.name);
        if (this.select != null) {
            stringBuffer.append(",select=");
            stringBuffer.append(this.select);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    ParameterNode(QName qName, Expr expr, int n) {
        this.name = qName;
        this.select = expr;
        this.type = n;
    }
}

