/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.lang;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UNIXProcess
extends Process {
    boolean isalive;
    int exit_code;
    FileDescriptor stdin_fd;
    FileDescriptor stdout_fd;
    FileDescriptor stderr_fd;
    FileDescriptor sync_fd;
    int pid;
    OutputStream stdin_stream;
    InputStream raw_stdout;
    InputStream raw_stderr;
    FileOutputStream sync;
    Throwable throwable;

    public int exitValue() {
        if (this.isalive) {
            throw new IllegalThreadStateException();
        }
        return this.exit_code;
    }

    public InputStream getErrorStream() {
        return this.raw_stderr;
    }

    public InputStream getInputStream() {
        return this.raw_stdout;
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    public int getPID() {
        return this.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int waitFor() throws InterruptedException {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            while (this.isalive) {
                this.wait();
            }
            return this.exit_code;
        }
    }

    public void destroy() {
        this.sendSignal(UNIXProcess.getKillSignal());
        try {
            this.raw_stdout.close();
            this.raw_stderr.close();
            this.stdin_stream.close();
            this.sync.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendSignal(int n) {
        if (!this.isalive) {
            return;
        }
        UNIXProcess.sendSignal(this.pid, n);
    }

    public static void sendSignal(int n, int n2) {
        UNIXProcess.sendSignal0(n, n2);
    }

    private final native int forkAndExec(Object[] var1, Object[] var2, String var3);

    private final native int execWait();

    private static final native void sendSignal0(int var0, int var1);

    private static final native int getKillSignal();

    protected void finalize() throws Throwable {
        super.finalize();
        UNIXProcess.try_close(this.raw_stdout);
        UNIXProcess.try_close(this.raw_stderr);
        UNIXProcess.try_close(this.stdin_stream);
    }

    private static final void try_close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static final void try_close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UNIXProcess(final String[] stringArray, final String[] stringArray2, File file) throws Throwable {
        final String string = file != null ? file.toString() : ".";
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                Object object;
                int n = 0;
                try {
                    n = UNIXProcess.this.forkAndExec(stringArray, stringArray2, string);
                }
                catch (Throwable throwable) {
                    UNIXProcess.this.throwable = throwable;
                    1 var3_4 = this;
                    synchronized (var3_4) {
                        this.notify();
                        return;
                    }
                }
                if (n == 0) {
                    object = this;
                    synchronized (object) {
                        UNIXProcess.this.isalive = true;
                        this.notify();
                    }
                    UNIXProcess.this.exit_code = UNIXProcess.this.execWait();
                }
                object = this;
                synchronized (object) {
                    UNIXProcess.this.isalive = false;
                    this.notifyAll();
                }
                object = UNIXProcess.this;
                synchronized (object) {
                    UNIXProcess.try_close(UNIXProcess.this.sync);
                    UNIXProcess.this.notifyAll();
                    return;
                }
            }
        };
        Thread thread2 = thread;
        synchronized (thread2) {
            thread.start();
            try {
                thread.wait();
            }
            catch (InterruptedException interruptedException) {}
            if (this.throwable != null) {
                try {
                    Throwable throwable = (Throwable)this.throwable.getClass().newInstance();
                    throwable.initCause(this.throwable);
                    throw throwable;
                }
                catch (InstantiationException instantiationException) {
                    throw this.throwable.fillInStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw this.throwable.fillInStackTrace();
                }
            }
            this.stdin_stream = new FileOutputStream(this.stdin_fd);
            this.raw_stdout = new FileInputStream(this.stdout_fd);
            this.raw_stderr = new FileInputStream(this.stderr_fd);
            this.sync = new FileOutputStream(this.sync_fd);
            byte[] byArray = new byte[1];
            try {
                this.sync.write(byArray);
            }
            catch (IOException iOException) {}
            return;
        }
    }
}

