/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Header;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Section;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Update;
import org.xbill.DNS.WireParseException;

public class Message
implements Cloneable {
    public static final int MAXLENGTH = 65535;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_SIGNED = 3;
    static final int TSIG_FAILED = 4;
    private static Record[] emptyRecordArray = new Record[0];
    private static RRset[] emptyRRsetArray = new RRset[0];
    private Header header;
    private List[] sections;
    private int size;
    private TSIG tsigkey;
    private TSIGRecord querytsig;
    private int tsigerror;
    int tsigstart;
    int tsigState;

    public static Message newQuery(Record record) {
        Message message = new Message();
        message.header.setOpcode(0);
        message.header.setFlag(7);
        message.addRecord(record, 0);
        return message;
    }

    public static Message newUpdate(Name name) {
        return new Update(name);
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record record, int n) {
        if (this.sections[n] == null) {
            this.sections[n] = new LinkedList();
        }
        this.sections[n].add(record);
        this.header.incCount(n);
    }

    public boolean removeRecord(Record record, int n) {
        if (this.sections[n] != null && this.sections[n].remove(record)) {
            this.header.decCount(n);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int n) {
        this.sections[n] = null;
        this.header.setCount(n, 0);
    }

    public boolean findRecord(Record record, int n) {
        boolean bl = false;
        if (this.sections[n] != null && this.sections[n].contains(record)) {
            bl = true;
        }
        return bl;
    }

    public boolean findRecord(Record record) {
        int n = 1;
        while (n <= 3) {
            if (this.sections[n] != null && this.sections[n].contains(record)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean findRRset(Name name, int n, int n2) {
        if (this.sections[n2] == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.sections[n2].size()) {
            Record record = (Record)this.sections[n2].get(n3);
            if (record.getType() == n && name.equals(record.getName())) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean findRRset(Name name, int n) {
        boolean bl = false;
        if (this.findRRset(name, n, 1) || this.findRRset(name, n, 2) || this.findRRset(name, n, 3)) {
            bl = true;
        }
        return bl;
    }

    public Record getQuestion() {
        if (this.sections[0] == null) {
            return null;
        }
        try {
            return (Record)this.sections[0].get(0);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public TSIGRecord getTSIG() {
        int n = this.header.getCount(3);
        if (n == 0) {
            return null;
        }
        List list2 = this.sections[3];
        Record record = (Record)list2.get(n - 1);
        if (record.type != 250) {
            return null;
        }
        return (TSIGRecord)record;
    }

    public boolean isSigned() {
        boolean bl = false;
        if (this.tsigState == 3 || this.tsigState == 1 || this.tsigState == 4) {
            bl = true;
        }
        return bl;
    }

    public boolean isVerified() {
        boolean bl = false;
        if (this.tsigState == 1) {
            bl = true;
        }
        return bl;
    }

    public OPTRecord getOPT() {
        Record[] recordArray = this.getSectionArray(3);
        int n = 0;
        while (n < recordArray.length) {
            if (recordArray[n] instanceof OPTRecord) {
                return (OPTRecord)recordArray[n];
            }
            ++n;
        }
        return null;
    }

    public int getRcode() {
        int n = this.header.getRcode();
        OPTRecord oPTRecord = this.getOPT();
        if (oPTRecord != null) {
            n += oPTRecord.getExtendedRcode() << 4;
        }
        return n;
    }

    public Record[] getSectionArray(int n) {
        if (this.sections[n] == null) {
            return emptyRecordArray;
        }
        List list2 = this.sections[n];
        return (Record[])list2.toArray(new Record[list2.size()]);
    }

    private static final boolean sameSet(Record record, Record record2) {
        boolean bl = false;
        if (record.getRRsetType() == record2.getRRsetType() && record.getDClass() == record2.getDClass() && record.getName().equals(record2.getName())) {
            bl = true;
        }
        return bl;
    }

    public RRset[] getSectionRRsets(int n) {
        if (this.sections[n] == null) {
            return emptyRRsetArray;
        }
        LinkedList linkedList = new LinkedList();
        Record[] recordArray = this.getSectionArray(n);
        HashSet hashSet = new HashSet();
        int n2 = 0;
        while (n2 < recordArray.length) {
            Name name = recordArray[n2].getName();
            boolean bl = true;
            if (hashSet.contains(name)) {
                int n3 = linkedList.size() - 1;
                while (n3 >= 0) {
                    RRset rRset = (RRset)linkedList.get(n3);
                    if (rRset.getType() == recordArray[n2].getRRsetType() && rRset.getDClass() == recordArray[n2].getDClass() && rRset.getName().equals(name)) {
                        rRset.addRR(recordArray[n2]);
                        bl = false;
                        break;
                    }
                    --n3;
                }
            }
            if (bl) {
                RRset rRset = new RRset(recordArray[n2]);
                linkedList.add(rRset);
                hashSet.add(name);
            }
            ++n2;
        }
        return (RRset[])linkedList.toArray(new RRset[linkedList.size()]);
    }

    void toWire(DNSOutput dNSOutput) {
        this.header.toWire(dNSOutput);
        Compression compression = new Compression();
        int n = 0;
        while (n < 4) {
            if (this.sections[n] != null) {
                int n2 = 0;
                while (n2 < this.sections[n].size()) {
                    Record record = (Record)this.sections[n].get(n2);
                    record.toWire(dNSOutput, n, compression);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private final int sectionToWire(DNSOutput dNSOutput, int n, Compression compression, int n2) {
        int n3 = this.sections[n].size();
        int n4 = dNSOutput.current();
        int n5 = 0;
        Record record = null;
        int n6 = 0;
        while (n6 < n3) {
            Record record2 = (Record)this.sections[n].get(n6);
            if (record != null && !Message.sameSet(record2, record)) {
                n4 = dNSOutput.current();
                n5 = n6;
            }
            record = record2;
            record2.toWire(dNSOutput, n, compression);
            if (dNSOutput.current() > n2) {
                dNSOutput.jump(n4);
                return n3 - n5;
            }
            ++n6;
        }
        return 0;
    }

    private final boolean toWire(DNSOutput dNSOutput, int n) {
        if (n < 12) {
            return false;
        }
        Header header = null;
        int n2 = n;
        if (this.tsigkey != null) {
            n2 -= this.tsigkey.recordLength();
        }
        int n3 = dNSOutput.current();
        this.header.toWire(dNSOutput);
        Compression compression = new Compression();
        int n4 = 0;
        while (n4 < 4) {
            int n5;
            if (this.sections[n4] != null && (n5 = this.sectionToWire(dNSOutput, n4, compression, n2)) != 0) {
                if (n4 == 3) break;
                if (header == null) {
                    header = (Header)this.header.clone();
                }
                header.setFlag(6);
                int n6 = header.getCount(n4);
                header.setCount(n4, n6 - n5);
                int n7 = n4 + 1;
                while (n7 < 4) {
                    header.setCount(n7, 0);
                    ++n7;
                }
                dNSOutput.save();
                dNSOutput.jump(n3);
                header.toWire(dNSOutput);
                dNSOutput.restore();
                break;
            }
            ++n4;
        }
        if (this.tsigkey != null) {
            TSIGRecord tSIGRecord = this.tsigkey.generate(this, dNSOutput.toByteArray(), this.tsigerror, this.querytsig);
            if (header == null) {
                header = (Header)this.header.clone();
            }
            tSIGRecord.toWire(dNSOutput, 3, compression);
            header.incCount(3);
            dNSOutput.save();
            dNSOutput.jump(n3);
            header.toWire(dNSOutput);
            dNSOutput.restore();
        }
        return true;
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        this.size = dNSOutput.current();
        return dNSOutput.toByteArray();
    }

    public byte[] toWire(int n) {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput, n);
        this.size = dNSOutput.current();
        return dNSOutput.toByteArray();
    }

    public void setTSIG(TSIG tSIG, int n, TSIGRecord tSIGRecord) {
        this.tsigkey = tSIG;
        this.tsigerror = n;
        this.querytsig = tSIGRecord;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int n) {
        if (n > 3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Record[] recordArray = this.getSectionArray(n);
        int n2 = 0;
        while (n2 < recordArray.length) {
            Record record = recordArray[n2];
            if (n == 0) {
                stringBuffer.append(";;\t" + record.name);
                stringBuffer.append(", type = " + Type.string(record.type));
                stringBuffer.append(", class = " + DClass.string(record.dclass));
            } else {
                stringBuffer.append(record);
            }
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        OPTRecord oPTRecord = this.getOPT();
        if (oPTRecord != null) {
            stringBuffer.append(this.header.toStringWithRcode(this.getRcode()) + '\n');
        } else {
            stringBuffer.append("" + this.header + '\n');
        }
        if (this.isSigned()) {
            stringBuffer.append(";; TSIG ");
            if (this.isVerified()) {
                stringBuffer.append("ok");
            } else {
                stringBuffer.append("invalid");
            }
            stringBuffer.append('\n');
        }
        int n = 0;
        while (n < 4) {
            if (this.header.getOpcode() != 5) {
                stringBuffer.append(";; " + Section.longString(n) + ":\n");
            } else {
                stringBuffer.append(";; " + Section.updString(n) + ":\n");
            }
            stringBuffer.append(this.sectionToString(n) + '\n');
            ++n;
        }
        stringBuffer.append(";; Message size: " + this.numBytes() + " bytes");
        return stringBuffer.toString();
    }

    public Object clone() {
        Message message = new Message();
        int n = 0;
        while (n < this.sections.length) {
            if (this.sections[n] != null) {
                message.sections[n] = new LinkedList(this.sections[n]);
            }
            ++n;
        }
        message.header = (Header)this.header.clone();
        message.size = this.size;
        return message;
    }

    private Message(Header header) {
        this.sections = new List[4];
        this.header = header;
    }

    public Message(int n) {
        this(new Header(n));
    }

    public Message() {
        this(new Header());
    }

    Message(DNSInput dNSInput) throws IOException {
        block7: {
            this(new Header(dNSInput));
            boolean bl = false;
            if (this.header.getOpcode() == 5) {
                bl = true;
            }
            boolean bl2 = bl;
            boolean bl3 = this.header.getFlag(6);
            try {
                int n = 0;
                while (n < 4) {
                    int n2 = this.header.getCount(n);
                    if (n2 > 0) {
                        this.sections[n] = new ArrayList(n2);
                    }
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = dNSInput.current();
                        Record record = Record.fromWire(dNSInput, n, bl2);
                        this.sections[n].add(record);
                        if (record.getType() == 250) {
                            this.tsigstart = n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            catch (WireParseException wireParseException) {
                if (bl3) break block7;
                throw wireParseException;
            }
        }
        this.size = dNSInput.current();
    }

    public Message(byte[] byArray) throws IOException {
        this(new DNSInput(byArray));
    }
}

