/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.i18n;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.batik.i18n.LocaleGroup;
import org.apache.batik.i18n.Localizable;

public class LocalizableSupport
implements Localizable {
    protected LocaleGroup localeGroup = LocaleGroup.DEFAULT;
    protected String bundleName;
    protected ClassLoader classLoader;
    protected Locale locale;
    protected Locale usedLocale;
    List resourceBundles = new ArrayList();
    Class lastResourceClass;
    Class cls;
    static /* synthetic */ Class class$java$lang$Object;

    public LocalizableSupport(String string, Class clazz) {
        this(string, clazz, null);
    }

    public LocalizableSupport(String string, Class clazz, ClassLoader classLoader) {
        this.bundleName = string;
        this.cls = clazz;
        this.classLoader = classLoader;
    }

    public LocalizableSupport(String string) {
        this(string, (ClassLoader)null);
    }

    public LocalizableSupport(String string, ClassLoader classLoader) {
        this.bundleName = string;
        this.classLoader = classLoader;
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.resourceBundles.clear();
            this.lastResourceClass = null;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocaleGroup(LocaleGroup localeGroup) {
        this.localeGroup = localeGroup;
    }

    public LocaleGroup getLocaleGroup() {
        return this.localeGroup;
    }

    public void setDefaultLocale(Locale locale) {
        this.localeGroup.setLocale(locale);
    }

    public Locale getDefaultLocale() {
        return this.localeGroup.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) {
        return MessageFormat.format(this.getString(string), objectArray);
    }

    protected Locale getCurrentLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        Locale locale = this.localeGroup.getLocale();
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    protected boolean setUsedLocale() {
        Locale locale = this.getCurrentLocale();
        if (this.usedLocale == locale) {
            return false;
        }
        this.usedLocale = locale;
        this.resourceBundles.clear();
        this.lastResourceClass = null;
        return true;
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(0);
    }

    protected boolean hasNextResourceBundle(int n) {
        if (n == 0) {
            return true;
        }
        if (n < this.resourceBundles.size()) {
            return true;
        }
        if (this.lastResourceClass == null) {
            return false;
        }
        return this.lastResourceClass != (class$java$lang$Object == null ? (class$java$lang$Object = LocalizableSupport.class$("java.lang.Object")) : class$java$lang$Object);
    }

    protected ResourceBundle lookupResourceBundle(String string, Class clazz) {
        ClassLoader classLoader = this.classLoader;
        ResourceBundle resourceBundle = null;
        if (classLoader != null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string, this.usedLocale, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle != null) {
                return resourceBundle;
            }
        }
        if (clazz != null) {
            try {
                classLoader = clazz.getClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(string, this.usedLocale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resourceBundle;
    }

    protected ResourceBundle getResourceBundle(int n) {
        this.setUsedLocale();
        ResourceBundle resourceBundle = null;
        if (this.cls == null) {
            if (this.resourceBundles.size() == 0) {
                resourceBundle = this.lookupResourceBundle(this.bundleName, null);
                this.resourceBundles.add(resourceBundle);
            }
            return (ResourceBundle)this.resourceBundles.get(0);
        }
        while (n >= this.resourceBundles.size()) {
            if (this.lastResourceClass == (class$java$lang$Object == null ? LocalizableSupport.class$("java.lang.Object") : class$java$lang$Object)) {
                return null;
            }
            this.lastResourceClass = this.lastResourceClass == null ? this.cls : this.lastResourceClass.getSuperclass();
            Class clazz = this.lastResourceClass;
            String string = clazz.getPackage().getName() + "." + this.bundleName;
            this.resourceBundles.add(this.lookupResourceBundle(string, clazz));
        }
        return (ResourceBundle)this.resourceBundles.get(n);
    }

    public String getString(String string) throws MissingResourceException {
        this.setUsedLocale();
        int n = 0;
        while (this.hasNextResourceBundle(n)) {
            ResourceBundle resourceBundle = this.getResourceBundle(n);
            if (resourceBundle != null) {
                try {
                    String string2 = resourceBundle.getString(string);
                    if (string2 != null) {
                        return string2;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            ++n;
        }
        String string3 = this.cls != null ? this.cls.toString() : this.bundleName;
        throw new MissingResourceException("Unable to find resource: " + string, string3, string);
    }

    public int getInteger(String string) throws MissingResourceException {
        String string2 = this.getString(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MissingResourceException("Malformed integer", this.bundleName, string);
        }
    }

    public int getCharacter(String string) throws MissingResourceException {
        String string2 = this.getString(string);
        if (string2 == null || string2.length() == 0) {
            throw new MissingResourceException("Malformed character", this.bundleName, string);
        }
        return string2.charAt(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

