/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformedExternalArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformedProjectArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.component.model.VariantWithOverloadAttributes;
import org.gradle.internal.model.CalculatedValueContainerFactory;

@ThreadSafe
public class DefaultTransformedVariantFactory
implements TransformedVariantFactory {
    private final TransformationNodeRegistry transformationNodeRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ConcurrentMap<VariantWithOverloadAttributes, ResolvedArtifactSet> variants = new ConcurrentHashMap<VariantWithOverloadAttributes, ResolvedArtifactSet>();
    private final Factory externalFactory = this::doCreateExternal;
    private final Factory projectFactory = this::doCreateProject;

    public DefaultTransformedVariantFactory(TransformationNodeRegistry transformationNodeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.transformationNodeRegistry = transformationNodeRegistry;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public ResolvedArtifactSet transformedExternalArtifacts(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, ImmutableAttributes target, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory) {
        return this.locateOrCreate(this.externalFactory, componentIdentifier, sourceVariant, target, transformation, dependenciesResolverFactory);
    }

    @Override
    public ResolvedArtifactSet transformedProjectArtifacts(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, ImmutableAttributes target, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory) {
        return this.locateOrCreate(this.projectFactory, componentIdentifier, sourceVariant, target, transformation, dependenciesResolverFactory);
    }

    private ResolvedArtifactSet locateOrCreate(Factory factory, ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, ImmutableAttributes target, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory) {
        VariantResolveMetadata.Identifier identifier = sourceVariant.getIdentifier();
        if (identifier == null) {
            return factory.create(componentIdentifier, sourceVariant, target, transformation, dependenciesResolverFactory);
        }
        return this.variants.computeIfAbsent(new VariantWithOverloadAttributes(identifier, target), key -> factory.create(componentIdentifier, sourceVariant, target, transformation, dependenciesResolverFactory));
    }

    private TransformedExternalArtifactSet doCreateExternal(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, ImmutableAttributes target, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory) {
        return new TransformedExternalArtifactSet(componentIdentifier, sourceVariant.getArtifacts(), target, transformation, dependenciesResolverFactory, this.calculatedValueContainerFactory);
    }

    private TransformedProjectArtifactSet doCreateProject(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, ImmutableAttributes target, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolverFactory) {
        return new TransformedProjectArtifactSet(componentIdentifier, sourceVariant.getArtifacts(), target, transformation, dependenciesResolverFactory, this.transformationNodeRegistry);
    }

    private static interface Factory {
        public ResolvedArtifactSet create(ComponentIdentifier var1, ResolvedVariant var2, ImmutableAttributes var3, Transformation var4, ExtraExecutionGraphDependenciesResolverFactory var5);
    }
}

