/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks;

import java.io.File;
import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.tasks.internal.XcodeSchemeFile;
import org.gradle.plugins.ide.api.XmlGeneratorTask;

@Incubating
public class GenerateSchemeFileTask
extends XmlGeneratorTask<XcodeSchemeFile> {
    public DefaultXcodeProject xcodeProject;

    @Internal
    public XcodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setXcodeProject(XcodeProject xcodeProject) {
        this.xcodeProject = (DefaultXcodeProject)xcodeProject;
    }

    protected void configure(XcodeSchemeFile schemeFile) {
        this.configureBuildAction(schemeFile.getBuildAction());
        this.configureTestAction(schemeFile.getTestAction());
        this.configureLaunchAction(schemeFile.getLaunchAction());
        this.configureArchiveAction(schemeFile.getArchiveAction());
        this.configureAnalyzeAction(schemeFile.getAnalyzeAction());
        this.configureProfileAction(schemeFile.getProfileAction());
    }

    private void configureBuildAction(XcodeSchemeFile.BuildAction action) {
        for (final XcodeTarget xcodeTarget : this.xcodeProject.getTargets()) {
            action.entry(new Action<XcodeSchemeFile.BuildActionEntry>(){

                public void execute(XcodeSchemeFile.BuildActionEntry buildActionEntry) {
                    buildActionEntry.setBuildForAnalysing(!xcodeTarget.isUnitTest());
                    buildActionEntry.setBuildForArchiving(!xcodeTarget.isUnitTest());
                    buildActionEntry.setBuildForProfiling(!xcodeTarget.isUnitTest());
                    buildActionEntry.setBuildForRunning(!xcodeTarget.isUnitTest());
                    buildActionEntry.setBuildForTesting(xcodeTarget.isUnitTest());
                    buildActionEntry.setBuildableReference(GenerateSchemeFileTask.this.toBuildableReference(xcodeTarget));
                }
            });
        }
    }

    private void configureTestAction(XcodeSchemeFile.TestAction action) {
        action.setBuildConfiguration("Debug");
        for (final XcodeTarget xcodeTarget : this.xcodeProject.getTargets()) {
            if (!xcodeTarget.isUnitTest()) continue;
            action.setBuildConfiguration("__GradleTestRunner_Debug");
            action.entry(new Action<XcodeSchemeFile.TestableEntry>(){

                public void execute(XcodeSchemeFile.TestableEntry testableEntry) {
                    testableEntry.setSkipped(false);
                    XcodeSchemeFile.BuildableReference buildableReference = GenerateSchemeFileTask.this.toBuildableReference(xcodeTarget);
                    testableEntry.setBuildableReference(buildableReference);
                }
            });
        }
    }

    private void configureLaunchAction(XcodeSchemeFile.LaunchAction action) {
        block1: {
            action.setBuildConfiguration((String)this.xcodeProject.getTargets().iterator().next().getDefaultConfigurationName().get());
            Iterator<XcodeTarget> iterator = this.xcodeProject.getTargets().iterator();
            if (!iterator.hasNext()) break block1;
            XcodeTarget xcodeTarget = iterator.next();
            XcodeSchemeFile.BuildableReference buildableReference = this.toBuildableReference(xcodeTarget);
            if (xcodeTarget.isRunnable()) {
                action.setBuildableProductRunnable(buildableReference);
            }
            action.setBuildableReference(buildableReference);
        }
    }

    private void configureArchiveAction(XcodeSchemeFile.ArchiveAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureProfileAction(XcodeSchemeFile.ProfileAction action) {
        action.setBuildConfiguration("Debug");
    }

    private void configureAnalyzeAction(XcodeSchemeFile.AnalyzeAction action) {
        action.setBuildConfiguration("Debug");
    }

    public File getInputFile() {
        return null;
    }

    protected XcodeSchemeFile create() {
        return new XcodeSchemeFile(this.getXmlTransformer());
    }

    private XcodeSchemeFile.BuildableReference toBuildableReference(XcodeTarget target) {
        XcodeSchemeFile.BuildableReference buildableReference = new XcodeSchemeFile.BuildableReference();
        buildableReference.setBuildableIdentifier("primary");
        buildableReference.setBlueprintIdentifier(target.getId());
        buildableReference.setBuildableName(target.getProductName());
        buildableReference.setBlueprintName(target.getName());
        buildableReference.setContainerRelativePath(this.getProject().getName() + ".xcodeproj");
        return buildableReference;
    }
}

