/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.io;

import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.chars.CharSets;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import java.io.Reader;

public class DelimitedWordReader
extends FastBufferedReader {
    private static final long serialVersionUID = 1L;
    private final CharOpenHashSet delimiters;

    @Override
    protected boolean isWordConstituent(char c) {
        return !this.delimiters.contains(c);
    }

    private void addCrLf() {
        this.delimiters.add('\n');
        this.delimiters.add('\r');
    }

    public DelimitedWordReader(int bufferSize, CharSet delimiters) {
        super(bufferSize);
        this.delimiters = new CharOpenHashSet((CharCollection)delimiters, 0.25f);
        this.addCrLf();
    }

    public DelimitedWordReader(CharSet delimiters) {
        this.delimiters = new CharOpenHashSet((CharCollection)delimiters, 0.25f);
        this.addCrLf();
    }

    public DelimitedWordReader(String delimiters) {
        this((CharSet)new CharOpenHashSet(delimiters.toCharArray()));
    }

    public DelimitedWordReader(String bufferSize, String delimiters) {
        this(Integer.parseInt(bufferSize), (CharSet)new CharOpenHashSet(delimiters.toCharArray()));
    }

    public DelimitedWordReader(Reader r, int bufferSize, CharSet delimiters) {
        super(r, bufferSize);
        this.delimiters = new CharOpenHashSet((CharCollection)delimiters, 0.25f);
        this.addCrLf();
    }

    public DelimitedWordReader(Reader r, CharSet delimiters) {
        super(r);
        this.delimiters = new CharOpenHashSet((CharCollection)delimiters, 0.25f);
        this.addCrLf();
    }

    public DelimitedWordReader(char[] array, int offset, int length, CharSet delimiters) {
        super(array, offset, length);
        this.delimiters = new CharOpenHashSet((CharCollection)delimiters, 0.25f);
        this.addCrLf();
    }

    public DelimitedWordReader(char[] array, CharSet delimiters) {
        super(array);
        this.delimiters = new CharOpenHashSet((CharCollection)delimiters, 0.25f);
        this.addCrLf();
    }

    public DelimitedWordReader(MutableString s, CharSet delimiters) {
        super(s, (CharSet)CharSets.EMPTY_SET);
        this.delimiters = new CharOpenHashSet((CharCollection)delimiters, 0.25f);
        this.addCrLf();
    }

    @Override
    public DelimitedWordReader copy() {
        return new DelimitedWordReader(this.bufferSize, (CharSet)this.delimiters);
    }

    @Override
    public String toSpec() {
        return this.toString();
    }

    @Override
    public String toString() {
        String className = this.getClass().getName();
        CharOpenHashSet additionalDelimiters = this.delimiters.clone();
        additionalDelimiters.remove('\n');
        additionalDelimiters.remove('\r');
        String delimiters = new String(additionalDelimiters.toCharArray());
        if (this.bufferSize == 16384) {
            return className + "(\"" + delimiters + "\")";
        }
        return className + "(" + this.bufferSize + ",\"" + delimiters + "\")";
    }
}

