/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;

public class CRAMReferenceRegion {
    private final CRAMReferenceSource referenceSource;
    private final SAMFileHeader samFileHeader;
    private byte[] referenceBases = null;
    private int referenceBasesContextID = -3;

    public CRAMReferenceRegion(CRAMReferenceSource cramReferenceSource, SAMFileHeader samFileHeader) {
        if (cramReferenceSource == null) {
            throw new IllegalArgumentException("A valid reference must be supplied to retrieve records from the CRAM stream.");
        }
        this.referenceSource = cramReferenceSource;
        this.samFileHeader = samFileHeader;
    }

    public byte[] getCurrentReferenceBases() {
        return this.referenceBases;
    }

    public byte[] getReferenceBases(int referenceIndex) {
        if (referenceIndex != -1) {
            if (this.referenceBases == null || referenceIndex != this.referenceBasesContextID) {
                SAMSequenceRecord sequence = this.samFileHeader.getSequence(referenceIndex);
                this.referenceBases = this.referenceSource.getReferenceBases(sequence, true);
                if (this.referenceBases == null) {
                    throw new IllegalArgumentException(String.format("A reference must be supplied (reference sequence %s not found).", sequence));
                }
                this.referenceBasesContextID = referenceIndex;
            }
            return this.referenceBases;
        }
        return null;
    }

    public void setEmbeddedReference(byte[] embeddedReferenceBytes, int embeddedReferenceIndex) {
        this.referenceBasesContextID = embeddedReferenceIndex;
        this.referenceBases = embeddedReferenceBytes;
    }
}

