/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.ChildClassLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DelegatingClassLoader
extends ChildClassLoader {
    private final Vector delegates = new Vector();
    private final Hashtable beingLoaded = new Hashtable();

    public DelegatingClassLoader(ChildClassLoader childClassLoader) {
        super(childClassLoader);
    }

    public DelegatingClassLoader() {
    }

    public void addDelegate(ChildClassLoader childClassLoader) {
        this.delegates.addElement(childClassLoader);
    }

    public void removeDelegate(ChildClassLoader childClassLoader) {
        this.delegates.removeElement(childClassLoader);
    }

    protected Class loadClassImpl(String string, boolean bl) {
        if (this.beingLoaded.containsKey(string)) {
            return null;
        }
        this.beingLoaded.put(string, string);
        Class clazz = null;
        Enumeration enumeration = this.delegates.elements();
        while (enumeration.hasMoreElements()) {
            ChildClassLoader childClassLoader = (ChildClassLoader)enumeration.nextElement();
            try {
                clazz = childClassLoader.loadClass(string, bl);
                if (clazz == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        this.beingLoaded.remove(string);
        return clazz;
    }

    protected InputStream getResourceAsStreamImpl(String string) {
        ChildClassLoader childClassLoader;
        if (this.beingLoaded.containsKey(string)) {
            return null;
        }
        this.beingLoaded.put(string, string);
        InputStream inputStream = null;
        Enumeration enumeration = this.delegates.elements();
        while (enumeration.hasMoreElements() && (inputStream = (childClassLoader = (ChildClassLoader)enumeration.nextElement()).getResourceAsStream(string)) == null) {
        }
        this.beingLoaded.remove(string);
        return inputStream;
    }

    protected URL getResourceImpl(String string) {
        ChildClassLoader childClassLoader;
        if (this.beingLoaded.containsKey(string)) {
            return null;
        }
        this.beingLoaded.put(string, string);
        URL uRL = null;
        Enumeration enumeration = this.delegates.elements();
        while (enumeration.hasMoreElements() && (uRL = (childClassLoader = (ChildClassLoader)enumeration.nextElement()).getResource(string)) == null) {
        }
        this.beingLoaded.remove(string);
        return uRL;
    }
}

