/*-
 * Copyright (c)1997-2005 by Hartmut Brandt
 * 	All rights reserved.
 *
 * Author: Harti Brandt <harti@freebsd.org>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Begemot: libbegemot/begemot.h.in,v 1.4 2005/06/01 08:10:24 brandt_h Exp $
 */

# ifndef begemot_h
# define begemot_h

# include <stdarg.h>
# include <sys/types.h>

# define BEGEMOT_MAJOR 1
# define BEGEMOT_MINOR 11

/*
 * Tcl 8... defines panic. :-((((
 */
# ifdef panic
#  undef panic
# endif

# ifdef __cplusplus
extern "C" {
# endif

# if defined(__GNUC__)
#  if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 5)
void panic(const char *, ...) __attribute__ ((noreturn, format(printf, 1, 2)));
void bug(const char *, ...) __attribute__ ((noreturn, format(printf, 1, 2)));
void warn(const char *, ...) __attribute__ ((format(printf, 1, 2)));
void error(const char *, ...) __attribute__ ((format(printf, 1, 2)));
void inform(const char *, ...) __attribute__ ((format(printf, 1, 2)));

void vpanic(const char *, va_list) __attribute__((noreturn));
void vbug(const char *, va_list) __attribute__((noreturn));

void verb(u_int, u_int, const char *, ...) __attribute__ ((format(printf, 3, 4)));
void verbc(u_int, u_int, const char *, ...) __attribute__ ((format(printf, 3, 4)));
void verbn(u_int, u_int, const char *, ...) __attribute__ ((format(printf, 3, 4)));

#  else

volatile void panic(const char *, ...);
volatile void bug(const char *, ...);
void warn(const char *, ...);
void error(const char *, ...);
void inform(const char *, ...);

volatile void vpanic(const char *, va_list);
volatile void vbug(const char *, va_list);

void verb(u_int, u_int, const char *, ...);
void verbc(u_int, u_int, const char *, ...);
void verbn(u_int, u_int, const char *, ...);

#  endif
# else

void panic(const char *, ...);
void bug(const char *, ...);
void warn(const char *, ...);
void error(const char *, ...);
void inform(const char *, ...);

void vpanic(const char *, va_list);
void vbug(const char *, va_list);

void verb(u_int, u_int, const char *, ...);
void verbc(u_int, u_int, const char *, ...);
void verbn(u_int, u_int, const char *, ...);

# endif

void vwarn(const char *, va_list);
void verror(const char *, va_list);
void vinform(const char *, va_list);

void vverb(u_int, u_int, const char *, va_list);
void vverbc(u_int, u_int, const char *, va_list);
void vverbn(u_int, u_int, const char *, va_list);

int geterrorcnt(void);
int getwarncnt(void);
void set_errmode(int);
void set_argv0(char *);

void * xalloc(size_t);
void * xrealloc(void *, size_t);
void xfree(void *);

char * strsave(const char *);
char * xstrsave(const char *);

size_t strnlen(const char *, size_t);
void strtrimsp(char **, int);
char * strnchr(const char *, int, size_t);

char * cstrc(char **, char, size_t *);
char * cstrd(char *, char, size_t);
extern int cstrwarn;

int getfields(char *, char **, int);
int getmfields(char *, char **, int);
char *setfields(char *);

/*
 * The following definitions require stdio.h to be included. Because we
 * don't want to require each program that uses libbegemot to include
 * stdio.h we make a heuristic check whether it's included or not.
 */
# ifdef EOF
struct stat;
void prstat(FILE *, const struct stat *);

char * readline(FILE *);
extern int readlinecnt;
# endif

struct iovec;

int frame_write(int, void *, u_int, void *, ...);
int frame_writev(int, void *, u_int, struct iovec *, u_int);
int frame_read(int, void *, u_int, void **, u_int *);
int framefd_write(int, void *, u_int, void *, ...);
int framefd_writev(int, void *, u_int, struct iovec *, u_int);
int framefd_read(int, void *, u_int, void **, u_int *);

typedef struct verb_option_t {
	char	*opt;
	u_int	level;
} verb_option_t;

enum {
	V_DFLT	= 0,
};

void verb_opts(verb_option_t *);

u_int verb_level(u_int);
void verb_option(char *);
# ifdef EOF
void verb_update(FILE *);
# endif

# ifdef __cplusplus
}
# endif
# endif
