/*  Programmable IRC function library 
    Copyright (C) 1999-2000 Jorgen Sigvardsson <jorgen@cs.kau.se>
    $Id: ctcp.h,v 1.6 2000/01/06 14:18:18 jorgen Exp $
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __CTCP_H__
#define __CTCP_H__

#include <btypes.h>

#define CTCP_CALLBACK(x) void x( srv_h srv, \
				 gcstring from, \
				 gboolean isRequest, \
				 gcstring cmd, \
				 gcstring params )

typedef void (*ctcp_callback_t)(srv_h, gcstring, gboolean, gcstring, gcstring);

void ctcp_set_callback(	ctcp_callback_t	cb,
			gcstring	cmd	);
void ctcp_dispatch_msg(	srv_h		srv,
			gcstring	from,
			gboolean	isRequest,
			gstring		line	);
void ctcp_write_req(	srv_h		srv,
			gcstring	to, 
			gcstring	cmd,
			gcstring	args	);
void ctcp_write_resp(	srv_h		srv,
			gcstring	to, 
			gcstring	cmd,
			gcstring	args	);
void ctcp_write_error(	srv_h		srv,
			gcstring	to, 
			gcstring	cmd,
			gcstring	arg	);
void ctcp_do_action(	srv_h		srv, 
			gcstring	to,
			gcstring	action	);
void ctcp_req_version(	srv_h		srv,
			gcstring	to	);
void ctcp_req_ping(	srv_h		srv,
			gcstring	to,
			gcstring	arg	);
void ctcp_req_cliinfo(	srv_h		srv,
			gcstring	to	);
void ctcp_req_userinfo(	srv_h		srv,
			gcstring	to	);
void ctcp_req_time(	srv_h		srv,
			gcstring	to	);
void ctcp_resp_version(	srv_h		srv,
			gcstring	to,
			gcstring	version );
void ctcp_resp_ping(	srv_h		srv,
			gcstring	to,
			gcstring	arg	);
void ctcp_resp_cliinfo(	srv_h		srv,
			gcstring	to,
			gcstring	info	);
void ctcp_resp_userinfo(	srv_h		srv,
				gcstring	to,
				gcstring	info );
void ctcp_resp_time(	srv_h		srv,
			gcstring	to,
			gcstring	time	);

#endif /* __CTCP_H__ */
