/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure.link;

import br.arca.morcego.physics.PunctualBody;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.run.Renderer;
import br.arca.morcego.structure.Link;
import br.arca.morcego.structure.Node;
import java.awt.Graphics;

public class DashedLink
extends Link {
    private int parts = 10;

    public DashedLink() {
    }

    public DashedLink(Node n1, Node n2) {
        super(n1, n2);
    }

    public void paint(Graphics g) {
        PunctualBody body1 = this.node1.getBody();
        PunctualBody body2 = this.node2.getBody();
        g.setColor(Renderer.fadeColor(this.color, Math.min(body1.getScale(), body2.getScale())));
        int sections = this.parts * 2 - 1;
        Vector3D start = new Vector3D(body1.projection.x, body1.projection.y, 0.0f);
        Vector3D inc = new Vector3D(body2.projection.x, body2.projection.y, 0.0f).getVectorFrom(start);
        Vector3D end = start.makeClone();
        inc.resize(1.0f / (float)sections);
        end.add(inc);
        int i = 0;
        while (i < sections) {
            if (i % 2 == 0) {
                start.proj();
                end.proj();
                g.drawLine((int)start.x, (int)start.y, (int)end.x, (int)end.y);
            }
            start.add(inc);
            end.add(inc);
            ++i;
        }
    }
}

