<?php
/**
 * エントリーの表示順を変更します
 */
class UpdateDisplayOrderAction extends SOY2Action{

    protected function execute(SOY2ActionRequest &$request,SOY2ActionForm &$form,SOY2ActionResponse &$response){
		$displayOrders = $form->displayOrder;
		$logic = SOY2Logic::createInstance("logic.site.Entry.EntryLogic");
		try{
			foreach($displayOrders as $entryId => $tmp){
				foreach($tmp as $labelId => $displayOrder){
					if(!strlen($displayOrder))$displayOrder = LabeledEntry::ORDER_MAX;
					$logic->updateDisplayOrder($entryId,$labelId,$displayOrder);
				}
			}
			return SOY2Action::SUCCESS;
		}catch(Exception $e){
			$this->setErrorMessage("failed","表示順変更に失敗しました");
			return SOY2Action::FAILED;
		}
    }
}

class UpdateDisplayOrderActionForm extends SOY2ActionForm{
	var $displayOrder;
	
	/**
	 * @validator number {"require":"true"}
	 */
	function setDisplayOrder($displayOrder){
		$this->displayOrder = $displayOrder;
	}
}
?>