# this file has been generated automatically; do not edit

import _lasso
import sys


def cptrToPy(cptr):
    if cptr is None:
        return None
    klass = getattr(lasso, cptr.typename)
    o = klass.__new__(klass)
    o._cptr = cptr
    return o

if sys.version_info >= (3,):
    def str2lasso(s):
        return s
else: # Python 2.x
    def str2lasso(s):
        if isinstance(s, unicode):
            return s.encode('utf-8')
        return s

class frozendict(dict):
    '''Immutable dict'''
    # from Python Cookbook:
    #   http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/414283
    def _blocked_attribute(obj):
        raise AttributeError('A frozendict cannot be modified.')
    _blocked_attribute = property(_blocked_attribute)

    __delitem__ = __setitem__ = clear = _blocked_attribute
    pop = popitem = setdefault = update = _blocked_attribute

    def __new__(cls, *args):
        new = dict.__new__(cls)
        dict.__init__(new, *args)
        return new

    def __init__(self, *args):
        pass

    def __hash__(self):
        try:
            return self._cached_hash
        except AttributeError:
            h = self._cached_hash = hash(tuple(sorted(self.items())))
            return h

    def __repr__(self):
        return 'frozendict(%s)' % dict.__repr__(self)

class Error(Exception):
    code = None

    @staticmethod
    def raise_on_rc(rc):
        global exceptions_dict
        if rc != 0:
            exception = exceptions_dict.get(rc, Error())
            exception.code = rc
            raise exception

    def __str__(self):
        if self.code:
            return '<lasso.%s(%s): %s>' % (self.__class__.__name__, self.code, _lasso.strError(self.code))
        else:
            return '<lasso.%s: %s>' % (self.__class__.__name__, self.message)

    def __getitem__(self, i):
        # compatibility with SWIG bindings
        if i == 0:
            return self.code
        elif i == 1:
            return _lasso.strError(self.code)
        else:
            raise IndexError()

class ProfileError(Error):
    pass

class ProviderError(Error):
    pass

class ServerError(ProviderError):
    pass

class LoginError(ProfileError):
    pass

class LogoutError(ProfileError):
    pass

class DefederationError(ProfileError):
    pass

class NameIdentifierMappingError(ProfileError):
    pass

class WsfProfileError(ProfileError):
    pass

class DiscoveryError(WsfProfileError):
    pass

class DataServiceError(WsfProfileError):
    pass

class DstError(WsfProfileError):
    pass

class XmlError(Error):
    pass

class XmlNodeNotFoundError(XmlError):
    pass

class XmlNodeContentNotFoundError(XmlError):
    pass

class XmlAttrNotFoundError(XmlError):
    pass

class XmlAttrValueNotFoundError(XmlError):
    pass

class XmlInvalidFileError(XmlError):
    pass

class XmlObjectConstructionFailedError(XmlError):
    pass

class XmlMissingNamespaceError(XmlError):
    pass

class XmlSchemaInvalidFragmentError(XmlError):
    pass

class XmlAttrValueInvalidError(XmlError):
    pass

class DsError(Error):
    pass

class DsSignatureNotFoundError(DsError):
    pass

class DsInvalidSignatureError(DsError):
    pass

class DsSignatureTmplCreationFailedError(DsError):
    pass

class DsContextCreationFailedError(DsError):
    pass

class DsPublicKeyLoadFailedError(DsError):
    pass

class DsPrivateKeyLoadFailedError(DsError):
    pass

class DsCertificateLoadFailedError(DsError):
    pass

class DsSignatureFailedError(DsError):
    pass

class DsKeysMngrCreationFailedError(DsError):
    pass

class DsKeysMngrInitFailedError(DsError):
    pass

class DsSignatureVerificationFailedError(DsError):
    pass

class DsCaCertChainLoadFailedError(DsError):
    pass

class DsInvalidSigalgError(DsError):
    pass

class DsDigestComputeFailedError(DsError):
    pass

class DsSignatureTemplateNotFoundError(DsError):
    pass

class DsTooMuchReferencesError(DsError):
    pass

class DsInvalidReferenceForSamlError(DsError):
    pass

class DsDecryptionFailedError(DsError):
    pass

class DsEncryptionFailedError(DsError):
    pass

class DsDecryptionFailedMissingPrivateKeyError(DsError):
    pass

class ServerProviderNotFoundError(ServerError):
    pass

class ServerAddProviderFailedError(ServerError):
    pass

class ServerAddProviderProtocolMismatchError(ServerError):
    pass

class ServerSetEncryptionPrivateKeyFailedError(ServerError):
    pass

class ServerInvalidXmlError(ServerError):
    pass

class ServerNoProviderLoadedError(ServerError):
    pass

class LogoutUnsupportedProfileError(LogoutError):
    pass

class LogoutRequestDeniedError(LogoutError):
    pass

class LogoutFederationNotFoundError(LogoutError):
    pass

class LogoutUnknownPrincipalError(LogoutError):
    pass

class LogoutPartialLogoutError(LogoutError):
    pass

class ProfileInvalidQueryError(ProfileError):
    pass

class ProfileInvalidPostMsgError(ProfileError):
    pass

class ProfileInvalidSoapMsgError(ProfileError):
    pass

class ProfileMissingRequestError(ProfileError):
    pass

class ProfileInvalidHttpMethodError(ProfileError):
    pass

class ProfileInvalidProtocolprofileError(ProfileError):
    pass

class ProfileInvalidMsgError(ProfileError):
    pass

class ProfileMissingRemoteProvideridError(ProfileError):
    pass

class ProfileUnsupportedProfileError(ProfileError):
    pass

class ProfileUnknownProfileUrlError(ProfileError):
    pass

class ProfileIdentityNotFoundError(ProfileError):
    pass

class ProfileFederationNotFoundError(ProfileError):
    pass

class ProfileNameIdentifierNotFoundError(ProfileError):
    pass

class ProfileBuildingQueryFailedError(ProfileError):
    pass

class ProfileBuildingRequestFailedError(ProfileError):
    pass

class ProfileBuildingMessageFailedError(ProfileError):
    pass

class ProfileBuildingResponseFailedError(ProfileError):
    pass

class ProfileSessionNotFoundError(ProfileError):
    pass

class ProfileBadIdentityDumpError(ProfileError):
    pass

class ProfileBadSessionDumpError(ProfileError):
    pass

class ProfileMissingResponseError(ProfileError):
    pass

class ProfileMissingStatusCodeError(ProfileError):
    pass

class ProfileMissingArtifactError(ProfileError):
    pass

class ProfileMissingResourceOfferingError(ProfileError):
    pass

class ProfileMissingServiceDescriptionError(ProfileError):
    pass

class ProfileMissingServiceTypeError(ProfileError):
    pass

class ProfileMissingAssertionError(ProfileError):
    pass

class ProfileMissingSubjectError(ProfileError):
    pass

class ProfileMissingNameIdentifierError(ProfileError):
    pass

class ProfileInvalidArtifactError(ProfileError):
    pass

class ProfileMissingEncryptionPrivateKeyError(ProfileError):
    pass

class ProfileStatusNotSuccessError(ProfileError):
    pass

class ProfileMissingIssuerError(ProfileError):
    pass

class ProfileMissingServiceInstanceError(ProfileError):
    pass

class ProfileMissingEndpointReferenceError(ProfileError):
    pass

class ProfileMissingEndpointReferenceAddressError(ProfileError):
    pass

class ProfileInvalidIssuerError(ProfileError):
    pass

class ProfileMissingServerError(ProfileError):
    pass

class ProfileUnknownProviderError(ProfileError):
    pass

class ProfileCannotVerifySignatureError(ProfileError):
    pass

class ProfileCannotFindAProviderError(ProfileError):
    pass

class ProfileResponseDoesNotMatchRequestError(ProfileError):
    pass

class ProfileInvalidRequestError(ProfileError):
    pass

class ProfileInvalidResponseError(ProfileError):
    pass

class ProfileUnsupportedBindingError(ProfileError):
    pass

class ProfileInvalidAssertionConditionsError(ProfileError):
    pass

class ProfileInvalidAssertionError(ProfileError):
    pass

class ProfileUnknownIssuerError(ProfileError):
    pass

class ProfileIssuerIsNotAnIdpError(ProfileError):
    pass

class ProfileRequestDeniedError(ProfileError):
    pass

class ProfileEndpointIndexNotFoundError(ProfileError):
    pass

class ProfileInvalidIdpListError(ProfileError):
    pass

class ParamError(Error):
    pass

class ParamBadTypeOrNullObjError(ParamError):
    pass

class ParamInvalidValueError(ParamError):
    pass

class ParamCheckFailedError(ParamError):
    pass

class ParamNonInitializedObjectError(ParamError):
    pass

class LoginFederationNotFoundError(LoginError):
    pass

class LoginConsentNotObtainedError(LoginError):
    pass

class LoginInvalidNameidpolicyError(LoginError):
    pass

class LoginRequestDeniedError(LoginError):
    pass

class LoginInvalidSignatureError(LoginError):
    pass

class LoginUnsignedAuthnRequestError(LoginError):
    pass

class LoginStatusNotSuccessError(LoginError):
    pass

class LoginUnknownPrincipalError(LoginError):
    pass

class LoginNoDefaultEndpointError(LoginError):
    pass

class LoginAssertionReplayError(LoginError):
    pass

class LoginAssertionDoesNotMatchRequestIdError(LoginError):
    pass

class LoginInvalidAssertionSignatureError(LoginError):
    pass

class DefederationMissingNameIdentifierError(DefederationError):
    pass

class SoapError(Error):
    pass

class SoapRedirectRequestFaultError(SoapError):
    pass

class SoapMissingEnvelopeError(SoapError):
    pass

class SoapMissingHeaderError(SoapError):
    pass

class SoapMissingBodyError(SoapError):
    pass

class SoapMissingSoapFaultDetailError(SoapError):
    pass

class NameidentifiermappingMissingTargetNamespaceError(NameIdentifierMappingError):
    pass

class NameidentifiermappingForbiddenCallOnThisSideError(NameIdentifierMappingError):
    pass

class NameidentifiermappingMissingTargetIdentifierError(NameIdentifierMappingError):
    pass

class DataserviceUnregisteredDstError(DataServiceError):
    pass

class DataserviceCannotAddItemError(DataServiceError):
    pass

class WsfprofileMissingCorrelationError(WsfProfileError):
    pass

class WsfprofileMissingSecurityError(WsfProfileError):
    pass

class WsfprofileMissingAssertionIdError(WsfProfileError):
    pass

class WsfprofileMissingEndpointError(WsfProfileError):
    pass

class WsfprofileSoapFaultError(WsfProfileError):
    pass

class WsfprofileUnsupportedSecurityMechanismError(WsfProfileError):
    pass

class WsfprofileMissingDescriptionError(WsfProfileError):
    pass

class WsfprofileMissingResourceIdError(WsfProfileError):
    pass

class WsfprofileMissingCredentialRefError(WsfProfileError):
    pass

class WsfprofileInvalidOrMissingReferenceToMessageIdError(WsfProfileError):
    pass

class WsfprofileSecurityMechanismCheckFailedError(WsfProfileError):
    pass

class WsfprofileUnknownStatusCodeError(WsfProfileError):
    pass

class WsfprofileServerInteractionRequiredError(WsfProfileError):
    pass

class WsfprofileServerInteractionRequiredForDataError(WsfProfileError):
    pass

class WsfprofileRedirectRequestError(WsfProfileError):
    pass

class WsfprofileRedirectRequestUnsupportedByRequesterError(WsfProfileError):
    pass

class WsfprofileMissingSenderIdError(WsfProfileError):
    pass

class DiscoverySvcMetadataRegisterFailedError(DiscoveryError):
    pass

class DiscoverySvcMetadataAssociationAddFailedError(DiscoveryError):
    pass

class DiscoveryMissingRequestedServiceError(DiscoveryError):
    pass

class DiscoveryFailedToBuildEndpointReferenceError(DiscoveryError):
    pass

class DstMissingServiceDataError(DstError):
    pass

class DstQueryFailedError(DstError):
    pass

class DstQueryPartiallyFailedError(DstError):
    pass

class DstModifyFailedError(DstError):
    pass

class DstModifyPartiallyFailedError(DstError):
    pass

class DstNewDataMissingError(DstError):
    pass

class DstQueryNotFoundError(DstError):
    pass

class DstNoDataError(DstError):
    pass

class DstMalformedQueryError(DstError):
    pass

class DstEmptyRequestError(DstError):
    pass

class RegistryError(Error):
    pass

class RegistryKeyExistsError(RegistryError):
    pass

class ProviderMissingPublicKeyError(ProviderError):
    pass

class WssecError(Error):
    pass

class WssecMissingSecurityTokenError(WssecError):
    pass

class WssecBadPasswordError(WssecError):
    pass

class Idwsf2DiscoveryError(Error):
    pass

class Idwsf2DiscoveryFailedError(Idwsf2DiscoveryError):
    pass

class Idwsf2DiscoveryForbiddenError(Idwsf2DiscoveryError):
    pass

class Idwsf2DiscoveryDuplicateError(Idwsf2DiscoveryError):
    pass

class Idwsf2DiscoveryLogicalDuplicateError(Idwsf2DiscoveryError):
    pass

class Idwsf2DiscoveryNoResultsError(Idwsf2DiscoveryError):
    pass

class Idwsf2DiscoveryNotFoundError(Idwsf2DiscoveryError):
    pass

class Idwsf2DstError(Error):
    pass

class Idwsf2DstDuplicateItemError(Idwsf2DstError):
    pass

class Idwsf2DstPartialFailureError(Idwsf2DstError):
    pass

class Idwsf2DstUnknownStatusCodeError(Idwsf2DstError):
    pass

class Idwsf2DstItemNotFoundError(Idwsf2DstError):
    pass

class AssertionQueryError(Error):
    pass

class AssertionqueryAttributeRequestAlreadyExistError(AssertionQueryError):
    pass

class AssertionqueryNotAnAttributeQueryError(AssertionQueryError):
    pass

class XmlencError(Error):
    pass

class XmlencInvalidEncryptedDataError(XmlencError):
    pass

class PaosError(Error):
    pass

class PaosMissingRequestError(PaosError):
    pass

class PaosMissingResponseError(PaosError):
    pass

class PaosMissingResponseConsumerUrlError(PaosError):
    pass

class EcpError(Error):
    pass

class EcpMissingRequestError(EcpError):
    pass

class EcpMissingResponseError(EcpError):
    pass

class EcpMissingRelaystateError(EcpError):
    pass

class EcpMissingAuthnRequestError(EcpError):
    pass

class EcpMissingSamlResponseError(EcpError):
    pass

class EcpAssertionConsumerUrlMismatchError(EcpError):
    pass

exceptions_dict = {
    _lasso.WSF_PROFILE_ERROR_UNKNOWN_STATUS_CODE: WsfprofileUnknownStatusCodeError,
    _lasso.PROFILE_ERROR_SESSION_NOT_FOUND: ProfileSessionNotFoundError,
    _lasso.WSF_PROFILE_ERROR_MISSING_ENDPOINT: WsfprofileMissingEndpointError,
    _lasso.LOGIN_ERROR_ASSERTION_REPLAY: LoginAssertionReplayError,
    _lasso.ECP_ERROR_MISSING_REQUEST: EcpMissingRequestError,
    _lasso.DISCOVERY_ERROR_SVC_METADATA_REGISTER_FAILED: DiscoverySvcMetadataRegisterFailedError,
    _lasso.DS_ERROR_DIGEST_COMPUTE_FAILED: DsDigestComputeFailedError,
    _lasso.ECP_ERROR_MISSING_RELAYSTATE: EcpMissingRelaystateError,
    _lasso.LOGIN_ERROR_ASSERTION_DOES_NOT_MATCH_REQUEST_ID: LoginAssertionDoesNotMatchRequestIdError,
    _lasso.NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_NAMESPACE: NameidentifiermappingMissingTargetNamespaceError,
    _lasso.DS_ERROR_SIGNATURE_NOT_FOUND: DsSignatureNotFoundError,
    _lasso.LOGIN_ERROR_FEDERATION_NOT_FOUND: LoginFederationNotFoundError,
    _lasso.PROFILE_ERROR_INVALID_RESPONSE: ProfileInvalidResponseError,
    _lasso.DS_ERROR_DECRYPTION_FAILED: DsDecryptionFailedError,
    _lasso.ECP_ERROR_MISSING_RESPONSE: EcpMissingResponseError,
    _lasso.DS_ERROR_SIGNATURE_FAILED: DsSignatureFailedError,
    _lasso.PROFILE_ERROR_MISSING_SERVER: ProfileMissingServerError,
    _lasso.DS_ERROR_CERTIFICATE_LOAD_FAILED: DsCertificateLoadFailedError,
    _lasso.WSF_PROFILE_ERROR_MISSING_SENDER_ID: WsfprofileMissingSenderIdError,
    _lasso.WSF_PROFILE_ERROR_INVALID_OR_MISSING_REFERENCE_TO_MESSAGE_ID: WsfprofileInvalidOrMissingReferenceToMessageIdError,
    _lasso.DST_ERROR_MODIFY_FAILED: DstModifyFailedError,
    _lasso.DS_ERROR_INVALID_SIGALG: DsInvalidSigalgError,
    _lasso.IDWSF2_DISCOVERY_ERROR_FORBIDDEN: Idwsf2DiscoveryForbiddenError,
    _lasso.DS_ERROR_KEYS_MNGR_INIT_FAILED: DsKeysMngrInitFailedError,
    _lasso.DST_ERROR_MISSING_SERVICE_DATA: DstMissingServiceDataError,
    _lasso.LOGOUT_ERROR_UNSUPPORTED_PROFILE: LogoutUnsupportedProfileError,
    _lasso.IDWSF2_DISCOVERY_ERROR_DUPLICATE: Idwsf2DiscoveryDuplicateError,
    _lasso.DS_ERROR_TOO_MUCH_REFERENCES: DsTooMuchReferencesError,
    _lasso.PROFILE_ERROR_BUILDING_QUERY_FAILED: ProfileBuildingQueryFailedError,
    _lasso.DST_ERROR_QUERY_PARTIALLY_FAILED: DstQueryPartiallyFailedError,
    _lasso.LOGOUT_ERROR_UNKNOWN_PRINCIPAL: LogoutUnknownPrincipalError,
    _lasso.PROFILE_ERROR_INVALID_PROTOCOLPROFILE: ProfileInvalidProtocolprofileError,
    _lasso.SOAP_ERROR_REDIRECT_REQUEST_FAULT: SoapRedirectRequestFaultError,
    _lasso.DS_ERROR_SIGNATURE_TEMPLATE_NOT_FOUND: DsSignatureTemplateNotFoundError,
    _lasso.PROFILE_ERROR_ISSUER_IS_NOT_AN_IDP: ProfileIssuerIsNotAnIdpError,
    _lasso.LOGIN_ERROR_INVALID_NAMEIDPOLICY: LoginInvalidNameidpolicyError,
    _lasso.DS_ERROR_ENCRYPTION_FAILED: DsEncryptionFailedError,
    _lasso.DS_ERROR_INVALID_SIGNATURE: DsInvalidSignatureError,
    _lasso.PROFILE_ERROR_STATUS_NOT_SUCCESS: ProfileStatusNotSuccessError,
    _lasso.IDWSF2_DISCOVERY_ERROR_FAILED: Idwsf2DiscoveryFailedError,
    _lasso.LOGIN_ERROR_STATUS_NOT_SUCCESS: LoginStatusNotSuccessError,
    _lasso.PROFILE_ERROR_RESPONSE_DOES_NOT_MATCH_REQUEST: ProfileResponseDoesNotMatchRequestError,
    _lasso.ECP_ERROR_MISSING_AUTHN_REQUEST: EcpMissingAuthnRequestError,
    _lasso.PROFILE_ERROR_FEDERATION_NOT_FOUND: ProfileFederationNotFoundError,
    _lasso.SERVER_ERROR_PROVIDER_NOT_FOUND: ServerProviderNotFoundError,
    _lasso.DST_ERROR_MODIFY_PARTIALLY_FAILED: DstModifyPartiallyFailedError,
    _lasso.SOAP_ERROR_MISSING_SOAP_FAULT_DETAIL: SoapMissingSoapFaultDetailError,
    _lasso.WSSEC_ERROR_MISSING_SECURITY_TOKEN: WssecMissingSecurityTokenError,
    _lasso.XML_ERROR_ATTR_NOT_FOUND: XmlAttrNotFoundError,
    _lasso.PARAM_ERROR_BAD_TYPE_OR_NULL_OBJ: ParamBadTypeOrNullObjError,
    _lasso.WSF_PROFILE_ERROR_SERVER_INTERACTION_REQUIRED: WsfprofileServerInteractionRequiredError,
    _lasso.WSF_PROFILE_ERROR_MISSING_CREDENTIAL_REF: WsfprofileMissingCredentialRefError,
    _lasso.DS_ERROR_INVALID_REFERENCE_FOR_SAML: DsInvalidReferenceForSamlError,
    _lasso.XML_ERROR_SCHEMA_INVALID_FRAGMENT: XmlSchemaInvalidFragmentError,
    _lasso.DST_ERROR_NO_DATA: DstNoDataError,
    _lasso.DS_ERROR_KEYS_MNGR_CREATION_FAILED: DsKeysMngrCreationFailedError,
    _lasso.DS_ERROR_CA_CERT_CHAIN_LOAD_FAILED: DsCaCertChainLoadFailedError,
    _lasso.WSF_PROFILE_ERROR_SOAP_FAULT: WsfprofileSoapFaultError,
    _lasso.PROFILE_ERROR_BUILDING_REQUEST_FAILED: ProfileBuildingRequestFailedError,
    _lasso.PROFILE_ERROR_MISSING_SERVICE_TYPE: ProfileMissingServiceTypeError,
    _lasso.XMLENC_ERROR_INVALID_ENCRYPTED_DATA: XmlencInvalidEncryptedDataError,
    _lasso.XML_ERROR_ATTR_VALUE_INVALID: XmlAttrValueInvalidError,
    _lasso.DST_ERROR_NEW_DATA_MISSING: DstNewDataMissingError,
    _lasso.DS_ERROR_PRIVATE_KEY_LOAD_FAILED: DsPrivateKeyLoadFailedError,
    _lasso.IDWSF2_DISCOVERY_ERROR_LOGICAL_DUPLICATE: Idwsf2DiscoveryLogicalDuplicateError,
    _lasso.WSF_PROFILE_ERROR_MISSING_RESOURCE_ID: WsfprofileMissingResourceIdError,
    _lasso.PROFILE_ERROR_INVALID_IDP_LIST: ProfileInvalidIdpListError,
    _lasso.WSF_PROFILE_ERROR_SERVER_INTERACTION_REQUIRED_FOR_DATA: WsfprofileServerInteractionRequiredForDataError,
    _lasso.NAME_IDENTIFIER_MAPPING_ERROR_FORBIDDEN_CALL_ON_THIS_SIDE: NameidentifiermappingForbiddenCallOnThisSideError,
    _lasso.XML_ERROR_ATTR_VALUE_NOT_FOUND: XmlAttrValueNotFoundError,
    _lasso.PROFILE_ERROR_INVALID_SOAP_MSG: ProfileInvalidSoapMsgError,
    _lasso.PROFILE_ERROR_MISSING_SUBJECT: ProfileMissingSubjectError,
    _lasso.REGISTRY_ERROR_KEY_EXISTS: RegistryKeyExistsError,
    _lasso.XML_ERROR_NODE_NOT_FOUND: XmlNodeNotFoundError,
    _lasso.WSF_PROFILE_ERROR_MISSING_DESCRIPTION: WsfprofileMissingDescriptionError,
    _lasso.PROFILE_ERROR_INVALID_REQUEST: ProfileInvalidRequestError,
    _lasso.PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND: ProfileNameIdentifierNotFoundError,
    _lasso.PROFILE_ERROR_CANNOT_VERIFY_SIGNATURE: ProfileCannotVerifySignatureError,
    _lasso.ECP_ERROR_ASSERTION_CONSUMER_URL_MISMATCH: EcpAssertionConsumerUrlMismatchError,
    _lasso.WSF_PROFILE_ERROR_MISSING_SECURITY: WsfprofileMissingSecurityError,
    _lasso.LOGOUT_ERROR_FEDERATION_NOT_FOUND: LogoutFederationNotFoundError,
    _lasso.XML_ERROR_OBJECT_CONSTRUCTION_FAILED: XmlObjectConstructionFailedError,
    _lasso.PROFILE_ERROR_MISSING_ENDPOINT_REFERENCE: ProfileMissingEndpointReferenceError,
    _lasso.NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_IDENTIFIER: NameidentifiermappingMissingTargetIdentifierError,
    _lasso.PROFILE_ERROR_INVALID_ISSUER: ProfileInvalidIssuerError,
    _lasso.PROFILE_ERROR_INVALID_POST_MSG: ProfileInvalidPostMsgError,
    _lasso.PROFILE_ERROR_UNSUPPORTED_BINDING: ProfileUnsupportedBindingError,
    _lasso.IDWSF2_DST_ERROR_UNKNOWN_STATUS_CODE: Idwsf2DstUnknownStatusCodeError,
    _lasso.DST_ERROR_EMPTY_REQUEST: DstEmptyRequestError,
    _lasso.PAOS_ERROR_MISSING_REQUEST: PaosMissingRequestError,
    _lasso.PROFILE_ERROR_BUILDING_MESSAGE_FAILED: ProfileBuildingMessageFailedError,
    _lasso.XML_ERROR_INVALID_FILE: XmlInvalidFileError,
    _lasso.PROFILE_ERROR_MISSING_RESOURCE_OFFERING: ProfileMissingResourceOfferingError,
    _lasso.PROFILE_ERROR_UNKNOWN_PROVIDER: ProfileUnknownProviderError,
    _lasso.LOGOUT_ERROR_PARTIAL_LOGOUT: LogoutPartialLogoutError,
    _lasso.PARAM_ERROR_CHECK_FAILED: ParamCheckFailedError,
    _lasso.WSF_PROFILE_ERROR_MISSING_ASSERTION_ID: WsfprofileMissingAssertionIdError,
    _lasso.LOGIN_ERROR_REQUEST_DENIED: LoginRequestDeniedError,
    _lasso.PROFILE_ERROR_MISSING_ENCRYPTION_PRIVATE_KEY: ProfileMissingEncryptionPrivateKeyError,
    _lasso.WSF_PROFILE_ERROR_UNSUPPORTED_SECURITY_MECHANISM: WsfprofileUnsupportedSecurityMechanismError,
    _lasso.PROFILE_ERROR_REQUEST_DENIED: ProfileRequestDeniedError,
    _lasso.PROFILE_ERROR_INVALID_ASSERTION_CONDITIONS: ProfileInvalidAssertionConditionsError,
    _lasso.PROFILE_ERROR_MISSING_NAME_IDENTIFIER: ProfileMissingNameIdentifierError,
    _lasso.WSF_PROFILE_ERROR_REDIRECT_REQUEST_UNSUPPORTED_BY_REQUESTER: WsfprofileRedirectRequestUnsupportedByRequesterError,
    _lasso.WSSEC_ERROR_BAD_PASSWORD: WssecBadPasswordError,
    _lasso.LOGIN_ERROR_UNKNOWN_PRINCIPAL: LoginUnknownPrincipalError,
    _lasso.PROFILE_ERROR_MISSING_REQUEST: ProfileMissingRequestError,
    _lasso.PROFILE_ERROR_INVALID_ARTIFACT: ProfileInvalidArtifactError,
    _lasso.SOAP_ERROR_MISSING_ENVELOPE: SoapMissingEnvelopeError,
    _lasso.PROFILE_ERROR_IDENTITY_NOT_FOUND: ProfileIdentityNotFoundError,
    _lasso.PROFILE_ERROR_INVALID_MSG: ProfileInvalidMsgError,
    _lasso.PROFILE_ERROR_UNSUPPORTED_PROFILE: ProfileUnsupportedProfileError,
    _lasso.PROVIDER_ERROR_MISSING_PUBLIC_KEY: ProviderMissingPublicKeyError,
    _lasso.LOGIN_ERROR_CONSENT_NOT_OBTAINED: LoginConsentNotObtainedError,
    _lasso.DST_ERROR_QUERY_FAILED: DstQueryFailedError,
    _lasso.PROFILE_ERROR_MISSING_SERVICE_INSTANCE: ProfileMissingServiceInstanceError,
    _lasso.DST_ERROR_QUERY_NOT_FOUND: DstQueryNotFoundError,
    _lasso.WSF_PROFILE_ERROR_REDIRECT_REQUEST: WsfprofileRedirectRequestError,
    _lasso.DS_ERROR_DECRYPTION_FAILED_MISSING_PRIVATE_KEY: DsDecryptionFailedMissingPrivateKeyError,
    _lasso.DISCOVERY_ERROR_FAILED_TO_BUILD_ENDPOINT_REFERENCE: DiscoveryFailedToBuildEndpointReferenceError,
    _lasso.DS_ERROR_PUBLIC_KEY_LOAD_FAILED: DsPublicKeyLoadFailedError,
    _lasso.SERVER_ERROR_INVALID_XML: ServerInvalidXmlError,
    _lasso.PROFILE_ERROR_MISSING_ASSERTION: ProfileMissingAssertionError,
    _lasso.IDWSF2_DST_ERROR_PARTIAL_FAILURE: Idwsf2DstPartialFailureError,
    _lasso.PROFILE_ERROR_UNKNOWN_PROFILE_URL: ProfileUnknownProfileUrlError,
    _lasso.PROFILE_ERROR_INVALID_QUERY: ProfileInvalidQueryError,
    _lasso.PROFILE_ERROR_CANNOT_FIND_A_PROVIDER: ProfileCannotFindAProviderError,
    _lasso.DEFEDERATION_ERROR_MISSING_NAME_IDENTIFIER: DefederationMissingNameIdentifierError,
    _lasso.PARAM_ERROR_INVALID_VALUE: ParamInvalidValueError,
    _lasso.DS_ERROR_SIGNATURE_VERIFICATION_FAILED: DsSignatureVerificationFailedError,
    _lasso.PROFILE_ERROR_MISSING_ENDPOINT_REFERENCE_ADDRESS: ProfileMissingEndpointReferenceAddressError,
    _lasso.PROFILE_ERROR_ENDPOINT_INDEX_NOT_FOUND: ProfileEndpointIndexNotFoundError,
    _lasso.SERVER_ERROR_NO_PROVIDER_LOADED: ServerNoProviderLoadedError,
    _lasso.DATA_SERVICE_ERROR_UNREGISTERED_DST: DataserviceUnregisteredDstError,
    _lasso.LOGIN_ERROR_INVALID_SIGNATURE: LoginInvalidSignatureError,
    _lasso.ASSERTION_QUERY_ERROR_NOT_AN_ATTRIBUTE_QUERY: AssertionqueryNotAnAttributeQueryError,
    _lasso.LOGIN_ERROR_UNSIGNED_AUTHN_REQUEST: LoginUnsignedAuthnRequestError,
    _lasso.SERVER_ERROR_SET_ENCRYPTION_PRIVATE_KEY_FAILED: ServerSetEncryptionPrivateKeyFailedError,
    _lasso.DS_ERROR_SIGNATURE_TMPL_CREATION_FAILED: DsSignatureTmplCreationFailedError,
    _lasso.PROFILE_ERROR_INVALID_ASSERTION: ProfileInvalidAssertionError,
    _lasso.IDWSF2_DISCOVERY_ERROR_NOT_FOUND: Idwsf2DiscoveryNotFoundError,
    _lasso.DISCOVERY_ERROR_SVC_METADATA_ASSOCIATION_ADD_FAILED: DiscoverySvcMetadataAssociationAddFailedError,
    _lasso.DS_ERROR_CONTEXT_CREATION_FAILED: DsContextCreationFailedError,
    _lasso.PROFILE_ERROR_MISSING_SERVICE_DESCRIPTION: ProfileMissingServiceDescriptionError,
    _lasso.PROFILE_ERROR_MISSING_REMOTE_PROVIDERID: ProfileMissingRemoteProvideridError,
    _lasso.PARAM_ERROR_NON_INITIALIZED_OBJECT: ParamNonInitializedObjectError,
    _lasso.PROFILE_ERROR_MISSING_RESPONSE: ProfileMissingResponseError,
    _lasso.LOGOUT_ERROR_REQUEST_DENIED: LogoutRequestDeniedError,
    _lasso.PAOS_ERROR_MISSING_RESPONSE: PaosMissingResponseError,
    _lasso.XML_ERROR_MISSING_NAMESPACE: XmlMissingNamespaceError,
    _lasso.ASSERTION_QUERY_ERROR_ATTRIBUTE_REQUEST_ALREADY_EXIST: AssertionqueryAttributeRequestAlreadyExistError,
    _lasso.PROFILE_ERROR_MISSING_ARTIFACT: ProfileMissingArtifactError,
    _lasso.WSF_PROFILE_ERROR_MISSING_CORRELATION: WsfprofileMissingCorrelationError,
    _lasso.SERVER_ERROR_ADD_PROVIDER_PROTOCOL_MISMATCH: ServerAddProviderProtocolMismatchError,
    _lasso.PROFILE_ERROR_MISSING_STATUS_CODE: ProfileMissingStatusCodeError,
    _lasso.PROFILE_ERROR_BAD_IDENTITY_DUMP: ProfileBadIdentityDumpError,
    _lasso.PROFILE_ERROR_BUILDING_RESPONSE_FAILED: ProfileBuildingResponseFailedError,
    _lasso.DST_ERROR_MALFORMED_QUERY: DstMalformedQueryError,
    _lasso.DATA_SERVICE_ERROR_CANNOT_ADD_ITEM: DataserviceCannotAddItemError,
    _lasso.LOGIN_ERROR_NO_DEFAULT_ENDPOINT: LoginNoDefaultEndpointError,
    _lasso.IDWSF2_DST_ERROR_DUPLICATE_ITEM: Idwsf2DstDuplicateItemError,
    _lasso.PROFILE_ERROR_BAD_SESSION_DUMP: ProfileBadSessionDumpError,
    _lasso.DISCOVERY_ERROR_MISSING_REQUESTED_SERVICE: DiscoveryMissingRequestedServiceError,
    _lasso.SOAP_ERROR_MISSING_BODY: SoapMissingBodyError,
    _lasso.PAOS_ERROR_MISSING_RESPONSE_CONSUMER_URL: PaosMissingResponseConsumerUrlError,
    _lasso.SERVER_ERROR_ADD_PROVIDER_FAILED: ServerAddProviderFailedError,
    _lasso.PROFILE_ERROR_INVALID_HTTP_METHOD: ProfileInvalidHttpMethodError,
    _lasso.LOGIN_ERROR_INVALID_ASSERTION_SIGNATURE: LoginInvalidAssertionSignatureError,
    _lasso.WSF_PROFILE_ERROR_SECURITY_MECHANISM_CHECK_FAILED: WsfprofileSecurityMechanismCheckFailedError,
    _lasso.IDWSF2_DST_ERROR_ITEM_NOT_FOUND: Idwsf2DstItemNotFoundError,
    _lasso.ECP_ERROR_MISSING_SAML_RESPONSE: EcpMissingSamlResponseError,
    _lasso.IDWSF2_DISCOVERY_ERROR_NO_RESULTS: Idwsf2DiscoveryNoResultsError,
    _lasso.PROFILE_ERROR_MISSING_ISSUER: ProfileMissingIssuerError,
    _lasso.XML_ERROR_NODE_CONTENT_NOT_FOUND: XmlNodeContentNotFoundError,
    _lasso.SOAP_ERROR_MISSING_HEADER: SoapMissingHeaderError,
    _lasso.PROFILE_ERROR_UNKNOWN_ISSUER: ProfileUnknownIssuerError,
}

### Constants (both enums and defines)
RD_COMP_H = _lasso.RD_COMP_H
ERROR_UNDEFINED = _lasso.ERROR_UNDEFINED
ERROR_UNIMPLEMENTED = _lasso.ERROR_UNIMPLEMENTED
ERROR_OUT_OF_MEMORY = _lasso.ERROR_OUT_OF_MEMORY
ERROR_CAST_FAILED = _lasso.ERROR_CAST_FAILED
XML_ERROR_NODE_NOT_FOUND = _lasso.XML_ERROR_NODE_NOT_FOUND
XML_ERROR_NODE_CONTENT_NOT_FOUND = _lasso.XML_ERROR_NODE_CONTENT_NOT_FOUND
XML_ERROR_ATTR_NOT_FOUND = _lasso.XML_ERROR_ATTR_NOT_FOUND
XML_ERROR_ATTR_VALUE_NOT_FOUND = _lasso.XML_ERROR_ATTR_VALUE_NOT_FOUND
XML_ERROR_INVALID_FILE = _lasso.XML_ERROR_INVALID_FILE
XML_ERROR_OBJECT_CONSTRUCTION_FAILED = _lasso.XML_ERROR_OBJECT_CONSTRUCTION_FAILED
XML_ERROR_MISSING_NAMESPACE = _lasso.XML_ERROR_MISSING_NAMESPACE
XML_ERROR_SCHEMA_INVALID_FRAGMENT = _lasso.XML_ERROR_SCHEMA_INVALID_FRAGMENT
XML_ERROR_ATTR_VALUE_INVALID = _lasso.XML_ERROR_ATTR_VALUE_INVALID
DS_ERROR_SIGNATURE_NOT_FOUND = _lasso.DS_ERROR_SIGNATURE_NOT_FOUND
DS_ERROR_INVALID_SIGNATURE = _lasso.DS_ERROR_INVALID_SIGNATURE
DS_ERROR_SIGNATURE_TMPL_CREATION_FAILED = _lasso.DS_ERROR_SIGNATURE_TMPL_CREATION_FAILED
DS_ERROR_CONTEXT_CREATION_FAILED = _lasso.DS_ERROR_CONTEXT_CREATION_FAILED
DS_ERROR_PUBLIC_KEY_LOAD_FAILED = _lasso.DS_ERROR_PUBLIC_KEY_LOAD_FAILED
DS_ERROR_PRIVATE_KEY_LOAD_FAILED = _lasso.DS_ERROR_PRIVATE_KEY_LOAD_FAILED
DS_ERROR_CERTIFICATE_LOAD_FAILED = _lasso.DS_ERROR_CERTIFICATE_LOAD_FAILED
DS_ERROR_SIGNATURE_FAILED = _lasso.DS_ERROR_SIGNATURE_FAILED
DS_ERROR_KEYS_MNGR_CREATION_FAILED = _lasso.DS_ERROR_KEYS_MNGR_CREATION_FAILED
DS_ERROR_KEYS_MNGR_INIT_FAILED = _lasso.DS_ERROR_KEYS_MNGR_INIT_FAILED
DS_ERROR_SIGNATURE_VERIFICATION_FAILED = _lasso.DS_ERROR_SIGNATURE_VERIFICATION_FAILED
DS_ERROR_CA_CERT_CHAIN_LOAD_FAILED = _lasso.DS_ERROR_CA_CERT_CHAIN_LOAD_FAILED
DS_ERROR_INVALID_SIGALG = _lasso.DS_ERROR_INVALID_SIGALG
DS_ERROR_DIGEST_COMPUTE_FAILED = _lasso.DS_ERROR_DIGEST_COMPUTE_FAILED
DS_ERROR_SIGNATURE_TEMPLATE_NOT_FOUND = _lasso.DS_ERROR_SIGNATURE_TEMPLATE_NOT_FOUND
DS_ERROR_TOO_MUCH_REFERENCES = _lasso.DS_ERROR_TOO_MUCH_REFERENCES
DS_ERROR_INVALID_REFERENCE_FOR_SAML = _lasso.DS_ERROR_INVALID_REFERENCE_FOR_SAML
DS_ERROR_DECRYPTION_FAILED = _lasso.DS_ERROR_DECRYPTION_FAILED
DS_ERROR_ENCRYPTION_FAILED = _lasso.DS_ERROR_ENCRYPTION_FAILED
DS_ERROR_DECRYPTION_FAILED_MISSING_PRIVATE_KEY = _lasso.DS_ERROR_DECRYPTION_FAILED_MISSING_PRIVATE_KEY
SERVER_ERROR_PROVIDER_NOT_FOUND = _lasso.SERVER_ERROR_PROVIDER_NOT_FOUND
SERVER_ERROR_ADD_PROVIDER_FAILED = _lasso.SERVER_ERROR_ADD_PROVIDER_FAILED
SERVER_ERROR_ADD_PROVIDER_PROTOCOL_MISMATCH = _lasso.SERVER_ERROR_ADD_PROVIDER_PROTOCOL_MISMATCH
SERVER_ERROR_SET_ENCRYPTION_PRIVATE_KEY_FAILED = _lasso.SERVER_ERROR_SET_ENCRYPTION_PRIVATE_KEY_FAILED
SERVER_ERROR_INVALID_XML = _lasso.SERVER_ERROR_INVALID_XML
SERVER_ERROR_NO_PROVIDER_LOADED = _lasso.SERVER_ERROR_NO_PROVIDER_LOADED
LOGOUT_ERROR_UNSUPPORTED_PROFILE = _lasso.LOGOUT_ERROR_UNSUPPORTED_PROFILE
LOGOUT_ERROR_REQUEST_DENIED = _lasso.LOGOUT_ERROR_REQUEST_DENIED
LOGOUT_ERROR_FEDERATION_NOT_FOUND = _lasso.LOGOUT_ERROR_FEDERATION_NOT_FOUND
LOGOUT_ERROR_UNKNOWN_PRINCIPAL = _lasso.LOGOUT_ERROR_UNKNOWN_PRINCIPAL
LOGOUT_ERROR_PARTIAL_LOGOUT = _lasso.LOGOUT_ERROR_PARTIAL_LOGOUT
PROFILE_ERROR_INVALID_QUERY = _lasso.PROFILE_ERROR_INVALID_QUERY
PROFILE_ERROR_INVALID_POST_MSG = _lasso.PROFILE_ERROR_INVALID_POST_MSG
PROFILE_ERROR_INVALID_SOAP_MSG = _lasso.PROFILE_ERROR_INVALID_SOAP_MSG
PROFILE_ERROR_MISSING_REQUEST = _lasso.PROFILE_ERROR_MISSING_REQUEST
PROFILE_ERROR_INVALID_HTTP_METHOD = _lasso.PROFILE_ERROR_INVALID_HTTP_METHOD
PROFILE_ERROR_INVALID_PROTOCOLPROFILE = _lasso.PROFILE_ERROR_INVALID_PROTOCOLPROFILE
PROFILE_ERROR_INVALID_MSG = _lasso.PROFILE_ERROR_INVALID_MSG
PROFILE_ERROR_MISSING_REMOTE_PROVIDERID = _lasso.PROFILE_ERROR_MISSING_REMOTE_PROVIDERID
PROFILE_ERROR_UNSUPPORTED_PROFILE = _lasso.PROFILE_ERROR_UNSUPPORTED_PROFILE
PROFILE_ERROR_UNKNOWN_PROFILE_URL = _lasso.PROFILE_ERROR_UNKNOWN_PROFILE_URL
PROFILE_ERROR_IDENTITY_NOT_FOUND = _lasso.PROFILE_ERROR_IDENTITY_NOT_FOUND
PROFILE_ERROR_FEDERATION_NOT_FOUND = _lasso.PROFILE_ERROR_FEDERATION_NOT_FOUND
PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND = _lasso.PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND
PROFILE_ERROR_BUILDING_QUERY_FAILED = _lasso.PROFILE_ERROR_BUILDING_QUERY_FAILED
PROFILE_ERROR_BUILDING_REQUEST_FAILED = _lasso.PROFILE_ERROR_BUILDING_REQUEST_FAILED
PROFILE_ERROR_BUILDING_MESSAGE_FAILED = _lasso.PROFILE_ERROR_BUILDING_MESSAGE_FAILED
PROFILE_ERROR_BUILDING_RESPONSE_FAILED = _lasso.PROFILE_ERROR_BUILDING_RESPONSE_FAILED
PROFILE_ERROR_SESSION_NOT_FOUND = _lasso.PROFILE_ERROR_SESSION_NOT_FOUND
PROFILE_ERROR_BAD_IDENTITY_DUMP = _lasso.PROFILE_ERROR_BAD_IDENTITY_DUMP
PROFILE_ERROR_BAD_SESSION_DUMP = _lasso.PROFILE_ERROR_BAD_SESSION_DUMP
PROFILE_ERROR_MISSING_RESPONSE = _lasso.PROFILE_ERROR_MISSING_RESPONSE
PROFILE_ERROR_MISSING_STATUS_CODE = _lasso.PROFILE_ERROR_MISSING_STATUS_CODE
PROFILE_ERROR_MISSING_ARTIFACT = _lasso.PROFILE_ERROR_MISSING_ARTIFACT
PROFILE_ERROR_MISSING_RESOURCE_OFFERING = _lasso.PROFILE_ERROR_MISSING_RESOURCE_OFFERING
PROFILE_ERROR_MISSING_SERVICE_DESCRIPTION = _lasso.PROFILE_ERROR_MISSING_SERVICE_DESCRIPTION
PROFILE_ERROR_MISSING_SERVICE_TYPE = _lasso.PROFILE_ERROR_MISSING_SERVICE_TYPE
PROFILE_ERROR_MISSING_ASSERTION = _lasso.PROFILE_ERROR_MISSING_ASSERTION
PROFILE_ERROR_MISSING_SUBJECT = _lasso.PROFILE_ERROR_MISSING_SUBJECT
PROFILE_ERROR_MISSING_NAME_IDENTIFIER = _lasso.PROFILE_ERROR_MISSING_NAME_IDENTIFIER
PROFILE_ERROR_INVALID_ARTIFACT = _lasso.PROFILE_ERROR_INVALID_ARTIFACT
PROFILE_ERROR_MISSING_ENCRYPTION_PRIVATE_KEY = _lasso.PROFILE_ERROR_MISSING_ENCRYPTION_PRIVATE_KEY
PROFILE_ERROR_STATUS_NOT_SUCCESS = _lasso.PROFILE_ERROR_STATUS_NOT_SUCCESS
PROFILE_ERROR_MISSING_ISSUER = _lasso.PROFILE_ERROR_MISSING_ISSUER
PROFILE_ERROR_MISSING_SERVICE_INSTANCE = _lasso.PROFILE_ERROR_MISSING_SERVICE_INSTANCE
PROFILE_ERROR_MISSING_ENDPOINT_REFERENCE = _lasso.PROFILE_ERROR_MISSING_ENDPOINT_REFERENCE
PROFILE_ERROR_MISSING_ENDPOINT_REFERENCE_ADDRESS = _lasso.PROFILE_ERROR_MISSING_ENDPOINT_REFERENCE_ADDRESS
PROFILE_ERROR_INVALID_ISSUER = _lasso.PROFILE_ERROR_INVALID_ISSUER
PROFILE_ERROR_MISSING_SERVER = _lasso.PROFILE_ERROR_MISSING_SERVER
PROFILE_ERROR_UNKNOWN_PROVIDER = _lasso.PROFILE_ERROR_UNKNOWN_PROVIDER
PROFILE_ERROR_CANNOT_VERIFY_SIGNATURE = _lasso.PROFILE_ERROR_CANNOT_VERIFY_SIGNATURE
PROFILE_ERROR_CANNOT_FIND_A_PROVIDER = _lasso.PROFILE_ERROR_CANNOT_FIND_A_PROVIDER
PROFILE_ERROR_RESPONSE_DOES_NOT_MATCH_REQUEST = _lasso.PROFILE_ERROR_RESPONSE_DOES_NOT_MATCH_REQUEST
PROFILE_ERROR_INVALID_REQUEST = _lasso.PROFILE_ERROR_INVALID_REQUEST
PROFILE_ERROR_INVALID_RESPONSE = _lasso.PROFILE_ERROR_INVALID_RESPONSE
PROFILE_ERROR_UNSUPPORTED_BINDING = _lasso.PROFILE_ERROR_UNSUPPORTED_BINDING
PROFILE_ERROR_INVALID_ASSERTION_CONDITIONS = _lasso.PROFILE_ERROR_INVALID_ASSERTION_CONDITIONS
PROFILE_ERROR_INVALID_ASSERTION = _lasso.PROFILE_ERROR_INVALID_ASSERTION
PROFILE_ERROR_UNKNOWN_ISSUER = _lasso.PROFILE_ERROR_UNKNOWN_ISSUER
PROFILE_ERROR_ISSUER_IS_NOT_AN_IDP = _lasso.PROFILE_ERROR_ISSUER_IS_NOT_AN_IDP
PROFILE_ERROR_REQUEST_DENIED = _lasso.PROFILE_ERROR_REQUEST_DENIED
PROFILE_ERROR_ENDPOINT_INDEX_NOT_FOUND = _lasso.PROFILE_ERROR_ENDPOINT_INDEX_NOT_FOUND
PROFILE_ERROR_INVALID_IDP_LIST = _lasso.PROFILE_ERROR_INVALID_IDP_LIST
PARAM_ERROR_BAD_TYPE_OR_NULL_OBJ = _lasso.PARAM_ERROR_BAD_TYPE_OR_NULL_OBJ
PARAM_ERROR_INVALID_VALUE = _lasso.PARAM_ERROR_INVALID_VALUE
PARAM_ERROR_CHECK_FAILED = _lasso.PARAM_ERROR_CHECK_FAILED
PARAM_ERROR_NON_INITIALIZED_OBJECT = _lasso.PARAM_ERROR_NON_INITIALIZED_OBJECT
LOGIN_ERROR_FEDERATION_NOT_FOUND = _lasso.LOGIN_ERROR_FEDERATION_NOT_FOUND
LOGIN_ERROR_CONSENT_NOT_OBTAINED = _lasso.LOGIN_ERROR_CONSENT_NOT_OBTAINED
LOGIN_ERROR_INVALID_NAMEIDPOLICY = _lasso.LOGIN_ERROR_INVALID_NAMEIDPOLICY
LOGIN_ERROR_REQUEST_DENIED = _lasso.LOGIN_ERROR_REQUEST_DENIED
LOGIN_ERROR_INVALID_SIGNATURE = _lasso.LOGIN_ERROR_INVALID_SIGNATURE
LOGIN_ERROR_UNSIGNED_AUTHN_REQUEST = _lasso.LOGIN_ERROR_UNSIGNED_AUTHN_REQUEST
LOGIN_ERROR_STATUS_NOT_SUCCESS = _lasso.LOGIN_ERROR_STATUS_NOT_SUCCESS
LOGIN_ERROR_UNKNOWN_PRINCIPAL = _lasso.LOGIN_ERROR_UNKNOWN_PRINCIPAL
LOGIN_ERROR_NO_DEFAULT_ENDPOINT = _lasso.LOGIN_ERROR_NO_DEFAULT_ENDPOINT
LOGIN_ERROR_ASSERTION_REPLAY = _lasso.LOGIN_ERROR_ASSERTION_REPLAY
LOGIN_ERROR_ASSERTION_DOES_NOT_MATCH_REQUEST_ID = _lasso.LOGIN_ERROR_ASSERTION_DOES_NOT_MATCH_REQUEST_ID
LOGIN_ERROR_INVALID_ASSERTION_SIGNATURE = _lasso.LOGIN_ERROR_INVALID_ASSERTION_SIGNATURE
DEFEDERATION_ERROR_MISSING_NAME_IDENTIFIER = _lasso.DEFEDERATION_ERROR_MISSING_NAME_IDENTIFIER
SOAP_ERROR_REDIRECT_REQUEST_FAULT = _lasso.SOAP_ERROR_REDIRECT_REQUEST_FAULT
SOAP_FAULT_REDIRECT_REQUEST = _lasso.SOAP_FAULT_REDIRECT_REQUEST
SOAP_ERROR_MISSING_ENVELOPE = _lasso.SOAP_ERROR_MISSING_ENVELOPE
SOAP_ERROR_MISSING_HEADER = _lasso.SOAP_ERROR_MISSING_HEADER
SOAP_ERROR_MISSING_BODY = _lasso.SOAP_ERROR_MISSING_BODY
SOAP_ERROR_MISSING_SOAP_FAULT_DETAIL = _lasso.SOAP_ERROR_MISSING_SOAP_FAULT_DETAIL
NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_NAMESPACE = _lasso.NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_NAMESPACE
NAME_IDENTIFIER_MAPPING_ERROR_FORBIDDEN_CALL_ON_THIS_SIDE = _lasso.NAME_IDENTIFIER_MAPPING_ERROR_FORBIDDEN_CALL_ON_THIS_SIDE
NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_IDENTIFIER = _lasso.NAME_IDENTIFIER_MAPPING_ERROR_MISSING_TARGET_IDENTIFIER
DATA_SERVICE_ERROR_UNREGISTERED_DST = _lasso.DATA_SERVICE_ERROR_UNREGISTERED_DST
DATA_SERVICE_ERROR_CANNOT_ADD_ITEM = _lasso.DATA_SERVICE_ERROR_CANNOT_ADD_ITEM
WSF_PROFILE_ERROR_MISSING_CORRELATION = _lasso.WSF_PROFILE_ERROR_MISSING_CORRELATION
WSF_PROFILE_ERROR_MISSING_SECURITY = _lasso.WSF_PROFILE_ERROR_MISSING_SECURITY
WSF_PROFILE_ERROR_MISSING_ASSERTION_ID = _lasso.WSF_PROFILE_ERROR_MISSING_ASSERTION_ID
WSF_PROFILE_ERROR_MISSING_ENDPOINT = _lasso.WSF_PROFILE_ERROR_MISSING_ENDPOINT
WSF_PROFILE_ERROR_SOAP_FAULT = _lasso.WSF_PROFILE_ERROR_SOAP_FAULT
WSF_PROFILE_ERROR_UNSUPPORTED_SECURITY_MECHANISM = _lasso.WSF_PROFILE_ERROR_UNSUPPORTED_SECURITY_MECHANISM
WSF_PROFILE_ERROR_MISSING_DESCRIPTION = _lasso.WSF_PROFILE_ERROR_MISSING_DESCRIPTION
WSF_PROFILE_ERROR_MISSING_RESOURCE_ID = _lasso.WSF_PROFILE_ERROR_MISSING_RESOURCE_ID
WSF_PROFILE_ERROR_MISSING_CREDENTIAL_REF = _lasso.WSF_PROFILE_ERROR_MISSING_CREDENTIAL_REF
WSF_PROFILE_ERROR_INVALID_OR_MISSING_REFERENCE_TO_MESSAGE_ID = _lasso.WSF_PROFILE_ERROR_INVALID_OR_MISSING_REFERENCE_TO_MESSAGE_ID
WSF_PROFILE_ERROR_SECURITY_MECHANISM_CHECK_FAILED = _lasso.WSF_PROFILE_ERROR_SECURITY_MECHANISM_CHECK_FAILED
WSF_PROFILE_ERROR_UNKNOWN_STATUS_CODE = _lasso.WSF_PROFILE_ERROR_UNKNOWN_STATUS_CODE
WSF_PROFILE_ERROR_SERVER_INTERACTION_REQUIRED = _lasso.WSF_PROFILE_ERROR_SERVER_INTERACTION_REQUIRED
WSF_PROFILE_ERROR_SERVER_INTERACTION_REQUIRED_FOR_DATA = _lasso.WSF_PROFILE_ERROR_SERVER_INTERACTION_REQUIRED_FOR_DATA
WSF_PROFILE_ERROR_REDIRECT_REQUEST = _lasso.WSF_PROFILE_ERROR_REDIRECT_REQUEST
WSF_PROFILE_ERROR_REDIRECT_REQUEST_UNSUPPORTED_BY_REQUESTER = _lasso.WSF_PROFILE_ERROR_REDIRECT_REQUEST_UNSUPPORTED_BY_REQUESTER
WSF_PROFILE_ERROR_MISSING_SENDER_ID = _lasso.WSF_PROFILE_ERROR_MISSING_SENDER_ID
DISCOVERY_ERROR_SVC_METADATA_REGISTER_FAILED = _lasso.DISCOVERY_ERROR_SVC_METADATA_REGISTER_FAILED
DISCOVERY_ERROR_SVC_METADATA_ASSOCIATION_ADD_FAILED = _lasso.DISCOVERY_ERROR_SVC_METADATA_ASSOCIATION_ADD_FAILED
DISCOVERY_ERROR_MISSING_REQUESTED_SERVICE = _lasso.DISCOVERY_ERROR_MISSING_REQUESTED_SERVICE
DISCOVERY_ERROR_FAILED_TO_BUILD_ENDPOINT_REFERENCE = _lasso.DISCOVERY_ERROR_FAILED_TO_BUILD_ENDPOINT_REFERENCE
DST_ERROR_MISSING_SERVICE_DATA = _lasso.DST_ERROR_MISSING_SERVICE_DATA
DST_ERROR_QUERY_FAILED = _lasso.DST_ERROR_QUERY_FAILED
DST_ERROR_QUERY_PARTIALLY_FAILED = _lasso.DST_ERROR_QUERY_PARTIALLY_FAILED
DST_ERROR_MODIFY_FAILED = _lasso.DST_ERROR_MODIFY_FAILED
DST_ERROR_MODIFY_PARTIALLY_FAILED = _lasso.DST_ERROR_MODIFY_PARTIALLY_FAILED
DST_ERROR_NEW_DATA_MISSING = _lasso.DST_ERROR_NEW_DATA_MISSING
DST_ERROR_QUERY_NOT_FOUND = _lasso.DST_ERROR_QUERY_NOT_FOUND
DST_ERROR_NO_DATA = _lasso.DST_ERROR_NO_DATA
DST_ERROR_MALFORMED_QUERY = _lasso.DST_ERROR_MALFORMED_QUERY
DST_ERROR_EMPTY_REQUEST = _lasso.DST_ERROR_EMPTY_REQUEST
REGISTRY_ERROR_KEY_EXISTS = _lasso.REGISTRY_ERROR_KEY_EXISTS
PROVIDER_ERROR_MISSING_PUBLIC_KEY = _lasso.PROVIDER_ERROR_MISSING_PUBLIC_KEY
WSSEC_ERROR_MISSING_SECURITY_TOKEN = _lasso.WSSEC_ERROR_MISSING_SECURITY_TOKEN
WSSEC_ERROR_BAD_PASSWORD = _lasso.WSSEC_ERROR_BAD_PASSWORD
IDWSF2_DISCOVERY_ERROR_FAILED = _lasso.IDWSF2_DISCOVERY_ERROR_FAILED
IDWSF2_DISCOVERY_ERROR_FORBIDDEN = _lasso.IDWSF2_DISCOVERY_ERROR_FORBIDDEN
IDWSF2_DISCOVERY_ERROR_DUPLICATE = _lasso.IDWSF2_DISCOVERY_ERROR_DUPLICATE
IDWSF2_DISCOVERY_ERROR_LOGICAL_DUPLICATE = _lasso.IDWSF2_DISCOVERY_ERROR_LOGICAL_DUPLICATE
IDWSF2_DISCOVERY_ERROR_NO_RESULTS = _lasso.IDWSF2_DISCOVERY_ERROR_NO_RESULTS
IDWSF2_DISCOVERY_ERROR_NOT_FOUND = _lasso.IDWSF2_DISCOVERY_ERROR_NOT_FOUND
IDWSF2_DST_ERROR_DUPLICATE_ITEM = _lasso.IDWSF2_DST_ERROR_DUPLICATE_ITEM
IDWSF2_DST_ERROR_PARTIAL_FAILURE = _lasso.IDWSF2_DST_ERROR_PARTIAL_FAILURE
IDWSF2_DST_ERROR_UNKNOWN_STATUS_CODE = _lasso.IDWSF2_DST_ERROR_UNKNOWN_STATUS_CODE
IDWSF2_DST_ERROR_ITEM_NOT_FOUND = _lasso.IDWSF2_DST_ERROR_ITEM_NOT_FOUND
ASSERTION_QUERY_ERROR_ATTRIBUTE_REQUEST_ALREADY_EXIST = _lasso.ASSERTION_QUERY_ERROR_ATTRIBUTE_REQUEST_ALREADY_EXIST
ASSERTION_QUERY_ERROR_NOT_AN_ATTRIBUTE_QUERY = _lasso.ASSERTION_QUERY_ERROR_NOT_AN_ATTRIBUTE_QUERY
XMLENC_ERROR_INVALID_ENCRYPTED_DATA = _lasso.XMLENC_ERROR_INVALID_ENCRYPTED_DATA
PAOS_ERROR_MISSING_REQUEST = _lasso.PAOS_ERROR_MISSING_REQUEST
PAOS_ERROR_MISSING_RESPONSE = _lasso.PAOS_ERROR_MISSING_RESPONSE
PAOS_ERROR_MISSING_RESPONSE_CONSUMER_URL = _lasso.PAOS_ERROR_MISSING_RESPONSE_CONSUMER_URL
ECP_ERROR_MISSING_REQUEST = _lasso.ECP_ERROR_MISSING_REQUEST
ECP_ERROR_MISSING_RESPONSE = _lasso.ECP_ERROR_MISSING_RESPONSE
ECP_ERROR_MISSING_RELAYSTATE = _lasso.ECP_ERROR_MISSING_RELAYSTATE
ECP_ERROR_MISSING_AUTHN_REQUEST = _lasso.ECP_ERROR_MISSING_AUTHN_REQUEST
ECP_ERROR_MISSING_SAML_RESPONSE = _lasso.ECP_ERROR_MISSING_SAML_RESPONSE
ECP_ERROR_ASSERTION_CONSUMER_URL_MISMATCH = _lasso.ECP_ERROR_ASSERTION_CONSUMER_URL_MISMATCH
CHECK_VERSION_EXACT = _lasso.CHECK_VERSION_EXACT
CHECK_VERSIONABI_COMPATIBLE = _lasso.CHECK_VERSIONABI_COMPATIBLE
CHECK_VERSION_NUMERIC = _lasso.CHECK_VERSION_NUMERIC
LOGIN_PROTOCOL_PROFILE_BRWS_ART = _lasso.LOGIN_PROTOCOL_PROFILE_BRWS_ART
LOGIN_PROTOCOL_PROFILE_BRWS_POST = _lasso.LOGIN_PROTOCOL_PROFILE_BRWS_POST
LOGIN_PROTOCOL_PROFILE_BRWS_LECP = _lasso.LOGIN_PROTOCOL_PROFILE_BRWS_LECP
LOGIN_PROTOCOL_PROFILE_REDIRECT = _lasso.LOGIN_PROTOCOL_PROFILE_REDIRECT
REQUEST_TYPE_INVALID = _lasso.REQUEST_TYPE_INVALID
REQUEST_TYPE_LOGIN = _lasso.REQUEST_TYPE_LOGIN
REQUEST_TYPE_LOGOUT = _lasso.REQUEST_TYPE_LOGOUT
REQUEST_TYPE_DEFEDERATION = _lasso.REQUEST_TYPE_DEFEDERATION
REQUEST_TYPE_NAME_REGISTRATION = _lasso.REQUEST_TYPE_NAME_REGISTRATION
REQUEST_TYPE_NAME_IDENTIFIER_MAPPING = _lasso.REQUEST_TYPE_NAME_IDENTIFIER_MAPPING
REQUEST_TYPE_LECP = _lasso.REQUEST_TYPE_LECP
REQUEST_TYPE_DISCO_QUERY = _lasso.REQUEST_TYPE_DISCO_QUERY
REQUEST_TYPE_DISCO_MODIFY = _lasso.REQUEST_TYPE_DISCO_MODIFY
REQUEST_TYPE_DST_QUERY = _lasso.REQUEST_TYPE_DST_QUERY
REQUEST_TYPE_DST_MODIFY = _lasso.REQUEST_TYPE_DST_MODIFY
REQUEST_TYPE_SASL_REQUEST = _lasso.REQUEST_TYPE_SASL_REQUEST
REQUEST_TYPE_NAME_ID_MANAGEMENT = _lasso.REQUEST_TYPE_NAME_ID_MANAGEMENT
REQUEST_TYPE_IDWSF2_DISCO_SVCMD_REGISTER = _lasso.REQUEST_TYPE_IDWSF2_DISCO_SVCMD_REGISTER
REQUEST_TYPE_IDWSF2_DISCO_SVCMD_ASSOCIATION_ADD = _lasso.REQUEST_TYPE_IDWSF2_DISCO_SVCMD_ASSOCIATION_ADD
REQUEST_TYPE_IDWSF2_DISCO_QUERY = _lasso.REQUEST_TYPE_IDWSF2_DISCO_QUERY
PROFILE_SIGNATURE_HINT_MAYBE = _lasso.PROFILE_SIGNATURE_HINT_MAYBE
PROFILE_SIGNATURE_HINT_FORCE = _lasso.PROFILE_SIGNATURE_HINT_FORCE
PROFILE_SIGNATURE_HINT_FORBID = _lasso.PROFILE_SIGNATURE_HINT_FORBID
PROFILE_SIGNATURE_VERIFY_HINT_MAYBE = _lasso.PROFILE_SIGNATURE_VERIFY_HINT_MAYBE
PROFILE_SIGNATURE_VERIFY_HINT_FORCE = _lasso.PROFILE_SIGNATURE_VERIFY_HINT_FORCE
PROFILE_SIGNATURE_VERIFY_HINT_IGNORE = _lasso.PROFILE_SIGNATURE_VERIFY_HINT_IGNORE
PROFILE_SIGNATURE_VERIFY_HINT_LAST = _lasso.PROFILE_SIGNATURE_VERIFY_HINT_LAST
HTTP_METHOD_NONE = _lasso.HTTP_METHOD_NONE
HTTP_METHOD_ANY = _lasso.HTTP_METHOD_ANY
HTTP_METHOD_IDP_INITIATED = _lasso.HTTP_METHOD_IDP_INITIATED
HTTP_METHOD_GET = _lasso.HTTP_METHOD_GET
HTTP_METHOD_POST = _lasso.HTTP_METHOD_POST
HTTP_METHOD_REDIRECT = _lasso.HTTP_METHOD_REDIRECT
HTTP_METHOD_SOAP = _lasso.HTTP_METHOD_SOAP
HTTP_METHOD_ARTIFACT_GET = _lasso.HTTP_METHOD_ARTIFACT_GET
HTTP_METHOD_ARTIFACT_POST = _lasso.HTTP_METHOD_ARTIFACT_POST
HTTP_METHOD_PAOS = _lasso.HTTP_METHOD_PAOS
HTTP_METHOD_LAST = _lasso.HTTP_METHOD_LAST
MD_PROTOCOL_TYPE_FEDERATION_TERMINATION = _lasso.MD_PROTOCOL_TYPE_FEDERATION_TERMINATION
MD_PROTOCOL_TYPE_NAME_IDENTIFIER_MAPPING = _lasso.MD_PROTOCOL_TYPE_NAME_IDENTIFIER_MAPPING
MD_PROTOCOL_TYPE_REGISTER_NAME_IDENTIFIER = _lasso.MD_PROTOCOL_TYPE_REGISTER_NAME_IDENTIFIER
MD_PROTOCOL_TYPE_SINGLE_LOGOUT = _lasso.MD_PROTOCOL_TYPE_SINGLE_LOGOUT
MD_PROTOCOL_TYPE_SINGLE_SIGN_ON = _lasso.MD_PROTOCOL_TYPE_SINGLE_SIGN_ON
MD_PROTOCOL_TYPE_ARTIFACT_RESOLUTION = _lasso.MD_PROTOCOL_TYPE_ARTIFACT_RESOLUTION
MD_PROTOCOL_TYPE_MANAGE_NAME_ID = _lasso.MD_PROTOCOL_TYPE_MANAGE_NAME_ID
MD_PROTOCOL_TYPE_ASSERTION_ID_REQUEST = _lasso.MD_PROTOCOL_TYPE_ASSERTION_ID_REQUEST
MD_PROTOCOL_TYPE_AUTHN_QUERY = _lasso.MD_PROTOCOL_TYPE_AUTHN_QUERY
MD_PROTOCOL_TYPE_AUTHZ = _lasso.MD_PROTOCOL_TYPE_AUTHZ
MD_PROTOCOL_TYPE_ATTRIBUTE = _lasso.MD_PROTOCOL_TYPE_ATTRIBUTE
MD_PROTOCOL_TYPE_LAST = _lasso.MD_PROTOCOL_TYPE_LAST
PROVIDER_ROLE_ANY = _lasso.PROVIDER_ROLE_ANY
PROVIDER_ROLE_NONE = _lasso.PROVIDER_ROLE_NONE
PROVIDER_ROLE_SP = _lasso.PROVIDER_ROLE_SP
PROVIDER_ROLE_IDP = _lasso.PROVIDER_ROLE_IDP
PROVIDER_ROLE_BOTH = _lasso.PROVIDER_ROLE_BOTH
PROVIDER_ROLE_AUTHN_AUTHORITY = _lasso.PROVIDER_ROLE_AUTHN_AUTHORITY
PROVIDER_ROLE_AUTHZ_AUTHORITY = _lasso.PROVIDER_ROLE_AUTHZ_AUTHORITY
PROVIDER_ROLE_ATTRIBUTE_AUTHORITY = _lasso.PROVIDER_ROLE_ATTRIBUTE_AUTHORITY
PROVIDER_ROLE_LAST = _lasso.PROVIDER_ROLE_LAST
PROVIDER_ROLE_ALL = _lasso.PROVIDER_ROLE_ALL
PROTOCOL_NONE = _lasso.PROTOCOL_NONE
PROTOCOL_LIBERTY_1_0 = _lasso.PROTOCOL_LIBERTY_1_0
PROTOCOL_LIBERTY_1_1 = _lasso.PROTOCOL_LIBERTY_1_1
PROTOCOL_LIBERTY_1_2 = _lasso.PROTOCOL_LIBERTY_1_2
PROTOCOL_SAML_2_0 = _lasso.PROTOCOL_SAML_2_0
ENCRYPTION_MODE_NONE = _lasso.ENCRYPTION_MODE_NONE
ENCRYPTION_MODE_NAMEID = _lasso.ENCRYPTION_MODE_NAMEID
ENCRYPTION_MODE_ASSERTION = _lasso.ENCRYPTION_MODE_ASSERTION
SERVER_LOAD_METADATA_FLAG_DEFAULT = _lasso.SERVER_LOAD_METADATA_FLAG_DEFAULT
SERVER_LOAD_METADATA_FLAG_CHECK_ENTITIES_DESCRIPTOR_SIGNATURE = _lasso.SERVER_LOAD_METADATA_FLAG_CHECK_ENTITIES_DESCRIPTOR_SIGNATURE
SERVER_LOAD_METADATA_FLAG_CHECK_ENTITY_DESCRIPTOR_SIGNATURE = _lasso.SERVER_LOAD_METADATA_FLAG_CHECK_ENTITY_DESCRIPTOR_SIGNATURE
SERVER_LOAD_METADATA_FLAG_INHERIT_SIGNATURE = _lasso.SERVER_LOAD_METADATA_FLAG_INHERIT_SIGNATURE
ASSERTION_QUERY_REQUEST_TYPE_UNSET = _lasso.ASSERTION_QUERY_REQUEST_TYPE_UNSET
ASSERTION_QUERY_REQUEST_TYPE_ASSERTION_ID = _lasso.ASSERTION_QUERY_REQUEST_TYPE_ASSERTION_ID
ASSERTION_QUERY_REQUEST_TYPE_AUTHN = _lasso.ASSERTION_QUERY_REQUEST_TYPE_AUTHN
ASSERTION_QUERY_REQUEST_TYPE_ATTRIBUTE = _lasso.ASSERTION_QUERY_REQUEST_TYPE_ATTRIBUTE
ASSERTION_QUERY_REQUEST_TYPE_AUTHZ_DECISION = _lasso.ASSERTION_QUERY_REQUEST_TYPE_AUTHZ_DECISION
ASSERTION_QUERY_REQUEST_TYPE_LAST = _lasso.ASSERTION_QUERY_REQUEST_TYPE_LAST
SAML2_ASSERTION_VALID = _lasso.SAML2_ASSERTION_VALID
SAML2_ASSERTION_INVALID = _lasso.SAML2_ASSERTION_INVALID
SAML2_ASSERTION_INDETERMINATE = _lasso.SAML2_ASSERTION_INDETERMINATE
DURATION_MINUTE = _lasso.DURATION_MINUTE
DURATION_HOUR = _lasso.DURATION_HOUR
DURATION_DAY = _lasso.DURATION_DAY
DURATION_WEEK = _lasso.DURATION_WEEK
SOAP_ENV_HREF = _lasso.SOAP_ENV_HREF
SOAP_ENV_PREFIX = _lasso.SOAP_ENV_PREFIX
SOAP_ENV_ACTOR = _lasso.SOAP_ENV_ACTOR
SOAP_FAULT_CODE_SERVER = _lasso.SOAP_FAULT_CODE_SERVER
SOAP_FAULT_CODE_CLIENT = _lasso.SOAP_FAULT_CODE_CLIENT
SOAP_FAULT_CODE_MUST_UNDERSTAND = _lasso.SOAP_FAULT_CODE_MUST_UNDERSTAND
SOAP_FAULT_CODE_VERSION_MISMATCH = _lasso.SOAP_FAULT_CODE_VERSION_MISMATCH
PRIVATE_STATUS_CODE_FAILED_TO_RESTORE_ARTIFACT = _lasso.PRIVATE_STATUS_CODE_FAILED_TO_RESTORE_ARTIFACT
WSUTIL1_HREF = _lasso.WSUTIL1_HREF
WSUTIL1_PREFIX = _lasso.WSUTIL1_PREFIX
XMLENC_HREF = _lasso.XMLENC_HREF
XMLENC_PREFIX = _lasso.XMLENC_PREFIX
LASSO_HREF = _lasso.LASSO_HREF
LASSO_PREFIX = _lasso.LASSO_PREFIX
PYTHON_HREF = _lasso.PYTHON_HREF
SIGNATURE_TYPE_ATTRIBUTE = _lasso.SIGNATURE_TYPE_ATTRIBUTE
SIGNATURE_METHOD_ATTRIBUTE = _lasso.SIGNATURE_METHOD_ATTRIBUTE
PRIVATE_KEY_ATTRIBUTE = _lasso.PRIVATE_KEY_ATTRIBUTE
PRIVATE_KEY_PASSWORD_ATTRIBUTE = _lasso.PRIVATE_KEY_PASSWORD_ATTRIBUTE
CERTIFICATE_ATTRIBUTE = _lasso.CERTIFICATE_ATTRIBUTE
LIB_HREF = _lasso.LIB_HREF
LIB_PREFIX = _lasso.LIB_PREFIX
LIB_MAJOR_VERSION_N = _lasso.LIB_MAJOR_VERSION_N
LIB_MINOR_VERSION_N = _lasso.LIB_MINOR_VERSION_N
LIB_NAMEID_POLICY_TYPE_NONE = _lasso.LIB_NAMEID_POLICY_TYPE_NONE
LIB_NAMEID_POLICY_TYPE_ONE_TIME = _lasso.LIB_NAMEID_POLICY_TYPE_ONE_TIME
LIB_NAMEID_POLICY_TYPE_FEDERATED = _lasso.LIB_NAMEID_POLICY_TYPE_FEDERATED
LIB_NAMEID_POLICY_TYPE_ANY = _lasso.LIB_NAMEID_POLICY_TYPE_ANY
LIB_AUTHN_CONTEXT_CLASS_REF_INTERNET_PROTOCOL = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_INTERNET_PROTOCOL
LIB_AUTHN_CONTEXT_CLASS_REF_INTERNET_PROTOCOL_PASSWORD = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_INTERNET_PROTOCOL_PASSWORD
LIB_AUTHN_CONTEXT_CLASS_REF_MOBILE_ONE_FACTOR_UNREGISTERED = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_MOBILE_ONE_FACTOR_UNREGISTERED
LIB_AUTHN_CONTEXT_CLASS_REF_MOBILE_TWO_FACTOR_UNREGISTERED = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_MOBILE_TWO_FACTOR_UNREGISTERED
LIB_AUTHN_CONTEXT_CLASS_REF_MOBILE_ONE_FACTOR_CONTRACT = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_MOBILE_ONE_FACTOR_CONTRACT
LIB_AUTHN_CONTEXT_CLASS_REF_MOBILE_TWO_FACTOR_CONTRACT = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_MOBILE_TWO_FACTOR_CONTRACT
LIB_AUTHN_CONTEXT_CLASS_REF_PASSWORD = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_PASSWORD
LIB_AUTHN_CONTEXT_CLASS_REF_PASSWORD_PROTECTED_TRANSPORT = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_PASSWORD_PROTECTED_TRANSPORT
LIB_AUTHN_CONTEXT_CLASS_REF_PREVIOUS_SESSION = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_PREVIOUS_SESSION
LIB_AUTHN_CONTEXT_CLASS_REF_SMARTCARD = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_SMARTCARD
LIB_AUTHN_CONTEXT_CLASS_REF_SMARTCARD_PKI = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_SMARTCARD_PKI
LIB_AUTHN_CONTEXT_CLASS_REF_SOFTWARE_PKI = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_SOFTWARE_PKI
LIB_AUTHN_CONTEXT_CLASS_REF_TIME_SYNC_TOKEN = _lasso.LIB_AUTHN_CONTEXT_CLASS_REF_TIME_SYNC_TOKEN
LIB_AUTHN_CONTEXT_COMPARISON_EXACT = _lasso.LIB_AUTHN_CONTEXT_COMPARISON_EXACT
LIB_AUTHN_CONTEXT_COMPARISON_MINIMUM = _lasso.LIB_AUTHN_CONTEXT_COMPARISON_MINIMUM
LIB_AUTHN_CONTEXT_COMPARISON_MAXIMUM = _lasso.LIB_AUTHN_CONTEXT_COMPARISON_MAXIMUM
LIB_AUTHN_CONTEXT_COMPARISON_BETTER = _lasso.LIB_AUTHN_CONTEXT_COMPARISON_BETTER
LIB_STATUS_CODE_FEDERATION_DOES_NOT_EXIST = _lasso.LIB_STATUS_CODE_FEDERATION_DOES_NOT_EXIST
LIB_STATUS_CODE_INVALID_ASSERTION_CONSUMER_SERVICE_INDEX = _lasso.LIB_STATUS_CODE_INVALID_ASSERTION_CONSUMER_SERVICE_INDEX
LIB_STATUS_CODE_INVALID_SIGNATURE = _lasso.LIB_STATUS_CODE_INVALID_SIGNATURE
LIB_STATUS_CODE_NO_AUTHN_CONTEXT = _lasso.LIB_STATUS_CODE_NO_AUTHN_CONTEXT
LIB_STATUS_CODE_NO_AVAILABLEIDP = _lasso.LIB_STATUS_CODE_NO_AVAILABLEIDP
LIB_STATUS_CODE_NO_PASSIVE = _lasso.LIB_STATUS_CODE_NO_PASSIVE
LIB_STATUS_CODE_NO_SUPPORTEDIDP = _lasso.LIB_STATUS_CODE_NO_SUPPORTEDIDP
LIB_STATUS_CODE_PROXY_COUNT_EXCEEDED = _lasso.LIB_STATUS_CODE_PROXY_COUNT_EXCEEDED
LIB_STATUS_CODE_UNKNOWN_PRINCIPAL = _lasso.LIB_STATUS_CODE_UNKNOWN_PRINCIPAL
LIB_STATUS_CODE_UNSIGNED_AUTHN_REQUEST = _lasso.LIB_STATUS_CODE_UNSIGNED_AUTHN_REQUEST
LIB_STATUS_CODE_UNSUPPORTED_PROFILE = _lasso.LIB_STATUS_CODE_UNSUPPORTED_PROFILE
LIB_PROTOCOL_PROFILE_BRWS_ART = _lasso.LIB_PROTOCOL_PROFILE_BRWS_ART
LIB_PROTOCOL_PROFILE_BRWS_POST = _lasso.LIB_PROTOCOL_PROFILE_BRWS_POST
LIB_PROTOCOL_PROFILE_BRWS_LECP = _lasso.LIB_PROTOCOL_PROFILE_BRWS_LECP
LIB_PROTOCOL_PROFILE_FED_TERM_IDP_HTTP = _lasso.LIB_PROTOCOL_PROFILE_FED_TERM_IDP_HTTP
LIB_PROTOCOL_PROFILE_FED_TERM_IDP_SOAP = _lasso.LIB_PROTOCOL_PROFILE_FED_TERM_IDP_SOAP
LIB_PROTOCOL_PROFILE_FED_TERM_SP_HTTP = _lasso.LIB_PROTOCOL_PROFILE_FED_TERM_SP_HTTP
LIB_PROTOCOL_PROFILE_FED_TERM_SP_SOAP = _lasso.LIB_PROTOCOL_PROFILE_FED_TERM_SP_SOAP
LIB_PROTOCOL_PROFILE_NIM_SP_HTTP = _lasso.LIB_PROTOCOL_PROFILE_NIM_SP_HTTP
LIB_PROTOCOL_PROFILE_RNI_IDP_HTTP = _lasso.LIB_PROTOCOL_PROFILE_RNI_IDP_HTTP
LIB_PROTOCOL_PROFILE_RNI_IDP_SOAP = _lasso.LIB_PROTOCOL_PROFILE_RNI_IDP_SOAP
LIB_PROTOCOL_PROFILE_RNI_SP_HTTP = _lasso.LIB_PROTOCOL_PROFILE_RNI_SP_HTTP
LIB_PROTOCOL_PROFILE_RNI_SP_SOAP = _lasso.LIB_PROTOCOL_PROFILE_RNI_SP_SOAP
LIB_PROTOCOL_PROFILE_SLO_SP_HTTP = _lasso.LIB_PROTOCOL_PROFILE_SLO_SP_HTTP
LIB_PROTOCOL_PROFILE_SLO_SP_SOAP = _lasso.LIB_PROTOCOL_PROFILE_SLO_SP_SOAP
LIB_PROTOCOL_PROFILE_SLO_IDP_HTTP = _lasso.LIB_PROTOCOL_PROFILE_SLO_IDP_HTTP
LIB_PROTOCOL_PROFILE_SLO_IDP_SOAP = _lasso.LIB_PROTOCOL_PROFILE_SLO_IDP_SOAP
LIB_NAME_IDENTIFIER_FORMAT_FEDERATED = _lasso.LIB_NAME_IDENTIFIER_FORMAT_FEDERATED
LIB_NAME_IDENTIFIER_FORMAT_ONE_TIME = _lasso.LIB_NAME_IDENTIFIER_FORMAT_ONE_TIME
LIB_NAME_IDENTIFIER_FORMAT_ENCRYPTED = _lasso.LIB_NAME_IDENTIFIER_FORMAT_ENCRYPTED
LIB_NAME_IDENTIFIER_FORMAT_ENTITYID = _lasso.LIB_NAME_IDENTIFIER_FORMAT_ENTITYID
LIB_CONSENT_OBTAINED = _lasso.LIB_CONSENT_OBTAINED
LIB_CONSENT_OBTAINED_PRIOR = _lasso.LIB_CONSENT_OBTAINED_PRIOR
LIB_CONSENT_OBTAINED_CURRENT_IMPLICIT = _lasso.LIB_CONSENT_OBTAINED_CURRENT_IMPLICIT
LIB_CONSENT_OBTAINED_CURRENT_EXPLICIT = _lasso.LIB_CONSENT_OBTAINED_CURRENT_EXPLICIT
LIB_CONSENT_UNAVAILABLE = _lasso.LIB_CONSENT_UNAVAILABLE
LIB_CONSENT_INAPPLICABLE = _lasso.LIB_CONSENT_INAPPLICABLE
METADATA_HREF = _lasso.METADATA_HREF
METADATA_PREFIX = _lasso.METADATA_PREFIX
SAML_ASSERTION_HREF = _lasso.SAML_ASSERTION_HREF
SAML_ASSERTION_PREFIX = _lasso.SAML_ASSERTION_PREFIX
SAML_PROTOCOL_HREF = _lasso.SAML_PROTOCOL_HREF
SAML_PROTOCOL_PREFIX = _lasso.SAML_PROTOCOL_PREFIX
SAML_MAJOR_VERSION_N = _lasso.SAML_MAJOR_VERSION_N
SAML_MINOR_VERSION_N = _lasso.SAML_MINOR_VERSION_N
SAML_STATUS_CODE_SUCCESS = _lasso.SAML_STATUS_CODE_SUCCESS
SAML_STATUS_CODE_VERSION_MISMATCH = _lasso.SAML_STATUS_CODE_VERSION_MISMATCH
SAML_STATUS_CODE_REQUESTER = _lasso.SAML_STATUS_CODE_REQUESTER
SAML_STATUS_CODE_RESPONDER = _lasso.SAML_STATUS_CODE_RESPONDER
SAML_STATUS_CODE_REQUEST_VERSION_TOO_HIGH = _lasso.SAML_STATUS_CODE_REQUEST_VERSION_TOO_HIGH
SAML_STATUS_CODE_REQUEST_VERSION_TOO_LOW = _lasso.SAML_STATUS_CODE_REQUEST_VERSION_TOO_LOW
SAML_STATUS_CODE_REQUEST_VERSION_DEPRECATED = _lasso.SAML_STATUS_CODE_REQUEST_VERSION_DEPRECATED
SAML_STATUS_CODE_TOO_MANY_RESPONSES = _lasso.SAML_STATUS_CODE_TOO_MANY_RESPONSES
SAML_STATUS_CODE_RESOURCE_NOT_RECOGNIZED = _lasso.SAML_STATUS_CODE_RESOURCE_NOT_RECOGNIZED
SAML_STATUS_CODE_REQUEST_DENIED = _lasso.SAML_STATUS_CODE_REQUEST_DENIED
SAML_AUTHENTICATION_METHOD_PASSWORD = _lasso.SAML_AUTHENTICATION_METHOD_PASSWORD
SAML_AUTHENTICATION_METHOD_KERBEROS = _lasso.SAML_AUTHENTICATION_METHOD_KERBEROS
SAML_AUTHENTICATION_METHOD_SECURE_REMOTE_PASSWORD = _lasso.SAML_AUTHENTICATION_METHOD_SECURE_REMOTE_PASSWORD
SAML_AUTHENTICATION_METHOD_HARDWARE_TOKEN = _lasso.SAML_AUTHENTICATION_METHOD_HARDWARE_TOKEN
SAML_AUTHENTICATION_METHOD_SMARTCARD_PKI = _lasso.SAML_AUTHENTICATION_METHOD_SMARTCARD_PKI
SAML_AUTHENTICATION_METHOD_SOFTWARE_PKI = _lasso.SAML_AUTHENTICATION_METHOD_SOFTWARE_PKI
SAML_AUTHENTICATION_METHOD_PGP = _lasso.SAML_AUTHENTICATION_METHOD_PGP
SAML_AUTHENTICATION_METHODS_PKI = _lasso.SAML_AUTHENTICATION_METHODS_PKI
SAML_AUTHENTICATION_METHOD_XKMS = _lasso.SAML_AUTHENTICATION_METHOD_XKMS
SAML_AUTHENTICATION_METHOD_XMLD_SIG = _lasso.SAML_AUTHENTICATION_METHOD_XMLD_SIG
SAML_AUTHENTICATION_METHOD_UNSPECIFIED = _lasso.SAML_AUTHENTICATION_METHOD_UNSPECIFIED
SAML_AUTHENTICATION_METHOD_LIBERTY = _lasso.SAML_AUTHENTICATION_METHOD_LIBERTY
SAML_CONFIRMATION_METHOD_ARTIFACT = _lasso.SAML_CONFIRMATION_METHOD_ARTIFACT
SAML_CONFIRMATION_METHOD_ARTIFACT01 = _lasso.SAML_CONFIRMATION_METHOD_ARTIFACT01
SAML_CONFIRMATION_METHOD_BEARER = _lasso.SAML_CONFIRMATION_METHOD_BEARER
SAML_CONFIRMATION_METHOD_HOLDER_OF_KEY = _lasso.SAML_CONFIRMATION_METHOD_HOLDER_OF_KEY
SAML_CONFIRMATION_METHOD_SENDER_VOUCHES = _lasso.SAML_CONFIRMATION_METHOD_SENDER_VOUCHES
SAML_EXT_CHANNEL_BINDING = _lasso.SAML_EXT_CHANNEL_BINDING
PAOS_HREF = _lasso.PAOS_HREF
PAOS_PREFIX = _lasso.PAOS_PREFIX
ECP_HREF = _lasso.ECP_HREF
ECP_PREFIX = _lasso.ECP_PREFIX
XSI_HREF = _lasso.XSI_HREF
XSI_PREFIX = _lasso.XSI_PREFIX
XML_HREF = _lasso.XML_HREF
XML_PREFIX = _lasso.XML_PREFIX
MESSAGE_FORMAT_XSCHEMA_ERROR = _lasso.MESSAGE_FORMAT_XSCHEMA_ERROR
MESSAGE_FORMAT_ERROR = _lasso.MESSAGE_FORMAT_ERROR
MESSAGE_FORMAT_UNKNOWN = _lasso.MESSAGE_FORMAT_UNKNOWN
MESSAGE_FORMAT_XML = _lasso.MESSAGE_FORMAT_XML
MESSAGE_FORMAT_BASE64 = _lasso.MESSAGE_FORMAT_BASE64
MESSAGE_FORMAT_QUERY = _lasso.MESSAGE_FORMAT_QUERY
MESSAGE_FORMAT_SOAP = _lasso.MESSAGE_FORMAT_SOAP
SIGNATURE_TYPE_NONE = _lasso.SIGNATURE_TYPE_NONE
SIGNATURE_TYPE_SIMPLE = _lasso.SIGNATURE_TYPE_SIMPLE
SIGNATURE_TYPE_WITHX509 = _lasso.SIGNATURE_TYPE_WITHX509
SIGNATURE_TYPE_LAST = _lasso.SIGNATURE_TYPE_LAST
SIGNATURE_METHOD_NONE = _lasso.SIGNATURE_METHOD_NONE
SIGNATURE_METHOD_RSA_SHA1 = _lasso.SIGNATURE_METHOD_RSA_SHA1
SIGNATURE_METHOD_DSA_SHA1 = _lasso.SIGNATURE_METHOD_DSA_SHA1
SIGNATURE_METHOD_HMAC_SHA1 = _lasso.SIGNATURE_METHOD_HMAC_SHA1
SIGNATURE_METHOD_RSA_SHA256 = _lasso.SIGNATURE_METHOD_RSA_SHA256
SIGNATURE_METHOD_HMAC_SHA256 = _lasso.SIGNATURE_METHOD_HMAC_SHA256
SIGNATURE_METHOD_RSA_SHA384 = _lasso.SIGNATURE_METHOD_RSA_SHA384
SIGNATURE_METHOD_HMAC_SHA384 = _lasso.SIGNATURE_METHOD_HMAC_SHA384
SIGNATURE_METHOD_RSA_SHA512 = _lasso.SIGNATURE_METHOD_RSA_SHA512
SIGNATURE_METHOD_HMAC_SHA512 = _lasso.SIGNATURE_METHOD_HMAC_SHA512
SIGNATURE_METHOD_LAST = _lasso.SIGNATURE_METHOD_LAST
ENCRYPTION_SYM_KEY_TYPE_DEFAULT = _lasso.ENCRYPTION_SYM_KEY_TYPE_DEFAULT
ENCRYPTION_SYM_KEY_TYPE_AES_256 = _lasso.ENCRYPTION_SYM_KEY_TYPE_AES_256
ENCRYPTION_SYM_KEY_TYPE_AES_128 = _lasso.ENCRYPTION_SYM_KEY_TYPE_AES_128
ENCRYPTION_SYM_KEY_TYPE_3DES = _lasso.ENCRYPTION_SYM_KEY_TYPE_3DES
ENCRYTPION_SYM_KEY_TYPE_LAST = _lasso.ENCRYTPION_SYM_KEY_TYPE_LAST
DS_HREF = _lasso.DS_HREF
DS_PREFIX = _lasso.DS_PREFIX
SAML2_METADATA_HREF = _lasso.SAML2_METADATA_HREF
SAML2_METADATA_PREFIX = _lasso.SAML2_METADATA_PREFIX
SAML2_PROTOCOL_HREF = _lasso.SAML2_PROTOCOL_HREF
SAML2_PROTOCOL_PREFIX = _lasso.SAML2_PROTOCOL_PREFIX
SAML2_ASSERTION_HREF = _lasso.SAML2_ASSERTION_HREF
SAML2_ASSERTION_PREFIX = _lasso.SAML2_ASSERTION_PREFIX
SAML2_METADATA_BINDING_SOAP = _lasso.SAML2_METADATA_BINDING_SOAP
SAML2_METADATA_BINDING_REDIRECT = _lasso.SAML2_METADATA_BINDING_REDIRECT
SAML2_METADATA_BINDING_POST = _lasso.SAML2_METADATA_BINDING_POST
SAML2_METADATA_BINDING_ARTIFACT = _lasso.SAML2_METADATA_BINDING_ARTIFACT
SAML2_METADATA_BINDING_PAOS = _lasso.SAML2_METADATA_BINDING_PAOS
SAML2_METADATA_BINDING_URI = _lasso.SAML2_METADATA_BINDING_URI
SAML2_DEFLATE_ENCODING = _lasso.SAML2_DEFLATE_ENCODING
SAML2_NAME_IDENTIFIER_FORMAT_UNSPECIFIED = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_UNSPECIFIED
SAML2_NAME_IDENTIFIER_FORMAT_EMAIL = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_EMAIL
SAML2_NAME_IDENTIFIER_FORMAT_X509 = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_X509
SAML2_NAME_IDENTIFIER_FORMAT_WINDOWS = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_WINDOWS
SAML2_NAME_IDENTIFIER_FORMAT_KERBEROS = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_KERBEROS
SAML2_NAME_IDENTIFIER_FORMAT_ENTITY = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_ENTITY
SAML2_NAME_IDENTIFIER_FORMAT_PERSISTENT = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_PERSISTENT
SAML2_NAME_IDENTIFIER_FORMAT_TRANSIENT = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_TRANSIENT
SAML2_NAME_IDENTIFIER_FORMAT_ENCRYPTED = _lasso.SAML2_NAME_IDENTIFIER_FORMAT_ENCRYPTED
SAML2_ATTRIBUTE_NAME_EPR = _lasso.SAML2_ATTRIBUTE_NAME_EPR
SAML2_ATTRIBUTE_NAME_FORMAT_UNSPECIFIED = _lasso.SAML2_ATTRIBUTE_NAME_FORMAT_UNSPECIFIED
SAML2_ATTRIBUTE_NAME_FORMAT_URI = _lasso.SAML2_ATTRIBUTE_NAME_FORMAT_URI
SAML2_ATTRIBUTE_NAME_FORMAT_BASIC = _lasso.SAML2_ATTRIBUTE_NAME_FORMAT_BASIC
SAML2_ACTION_NAMESPACE_RWEDC = _lasso.SAML2_ACTION_NAMESPACE_RWEDC
SAML2_ACTION_NAMESPACE_RWEDC_NEGATION = _lasso.SAML2_ACTION_NAMESPACE_RWEDC_NEGATION
SAML2_ACTION_NAMESPACE_GHPP = _lasso.SAML2_ACTION_NAMESPACE_GHPP
SAML2_ACTION_NAMESPACE_UNIX = _lasso.SAML2_ACTION_NAMESPACE_UNIX
SAML2_ACTION_RWEDC_READ = _lasso.SAML2_ACTION_RWEDC_READ
SAML2_ACTION_RWEDC_WRITE = _lasso.SAML2_ACTION_RWEDC_WRITE
SAML2_ACTION_RWEDC_EXECUTE = _lasso.SAML2_ACTION_RWEDC_EXECUTE
SAML2_ACTION_RWEDC_DELETE = _lasso.SAML2_ACTION_RWEDC_DELETE
SAML2_ACTION_RWEDC_CONTROL = _lasso.SAML2_ACTION_RWEDC_CONTROL
SAML2_ACTION_RWEDC_NEGATION = _lasso.SAML2_ACTION_RWEDC_NEGATION
SAML2_ACTION_GHPP_GET = _lasso.SAML2_ACTION_GHPP_GET
SAML2_ACTION_GHPP_HEAD = _lasso.SAML2_ACTION_GHPP_HEAD
SAML2_ACTION_GHPP_PUT = _lasso.SAML2_ACTION_GHPP_PUT
SAML2_ACTION_GHPP_POST = _lasso.SAML2_ACTION_GHPP_POST
SAML2_CONSENT_OBTAINED = _lasso.SAML2_CONSENT_OBTAINED
SAML2_CONSENT_PRIOR = _lasso.SAML2_CONSENT_PRIOR
SAML2_CONSENT_IMPLICIT = _lasso.SAML2_CONSENT_IMPLICIT
SAML2_CONSENT_EXPLICIT = _lasso.SAML2_CONSENT_EXPLICIT
SAML2_CONSENT_UNAVAILABLE = _lasso.SAML2_CONSENT_UNAVAILABLE
SAML2_CONSENT_INAPPLICABLE = _lasso.SAML2_CONSENT_INAPPLICABLE
SAML2_STATUS_CODE_SUCCESS = _lasso.SAML2_STATUS_CODE_SUCCESS
SAML2_STATUS_CODE_REQUESTER = _lasso.SAML2_STATUS_CODE_REQUESTER
SAML2_STATUS_CODE_RESPONDER = _lasso.SAML2_STATUS_CODE_RESPONDER
SAML2_STATUS_CODE_VERSION_MISMATCH = _lasso.SAML2_STATUS_CODE_VERSION_MISMATCH
SAML2_STATUS_CODE_AUTHN_FAILED = _lasso.SAML2_STATUS_CODE_AUTHN_FAILED
SAML2_STATUS_CODE_INVALID_ATTR_NAME = _lasso.SAML2_STATUS_CODE_INVALID_ATTR_NAME
SAML2_STATUS_CODE_INVALID_NAME_ID_POLICY = _lasso.SAML2_STATUS_CODE_INVALID_NAME_ID_POLICY
SAML2_STATUS_CODE_NO_AUTHN_CONTEXT = _lasso.SAML2_STATUS_CODE_NO_AUTHN_CONTEXT
SAML2_STATUS_CODE_NO_AVAILABLE_IDP = _lasso.SAML2_STATUS_CODE_NO_AVAILABLE_IDP
SAML2_STATUS_CODE_NO_PASSIVE = _lasso.SAML2_STATUS_CODE_NO_PASSIVE
SAML2_STATUS_CODE_NO_SUPPORTED_IDP = _lasso.SAML2_STATUS_CODE_NO_SUPPORTED_IDP
SAML2_STATUS_CODE_PARTIAL_LOGOUT = _lasso.SAML2_STATUS_CODE_PARTIAL_LOGOUT
SAML2_STATUS_CODE_PROXY_COUNT_EXCEEDED = _lasso.SAML2_STATUS_CODE_PROXY_COUNT_EXCEEDED
SAML2_STATUS_CODE_REQUEST_DENIED = _lasso.SAML2_STATUS_CODE_REQUEST_DENIED
SAML2_STATUS_CODE_REQUEST_UNSUPPORTED = _lasso.SAML2_STATUS_CODE_REQUEST_UNSUPPORTED
SAML2_STATUS_CODE_REQUEST_VERSION_DEPRECATED = _lasso.SAML2_STATUS_CODE_REQUEST_VERSION_DEPRECATED
SAML2_STATUS_CODE_REQUEST_VERSION_TOO_HIGH = _lasso.SAML2_STATUS_CODE_REQUEST_VERSION_TOO_HIGH
SAML2_STATUS_CODE_REQUEST_VERSION_TOO_LOW = _lasso.SAML2_STATUS_CODE_REQUEST_VERSION_TOO_LOW
SAML2_STATUS_CODE_RESOURCE_NOT_RECOGNIZED = _lasso.SAML2_STATUS_CODE_RESOURCE_NOT_RECOGNIZED
SAML2_STATUS_CODE_TOO_MANY_RESPONSES = _lasso.SAML2_STATUS_CODE_TOO_MANY_RESPONSES
SAML2_STATUS_CODE_UNKNOWN_ATTR_PROFILE = _lasso.SAML2_STATUS_CODE_UNKNOWN_ATTR_PROFILE
SAML2_STATUS_CODE_UNKNOWN_PRINCIPAL = _lasso.SAML2_STATUS_CODE_UNKNOWN_PRINCIPAL
SAML2_STATUS_CODE_UNSUPPORTED_BINDING = _lasso.SAML2_STATUS_CODE_UNSUPPORTED_BINDING
SAML2_AUTHN_CONTEXT_AUTHENTICATED_TELEPHONY = _lasso.SAML2_AUTHN_CONTEXT_AUTHENTICATED_TELEPHONY
SAML2_AUTHN_CONTEXT_INTERNET_PROTOCOL = _lasso.SAML2_AUTHN_CONTEXT_INTERNET_PROTOCOL
SAML2_AUTHN_CONTEXT_INTERNET_PROTOCOL_PASSWORD = _lasso.SAML2_AUTHN_CONTEXT_INTERNET_PROTOCOL_PASSWORD
SAML2_AUTHN_CONTEXT_KERBEROS = _lasso.SAML2_AUTHN_CONTEXT_KERBEROS
SAML2_AUTHN_CONTEXT_MOBILE_ONE_FACTOR_CONTRACT = _lasso.SAML2_AUTHN_CONTEXT_MOBILE_ONE_FACTOR_CONTRACT
SAML2_AUTHN_CONTEXT_MOBILE_ONE_FACTOR_UNREGISTERED = _lasso.SAML2_AUTHN_CONTEXT_MOBILE_ONE_FACTOR_UNREGISTERED
SAML2_AUTHN_CONTEXT_MOBILE_TWO_FACTOR_CONTRACT = _lasso.SAML2_AUTHN_CONTEXT_MOBILE_TWO_FACTOR_CONTRACT
SAML2_AUTHN_CONTEXT_MOBILE_TWO_FACTOR_UNREGISTERED = _lasso.SAML2_AUTHN_CONTEXT_MOBILE_TWO_FACTOR_UNREGISTERED
SAML2_AUTHN_CONTEXT_NOMAD_TELEPHONY = _lasso.SAML2_AUTHN_CONTEXT_NOMAD_TELEPHONY
SAML2_AUTHN_CONTEXT_PERSONALIZED_TELEPHONY = _lasso.SAML2_AUTHN_CONTEXT_PERSONALIZED_TELEPHONY
SAML2_AUTHN_CONTEXT_PGP = _lasso.SAML2_AUTHN_CONTEXT_PGP
SAML2_AUTHN_CONTEXT_PASSWORD_PROTECTED_TRANSPORT = _lasso.SAML2_AUTHN_CONTEXT_PASSWORD_PROTECTED_TRANSPORT
SAML2_AUTHN_CONTEXT_PASSWORD = _lasso.SAML2_AUTHN_CONTEXT_PASSWORD
SAML2_AUTHN_CONTEXT_PREVIOUS_SESSION = _lasso.SAML2_AUTHN_CONTEXT_PREVIOUS_SESSION
SAML2_AUTHN_CONTEXT_SMARTCARD = _lasso.SAML2_AUTHN_CONTEXT_SMARTCARD
SAML2_AUTHN_CONTEXT_SMARTCARD_PKI = _lasso.SAML2_AUTHN_CONTEXT_SMARTCARD_PKI
SAML2_AUTHN_CONTEXT_SOFTWARE_PKI = _lasso.SAML2_AUTHN_CONTEXT_SOFTWARE_PKI
SAML2_AUTHN_CONTEXT_SPKI = _lasso.SAML2_AUTHN_CONTEXT_SPKI
SAML2_AUTHN_CONTEXT_SECURE_REMOTE_PASSWORD = _lasso.SAML2_AUTHN_CONTEXT_SECURE_REMOTE_PASSWORD
SAML2_AUTHN_CONTEXT_TLS_CLIENT = _lasso.SAML2_AUTHN_CONTEXT_TLS_CLIENT
SAML2_AUTHN_CONTEXT_X509 = _lasso.SAML2_AUTHN_CONTEXT_X509
SAML2_AUTHN_CONTEXT_TELEPHONY = _lasso.SAML2_AUTHN_CONTEXT_TELEPHONY
SAML2_AUTHN_CONTEXT_TIME_SYNC_TOKEN = _lasso.SAML2_AUTHN_CONTEXT_TIME_SYNC_TOKEN
SAML2_AUTHN_CONTEXT_XMLDSIG = _lasso.SAML2_AUTHN_CONTEXT_XMLDSIG
SAML2_AUTHN_CONTEXT_UNSPECIFIED = _lasso.SAML2_AUTHN_CONTEXT_UNSPECIFIED
SAML2_CONFIRMATION_METHOD_BEARER = _lasso.SAML2_CONFIRMATION_METHOD_BEARER
SAML2_CONFIRMATION_METHOD_HOLDER_OF_KEY = _lasso.SAML2_CONFIRMATION_METHOD_HOLDER_OF_KEY
SAML2_FIELD_ENCODING = _lasso.SAML2_FIELD_ENCODING
SAML2_FIELD_RESPONSE = _lasso.SAML2_FIELD_RESPONSE
SAML2_FIELD_REQUEST = _lasso.SAML2_FIELD_REQUEST
SAML2_FIELD_ARTIFACT = _lasso.SAML2_FIELD_ARTIFACT
SAML2_FIELD_RELAYSTATE = _lasso.SAML2_FIELD_RELAYSTATE
SAML2_FIELD_SIGNATURE = _lasso.SAML2_FIELD_SIGNATURE
SAML2_FIELD_SIGALG = _lasso.SAML2_FIELD_SIGALG
SAML2_ATTRIBUTE_PROFILE_BASIC = _lasso.SAML2_ATTRIBUTE_PROFILE_BASIC
SAML2_ATTRIBUTE_PROFILE_X500 = _lasso.SAML2_ATTRIBUTE_PROFILE_X500
SAML2_ATTRIBUTE_PROFILE_UUID = _lasso.SAML2_ATTRIBUTE_PROFILE_UUID
SAML2_ATTRIBUTE_PROFILE_DCE = _lasso.SAML2_ATTRIBUTE_PROFILE_DCE
SAML2_ECP_PROFILE_WANT_AUTHN_SIGNED = _lasso.SAML2_ECP_PROFILE_WANT_AUTHN_SIGNED
SAML2_CONDITIONS_DELEGATION = _lasso.SAML2_CONDITIONS_DELEGATION
WSF_ENABLED = _lasso.WSF_ENABLED
SAML2_SUPPORT = True

class Node(object):
    def __init__(self, ):
        self._cptr = _lasso.node_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromDump(cls, dump):
         return cptrToPy(_lasso.node_new_from_dump(str2lasso(dump)))

    @classmethod
    def newFromSoap(cls, soap):
         return cptrToPy(_lasso.node_new_from_soap(str2lasso(soap)))

    @classmethod
    def newFromXmlNode(cls, node):
         return cptrToPy(_lasso.node_new_from_xmlNode(node))

    def cleanupOriginalXmlnodes(self):
        '''
        C{self}: a L{Node}
        
        Traverse the L{Node} tree starting at Node and remove keeped xmlNode
        if one is found.
        
        @return: None
        '''
        _lasso.node_cleanup_original_xmlnodes(self._cptr)

    def dump(self):
        '''
        Dumps C{self}.  All datas in object are dumped in an XML format.
        
        @return: a full XML dump of C{self}.
        '''
        return _lasso.node_dump(self._cptr)

    def exportToBase64(self):
        '''
        Exports C{self} to a base64-encoded message.
        
        @return: a base64-encoded export of C{self}.
        '''
        return _lasso.node_export_to_base64(self._cptr)

    def exportToQuery(self, sign_method = 1, private_key_file = None):
        '''
        Exports C{self} to a HTTP query string.  If C{private_key_file} is
        None, query won't be signed.
        
        @param sign_method:  the Signature transform method
        @param private_key_file:  the path to the private key (may be None)
        @return: a HTTP query export of C{self}.
        '''
        return _lasso.node_export_to_query(self._cptr, sign_method, str2lasso(private_key_file))

    def exportToQueryWithPassword(self, sign_method = 1, private_key_file = None, private_key_file_password = None):
        '''
        Exports C{self} to a HTTP query string.  If C{private_key_file} is
        None, query won't be signed.
        
        @param sign_method:  the Signature transform method
        @param private_key_file:  the path to the private key (may be None)
        @param private_key_file_password:  the password needed to decrypt the
            private key
        @return: a HTTP query export of C{self}.
        '''
        return _lasso.node_export_to_query_with_password(self._cptr, sign_method, str2lasso(private_key_file), str2lasso(private_key_file_password))

    def exportToSoap(self):
        '''
        Exports C{self} to a SOAP message.
        
        @return: a SOAP export of C{self}.
        '''
        return _lasso.node_export_to_soap(self._cptr)

    def exportToSoapWithHeaders(self, headers = None):
        '''
        Exports C{self} to a SOAP message. The C{self} becomes the SOAP body.
        each header in the #headers list is added to the SOAP header if non-
        None. C{headers} is permitted to be an empty list (e.g. None).
        
        <example> <title>Create SOAP envelope with variable number of header
        nodes</title>
        
        <para>You need to form a SOAP message with authn_request as the body
        and paos_request, ecp_request and ecp_relaystate as SOAP header
        elements. It is possible one or more of these may be None and should
        be skipped.</para> <programlisting> char *text = None; LassoNode
        *paos_request = None; LassoNode *ecp_request = None; LassoNode
        *ecp_relaystate = None; GList *headers = None;
        
        paos_request = lasso_paos_request_new(responseConsumerURL,
        message_id); ecp_request = lasso_ecp_request_new(issuer, is_passive,
        provider_name, idp_list);
        
        lasso_list_add_new_gobject(headers, paos_request);
        lasso_list_add_new_gobject(headers, ecp_request);
        lasso_list_add_new_gobject(headers, ecp_relaystate);
        
        text = lasso_node_export_to_soap_with_headers(node, headers);
        
        lasso_release_list_of_gobjects(headers); </programlisting> </example>
        
        @param headers:  #GList of #LassNode
        @return: a SOAP export of C{self}.
        '''
        return _lasso.node_export_to_soap_with_headers(self._cptr, headers)

    def exportToXml(self):
        '''
        Exports C{self} to an xml message.
        
        @return: an xml export of C{self}.
        '''
        return _lasso.node_export_to_xml(self._cptr)

    def exportToPaosRequest(self, issuer, responseConsumerURL, relay_state):
        '''
        Exports C{self} to a PAOS message.
        
        Deprecated, use lasso_node_export_to_paos_request_full() instead
        
        @return: a PAOS export of C{self}.
        '''
        return _lasso.node_export_to_paos_request(self._cptr, str2lasso(issuer), str2lasso(responseConsumerURL), str2lasso(relay_state))

    def exportToPaosRequestFull(self, issuer, responseConsumerURL, message_id, relay_state, is_passive, provider_name = None, idp_list = None):
        '''
        Creates a new SOAP message. The SOAP headers include a PaosRequst, a
        EcpRequest and optionally a EcpRelayState. The SOAP body contains the
        C{self} parameters.
        
        Returns: string containing a PAOS request. The string must be freed by
        the caller.
        
        
        
        
        
        
        
        '''
        return _lasso.node_export_to_paos_request_full(self._cptr, str2lasso(issuer), str2lasso(responseConsumerURL), str2lasso(message_id), str2lasso(relay_state), is_passive, str2lasso(provider_name), idp_list and idp_list._cptr)

    def exportToEcpSoapResponse(self, assertionConsumerURL):
        '''
        Exports C{self} to a ECP SOAP message.
        
        @return: a ECP SOAP export of C{self}.
        '''
        return _lasso.node_export_to_ecp_soap_response(self._cptr, str2lasso(assertionConsumerURL))

    def getXmlNode(self, lasso_dump):
        '''
        Builds an XML representation of C{self}.
        
        @param lasso_dump:  whether to include lasso-specific nodes
        @return: a new xmlNode.
        '''
        return _lasso.node_get_xmlNode(self._cptr, lasso_dump)

    def getOriginalXmlnode(self):
        '''
        Retrieve the original xmlNode eventually associated to this L{Node}.
        
        @return: an #xmlNodePtr or None.
        '''
        return _lasso.node_get_original_xmlnode(self._cptr)

    def setOriginalXmlnode(self, xmlnode):
        '''
        Set the underlying XML representation of the object.
        
        @param xmlnode:  an #xmlNode
        '''
        _lasso.node_set_original_xmlnode(self._cptr, xmlnode)

    def setCustomNamespace(self, prefix, href):
        '''
        Set a custom namespace for an object instance, use it with object
        existing a lot of revision of the nearly same namespace.
        
        @param prefix:  the prefix to use for the definition
        @param href:  the URI of the namespace
        '''
        _lasso.node_set_custom_namespace(self._cptr, str2lasso(prefix), str2lasso(href))

    def setCustomNodename(self, nodename):
        '''
        Set a custom nodename for an object instance, use it with object
        implement a schema type and not a real element.
        
        @param nodename:  the name to use for the node
        '''
        _lasso.node_set_custom_nodename(self._cptr, str2lasso(nodename))

    def getName(self):
        '''
        Return the XML element name for this object, the one that would be
        used in the XML dump of this object.
        
        @return: the name of the object, the value must not be stored.
        '''
        return _lasso.node_get_name(self._cptr)

    def getNamespace(self):
        return _lasso.node_get_namespace(self._cptr)

    def initFromMessage(self, message):
        '''
        Parses C{message} and initialiazes C{self} fields with data from it.
        Message type may be base64, SOAP, XML or query string, correct type is
        found automatically.
        
        @param message:  a Liberty message
        @return: a L{MessageFormat} value.
        '''
        return _lasso.node_init_from_message(self._cptr, str2lasso(message))

    def initFromQuery(self, query):
        '''
        Initialiazes C{self} fields with data from C{query} string.
        
        @param query:  the query string
        @return: True if success
        '''
        return _lasso.node_init_from_query(self._cptr, str2lasso(query))

    def initFromXml(self, xmlnode):
        '''
        Initialiazes C{self} fields with data from C{xmlnode} XML node.
        
        @param xmlnode:  the libxml2 node
        '''
        rc = _lasso.node_init_from_xml(self._cptr, xmlnode)
        Error.raise_on_rc(rc)

    def debug(self, level = 10):
        '''
        Create a debug dump for C{self}, it is pretty printed so any contained
        signature will be uncheckable.
        
        @param level:  the indentation depth, i.e. the depth of the last nodes
            to be indented.
        @return: a full indented and so human readable dump of C{self}.
        '''
        return _lasso.node_debug(self._cptr, level)

    originalXmlnode = property(getOriginalXmlnode, setOriginalXmlnode)
    name = property(getName)
    namespace = property(getNamespace)

class Key(Node):
    @classmethod
    def newForSignatureFromBase64String(cls, base64_string, password, signature_method, certificate):
         return cptrToPy(_lasso.key_new_for_signature_from_base64_string(str2lasso(base64_string), str2lasso(password), signature_method, str2lasso(certificate)))

    @classmethod
    def newForSignatureFromFile(cls, filename_or_buffer, password, signature_method, certificate):
         return cptrToPy(_lasso.key_new_for_signature_from_file(str2lasso(filename_or_buffer), str2lasso(password), signature_method, str2lasso(certificate)))

    def queryVerify(self, query):
        '''
        query: a raw HTTP query string
        
        Sign the given query string using the given key.
        
        @return: the signed query string.
        '''
        rc = _lasso.key_query_verify(self._cptr, str2lasso(query))
        Error.raise_on_rc(rc)

    def querySign(self, query):
        return _lasso.key_query_sign(self._cptr, str2lasso(query))

    def saml2XmlVerify(self, id, document):
        '''
        Verify the first signature node child of the node with the given id.
        It follows from the profile of XMLDsig used by the SAML 2.0
        specification.
        
        @param id:  the value of the ID attribute of signed node
        @param document:  the document containing the signed node
        @return: 0 if the signature validate, an error code otherwise.
        '''
        rc = _lasso.key_saml2_xml_verify(self._cptr, str2lasso(id), document)
        Error.raise_on_rc(rc)

    def saml2XmlSign(self, id, document):
        '''
        Sign the first signature node child of the node with the given id. It
        no signature node is found a new one is added at the end of the
        children list of the signed node.
        
        The passed document node is modified in-place.
        
        @param id:  the value of the ID attribute of signed node
        @param document:  the document containing the signed node
        @return: The modified xmlNode object, or None if the signature failed.
        '''
        return _lasso.key_saml2_xml_sign(self._cptr, str2lasso(id), document)


class Federation(Node):
    def __init__(self, remote_providerID):
        self._cptr = _lasso.federation_new(str2lasso(remote_providerID))
        if self._cptr is None:
            raise Error('failed to create object')

    def get_remoteProviderId(self):
        t = _lasso.Federation_remoteProviderId_get(self._cptr)
        return t;
    def set_remoteProviderId(self, value):
        value = str2lasso(value)
        _lasso.Federation_remoteProviderId_set(self._cptr, value)
    remoteProviderId = property(get_remoteProviderId, set_remoteProviderId)

    def get_localNameIdentifier(self):
        t = _lasso.Federation_localNameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_localNameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Federation_localNameIdentifier_set(self._cptr, value)
    localNameIdentifier = property(get_localNameIdentifier, set_localNameIdentifier)

    def get_remoteNameIdentifier(self):
        t = _lasso.Federation_remoteNameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_remoteNameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Federation_remoteNameIdentifier_set(self._cptr, value)
    remoteNameIdentifier = property(get_remoteNameIdentifier, set_remoteNameIdentifier)

    def buildLocalNameIdentifier(self, nameQualifier, format, content):
        '''
        Builds federation local name identifier.
        
        @param nameQualifier:  the name identifier qualifier
        @param format:  the name identifier format
        @param content:  the name identifier content
        '''
        _lasso.federation_build_local_name_identifier(self._cptr, str2lasso(nameQualifier), str2lasso(format), str2lasso(content))

    def verifyNameIdentifier(self, name_identifier):
        '''
        Checks whether federation is for C{name_identifier}.
        
        @param name_identifier:  the L{SamlNameIdentifier}
        @return: True if the federation is for C{name_identifier}.
        '''
        return _lasso.federation_verify_name_identifier(self._cptr, name_identifier and name_identifier._cptr)


class Identity(Node):
    def __init__(self, ):
        self._cptr = _lasso.identity_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromDump(cls, dump):
         return cptrToPy(_lasso.identity_new_from_dump(str2lasso(dump)))

    def get_federations(self):
        t = _lasso.Identity_federations_get(self._cptr)
        if not t: return t
        d2 = {}
        for k, v in t.items():
            d2[k] = cptrToPy(v)
        t = frozendict(d2)
        return t;
    def set_federations(self, value):
        _lasso.Identity_federations_set(self._cptr, value)
    federations = property(get_federations, set_federations)

    def get_isDirty(self):
        t = _lasso.Identity_isDirty_get(self._cptr)
        return t;
    def set_isDirty(self, value):
        _lasso.Identity_isDirty_set(self._cptr, value)
    isDirty = property(get_isDirty, set_isDirty)

    def getFederation(self, providerID):
        '''
        Looks up and returns the L{Federation} for this provider ID.
        
        @param providerID:  the provider ID
        @return: the L{Federation}; or None if it didn't exist.  The
            L{Federation} is internally allocated.  It must not be freed,
            modified or stored.
        '''
        return cptrToPy(_lasso.identity_get_federation(self._cptr, str2lasso(providerID)))

    def dump(self):
        '''
        Dumps C{self} content to an XML string.
        
        @return: the dump string.
        '''
        return _lasso.identity_dump(self._cptr)


class Profile(Node):
    def get_server(self):
        t = _lasso.Profile_server_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_server(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Profile_server_set(self._cptr, value)
    server = property(get_server, set_server)

    def get_request(self):
        t = _lasso.Profile_request_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_request(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Profile_request_set(self._cptr, value)
    request = property(get_request, set_request)

    def get_response(self):
        t = _lasso.Profile_response_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_response(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Profile_response_set(self._cptr, value)
    response = property(get_response, set_response)

    def get_nameIdentifier(self):
        t = _lasso.Profile_nameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Profile_nameIdentifier_set(self._cptr, value)
    nameIdentifier = property(get_nameIdentifier, set_nameIdentifier)

    def get_remoteProviderId(self):
        t = _lasso.Profile_remoteProviderId_get(self._cptr)
        return t;
    def set_remoteProviderId(self, value):
        value = str2lasso(value)
        _lasso.Profile_remoteProviderId_set(self._cptr, value)
    remoteProviderId = property(get_remoteProviderId, set_remoteProviderId)

    def get_msgUrl(self):
        t = _lasso.Profile_msgUrl_get(self._cptr)
        return t;
    def set_msgUrl(self, value):
        value = str2lasso(value)
        _lasso.Profile_msgUrl_set(self._cptr, value)
    msgUrl = property(get_msgUrl, set_msgUrl)

    def get_msgBody(self):
        t = _lasso.Profile_msgBody_get(self._cptr)
        return t;
    def set_msgBody(self, value):
        value = str2lasso(value)
        _lasso.Profile_msgBody_set(self._cptr, value)
    msgBody = property(get_msgBody, set_msgBody)

    def get_msgRelayState(self):
        t = _lasso.Profile_msgRelayState_get(self._cptr)
        return t;
    def set_msgRelayState(self, value):
        value = str2lasso(value)
        _lasso.Profile_msgRelayState_set(self._cptr, value)
    msgRelayState = property(get_msgRelayState, set_msgRelayState)

    def getIdentity(self):
        '''
        Gets the identity bound to C{self}.
        
        @return: the identity or None if it none was found.  The L{Identity}
            object is internally allocated and must not be freed by the
            caller.
        '''
        return cptrToPy(_lasso.profile_get_identity(self._cptr))

    def getSession(self):
        '''
        Gets the session bound to C{self}.
        
        @return: the session or None if it none was found.  The L{Session}
            object is internally allocated and must not be freed by the
            caller.
        '''
        return cptrToPy(_lasso.profile_get_session(self._cptr))

    def hasDirtyIdentity(self):
        '''
        Checks whether identity has been modified (and should therefore be
        saved).
        
        @return: True if identity has changed
        '''
        return _lasso.profile_has_dirty_identity(self._cptr)

    def hasDirtySession(self):
        '''
        Checks whether session has been modified (and should therefore be
        saved).
        
        @return: True if session has changed
        '''
        return _lasso.profile_has_dirty_session(self._cptr)

    def setIdentityFromDump(self, dump):
        '''
        Builds a new L{Identity} object from XML dump and binds it to C{self}.
        
        @param dump:  XML identity dump
        '''
        rc = _lasso.profile_set_identity_from_dump(self._cptr, str2lasso(dump))
        Error.raise_on_rc(rc)

    def setSessionFromDump(self, dump):
        '''
        Builds a new L{Session} object from XML dump and binds it to C{self}.
        
        @param dump:  XML session dump
        '''
        rc = _lasso.profile_set_session_from_dump(self._cptr, str2lasso(dump))
        Error.raise_on_rc(rc)

    def getFederationNameIdentifier(self):
        '''
        Looks up appropriate federation in object and gets the service
        provider name identifier (which is actually a L{SamlNameIdentifier} in
        ID-FF 1.2 and L{Saml2NameID} in SAML 2.0).
        
        @return: the name identifier or None if none was found.  The L{Node}
            object is internally allocated and must not be freed by the
            caller.
        '''
        return cptrToPy(_lasso.profile_get_federation_nameIdentifier(self._cptr))

    def getArtifact(self):
        '''
        Return the artifact token
        
        @return: a newly allocated string or None.
        '''
        return _lasso.profile_get_artifact(self._cptr)

    def getArtifactMessage(self):
        '''
        Return the artifact message.
        
        @return: a newly allocated string or None
        '''
        return _lasso.profile_get_artifact_message(self._cptr)

    def setArtifactMessage(self, message):
        '''
        Set C{message} as the content for the ArtifactResolve response.
        
        @param message:  the artifact message content
        '''
        _lasso.profile_set_artifact_message(self._cptr, str2lasso(message))

    def setSignatureHint(self, signature_hint):
        '''
        By default each profile will choose to sign or not its messages, this
        method allow to force or forbid the signature of messages, on a per
        transaction basis.
        
        @param signature_hint:  wheter next produced messages should be signed
            or not (or let Lasso choose from implicit information).
        '''
        _lasso.profile_set_signature_hint(self._cptr, signature_hint)

    def getSignatureHint(self):
        '''
        Return the value of the signature hint attribute (see
        lasso_profile_set_signature_hint()).
        
        @return: a value in the enum type L{ProfileSignatureHint}.
        '''
        return _lasso.profile_get_signature_hint(self._cptr)

    def setSoapFaultResponse(self, faultcode, faultstring = None, details = None):
        '''
        Set the response to a SOAP fault, using C{faultcode}, C{faultstring},
        and C{details} to initialize it.
        
        @param faultcode:  the code for the SOAP fault
        @param faultstring:  the description for the SOAP fault
        @param details:  a list of nodes to add as details
        @return: 0 if successful, an error code otherwise.
        '''
        rc = _lasso.profile_set_soap_fault_response(self._cptr, str2lasso(faultcode), str2lasso(faultstring), details)
        Error.raise_on_rc(rc)

    def setSignatureVerifyHint(self, signature_verify_hint):
        '''
        By default each profile will choose to verify or not its messages,
        this method allow to force or forbid the signature of messages, on a
        per transaction basis.
        
        @param signature_verify_hint:  whether next received message
            signatures should be checked or not (or let Lasso choose from
            implicit information).
        '''
        _lasso.profile_set_signature_verify_hint(self._cptr, signature_verify_hint)

    def getSignatureVerifyHint(self):
        '''
        Return the value of the signature verify hint attribute (see
        lasso_profile_set_signature_verify_hint()).
        
        @return: a value in the enum type L{ProfileSignatureVerifyHint}.
        '''
        return _lasso.profile_get_signature_verify_hint(self._cptr)

    def ssoRoleWith(self, remote_provider_id):
        '''
        Returns whether the current provider is a service provider relatively
        to another provider. It uses the L{Profile}.identity to find if a
        federation qualifier by the given provider exists or the reverse.
        
        @param remote_provider_id:  the identifier of a provider
        @return: #LASSO_PROVIDER_ROLE_NONE if nothing can be said,
            #LASSO_PROVIDER_ROLE_SP if a federation qualifier by
            C{remote_provider_id} exists or #LASSO_PROVIDER_ROLE_IDP if a
            federation qualifier by our own L{Provider}.ProviderID exists.
        '''
        return _lasso.profile_sso_role_with(self._cptr, str2lasso(remote_provider_id))

    def getSignatureStatus(self):
        '''
        Returns the signature status from the last parsed message.
        
        @return: 0 if no error from signature checking occurred, an error code
            otherwise.
        '''
        rc = _lasso.profile_get_signature_status(self._cptr)
        Error.raise_on_rc(rc)

    def getMessageId(self):
        '''
        Return the messge ID.
        
        @return: a newly allocated string or None
        '''
        return _lasso.profile_get_message_id(self._cptr)

    def setMessageId(self, message_id):
        '''
        Set C{message_id} for the current conversation
        
        @param message_id:  the message ID
        '''
        _lasso.profile_set_message_id(self._cptr, str2lasso(message_id))

    def getIdpList(self):
        '''
        Return the messge ID.
        
        @return: a L{Node}, when using SAML 2.0 a L{Samlp2IDPList}, when using
            ID-FF a L{LibIDPList}.
        '''
        return cptrToPy(_lasso.profile_get_idp_list(self._cptr))

    def setIdpList(self, idp_list):
        '''
        Set C{idp_list} for the current conversation
        
        @param idp_list:  a L{Node}, when using SAML 2.0 a L{Samlp2IDPList},
            when using ID-FF a L{LibIDPList}.
        '''
        _lasso.profile_set_idp_list(self._cptr, idp_list and idp_list._cptr)

    identity = property(getIdentity)
    session = property(getSession)
    federationNameIdentifier = property(getFederationNameIdentifier)
    artifact = property(getArtifact)
    artifactMessage = property(getArtifactMessage, setArtifactMessage)
    signatureHint = property(getSignatureHint, setSignatureHint)
    signatureVerifyHint = property(getSignatureVerifyHint, setSignatureVerifyHint)
    signatureStatus = property(getSignatureStatus)
    messageId = property(getMessageId, setMessageId)
    idpList = property(getIdpList, setIdpList)

class Defederation(Profile):
    def __init__(self, server):
        self._cptr = _lasso.defederation_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    def buildNotificationMsg(self):
        '''
        Builds the federation termination notification message.
        
        It gets the federation termination notification protocol profile and:
        
         - if it is a SOAP method, then it builds the federation termination
           notification SOAP message, optionally signs the notification node,
           sets   C{msg_body}, gets the SoapEndpoint url and sets C{msg_url}
           of the federation   termination object.
        
         - if it is a HTTP-Redirect method, then it builds the federation
           termination   notification QUERY message (optionally signs the
           notification message),   builds the federation termination
           notification url with federation   termination service url, sets
           C{msg_url} in the federation termination   object, sets C{msg_body}
           to None.
        '''
        rc = _lasso.defederation_build_notification_msg(self._cptr)
        Error.raise_on_rc(rc)

    def initNotification(self, remote_providerID = None, http_method = HTTP_METHOD_ANY):
        '''
        Sets a new federation termination notification to the remote provider
        id with the provider id of the requester (from the server object) and
        the name identifier of the federated principal.
        
        @param remote_providerID:  the provider id of the federation
            termination notified provider.
        @param http_method:  the HTTP method to send the message.
        '''
        rc = _lasso.defederation_init_notification(self._cptr, str2lasso(remote_providerID), http_method)
        Error.raise_on_rc(rc)

    def processNotificationMsg(self, notification_msg):
        '''
        Processes a lib:FederationTerminationNotification message.  Rebuilds a
        request object from the message and optionally verifies its signature.
        
        Set the msg_nameIdentifier attribute with the NameIdentifier content
        of the notification object and optionally set the msg_relayState
        attribute with the RelayState content of the notification object.
        
        @param notification_msg:  the federation termination notification
            message
        '''
        rc = _lasso.defederation_process_notification_msg(self._cptr, str2lasso(notification_msg))
        Error.raise_on_rc(rc)

    def validateNotification(self):
        '''
        Checks notification with regards to message status and principal
        federations; update them accordingly.
        '''
        rc = _lasso.defederation_validate_notification(self._cptr)
        Error.raise_on_rc(rc)


class Login(Profile):
    def __init__(self, server):
        self._cptr = _lasso.login_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromDump(cls, server, dump):
         return cptrToPy(_lasso.login_new_from_dump(server and server._cptr, str2lasso(dump)))

    def get_protocolProfile(self):
        t = _lasso.Login_protocolProfile_get(self._cptr)
        return t;
    def set_protocolProfile(self, value):
        _lasso.Login_protocolProfile_set(self._cptr, value)
    protocolProfile = property(get_protocolProfile, set_protocolProfile)

    def get_assertionArtifact(self):
        t = _lasso.Login_assertionArtifact_get(self._cptr)
        return t;
    def set_assertionArtifact(self, value):
        value = str2lasso(value)
        _lasso.Login_assertionArtifact_set(self._cptr, value)
    assertionArtifact = property(get_assertionArtifact, set_assertionArtifact)

    def acceptSso(self):
        '''
        Gets the assertion of the response and adds it to the L{Session}
        object. Builds a federation with the 2 name identifiers of the
        assertion and adds it into the identity. If the session or the
        identity are None, they are created.
        
        @return: 0 on success; or <itemizedlist> <listitem><para>
            #LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is not a L{Login}
            object, </para></listitem> <listitem><para>
            #LASSO_PROFILE_ERROR_MISSING_RESPONSE if no response is present in
            the login profile object; usually because no call to
            lasso_login_process_authn_response_msg was done;
            </para></listitem> <listitem><para>
            #LASSO_PROFILE_ERROR_MISSING_ASSERTION if the response does not
            contain an assertion, </para></listitem> <listitem><para>
            #LASSO_PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND if the assertion
            does not contain a NameID element, </para></listitem>
            <listitem><para> #LASSO_PROFILE_ERROR_MISSING_NAME_IDENTIFIER same
            as #LASSO_PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND,
            </para></listitem> <listitem><para>
            #LASSO_LOGIN_ERROR_ASSERTION_REPLAY if the assertion has already
            been used. </para></listitem> </itemizedlist>
        '''
        rc = _lasso.login_accept_sso(self._cptr)
        Error.raise_on_rc(rc)

    def buildArtifactMsg(self, http_method):
        '''
        Builds a SAML artifact. Depending of the HTTP method, the data for the
        sending of the artifact are stored in C{msg_url} (REDIRECT) or
        C{msg_url}, C{msg_body} and C{msg_relayState} (POST).
        
        @param http_method:  the HTTP method to send the artifact (REDIRECT or
            POST)
        @return: 0 on success; or <itemizedlist> <listitem><para>
            LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is not a L{Login}
            object, </para></listitem> <listitem><para>
            LASSO_PROFILE_ERROR_MISSING_REMOTE_PROVIDERID if no remote
            provider ID was setup in the login profile object, it's usually
            done by lasso_login_process_authn_request_msg, </para></listitem>
            <listitem><para> LASSO_PROFILE_ERROR_INVALID_HTTP_METHOD if the
            HTTP method is neither LASSO_HTTP_METHOD_REDIRECT or
            LASSO_HTTP_METHOD_POST (ID-FF 1.2 case) or neither
            LASSO_HTTP_METHOD_ARTIFACT_GET or LASSO_HTTP_METHOD_ARTIFACT_POST
            (SAML 2.0 case) for SAML 2.0), </para></listitem> <listitem><para>
            LASSO_PROFILE_ERROR_INVALID_PROTOCOLPROFILE if the current
            protocolProfile is not </para></listitem> <listitem><para>
            LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_ART (only for ID-FF 1.2),
            </para></listitem> <listitem><para>
            LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND if the remote provider is
            not known to our server object which impeach us to find a service
            endpoint, </para></listitem> <listitem><para>
            LASSO_PROFILE_ERROR_MISSING_RESPONSE if the response object is
            missing, </para></listitem> <listitem><para>
            LASSO_PROFILE_ERROR_MISSING_STATUS_CODE if the response object is
            missing a status code, </para></listitem> /itemizedlist>
        '''
        rc = _lasso.login_build_artifact_msg(self._cptr, http_method)
        Error.raise_on_rc(rc)

    def buildAssertion(self, authenticationMethod = None, authenticationInstant = None, reauthenticateOnOrAfter = None, notBefore = None, notOnOrAfter = None):
        '''
        Builds an assertion and stores it in profile session.
        C{authenticationInstant}, reauthenticateOnOrAfter, C{notBefore} and
        C{notOnOrAfter} may be None.  If C{authenticationInstant} is None, the
        current time will be used.  Time values must be encoded in UTC.
        
        Construct the authentication assertion for the response. It must be
        called after validating the request using
        lasso_login_validate_request_msg(). The created assertion is accessed
        using lasso_login_get_assertion().
        
        @param authenticationMethod:  the authentication method
        @param authenticationInstant:  the time at which the authentication
            took place
        @param notBefore:  the earliest time instant at which the assertion is
            valid
        @param notOnOrAfter:  the time instant at which the assertion has
            expired
        @return: 0 on success; or <itemizedlist> <listitem><para>
            #LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is not a L{Login}
            object, </para></listitem> <listitem><para>
            #LASSO_PROFILE_ERROR_IDENTITY_NOT_FOUND if no identity object was
            found in the login profile object. </para></listitem>
            <listitem><para> #LASSO_PROFILE_ERROR_MISSING_RESPONSE if no
            response object is present ( it is normally initialized by
            lasso_login_process_authn_request_msg() ) </para></listitem>
            <listitem><para> #LASSO_PROFILE_ERROR_FEDERATION_NOT_FOUND if a
            #LASSO_SAML2_NAME_IDENTIFIER_FORMAT_PERSISTENT or
            #LASSO_SAML2_NAME_IDENTIFIER_FORMAT_ENCRYPTED NameID format is
            asked and no corresponding federation was found in the L{Identity}
            object, </para></listitem> <listitem><para>
            #LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND if encryption is needed and
            the request issuing provider is unknown (it as not been registered
            in the L{Server} object), </para></listitem> <listitem><para>
            #LASSO_DS_ERROR_ENCRYPTION_FAILED if encryption is needed but it
            failed, </para></listitem> </itemizedlist>
        '''
        rc = _lasso.login_build_assertion(self._cptr, str2lasso(authenticationMethod), str2lasso(authenticationInstant), str2lasso(reauthenticateOnOrAfter), str2lasso(notBefore), str2lasso(notOnOrAfter))
        Error.raise_on_rc(rc)

    def buildAuthnRequestMsg(self):
        '''
        Converts profile authentication request (C{request} member) into a
        Liberty message, either an URL in HTTP-Redirect profile or an URL and
        a field value in Browser-POST (form) profile.
        
        The URL is set into the C{msg_url} member and the eventual field value
        (LAREQ) is set into the C{msg_body} member.
        
        @return: 0 on success; or <itemizedlist> <listitem><para>
            #LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is not a L{Login}
            object, </para></listitem> <listitem><para>
            #LASSO_PROFILE_ERROR_MISSING_REMOTE_PROVIDERID if not remote
            provider ID was setup&160;- it usually means that
            lasso_login_init_request() was not called before,
            </para></listitem> <listitem><para>
            #LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND if the remote provider ID
            is not registered in the server object, </para></listitem>
            <listitem><para> #LASSO_PROFILE_ERROR_UNSUPPORTED_PROFILE if the
            SSO profile is not supported by the targeted provider,
            </para></listitem> <listitem><para>
            #LASSO_PROFILE_ERROR_BUILDING_QUERY_FAILED if the building of the
            query part of the redirect URL or of the body of the POST content
            failed&160;- it only happens with the #LASSO_HTTP_METHOD_REDIRECT,
            #LASSO_HTTP_METHOD_POST, #LASSO_HTTP_METHOD_ARTIFACT_GET and
            #LASSO_HTTP_METHOD_ARTIFACT_POST bindings&160;-,
            </para></listitem> <listitem><para>
            #LASSO_PROFILE_ERROR_UNKNOWN_PROFILE_URL if the metadata of the
            remote provider does not contain an url for the SSO profile,
            </para></listitem> <listitem><para>
            #LASSO_PROFILE_ERROR_INVALID_REQUEST if the request object is not
            of the needed type, is usually means that
            lasso_login_init_request() was not called before,
            </para></listitem> <listitem><para> #LASSO_PROFILE_MISSING_REQUEST
            if the request object is missing, </para></listitem>
            <listitem><para> #LASSO_PROFILE_ERROR_INVALID_HTTP_METHOD if the
            current setted C{http_method} on the L{Login} object is invalid.
            </para></listitem> </itemizedlist>
        '''
        rc = _lasso.login_build_authn_request_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildAuthnResponseMsg(self):
        '''
        Converts profile authentication response (C{response} member) into a
        Liberty message.
        
        The URL is set into the C{msg_url} member and the field value (LARES)
        is set into the C{msg_body} member.
        
        @return: 0 on success; or <itemizedlist> <listitem><para>
            LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is not a L{Login}
            object, </para></listitem> <listitem><para>
            LASSO_PROFILE_ERROR_INVALID_PROTOCOLPROFILE if the current
            protocol profile is not </para></listitem> <listitem><para>
            LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_POST or
            LASSO_LOGIN_PROTOCOL_PROFILE_BRWS_LECP, </para></listitem>
            <listitem><para> LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND if the
            remote provider ID is not registered in the server object,
            </para></listitem> <listitem><para>
            LASSO_PROFILE_ERROR_UNKNOWN_PROFILE_URL if the metadata of the
            remote provider does not contain an URL for the assertion
            consuming service, </para></listitem> <listitem><para>
            LASSO_PROFILE_ERROR_MISSING_SERVER the server object is needed to
            sign a message and it is missing, </para></listitem>
            <listitem><para> LASSO_DS_ERROR_PRIVATE_KEY_LOAD_FAILED the
            private key for signing could not be found, </para></listitem>
            <listitem><para> LASSO_PROFILE_ERROR_MISSING_RESPONSE if the
            response object is missing, </para></listitem> <listitem><para>
            LASSO_PROFILE_ERROR_UNSUPPORTED_PROFILE if the SSO profile is not
            supported by the targeted provider, </para></listitem>
            <listitem><para> LASSO_PROFILE_BUILDING_QUERY_FAILED if using
            #LASSO_HTTP_METHOD_REDIRECT building of the redirect URL failed,
            </para></listitem> <listitem><para>
            LASSO_PROFILE_BUILDING_MSG_FAILED if using
            #LASSO_HTTP_METHOD_POST, #LASSO_HTTP_METHOD_SOAP or
            #LASSO_HTTP_METHOD_PAOS and building the C{msg_body} failed.
            </para></listitem> </itemizedlist>
        '''
        rc = _lasso.login_build_authn_response_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildRequestMsg(self):
        '''
        Produce a SOAP Artifact Resolve message. It must follows a call to
        lasso_login_init_request() on the artifact message. Converts  artifact
        request into a Liberty SOAP message.
        
        The URL is set into the C{msg_url} member and the SOAP message is set
        into the C{msg_body} member. You should POST the C{msg_body} to the
        C{msg_url} afterward.
        
        @return: 0 on success; or LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if
            login is not a L{Login} object,
            LASSO_PROFILE_ERROR_MISSING_REMOTE_PROVIDERID if not remote
            provider ID was setup -- it usually means that
            lasso_login_init_request was not called before,
            LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND if the remote provider ID is
            not registered in the server object.
        '''
        rc = _lasso.login_build_request_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildResponseMsg(self, remote_providerID = None):
        '''
        Converts profile assertion response (C{response} member) into a
        Liberty SOAP messageresponse message.
        
        The URL is set into the C{msg_url} member and the SOAP message is set
        into the C{msg_body} member.
        
        @param remote_providerID:  service provider ID
        @return: 0 on success; or a negative value otherwise.
            LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is not a L{Login}
            object, LASSO_PROFILE_ERROR_SESSION_NOT_FOUND if no session object
            was found in the login profile object -- it should be created by
            lasso_login_build_assertion() if you did not set it manually
            before calling lasso_login_build_assertion().
        '''
        rc = _lasso.login_build_response_msg(self._cptr, str2lasso(remote_providerID))
        Error.raise_on_rc(rc)

    def dump(self):
        '''
        Dumps C{self} content to an XML string.
        
        @return: the dump string.
        '''
        return _lasso.login_dump(self._cptr)

    def initAuthnRequest(self, remote_providerID = None, http_method = HTTP_METHOD_REDIRECT):
        '''
        <para>Initializes a new AuthnRequest from current service provider to
        remote identity provider specified in C{remote_providerID} (if None
        the first known identity provider is used).</para>
        
        <para>For ID-FF 1.2 the default NameIDPolicy in an AuthnRequest is
        None, which imply that a federation must already exist on the IdP
        side.</para>
        
        <para>For SAML 2.0 the default NameIDPolicy is the first listed in the
        metadatas of the current provider, or if none is specified, Transient,
        which ask the IdP to give a one-time federation</para>
        
        @param remote_providerID:  the providerID of the identity provider
            (may be None)
        @param http_method:  HTTP method to use for request transmission
        @return: 0 on success; or <itemizedlist>
            <listitem><para>LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is
            not a L{Login} object,</para></listitem>
            <listitem><para>LASSO_PROFILE_ERROR_MISSING_REMOTE_PROVIDERID if
            C{remote_providerID} is None and no default remote provider could
            be found from the server object -- usually the first one in the
            order of adding to the server object --,</para></listitem>
            <listitem><para>LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND if the
            C{remote_providerID} is not known to our server
            object.</para></listitem>
            <listitem><para>LASSO_PROFILE_ERROR_INVALID_HTTP_METHOD if the
            HTTP method is neither LASSO_HTTP_METHOD_REDIRECT or
            LASSO_HTTP_METHOD_POST,</para></listitem>
            <listitem><para>LASSO_PROFILE_ERROR_BUILDING_REQUEST_FAILED if
            creation of the request object failed.</para></listitem>
            </itemizedlist>
        '''
        rc = _lasso.login_init_authn_request(self._cptr, str2lasso(remote_providerID), http_method)
        Error.raise_on_rc(rc)

    def initRequest(self, response_msg, response_http_method = HTTP_METHOD_REDIRECT):
        '''
        Initializes an artifact request. C{response_msg} is either the query
        string (in redirect mode) or the form LAREQ field (in browser-post
        mode). It should only be used if you received an artifact message,
        C{response_msg} must be content of the artifact field for the POST
        artifact binding of the query string for the REDIRECT artifact
        binding. You must set the C{response_http_method} argument according
        to the way you received the artifact message.
        
        @param response_msg:  the authentication response received
        @param response_http_method:  the method used to receive the
            authentication response
        @return: 0 on success; or <itemizedlist> <listitem> <para>
            LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is not a L{Login}
            object, </para> </listitem> <listitem> <para>
            LASSO_PARAM_ERROR_INVALID_VALUE if C{response_msg} is None,
            </para> </listitem> <listitem> <para>
            LASSO_PROFILE_ERROR_INVALID_HTTP_METHOD if the HTTP method is
            neither LASSO_HTTP_METHOD_REDIRECT or LASSO_HTTP_METHOD_POST (in
            the ID-FF 1.2 case) or neither LASSO_HTTP_METHOD_ARTIFACT_GET or
            LASSO_HTTP_METHOD_ARTIFACT_POST (in the SAML 2.0 case), </para>
            </listitem> <listitem> <para> LASSO_PROFILE_ERROR_MISSING_ARTIFACT
            if no artifact field was found in the query string (only possible
            for the LASSO_HTTP_METHOD_REDIRECT case), </para> </listitem>
            <listitem> <para> LASSO_PROFILE_ERROR_INVALID_ARTIFACT if decoding
            of the artifact failed -- whether because the base64 encoding is
            invalid or because the type code is wrong --, </para> </listitem>
            <listitem> <para> LASSO_PROFILE_ERROR_MISSING_REMOTE_PROVIDERID if
            no provider ID could be found corresponding to the hash contained
            in the artifact. </para> </listitem> </itemizedlist>
        '''
        rc = _lasso.login_init_request(self._cptr, str2lasso(response_msg), response_http_method)
        Error.raise_on_rc(rc)

    def initIdpInitiatedAuthnRequest(self, remote_providerID):
        '''
        <para>Generates an authentication response without matching
        authentication request.</para>
        
        <para>The choice of NameIDFormat is the same as for
        lasso_login_init_authn_request() but with the target
        C{remote_providerID} as the current provider</para>
        
        <para>If C{remote_providerID} is None, the first known provider is
        used.</para>
        
        @param remote_providerID:  the providerID of the remote service
            provider (may be None)
        @return: 0 on success; or a negative value otherwise. Error codes are
            the same as lasso_login_init_authn_request().
        '''
        rc = _lasso.login_init_idp_initiated_authn_request(self._cptr, str2lasso(remote_providerID))
        Error.raise_on_rc(rc)

    def mustAskForConsent(self):
        '''
        Evaluates if consent must be asked to the Principal to federate him.
        
        @return: True if consent must be asked
        '''
        return _lasso.login_must_ask_for_consent(self._cptr)

    def mustAuthenticate(self):
        '''
        Evaluates if user must be authenticated.
        
        @return: True if user must be authenticated
        '''
        return _lasso.login_must_authenticate(self._cptr)

    def processAuthnRequestMsg(self, authn_request_msg = None):
        '''
        Processes received authentication request, checks it is signed
        correctly, checks if requested protocol profile is supported, etc.
        
        @param authn_request_msg:  the authentication request received
        @return: 0 on success; or <itemizedlist> <listitem> <para>
            #LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login is no a L{Login}
            object, </para> </listitem> <listitem> <para>
            #LASSO_PROFILE_ERROR_MISSING_REQUEST if C{authn_request_msg} is
            #None and no request as actually been processed or initialized
            &#151; see lasso_login_init_idp_initiated_authn_request(),
        '''
        rc = _lasso.login_process_authn_request_msg(self._cptr, str2lasso(authn_request_msg))
        Error.raise_on_rc(rc)

    def processAuthnResponseMsg(self, authn_response_msg):
        '''
        Processes received authentication response.
        
        @param authn_response_msg:  the authentication response received
        @return: 0 on success; or <itemizedlist>
            <listitem><para>#LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login
            is not a L{Login} object,</para></listitem>
            <listitem><para>#LASSO_PARAM_ERROR_INVALID_VALUE if
            authn_response_msg is None,</para></listitem>
            <listitem><para>#LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND, if the
            issuing provider of the assertion is not registered in the
            L{Server} object,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_MISSING_ISSUER if the parsed
            samlp2:AuthnRequest does not have a proper Issuer element,
            </para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_MISSING_STATUS_CODE if the
            reponse is missing a <literal>StatusCode</literal>
            element,</para></listitem>
            <listitem><para>#LASSO_PROFILE_STATUS_NOT_SUCCESS_ERROR if the
            identity provider returned a failure response,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_REQUEST_DENIED</para> if the
            identity provider returned the specific status code
            <literal>RequestDenied</literal>,</listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_INVALID_MSG if the message is
            not a L{SamlpResponse} (ID-FF 1.2) or a L{Samlp2ResponseMsg} (SAML
            2.0),</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_UNSUPPORTED_PROFILE, if the
            received message format does not correspond to a binding supported
            by this function, the only supported binding by this function is
            HTTP POST,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_MISSING_SERVER the server
            object is needed to sign a message and it is
            missing,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_CANNOT_VERIFY_SIGNATURE if
            the validation of the signature of the message failed, a specific
            error code is available in <literal>login->parent.signature_status
            </literal></para></listitem> <listitem><para>#LASSO_LOGIN_ERROR_AS
            SERTION_DOES_NOT_MATCH_REQUEST_ID if the received response does
            not match the saved AuthenticationRequest ID,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_INVALID_ISSUER if the
            assertion issuer does not match the AuthenticationResponse
            issuer,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND if
            not NameID could be found or decoded,</para></listitem>
            </itemizedlist>
        '''
        rc = _lasso.login_process_authn_response_msg(self._cptr, str2lasso(authn_response_msg))
        Error.raise_on_rc(rc)

    def processRequestMsg(self, request_msg):
        '''
        Processes received artifact request.
        
        @param request_msg:  the artifact request received
        '''
        rc = _lasso.login_process_request_msg(self._cptr, str2lasso(request_msg))
        Error.raise_on_rc(rc)

    def processResponseMsg(self, response_msg):
        '''
        Processes received assertion response.
        
        @param response_msg:  the assertion response received
        @return: 0 on success; or <itemizedlist>
            <listitem><para>#LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login
            is not a L{Login} object,</para></listitem>
            <listitem><para>#LASSO_PARAM_ERROR_INVALID_VALUE if response_msg
            is None,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_INVALID_MSG if the message is
            not a L{SamlpResponse} (ID-FF 1.2) or a L{Samlp2ResponseMsg} (SAML
            2.0),</para></listitem> <listitem><para>#LASSO_PROFILE_ERROR_RESPO
            NSE_DOES_NOT_MATCH_REQUEST if the response does not refer to the
            request or if the response refer to an unknown request and <link
            linkend="strict-checking"><literal>strict-
            checking</literal></link> is activated ,</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_REQUEST_DENIED the identity
            provided returned a failure status of
            "RequestDenied"</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_FEDERATION_NOT_FOUND if
            creation of a new federation was not allowed and none
            existed,</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_UNKNOWN_PRINCIPAL if
            authentication failed or/and if the user cancelled the
            authentication,</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_STATUS_NOT_SUCCESS, if the
            response status is a failure but we have no more precise error
            code to report it, you must look at the second level status in the
            response,</para></listitem>
            <listitem><para>#LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND, if the
            issuing provider of the assertion is unknown,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_INVALID_ISSUER the issuer of
            the assertion received, is not the expected one</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND no
            statement was fournd, or none statement contains a subject with a
            name identifier,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_MISSING_STATUS_CODE if the
            reponse is missing a <literal>StatusCode</literal>
            element,</para></listitem>
            <listitem><para>#LASSO_PROFILE_ERROR_MISSING_ASSERTION if the
            message does not contain any assertion.</para></listitem>
            </itemizedlist>
        '''
        rc = _lasso.login_process_response_msg(self._cptr, str2lasso(response_msg))
        Error.raise_on_rc(rc)

    def validateRequestMsg(self, authentication_result, is_consent_obtained):
        '''
        Initializes a response to the authentication request received.
        
        @param authentication_result:  whether user has authenticated
            succesfully
        @param is_consent_obtained:  whether user consent has been obtained
        @return: 0 on success; or <itemizedlist>
            <listitem><para>#LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if login
            is not a L{Login} object,</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_REQUEST_DENIED</para> if
            C{authentication_result} if FALSE,</listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_INVALID_SIGNATURE if signature
            validation of the request failed,</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_UNSIGNED_AUTHN_REQUEST if no
            signature was present on the request,</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_FEDERATION_NOT_FOUND if
            federation policy is #LASSO_LIB_NAMEID_POLICY_TYPE_NONE and no
            federation was found in the L{Identity} object (ID-FF 1.2
            case)</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_INVALID_NAMEIDPOLICY if request
            policy is not one of #LASSO_LIB_NAMEID_POLICY_TYPE_FEDERATED or
            #LASSO_LIB_NAMEID_POLICY_TYPE_ANY (ID-FF 1.2 case) or if no NameID
            policy was defined or the AllowCreate request flag is FALSE (SAML
            2.0 case),</para></listitem>
            <listitem><para>#LASSO_LOGIN_ERROR_CONSENT_NOT_OBTAINED if
            C{is_consent_obtained} is FALSE and conssent was necessary (for
            example if the request does not communicate that consent was
            already obtained from the user),</para></listitem>
            <listitem><para>#LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND if the
            requesting provider is unknown,</para></listitem> </itemizedlist>
        '''
        rc = _lasso.login_validate_request_msg(self._cptr, authentication_result, is_consent_obtained)
        Error.raise_on_rc(rc)

    def processPaosResponseMsg(self, msg):
        rc = _lasso.login_process_paos_response_msg(self._cptr, str2lasso(msg))
        Error.raise_on_rc(rc)

    def getAssertion(self):
        '''
        Return the last build assertion.
        
        @return: a L{Node} representing the build assertion (generally a
            L{SamlAssertion} when using ID-FF 1.2 or a L{Saml2Assertion} when
            using SAML 2.0)
        '''
        return cptrToPy(_lasso.login_get_assertion(self._cptr))

    assertion = property(getAssertion)

class Lecp(Login):
    def __init__(self, server):
        self._cptr = _lasso.lecp_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    def get_authnRequestEnvelope(self):
        t = _lasso.Lecp_authnRequestEnvelope_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_authnRequestEnvelope(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Lecp_authnRequestEnvelope_set(self._cptr, value)
    authnRequestEnvelope = property(get_authnRequestEnvelope, set_authnRequestEnvelope)

    def get_authnResponseEnvelope(self):
        t = _lasso.Lecp_authnResponseEnvelope_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_authnResponseEnvelope(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Lecp_authnResponseEnvelope_set(self._cptr, value)
    authnResponseEnvelope = property(get_authnResponseEnvelope, set_authnResponseEnvelope)

    def get_assertionConsumerServiceURL(self):
        t = _lasso.Lecp_assertionConsumerServiceURL_get(self._cptr)
        return t;
    def set_assertionConsumerServiceURL(self, value):
        value = str2lasso(value)
        _lasso.Lecp_assertionConsumerServiceURL_set(self._cptr, value)
    assertionConsumerServiceURL = property(get_assertionConsumerServiceURL, set_assertionConsumerServiceURL)

    def buildAuthnRequestEnvelopeMsg(self):
        '''
        Builds an enveloped authentication request message.  Sets C{msg_body}
        to that message.
        '''
        rc = _lasso.lecp_build_authn_request_envelope_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildAuthnRequestMsg(self):
        '''
        Builds an authentication request. The data for the sending of the
        request are stored in C{msg_url} and C{msg_body} (SOAP POST).
        '''
        rc = _lasso.lecp_build_authn_request_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildAuthnResponseMsg(self):
        '''
        Builds the lecp authentication response message (base64).  Sets
        C{msg_body} to that message.
        '''
        rc = _lasso.lecp_build_authn_response_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildAuthnResponseEnvelopeMsg(self):
        '''
        Builds the enveloped LECP authentication response message (SOAP
        message). Sets C{msg_body} to that message.
        '''
        rc = _lasso.lecp_build_authn_response_envelope_msg(self._cptr)
        Error.raise_on_rc(rc)

    def initAuthnRequest(self, remote_providerID = None):
        '''
        Initializes a new lib:AuthnRequest.
        
        @param remote_providerID:  the providerID of the identity provider.
            When None, the first known identity provider is used.
        '''
        rc = _lasso.lecp_init_authn_request(self._cptr, str2lasso(remote_providerID))
        Error.raise_on_rc(rc)

    def processAuthnRequestMsg(self, authn_request_msg):
        '''
        Processes received authentication request, checks it is signed
        correctly, checks if requested protocol profile is supported, etc.
        
        @param authn_request_msg:  the authentication request received
        '''
        rc = _lasso.lecp_process_authn_request_msg(self._cptr, str2lasso(authn_request_msg))
        Error.raise_on_rc(rc)

    def processAuthnRequestEnvelopeMsg(self, request_msg):
        '''
        Processes received enveloped authentication request, extracts the
        authentication request out of it.
        
        @param request_msg:  the enveloped authentication request received
        '''
        rc = _lasso.lecp_process_authn_request_envelope_msg(self._cptr, str2lasso(request_msg))
        Error.raise_on_rc(rc)

    def processAuthnResponseEnvelopeMsg(self, response_msg):
        '''
        Processes received enveloped authentication response, extracts the
        authentication response out of it and stores it in C{response}.
        
        @param response_msg:  the enveloped authentication response received
        '''
        rc = _lasso.lecp_process_authn_response_envelope_msg(self._cptr, str2lasso(response_msg))
        Error.raise_on_rc(rc)


class Logout(Profile):
    def __init__(self, server):
        self._cptr = _lasso.logout_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromDump(cls, server, dump):
         return cptrToPy(_lasso.logout_new_from_dump(server and server._cptr, str2lasso(dump)))

    def buildRequestMsg(self):
        '''
        Builds the logout request message.
        
        It gets the HTTP method retrieved to send the request and:
        
         - if it is a SOAP method, then it builds the logout request SOAP
           message,   sets the msg_body attribute, gets the single logout
           service url and sets   C{msg_url} in the logout object.
        
         - if it is a HTTP-Redirect method, then it builds the logout request
           QUERY   message, builds the logout request url, sets C{msg_url} in
           the logout   request url, sets C{msg_body} to None.
        
        If private key and certificate are set in server object it will also
        signs the message (either with X509 if SOAP or with a simple signature
        for query strings).
        '''
        rc = _lasso.logout_build_request_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildResponseMsg(self):
        '''
        Builds the logout response message.
        
        It gets the request message method and:
        
         - if it is a SOAP method, then it builds the logout response SOAP
           message,    sets the msg_body attribute, gets the single logout
           service return url    and sets C{msg_url} in the logout object.
        
         - if it is a HTTP-Redirect method, then it builds the logout response
           QUERY message,    builds the logout response url, sets C{msg_url}
           with the logout response url,    sets C{msg_body} to None
        
        If private key and certificate are set in server object it will also
        signs the message (either with X509 if SOAP or with a simple signature
        for query strings).
        '''
        rc = _lasso.logout_build_response_msg(self._cptr)
        Error.raise_on_rc(rc)

    def dump(self):
        '''
        Dumps C{self} content to an XML string.
        
        @return: the dump string.
        '''
        return _lasso.logout_dump(self._cptr)

    def getNextProviderId(self):
        '''
        Returns the provider id from providerID_index in list of providerIDs
        in principal session with the exception of initial service provider
        ID.
        
        @return: a newly allocated string or None
        '''
        return _lasso.logout_get_next_providerID(self._cptr)

    def initRequest(self, remote_providerID = None, request_method = HTTP_METHOD_ANY):
        '''
        Initializes a new SLO request.
        
        @param remote_providerID:  the providerID of the identity provider.
            If None the first identity provider is used.
        @param request_method:  if set, then it get the protocol profile in
            metadata corresponding of this HTTP request method.
        '''
        rc = _lasso.logout_init_request(self._cptr, str2lasso(remote_providerID), request_method)
        Error.raise_on_rc(rc)

    def processRequestMsg(self, request_msg):
        '''
        Processes a SLO LogoutRequest message.  Rebuilds a request object from
        the message and optionally verifies its signature.
        
        @param request_msg:  the logout request message
        '''
        rc = _lasso.logout_process_request_msg(self._cptr, str2lasso(request_msg))
        Error.raise_on_rc(rc)

    def processResponseMsg(self, response_msg):
        '''
        Parses the response message and builds the response object.
        
        Checks the status code value and if it is not success, then if the
        local provider is a Service Provider and response method is SOAP, then
        builds a new logout request message for HTTP Redirect / GET method and
        returns the error code LASSO_LOGOUT_ERROR_UNSUPPORTED_PROFILE.
        
        If it is a SOAP method or, IDP type and http method is Redirect/GET,
        then removes assertion.
        
        If local server is an Identity Provider and if there is no more
        assertion (Identity Provider has logged out every Service Providers),
        then restores the initial response.
        
        @param response_msg:  the response message
        '''
        rc = _lasso.logout_process_response_msg(self._cptr, str2lasso(response_msg))
        Error.raise_on_rc(rc)

    def resetProviderIdIndex(self):
        '''
        Reset the providerID_index attribute (set to 0).
        '''
        rc = _lasso.logout_reset_providerID_index(self._cptr)
        Error.raise_on_rc(rc)

    def validateRequest(self):
        '''
        
        
         - Sets the remote provider id
        
         - Sets a logout response with status code value to success.
        
         - Checks current signature status, if verification failed, stop
           processing   and set the status code value to failure.
        
         - Verifies federation and authentication.
        
         - If the request http method is a SOAP method, then verifies every
           other   Service Providers supports SOAP method : if not, then sets
           status code   value to UnsupportedProfile and returns a code error
           with   LASSO_LOGOUT_ERROR_UNSUPPORTED_PROFILE.
        
         - Every tests are ok, then removes assertion.
        
         - If local server is an Identity Provider and if there is more than
           one   Service Provider (except the initial Service Provider), then
           saves the   initial request, response and remote provider id.
        
        @return: 0 on success; or LASSO_PROFILE_ERROR_MISSING_REQUEST if no
            request has been found -- usually means that
            lasso_logout_process_request_msg was not called,
            LASSO_SERVER_ERROR_PROVIDER_NOT_FOUND if the requesting provider
            is not known to the server object,
            LASSO_PROFILE_ERROR_BUILDING_RESPONSE_FAILED if creation of the
            response object failed,
            LASSO_PROFILE_ERROR_NAME_IDENTIFIER_NOT_FOUND if the request do
            not contain a NameID element,
            LASSO_PROFILE_ERROR_SESSION_NOT_FOUND if the logout profile object
            do not contain a session object,
            LASSO_PROFILE_ERROR_MISSING_ASSERTION if no assertion from the
            requesting provider was found,
            LASSO_PROFILE_ERROR_IDENTITY_NOT_FOUND if the logout profile
            object do not contain an identity object,
            LASSO_PROFILE_ERROR_FEDERATION_NOT_FOUND if no federation for the
            requesting provider was found,
            LASSO_LOGOUT_ERROR_UNSUPPORTED_PROFILE if the requested HTTP
            method is not supported by all the remote provider of the current
            session.
        '''
        rc = _lasso.logout_validate_request(self._cptr)
        Error.raise_on_rc(rc)

    nextProviderId = property(getNextProviderId)

class NameIdentifierMapping(Profile):
    def __init__(self, server):
        self._cptr = _lasso.name_identifier_mapping_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    def get_targetNameIdentifier(self):
        t = _lasso.NameIdentifierMapping_targetNameIdentifier_get(self._cptr)
        return t;
    def set_targetNameIdentifier(self, value):
        value = str2lasso(value)
        _lasso.NameIdentifierMapping_targetNameIdentifier_set(self._cptr, value)
    targetNameIdentifier = property(get_targetNameIdentifier, set_targetNameIdentifier)

    def buildRequestMsg(self):
        '''
        Builds a name identifier mapping request message.
        
        
        
         - If it is a SOAP method, then it builds the request as a SOAP
           message,   optionally signs his node, sets C{msg_body} with that
           message and sets   C{msg_url} with the SOAP Endpoint URL
        
         - If it is a HTTP-Redirect method, then it builds the request as a
           query   string message, optionally signs it and sets C{msg_url} to
           that URL.
        '''
        rc = _lasso.name_identifier_mapping_build_request_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildResponseMsg(self):
        '''
        Builds a name identifier mapping response message.
        
        
        
         - If it is a SOAP method, then it builds the response as a SOAP
           message,   optionally signs his node, sets C{msg_body} with that
           message and sets   C{msg_url} with the register name identifier
           service return URL.
        
         - If it is a HTTP-Redirect method, then it builds the response as a
           query   string message, optionally signs it and sets C{msg_url} to
           that URL.
        
        If private key and certificate are set in server object it will also
        signs the message (either with X509 if SOAP or with a simple signature
        for query strings).
        '''
        rc = _lasso.name_identifier_mapping_build_response_msg(self._cptr)
        Error.raise_on_rc(rc)

    def initRequest(self, targetNamespace, remote_providerID = None):
        '''
        Initializes a new lib:NameIdentifierMappingRequest request.
        
        @param targetNamespace:  the request targetNamespace
        @param remote_providerID:  the providerID of the identity provider.
        '''
        rc = _lasso.name_identifier_mapping_init_request(self._cptr, str2lasso(targetNamespace), str2lasso(remote_providerID))
        Error.raise_on_rc(rc)

    def processRequestMsg(self, request_msg):
        '''
        Processes a lib:NameIdentifierMappingRequest message.  Rebuilds a
        request object from the message and optionally verifies its signature.
        
        @param request_msg:  the name identifier mapping request message
        '''
        rc = _lasso.name_identifier_mapping_process_request_msg(self._cptr, str2lasso(request_msg))
        Error.raise_on_rc(rc)

    def processResponseMsg(self, response_msg):
        '''
        Processes a lib:NameIdentifierMappingResponse message.  Rebuilds a
        response object from the message and optionally verifies its
        signature.
        
        If the response depicts Success it will also sets
        C{targetNameIdentifier}.
        
        @param response_msg:  the name identifier mapping response message
        '''
        rc = _lasso.name_identifier_mapping_process_response_msg(self._cptr, str2lasso(response_msg))
        Error.raise_on_rc(rc)

    def validateRequest(self):
        '''
        Checks profile request with regards to message status and principal
        federations, update them accordingly and prepares a
        lib:NameIdentifierMappingResponse accordingly.
        '''
        rc = _lasso.name_identifier_mapping_validate_request(self._cptr)
        Error.raise_on_rc(rc)


class NameRegistration(Profile):
    def __init__(self, server):
        self._cptr = _lasso.name_registration_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromDump(cls, server, dump):
         return cptrToPy(_lasso.name_registration_new_from_dump(server and server._cptr, str2lasso(dump)))

    def get_oldNameIdentifier(self):
        t = _lasso.NameRegistration_oldNameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_oldNameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.NameRegistration_oldNameIdentifier_set(self._cptr, value)
    oldNameIdentifier = property(get_oldNameIdentifier, set_oldNameIdentifier)

    def buildRequestMsg(self):
        '''
        Builds a register name identifier request message.
        
        It gets the register name identifier protocol profile and:
        
         - if it is a SOAP method, then it builds the register name identifier
           request SOAP message, optionally signs his node, sets C{msg_body},
           gets the SoapEndpoint url and sets C{msg_url}.
        
         - if it is a HTTP-Redirect method, then it builds the register name
           identifier request QUERY message (optionally signs the request
           message),   builds the request url with register name identifier
           url with register   name identifier service url, sets C{msg_url} in
           the register name   identifier object, sets C{msg_body} to None.
        '''
        rc = _lasso.name_registration_build_request_msg(self._cptr)
        Error.raise_on_rc(rc)

    def buildResponseMsg(self):
        '''
        Builds the register name idendifier response message.
        
        It gets the request message method and:
        
         - if it is a SOAP method, then it builds the response SOAP message,
           sets    the msg_body attribute, gets the register name identifier
           service return    url and sets C{msg_url} of the object.
        
         - if it is a HTTP-Redirect method, then it builds the response QUERY
           message, builds the response url, sets C{msg_url} with the response
           url    and sets the msg_body with None
        
        If private key and certificate are set in server object it will also
        signs the message (either with X509 if SOAP or with a simple signature
        for query strings).
        '''
        rc = _lasso.name_registration_build_response_msg(self._cptr)
        Error.raise_on_rc(rc)

    def dump(self):
        '''
        Dumps C{self} content to an XML string.
        
        @return: the dump string.
        '''
        return _lasso.name_registration_dump(self._cptr)

    def initRequest(self, remote_providerID, http_method = HTTP_METHOD_ANY):
        '''
        Initializes a new lib:RegisterNameIdentifierRequest request; it sets
        C{self}->nameIdentifier to the new name identifier and
        C{self}->oldNameIdentifier to the old one.
        
        @param remote_providerID:  the providerID of the identity provider.
        @param http_method:  if set, then it get the protocol profile in
            metadata corresponding of this HTTP request method.
        '''
        rc = _lasso.name_registration_init_request(self._cptr, str2lasso(remote_providerID), http_method)
        Error.raise_on_rc(rc)

    def processRequestMsg(self, request_msg):
        '''
        Processes a lib:RegisterNameIdentifierRequest message.  Rebuilds a
        request object from the message and optionally verifies its signature.
        Sets profile->nameIdentifier to local name identifier.  If it changed
        (when this is IdP-initiated and there was no previously defined local
        name identifier) profile->nameIdentifier will be the new one and
        profile->oldNameIdentiifer the old one.
        
        @param request_msg:  the register name identifier request message
        '''
        rc = _lasso.name_registration_process_request_msg(self._cptr, str2lasso(request_msg))
        Error.raise_on_rc(rc)

    def processResponseMsg(self, response_msg):
        '''
        Processes a lib:RegisterNameIdentifierResponse message.  Rebuilds a
        response object from the message and optionally verifies its
        signature.
        
        If the response depicts Success it will also update Principal
        federation.
        
        @param response_msg:  the register name identifier response message
        '''
        rc = _lasso.name_registration_process_response_msg(self._cptr, str2lasso(response_msg))
        Error.raise_on_rc(rc)

    def validateRequest(self):
        '''
        Checks profile request with regards to message status and principal
        federations, update them accordingly and prepares a
        lib:RegisterNameIdentifierResponse accordingly.
        '''
        rc = _lasso.name_registration_validate_request(self._cptr)
        Error.raise_on_rc(rc)


class Provider(Node):
    def __init__(self, role, metadata, public_key = None, ca_cert_chain = None):
        self._cptr = _lasso.provider_new(role, str2lasso(metadata), str2lasso(public_key), str2lasso(ca_cert_chain))
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromBuffer(cls, role, metadata, public_key = None, ca_cert_chain = None):
         return cptrToPy(_lasso.provider_new_from_buffer(role, str2lasso(metadata), str2lasso(public_key), str2lasso(ca_cert_chain)))

    @classmethod
    def newFromDump(cls, dump):
         return cptrToPy(_lasso.provider_new_from_dump(str2lasso(dump)))

    def get_providerId(self):
        t = _lasso.Provider_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.Provider_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_role(self):
        t = _lasso.Provider_role_get(self._cptr)
        return t;
    def set_role(self, value):
        _lasso.Provider_role_set(self._cptr, value)
    role = property(get_role, set_role)

    def get_metadataFilename(self):
        t = _lasso.Provider_metadataFilename_get(self._cptr)
        return t;
    def set_metadataFilename(self, value):
        value = str2lasso(value)
        _lasso.Provider_metadataFilename_set(self._cptr, value)
    metadataFilename = property(get_metadataFilename, set_metadataFilename)

    def get_publicKey(self):
        t = _lasso.Provider_publicKey_get(self._cptr)
        return t;
    def set_publicKey(self, value):
        value = str2lasso(value)
        _lasso.Provider_publicKey_set(self._cptr, value)
    publicKey = property(get_publicKey, set_publicKey)

    def get_caCertChain(self):
        t = _lasso.Provider_caCertChain_get(self._cptr)
        return t;
    def set_caCertChain(self, value):
        value = str2lasso(value)
        _lasso.Provider_caCertChain_set(self._cptr, value)
    caCertChain = property(get_caCertChain, set_caCertChain)

    def getAssertionConsumerServiceUrl(self, service_id = None):
        '''
        Extracts the AssertionConsumerServiceURL from the provider metadata
        descriptor.
        
        @param service_id:  the AssertionConsumerServiceID, None for default
        @return: the element value, None if the element was not found.
        '''
        return _lasso.provider_get_assertion_consumer_service_url(self._cptr, str2lasso(service_id))

    def getMetadataOne(self, name):
        '''
        Extracts the element C{name} from the provider metadata descriptor.
        
        @param name:  the element name
        @return: the element value, None if the element was not found.
        '''
        return _lasso.provider_get_metadata_one(self._cptr, str2lasso(name))

    def getMetadataList(self, name):
        '''
        Extracts zero to many elements from the provider metadata descriptor.
        
        @param name:  the element name
        @return: a #GList with the elements.  This GList is internally
            allocated and points to internally allocated strings.  It must not
            be freed, modified or stored.
        '''
        return _lasso.provider_get_metadata_list(self._cptr, str2lasso(name))

    def getFirstHttpMethod(self, remote_provider, protocol_type):
        '''
        Looks up and returns a L{HttpMethod} appropriate for performing the
        C{protocol_type} between C{self} and C{remote_provider}.
        
        @param remote_provider:  a L{Provider} depicting the remote provider
        @param protocol_type:  a Liberty profile
        @return: the L{HttpMethod}
        '''
        return _lasso.provider_get_first_http_method(self._cptr, remote_provider and remote_provider._cptr, protocol_type)

    def acceptHttpMethod(self, remote_provider, protocol_type, http_method, initiate_profile):
        '''
        Gets if C{http_method} is an appropriate method for the
        C{protocol_type} profile between C{self} and C{remote_provider}.
        
        @param remote_provider:  a L{Provider} depicting the remote provider
        @param protocol_type:  a Liberty profile type
        @param http_method:  an HTTP method
        @param initiate_profile:  whether C{self} initiates the profile
        @return: True if it is appropriate
        '''
        return _lasso.provider_accept_http_method(self._cptr, remote_provider and remote_provider._cptr, protocol_type, http_method, initiate_profile)

    def hasProtocolProfile(self, protocol_type, protocol_profile):
        '''
        Gets if C{self} supports C{protocol_profile}.
        
        @param protocol_type:  a Liberty profile type
        @param protocol_profile:  a fully-qualified Liberty profile
        @return: True if it is supported
        '''
        return _lasso.provider_has_protocol_profile(self._cptr, protocol_type, str2lasso(protocol_profile))

    def getBase64SuccinctId(self):
        '''
        Computes and returns the base64-encoded provider succinct ID.
        
        @return: the provider succinct ID.
        '''
        return _lasso.provider_get_base64_succinct_id(self._cptr)

    def getOrganization(self):
        '''
        Returns the provider metadata &lt;Organization&gt; XML node.
        
        @return: the &lt;Organization/&gt; node (libxml2 xmlNode*); or None if
            it is not found.  This xmlnode must be freed by the caller.
        '''
        return _lasso.provider_get_organization(self._cptr)

    def getProtocolConformance(self):
        '''
        Return the protocol conformance of the given provider, it should allow
        to switch behaviour of SP and IdP code toward a specific protocol. See
        also L{ProtocolConformance}.
        
        @return: a value in the L{ProtocolConformance} enumeration.
        '''
        return _lasso.provider_get_protocol_conformance(self._cptr)

    def setProtocolConformance(self, protocol_conformance):
        '''
        Normally the protocol conformance is set when the metadata for the
        provider is loaded because the metadata defines the type of server.
        However some L{Server} variants do not have metadata (e.g. ECP)
        therefore instead of loading the metadata it is necessary to
        explicitly set the protocol conformance because parts of the Lasso
        library dispatch based on the protocol conformance. Without the
        protocol conformance being set it is likely the wrong code will
        execute.
        
        **WARNING**, do not manually set the protocol conformance if metadata
        has been loaded, metadata is the final arbiter of protocol
        conformance.
        
        @param protocol_conformance:  L{ProtocolConformance} enumerated value.
        '''
        _lasso.provider_set_protocol_conformance(self._cptr, protocol_conformance)

    def setEncryptionMode(self, encryption_mode):
        '''
        Activate or desactivate encryption
        
        @param encryption_mode:  TRUE to activate, FALSE to desactivate
        '''
        _lasso.provider_set_encryption_mode(self._cptr, encryption_mode)

    def getEncryptionMode(self):
        '''
        Return the current encryption mode.
        
        @return: a value in the L{EncryptionMode} enumeration.
        '''
        return _lasso.provider_get_encryption_mode(self._cptr)

    def setEncryptionSymKeyType(self, encryption_sym_key_type):
        '''
        Set the type of the generated encryption symetric key
        
        @param encryption_sym_key_type:  enum type for generated symetric key
        '''
        _lasso.provider_set_encryption_sym_key_type(self._cptr, encryption_sym_key_type)

    def getDefaultNameIdFormat(self):
        '''
        If the provider has a list of supported name id formats in its
        metadatas, return the first one.
        
        @return: a NameIDFormat URI or None, the returned value must be freed
            by the caller.
        '''
        return _lasso.provider_get_default_name_id_format(self._cptr)

    def getSpNameQualifier(self):
        '''
        Return the entityID to use for qualifying NameIdentifier.
        
        @return: a private string or None. Do not keep a reference on this
            string or free it.
        '''
        return _lasso.provider_get_sp_name_qualifier(self._cptr)

    def verifySingleNodeSignature(self, node, id_attr_name):
        '''
        Return wheter the provider signed this node.
        
        @param node:  a L{Node} object, still having its originalXmlnode
            content, and containing an XML signature.
        @param id_attr_name:  the name of the ID attribute to lookup.
        @return: 0 if the node is signed by this provider, an error code
            otherwise.
        '''
        rc = _lasso.provider_verify_single_node_signature(self._cptr, node and node._cptr, str2lasso(id_attr_name))
        Error.raise_on_rc(rc)

    def getIdpSupportedAttributes(self):
        '''
        If the provider supports the IDP SSO role, then return the list of
        Attribute definition that this provider declared supporting.
        
        @return: a list of L{Saml2Attribute} or L{SamlAttribute}
        '''
        value = _lasso.provider_get_idp_supported_attributes(self._cptr)
        if value is not None:
            value = tuple([cptrToPy(x) for x in value])
        return value

    def getValidUntil(self):
        '''
        Return the time after which the metadata for this provider will become
        invalid. This is an ISO-8601 formatted string.
        
        @return: an internally allocated string, you can copy it but not store
            it.
        '''
        return _lasso.provider_get_valid_until(self._cptr)

    def getCacheDuration(self):
        '''
        Return the time during which the metadata for this provider can be
        kept.
        
        @return: an internally allocated string, you can copy it but not store
            it.
        '''
        return _lasso.provider_get_cache_duration(self._cptr)

    def getMetadataOneForRole(self, role, name):
        '''
        Return the given information extracted from the metadata of the given
        L{Provider} for the given C{role} descriptor.
        
        Retun value: a newly allocated string or None. If non-None must be
        freed by the caller.
        
        @param role:  a L{ProviderRole} value
        @param name:  a metadata information name
        '''
        return _lasso.provider_get_metadata_one_for_role(self._cptr, role, str2lasso(name))

    def getMetadataListForRole(self, role, name):
        '''
        Extracts zero to many elements from the C{self} descriptor for the
        given C{role}.
        
        @param role:  a L{ProviderRole} value
        @param name:  the element name
        @return: a #GList with the elements.  This GList is internally
            allocated and points to internally allocated strings.  It must not
            be freed, modified or stored.
        '''
        return _lasso.provider_get_metadata_list_for_role(self._cptr, role, str2lasso(name))

    def getMetadataKeysForRole(self, role):
        '''
        Returns the list of metadata keys existing for the given provider.
        
        @param role:  a L{ProviderRole} value
        @return: a newly allocated list of strings
        '''
        return _lasso.provider_get_metadata_keys_for_role(self._cptr, role)

    def getRoles(self):
        '''
        Return the bitmask of the supported roles.
        
        @return: a L{ProviderRole} enumeration value.
        '''
        return _lasso.provider_get_roles(self._cptr)

    def matchConformance(self, another_provider):
        '''
        Return whether the two provider support a same protocol. See also
        L{ProtocolConformance}.
        
        @param another_provider:  a L{Provider} object
        @return: TRUE or FALSE.
        '''
        return _lasso.provider_match_conformance(self._cptr, another_provider and another_provider._cptr)

    def setServerSigningKey(self, key):
        '''
        @param key:  a L{Key} object
        @return: 0 if successful, an error code otherwise.
        '''
        rc = _lasso.provider_set_server_signing_key(self._cptr, key and key._cptr)
        Error.raise_on_rc(rc)

    def addKey(self, key, after = False):
        '''
        Add a new signature key for validating message received from C{self}.
        If the key is used to improve verification time add it first with
        C{after} as true, it the key is ther for continuity of service (when
        doing a key rollover for example) at it last with C{after} as false.
        
        @param key:  a L{Key} object
        @param after:  add the key at the end of the list, not on front.
        @return: 0 if successful, an error code otherwise.
        '''
        rc = _lasso.provider_add_key(self._cptr, key and key._cptr, after)
        Error.raise_on_rc(rc)

    def verifySignature(self, message, id_attr_name, format):
        return _lasso.provider_verify_signature(self._cptr, str2lasso(message), str2lasso(id_attr_name), format)

    def saml2NodeEncrypt(self, lasso_node):
        '''
        Dump the node object to an XML fragment, then encrypt this fragment
        using encryption key of C{self}, then encapsulate the resulting
        encrypted content into a L{Saml2EncryptedElement}.
        
        @param lasso_node:  a L{Node} object
        @return: a newly created L{Saml2EncryptedElement} if successfull, None
            otherwise.
        '''
        return cptrToPy(_lasso.provider_saml2_node_encrypt(self._cptr, lasso_node and lasso_node._cptr))

    base64SuccinctId = property(getBase64SuccinctId)
    organization = property(getOrganization)
    protocolConformance = property(getProtocolConformance, setProtocolConformance)
    encryptionMode = property(getEncryptionMode, setEncryptionMode)
    defaultNameIdFormat = property(getDefaultNameIdFormat)
    spNameQualifier = property(getSpNameQualifier)
    idpSupportedAttributes = property(getIdpSupportedAttributes)
    validUntil = property(getValidUntil)
    cacheDuration = property(getCacheDuration)
    roles = property(getRoles)

class Server(Provider):
    def __init__(self, metadata = None, private_key = None, private_key_password = None, certificate = None):
        self._cptr = _lasso.server_new(str2lasso(metadata), str2lasso(private_key), str2lasso(private_key_password), str2lasso(certificate))
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromBuffers(cls, metadata, private_key_content = None, private_key_password = None, certificate_content = None):
         return cptrToPy(_lasso.server_new_from_buffers(str2lasso(metadata), str2lasso(private_key_content), str2lasso(private_key_password), str2lasso(certificate_content)))

    @classmethod
    def newFromDump(cls, dump):
         return cptrToPy(_lasso.server_new_from_dump(str2lasso(dump)))

    def get_providers(self):
        t = _lasso.Server_providers_get(self._cptr)
        if not t: return t
        d2 = {}
        for k, v in t.items():
            d2[k] = cptrToPy(v)
        t = frozendict(d2)
        return t;
    def set_providers(self, value):
        _lasso.Server_providers_set(self._cptr, value)
    providers = property(get_providers, set_providers)

    def get_privateKey(self):
        t = _lasso.Server_privateKey_get(self._cptr)
        return t;
    def set_privateKey(self, value):
        value = str2lasso(value)
        _lasso.Server_privateKey_set(self._cptr, value)
    privateKey = property(get_privateKey, set_privateKey)

    def get_privateKeyPassword(self):
        t = _lasso.Server_privateKeyPassword_get(self._cptr)
        return t;
    def set_privateKeyPassword(self, value):
        value = str2lasso(value)
        _lasso.Server_privateKeyPassword_set(self._cptr, value)
    privateKeyPassword = property(get_privateKeyPassword, set_privateKeyPassword)

    def get_certificate(self):
        t = _lasso.Server_certificate_get(self._cptr)
        return t;
    def set_certificate(self, value):
        value = str2lasso(value)
        _lasso.Server_certificate_set(self._cptr, value)
    certificate = property(get_certificate, set_certificate)

    def get_signatureMethod(self):
        t = _lasso.Server_signatureMethod_get(self._cptr)
        return t;
    def set_signatureMethod(self, value):
        _lasso.Server_signatureMethod_set(self._cptr, value)
    signatureMethod = property(get_signatureMethod, set_signatureMethod)

    def addProvider(self, role, metadata, public_key = None, ca_cert_chain = None):
        '''
        Creates a new L{Provider} and makes it known to the C{self}
        
        @param role:  provider role, identity provider or service provider
        @param metadata:  path to the provider metadata file
        @param public_key:  provider public key file (may be a certificate) or
            None
        @param ca_cert_chain:  provider CA certificate chain file or None
        '''
        rc = _lasso.server_add_provider(self._cptr, role, str2lasso(metadata), str2lasso(public_key), str2lasso(ca_cert_chain))
        Error.raise_on_rc(rc)

    def addProviderFromBuffer(self, role, metadata, public_key = None, ca_cert_chain = None):
        '''
        Creates a new L{Provider} and makes it known to the C{self}
        
        @param role:  provider role, identity provider or service provider
        @param metadata:  a string buffer containg the metadata file for a new
            provider
        @param public_key:  provider public key file (may be a certificate) or
            None
        @param ca_cert_chain:  provider CA certificate chain file or None
        '''
        rc = _lasso.server_add_provider_from_buffer(self._cptr, role, str2lasso(metadata), str2lasso(public_key), str2lasso(ca_cert_chain))
        Error.raise_on_rc(rc)

    def dump(self):
        '''
        Dumps C{self} content to an XML string.
        
        @return: the dump string.
        '''
        return _lasso.server_dump(self._cptr)

    def getProvider(self, providerID):
        '''
        Looks up for a L{Provider} whose ID is C{providerID} and returns it.
        
        @param providerID:  the provider ID
        @return: the L{Provider}, None if it was not found.  The L{Provider}
            is owned by Lasso and should not be freed.
        '''
        return cptrToPy(_lasso.server_get_provider(self._cptr, str2lasso(providerID)))

    def setEncryptionPrivateKey(self, filename_or_buffer = None):
        '''
        Load an encryption private key from a file and set it in the server
        object
        
        If C{filename_or_buffer} is None, it frees the currently setted key.
        
        @param filename_or_buffer:  file name of the encryption key to load or
            its content as a None-terminated string.
        @return: 0 on success; another value if an error occured. Deprecated:
            2.3: Use lasso_server_set_encryption_private_key_with_password()
            instead.
        '''
        rc = _lasso.server_set_encryption_private_key(self._cptr, str2lasso(filename_or_buffer))
        Error.raise_on_rc(rc)

    def loadAffiliation(self, filename):
        '''
        Load an affiliation metadata file into C{self}; this must be called
        after providers have been added to C{self}.
        
        @param filename:  file name of the affiliation metadata to load
        '''
        rc = _lasso.server_load_affiliation(self._cptr, str2lasso(filename))
        Error.raise_on_rc(rc)

    def setEncryptionPrivateKeyWithPassword(self, filename_or_buffer = None, password = None):
        '''
        Load an encryption private key from a file and set it in the server
        object. If C{password} is non-None try to decrypt the key with it.
        
        If C{filename_or_buffer} is None, it frees the currently setted key.
        
        @param filename_or_buffer:  file name of the encryption key to load or
            its content as a None-terminated string.
        @param password:  an optional password to decrypt the encryption key.
        @return: 0 on success; another value if an error occured. Since: 2.3
        '''
        rc = _lasso.server_set_encryption_private_key_with_password(self._cptr, str2lasso(filename_or_buffer), str2lasso(password))
        Error.raise_on_rc(rc)

    def loadMetadata(self, role, federation_file, trusted_roots, blacklisted_entity_ids, flags):
        '''
        Load all the SAML 2.0 entities from C{federation_file} which contains
        a declaration for C{role}. If C{trusted_roots} is non-None, use it to
        check a signature on the metadata file, otherwise ignore signature
        validation.
        
        @param role:  a L{ProviderRole} value
        @param federation_file:  path to a SAML 2.0 metadata file
        @param trusted_roots:  a PEM encoded files containing the certificates
            to check signatures on the metadata file (optional)
        @param blacklisted_entity_ids:  a list of EntityID which should not be
            loaded, can be None.
        @param loaded_entity_ids:  an output parameter for the list of the
            loaded EntityID, can be None.
        @param flags:  flags modifying the behaviour for checking signatures
            on EntityDescriptor and EntitiesDescriptors nodes.
        @return: 0 on success, an error code otherwise, among: <itemizedlist>
            <listitem><para> LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ if server
            is not a L{Server} object or C{role} is not a valid role value,
            </para></listitem> <listitem><para>
            LASSO_DS_ERROR_CA_CERT_CHAIN_LOAD_FAILED if the C{trusted_root}
            file cannot be loaded, </para></listitem> </itemizedlist>
        '''
        _loaded_entity_ids_out = list((None,))
        rc = _lasso.server_load_metadata(self._cptr, role, str2lasso(federation_file), str2lasso(trusted_roots), blacklisted_entity_ids, _loaded_entity_ids_out, flags)
        Error.raise_on_rc(rc)
        return _loaded_entity_ids_out[0]

    def addProvider2(self, provider):
        '''
        Add C{provider} to the list of known providers object of C{self}.
        
        Return 0 if successful, LASSO_PARAM_ERROR_BAD_TYPE_OR_None_OBJ
        otherwise.
        
        @param provider:  a L{Provider} object
        '''
        rc = _lasso.server_add_provider2(self._cptr, provider and provider._cptr)
        Error.raise_on_rc(rc)

    def getEndpointUrlById(self, provider_id, endpoint_description):
        '''
        Locate the provider in the server's list of providers, then select an
        endpoint given the C{endpoint_description} and return than endpoint's
        URL. If the provider cannot be found or if the provider does not have
        a matching endpoint None will be returned.
        
        Returns: url (must be freed by caller)
        
        @param provider_id:  the EntityID whose endpoints will be examined.
        @param endpoint_description:  string describing criteria used to
            select endpoint.
        '''
        return _lasso.server_get_endpoint_url_by_id(self._cptr, str2lasso(provider_id), str2lasso(endpoint_description))

    def getFilteredProviderList(self, role, protocol_type, http_method):
        '''
        Iterate over the C{self} providers and build a list of provider
        EntityID's who have the specified C{role} and at least one endpoint
        matching the C{protocol_type} and C{http_method}. Return a #GList list
        of EntityID's at the C{provider_list} pointer. The caller is
        responsible for freeing the C{provider_list} by calling
        lasso_release_list_of_strings().
        
        @param role:  each returned provider will match this L{ProviderRole}
        @param protocol_type:  provider must have endpoint matching
            L{MdProtocolType} and C{http_method}
        @param http_method:  provider must have endpoint matching
            L{HttpMethod} and C{protocol_type}
        @return: #GList of matching provider EntityID's returned here.
        '''
        return _lasso.server_get_filtered_provider_list(self._cptr, role, protocol_type, http_method)

    def saml2AssertionSetupSignature(self, saml2_assertion):
        '''
        Configure signature on a saml2:Assertion element.
        
        @param saml2_assertion:  a L{Saml2Assertion} object
        @return: 0 if successfull, an error code otherwise.
        '''
        rc = _lasso.server_saml2_assertion_setup_signature(self._cptr, saml2_assertion and saml2_assertion._cptr)
        Error.raise_on_rc(rc)


class Session(Node):
    def __init__(self, ):
        self._cptr = _lasso.session_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromDump(cls, dump):
         return cptrToPy(_lasso.session_new_from_dump(str2lasso(dump)))

    def get_assertions(self):
        t = _lasso.Session_assertions_get(self._cptr)
        if not t: return t
        d2 = {}
        for k, v in t.items():
            d2[k] = cptrToPy(v)
        t = frozendict(d2)
        return t;
    def set_assertions(self, value):
        _lasso.Session_assertions_set(self._cptr, value)
    assertions = property(get_assertions, set_assertions)

    def get_isDirty(self):
        t = _lasso.Session_isDirty_get(self._cptr)
        return t;
    def set_isDirty(self, value):
        _lasso.Session_isDirty_set(self._cptr, value)
    isDirty = property(get_isDirty, set_isDirty)

    def dump(self):
        '''
        Dumps C{self} content to an XML string.
        
        @return: the dump string.
        '''
        return _lasso.session_dump(self._cptr)

    def getAssertions(self, provider_id = None):
        '''
        Gets the assertions for the given C{provider_id}.
        
        @param provider_id:  the provider ID
        @return: a list of L{SamlAssertion}.
        '''
        value = _lasso.session_get_assertions(self._cptr, str2lasso(provider_id))
        if value is not None:
            value = tuple([cptrToPy(x) for x in value])
        return value

    def getProviderIndex(self, index):
        '''
        Looks up and returns the nth provider id.
        
        @param index:  index of requested provider
        @return: the provider id; or None if there were no nth provider.
        '''
        return _lasso.session_get_provider_index(self._cptr, index)

    def isEmpty(self):
        '''
        Returns True if session is empty.
        
        @return: True if empty
        '''
        return _lasso.session_is_empty(self._cptr)

    def removeAssertion(self, providerID):
        '''
        Removes assertion for C{providerID} from C{self}.
        
        @param providerID:  the provider ID
        '''
        rc = _lasso.session_remove_assertion(self._cptr, str2lasso(providerID))
        Error.raise_on_rc(rc)

    def getAssertion(self, providerID):
        '''
        Gets the assertion for the given C{providerID}.
        
        @param providerID:  the provider ID
        @return: the assertion or None if it didn't exist.  This
            L{SamlAssertion} is internally allocated and must not be freed by
            the caller.
        '''
        return cptrToPy(_lasso.session_get_assertion(self._cptr, str2lasso(providerID)))

    def addAssertion(self, providerID, assertion):
        '''
        Adds C{assertion} to the principal session. This function also add the
        assertion to the index by assertionID.
        
        @param providerID:  the provider ID
        @param assertion:  the assertion
        '''
        rc = _lasso.session_add_assertion(self._cptr, str2lasso(providerID), assertion and assertion._cptr)
        Error.raise_on_rc(rc)

    def getNameIds(self, providerID):
        '''
        List the known NameID coming from this provider during this session.
        
        @param providerID:  a provider identifier
        @return: a list of L{Node} objects.
        '''
        value = _lasso.session_get_name_ids(self._cptr, str2lasso(providerID))
        if value is not None:
            value = tuple([cptrToPy(x) for x in value])
        return value

    def getSessionIndexes(self, providerID, name_id):
        '''
        Gets all the registered session indexes for this session.
        
        @param providerID:  a provider id
        @param name_id:  a L{SamlAssertion} or L{Saml2Assertion} object
        @return: a list of string containing the session index identifiers.
        '''
        return _lasso.session_get_session_indexes(self._cptr, str2lasso(providerID), name_id and name_id._cptr)

    def getAssertionIds(self, providerID):
        '''
        List the ids of assertions received during the current session.
        
        @param providerID:  a provider identifier
        @return: a list of strings
        '''
        return _lasso.session_get_assertion_ids(self._cptr, str2lasso(providerID))


class AssertionQuery(Profile):
    def __init__(self, server):
        self._cptr = _lasso.assertion_query_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    def initRequest(self, remote_provider_id, http_method, query_request_type):
        '''
        Initializes a new Assertion Query Request. For the AssertionID request
        type, the remote_provider_id is mandatory, for all other kind of
        request it is optional if we can find a provider supporting the
        associated role, i.e. IDP; authentication, attribute and authorization
        authority.
        
        @param remote_provider_id:  the providerID of the remote provider.
        @param http_method:  if set, then it get the protocol profile in
            metadata corresponding of this HTTP request method.
        @param query_request_type:  the type of request.
        '''
        rc = _lasso.assertion_query_init_request(self._cptr, str2lasso(remote_provider_id), http_method, query_request_type)
        Error.raise_on_rc(rc)

    def validateRequest(self):
        '''
        Processes a Assertion query or request; caller must add assertions to
        the response afterwards.
        '''
        rc = _lasso.assertion_query_validate_request(self._cptr)
        Error.raise_on_rc(rc)

    def buildRequestMsg(self):
        '''
        Build an Assertion Query profile request message.
        '''
        rc = _lasso.assertion_query_build_request_msg(self._cptr)
        Error.raise_on_rc(rc)

    def processRequestMsg(self, request_msg):
        '''
        Processes a Assertion query or request message.  Rebuilds a request
        object from the message and check its signature.
        
        @param request_msg:  the Assertion query or request message
        '''
        rc = _lasso.assertion_query_process_request_msg(self._cptr, str2lasso(request_msg))
        Error.raise_on_rc(rc)

    def buildResponseMsg(self):
        '''
        Builds the Response message.
        '''
        rc = _lasso.assertion_query_build_response_msg(self._cptr)
        Error.raise_on_rc(rc)

    def processResponseMsg(self, response_msg):
        '''
        Parses the response message and builds the corresponding response
        object.
        
        @param response_msg:  the response message
        '''
        rc = _lasso.assertion_query_process_response_msg(self._cptr, str2lasso(response_msg))
        Error.raise_on_rc(rc)

    def addAttributeRequest(self, format, name):
        '''
        Append a new attribute designator to the current attribute request.
        
        @param attribute_format:  the attribute designator format
        @param attribute_name:  the attribute designator name
        @return: 0 if successful, an error code otherwise.
        '''
        rc = _lasso.assertion_query_add_attribute_request(self._cptr, str2lasso(format), str2lasso(name))
        Error.raise_on_rc(rc)

    def getRequestType(self):
        '''
        Return the type of the last processed request.
        
        @return: a L{AssertionQueryRequestType} value
        '''
        return _lasso.assertion_query_get_request_type(self._cptr)

    requestType = property(getRequestType)

class Ecp(Profile):
    def __init__(self, server):
        self._cptr = _lasso.ecp_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    def get_assertionConsumerUrl(self):
        t = _lasso.Ecp_assertionConsumerUrl_get(self._cptr)
        return t;
    def set_assertionConsumerUrl(self, value):
        value = str2lasso(value)
        _lasso.Ecp_assertionConsumerUrl_set(self._cptr, value)
    assertionConsumerUrl = property(get_assertionConsumerUrl, set_assertionConsumerUrl)

    def get_messageId(self):
        t = _lasso.Ecp_messageId_get(self._cptr)
        return t;
    def set_messageId(self, value):
        value = str2lasso(value)
        _lasso.Ecp_messageId_set(self._cptr, value)
    messageId = property(get_messageId, set_messageId)

    def get_responseConsumerUrl(self):
        t = _lasso.Ecp_responseConsumerUrl_get(self._cptr)
        return t;
    def set_responseConsumerUrl(self, value):
        value = str2lasso(value)
        _lasso.Ecp_responseConsumerUrl_set(self._cptr, value)
    responseConsumerUrl = property(get_responseConsumerUrl, set_responseConsumerUrl)

    def get_relaystate(self):
        t = _lasso.Ecp_relaystate_get(self._cptr)
        return t;
    def set_relaystate(self, value):
        value = str2lasso(value)
        _lasso.Ecp_relaystate_set(self._cptr, value)
    relaystate = property(get_relaystate, set_relaystate)

    def get_issuer(self):
        t = _lasso.Ecp_issuer_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_issuer(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Ecp_issuer_set(self._cptr, value)
    issuer = property(get_issuer, set_issuer)

    def get_providerName(self):
        t = _lasso.Ecp_providerName_get(self._cptr)
        return t;
    def set_providerName(self, value):
        value = str2lasso(value)
        _lasso.Ecp_providerName_set(self._cptr, value)
    providerName = property(get_providerName, set_providerName)

    def get_isPassive(self):
        t = _lasso.Ecp_isPassive_get(self._cptr)
        return t;
    def set_isPassive(self, value):
        _lasso.Ecp_isPassive_set(self._cptr, value)
    isPassive = property(get_isPassive, set_isPassive)

    def get_spIdpList(self):
        t = _lasso.Ecp_spIdpList_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_spIdpList(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Ecp_spIdpList_set(self._cptr, value)
    spIdpList = property(get_spIdpList, set_spIdpList)

    def get_knownSpProvidedIdpEntriesSupportingEcp(self):
        t = _lasso.Ecp_knownSpProvidedIdpEntriesSupportingEcp_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_knownSpProvidedIdpEntriesSupportingEcp(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Ecp_knownSpProvidedIdpEntriesSupportingEcp_set(self._cptr, value)
    knownSpProvidedIdpEntriesSupportingEcp = property(get_knownSpProvidedIdpEntriesSupportingEcp, set_knownSpProvidedIdpEntriesSupportingEcp)

    def get_knownIdpEntityIdsSupportingEcp(self):
        t = _lasso.Ecp_knownIdpEntityIdsSupportingEcp_get(self._cptr)
        return t;
    def set_knownIdpEntityIdsSupportingEcp(self, value):
        _lasso.Ecp_knownIdpEntityIdsSupportingEcp_set(self._cptr, value)
    knownIdpEntityIdsSupportingEcp = property(get_knownIdpEntityIdsSupportingEcp, set_knownIdpEntityIdsSupportingEcp)

    def processAuthnRequestMsg(self, authn_request_msg):
        '''
        This function implements the following ECP step: ECP Step 3, ECP
        determines IdP ECP Step 4, parse SP PAOS Authn request, build SOAP for
        IdP
        
        This is to be used in an ECP client. The C{authn_request_msg} is the
        SOAP PAOS message received from the SP in response to a resource
        request with an HTTP Accept header indicating PAOS support.
        
        The following actions are implemented:
        
        * Extract the samlp:AuthnRequest from the SOAP body and build a   new
        SOAP message containing the samlp:AuthnRequest which will   be
        forwarded to the IdP. This new SOAP message is stored in the
        L{Profile}.msg_body.
        
        * Parse the SOAP header which will contain a paos:Request, a
        ecp:Request and optionally a ecp:RelayState. Some of the data   in
        these headers need to be preserved for later processing steps.
        
          1. The paos:Request.responseConsumerURL is copied to the
        L{Ecp}.response_consumer_url. This is necessary because the      ECP
        client MUST assure it matches the
        ecp:Response.AssertionConsumerServiceURL returned by the IdP to
        prevent man-in-the-middle attacks. It must also match the
        samlp:AuthnRequest.AssertionConsumerServiceURL.
        
          2. If the paos:Request contained a messageID it is copied to
        L{Ecp}.message_id so it can be returned in the subsequent
        paos:Response.refToMessageID. This allows a provider to      correlate
        messages.
        
          3. If an ecp:RelayState is present it is copied to
        L{Ecp}.relaystate. This is necessary because in step 7 when      the
        ECP responds to the SP it must include RelayState provided in      the
        request.
        
        * In addition the following items are copied to the L{Ecp} for
        informational purposes:
        
          * L{Ecp}.issuer = ecp:Request.Issuer
        
          * L{Ecp}.provider_name = ecp:Request.ProviderName
        
          * L{Ecp}.is_passive = ecp:Request.IsPassive
        
          * L{Ecp}.sp_idp_list = ecp:Request.IDPList
        
        # IdP Selection
        
        In Step 3. The ECP must determine the IdP to forward the AuthnRequest
        to. There are two sets of IdP's which come into play. The ECP client
        has a set of IdP's it knows about because their metadata has been
        loaded into the L{Server} object. The SP may optionally send a list of
        IdP's in the ecp:Request that it trusts.
        
        The selected IdP *must* be one of the IdP's loaded into the L{Server}
        object from metadata because the IdP endpoints must be known.
        Furthermore the IdP *must* support the SingleSignOnService using the
        SOAP binding. Therefore the known IdP's are filtered for those that
        match this criteria and a list of their EntityID's are assigned to
        L{Ecp}.known_idp_entity_ids_supporting_ecp. The selected IdP *must* be
        a member of this list.
        
        The SP may optionally send a list of IdP's it trusts. If the SP sends
        an IDPList the selected IdP should be a member of this list and from
        above we know it must also be a member of the
        L{Ecp}.known_idp_entity_ids_supporting_ecp. Therefore the
        L{Ecp}.known_sp_provided_idp_entries_supporting_ecp list is set to the
        common members (e.g. intersection) of the SP provided IdP list and the
        list of known IdP's supporting ECP.
        
        When making an IdP selection if the SP provided an IdP List (use
        L{Ecp}.lasso_ecp_has_sp_idplist()) then it should be selected from the
        L{Ecp}.known_sp_provided_idp_entries_supporting_ecp list. Otherwise
        the IdP should be selected from
        L{Ecp}.known_idp_entity_ids_supporting_ecp.
        
        A default IdP will be selected using the above logic by picking the
        first IdP in the appropriate list, it's endpoint URL will be assigned
        to L{Profile}.msg_url. The above processing is implemented by
        L{Ecp}.lasso_ecp_process_sp_idp_list() and if the SP IDPList is
        updated this routine should be called.
        
        A note about the 3 IdP lists. The L{Ecp}.sp_idp_list.IDPList and
        L{Ecp}.known_sp_provided_idp_entries_supporting_ecp are #GList's of
        L{Samlp2IDPEntry} object which have a ProviderID, Name, and Loc
        attribute. You may wish to use this SP provided information when
        making a decision or presenting in a user interface that allows a user
        to make a choice. The L{Ecp}.known_idp_entity_ids_supporting_ecp is a
        #GList of EntityID strings.
        
        Given the EntityID of an IdP you can get the ECP endpoint by calling
        L{Ecp}.lasso_ecp_get_endpoint_url_by_entity_id()
        
        # Results
        
        After a successful return from this call you are ready to complete
        Step 4. and forward the request the IdP.
        
        The URL to send to the request to will be L{Profile}.msg_url (if you
        accept the default IdP) and the body of the message to post will be
        L{Profile}.msg_body.
        
         # Side Effects
        
        After a successful return the L{Ecp} object will be updated with:
        
        * ecp->response_consumer_url = paos_request->responseConsumerURL *
        ecp->message_id = paos_request->messageID * ecp->relaystate =
        ecp_relaystate->RelayState * ecp->issuer = ecp_request->Issue *
        ecp->provider_name = ecp_request->ProviderName * ecp->is_passive =
        ecp_request->IsPassive * ecp->known_idp_entity_ids_supporting_ecp *
        ecp->sp_idp_list = ecp_request->IDPList *
        ecp->known_sp_provided_idp_entries_supporting_ecp
        
        @param authn_request_msg:  the PAOS authn request received from the SP
        '''
        rc = _lasso.ecp_process_authn_request_msg(self._cptr, str2lasso(authn_request_msg))
        Error.raise_on_rc(rc)

    def processResponseMsg(self, response_msg):
        '''
        The function implements ECP Step 7; parse IdP SOAP response and build
        PAOS response for SP.
        
        See SAML Profile Section 4.2.4.5 PAOS Response Header Block: ECP to SP
        
        This is to be used in an ECP client. The C{response_msg} parameter
        contains the SOAP response from the IdP. We extract the ECP Header
        Block and body from it. We will generate a new PAOS message to send to
        the SP, the SOAP header will contain a paos:Response. If we received a
        paos:Request.MessageID in Step. 4 from the SP then we will copy it
        back to the paos:Response.refToMessageID. If we received a RelayState
        we will add that to the SOAP header as well.
        
        To prevent a man-in-the-middle attack we verify the
        responseConsumerURL we received in Step 4 matches the
        ecp:Response.AssertionConsumerServiceURL we just received back from
        the IdP. If they do not match we return a
        #LASSO_ECP_ERROR_ASSERTION_CONSUMER_URL_MISMATCH error and set the
        L{Provider}.msg_body to the appropriate SOAP fault.
        
        The new PAOS message for the SP we are buiding contains the IdP
        response in the new SOAP body and the new SOAP headers will contain a
        paso:Response and optionally an ecp:RelayState.
        
        After a successful return from this call you are ready to complete
        Step 7. and forward the response to the SP.
        
        The PASO message is assigned to the L{Provider}.msg_body and the
        desination URL is assigned to the L{Provider}.msg_url.
        
        # Side Effects
        
        After a successful return the L{Ecp} object will be updated with:
        
        * ecp->assertion_consumer_url =
        ecp_response->AssertionConsumerServiceURL * ecp.profile.msg_url =
        ecp->assertion_consumer_url * ecp.profile.msg_body_url = PAOS response
        to SP
        
        @param response_msg:  the SOAP response from the IdP
        '''
        rc = _lasso.ecp_process_response_msg(self._cptr, str2lasso(response_msg))
        Error.raise_on_rc(rc)

    def isProviderInSpIdplist(self, entity_id):
        '''
        Check to see if the provider with C{entity_id} is in the ecp IDPList
        returned by the SP.
        
        @param entity_id:  EntityID to check if member of L{Ecp}.IDPList
        @return: TRUE if C{entity_id} is in L{Ecp}.IDPList, FALSE otherwise
        '''
        return _lasso.ecp_is_provider_in_sp_idplist(self._cptr, str2lasso(entity_id))

    def isIdpEntryKnownIdpSupportingEcp(self, idp_entry):
        '''
        Check to see if the C{idp_entry} is in the C{entity_id_list}
        
        @param idp_entry:  L{Samlp2IDPEntry} to check if member of
            C{entity_id_list}
        @return: TRUE if C{entity_id} is in C{idp_list}, FALSE otherwise
        '''
        return _lasso.ecp_is_idp_entry_known_idp_supporting_ecp(self._cptr, idp_entry and idp_entry._cptr)

    def setKnownSpProvidedIdpEntriesSupportingEcp(self):
        '''
        The SP may provide a list of L{Samlp2IDPEntry} (L{Ecp}.sp_idp_list)
        which it trusts. The ECP client has a list of IDP EntityID's it knows
        supports ECP (L{Ecp}.known_idp_entity_ids_supporting_ecp).  The set of
        possible IDP's which can service the SP's authn request are the
        interesection of these two lists (the IDP's the SP approves and IDP's
        the ECP knows about). This find the common members between the two
        lists and assign them to
        L{Ecp}.known_sp_provided_idp_entries_supporting_ecp.
        '''
        _lasso.ecp_set_known_sp_provided_idp_entries_supporting_ecp(self._cptr)

    def hasSpIdplist(self):
        '''
        Returns TRUE if the SP provided an IDP List, FALSE otherwise.
        '''
        return _lasso.ecp_has_sp_idplist(self._cptr)

    def getEndpointUrlByEntityId(self, entity_id):
        '''
        Returns the SingleSignOnService SOAP endpoint URL for the specified
        C{entity_id}. If the provider cannot be found or if the provider does
        not have a matching endpoint None will be returned.
        
        Returns: url (must be freed by caller)
        
        @param entity_id:  the EntityID of the IdP
        '''
        return _lasso.ecp_get_endpoint_url_by_entity_id(self._cptr, str2lasso(entity_id))

    def processSpIdpList(self, sp_idp_list):
        '''
        The SP may optionally send a list of IdP's it trusts in ecp:IDPList.
        The ecp:IDPList may not be complete if the IDPList.GetComplete is non-
        None. If so the IDPList.GetComplete is a URL where a complete IDPList
        may be fetched.
        
        Whenever the IDPList is updated this function needs to be called
        because it sets the
        L{Ecp}.known_sp_provided_idp_entries_supporting_ecp and the default
        IdP URL (L{Profile}.msg_url).
        
        The L{Ecp} client has a list of IdP's it knows supports ECP
        (L{Ecp}.known_idp_entity_ids_supporting_ecp). The set of IdP's
        available to select from should be those in common between SP provided
        IdP list and those known by this ECP client to support ECP.
        
        This routine sets the
        L{Ecp}.known_sp_provided_idp_entries_supporting_ecp list to the common
        members (e.g. intersection) of the SP provided IdP list and the list
        of known IdP's supporting ECP.
        
        A default IdP will be selected and it's endpoint URL will be assigned
        to L{Profile}.msg_url.
        
        If the SP provided an IDP list then the default URL will be taken from
        first IDPEntry in L{Ecp}.known_sp_provided_idp_entries_supporting_ecp
        otherwise it will be taken from
        L{Ecp}.known_idp_entity_ids_supporting_ecp.
        '''
        return _lasso.ecp_process_sp_idp_list(self._cptr, sp_idp_list and sp_idp_list._cptr)


class NameIdManagement(Profile):
    def __init__(self, server):
        self._cptr = _lasso.name_id_management_new(server and server._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromDump(cls, server, dump):
         return cptrToPy(_lasso.name_id_management_new_from_dump(server and server._cptr, str2lasso(dump)))

    def dump(self):
        '''
        Dumps C{self} content to an XML string.
        
        @return: the dump string.
        '''
        return _lasso.name_id_management_dump(self._cptr)

    def initRequest(self, remote_provider_id = None, new_name_id = None, http_method = HTTP_METHOD_ANY):
        '''
        Initializes a new Name Id Management Request. If C{new_name_id} is
        None, it is a Termination request, if not and we are an IdP is a
        NameID change request, if we are a SP, it is a request to add a SP
        provided Id to the NameID of the IdP. It can be useful if the SP do
        not want to store the federation, instead he can export its own
        identifiers to the IdP.
        
        @param remote_provider_id:  the providerID of the remote provider.
        @param new_name_id:  the new NameId or None to terminate a federation
        @param http_method:  if set, then it get the protocol profile in
            metadata corresponding of this HTTP request method.
        '''
        rc = _lasso.name_id_management_init_request(self._cptr, str2lasso(remote_provider_id), str2lasso(new_name_id), http_method)
        Error.raise_on_rc(rc)

    def buildRequestMsg(self):
        '''
        Builds the Name Id Management request message.
        '''
        rc = _lasso.name_id_management_build_request_msg(self._cptr)
        Error.raise_on_rc(rc)

    def processRequestMsg(self, request_msg):
        '''
        Processes a Name Id Management request message.  Rebuilds a request
        object from the message and check its signature.
        
        @param request_msg:  the Name Id Management request message
        '''
        rc = _lasso.name_id_management_process_request_msg(self._cptr, str2lasso(request_msg))
        Error.raise_on_rc(rc)

    def validateRequest(self):
        '''
        Processes a Name Id Management request, performing requested actions
        against principal federations.  Profile identity may have to be saved
        afterwards.
        '''
        rc = _lasso.name_id_management_validate_request(self._cptr)
        Error.raise_on_rc(rc)

    def buildResponseMsg(self):
        '''
        Builds the Name Id Management response message.
        '''
        rc = _lasso.name_id_management_build_response_msg(self._cptr)
        Error.raise_on_rc(rc)

    def processResponseMsg(self, response_msg):
        '''
        Parses the response message and builds the corresponding response
        object. Performs requested actions against principal federations.
        Profile identity may have to be saved afterwards.
        
        @param response_msg:  the response message
        '''
        rc = _lasso.name_id_management_process_response_msg(self._cptr, str2lasso(response_msg))
        Error.raise_on_rc(rc)


class LibAuthnContext(Node):
    def __init__(self, ):
        self._cptr = _lasso.lib_authn_context_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_authnContextClassRef(self):
        t = _lasso.LibAuthnContext_authnContextClassRef_get(self._cptr)
        return t;
    def set_authnContextClassRef(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnContext_authnContextClassRef_set(self._cptr, value)
    authnContextClassRef = property(get_authnContextClassRef, set_authnContextClassRef)

    def get_authnContextStatementRef(self):
        t = _lasso.LibAuthnContext_authnContextStatementRef_get(self._cptr)
        return t;
    def set_authnContextStatementRef(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnContext_authnContextStatementRef_set(self._cptr, value)
    authnContextStatementRef = property(get_authnContextStatementRef, set_authnContextStatementRef)


class LibAuthnRequestEnvelope(Node):
    def __init__(self, ):
        self._cptr = _lasso.lib_authn_request_envelope_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, authnRequest, providerID, assertionConsumerServiceURL):
         return cptrToPy(_lasso.lib_authn_request_envelope_new_full(authnRequest and authnRequest._cptr, str2lasso(providerID), str2lasso(assertionConsumerServiceURL)))

    def get_extension(self):
        t = _lasso.LibAuthnRequestEnvelope_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibAuthnRequestEnvelope_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_authnRequest(self):
        t = _lasso.LibAuthnRequestEnvelope_authnRequest_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_authnRequest(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibAuthnRequestEnvelope_authnRequest_set(self._cptr, value)
    authnRequest = property(get_authnRequest, set_authnRequest)

    def get_providerId(self):
        t = _lasso.LibAuthnRequestEnvelope_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequestEnvelope_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_providerName(self):
        t = _lasso.LibAuthnRequestEnvelope_providerName_get(self._cptr)
        return t;
    def set_providerName(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequestEnvelope_providerName_set(self._cptr, value)
    providerName = property(get_providerName, set_providerName)

    def get_assertionConsumerServiceUrl(self):
        t = _lasso.LibAuthnRequestEnvelope_assertionConsumerServiceUrl_get(self._cptr)
        return t;
    def set_assertionConsumerServiceUrl(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequestEnvelope_assertionConsumerServiceUrl_set(self._cptr, value)
    assertionConsumerServiceUrl = property(get_assertionConsumerServiceUrl, set_assertionConsumerServiceUrl)
    assertionConsumerServiceURL = assertionConsumerServiceUrl

    def get_idpList(self):
        t = _lasso.LibAuthnRequestEnvelope_idpList_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_idpList(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibAuthnRequestEnvelope_idpList_set(self._cptr, value)
    idpList = property(get_idpList, set_idpList)
    iDPList = idpList

    def get_isPassive(self):
        t = _lasso.LibAuthnRequestEnvelope_isPassive_get(self._cptr)
        return t;
    def set_isPassive(self, value):
        _lasso.LibAuthnRequestEnvelope_isPassive_set(self._cptr, value)
    isPassive = property(get_isPassive, set_isPassive)


class LibAuthnResponseEnvelope(Node):
    def __init__(self, response, assertionConsumerServiceURL):
        self._cptr = _lasso.lib_authn_response_envelope_new(response and response._cptr, str2lasso(assertionConsumerServiceURL))
        if self._cptr is None:
            raise Error('failed to create object')

    def get_extension(self):
        t = _lasso.LibAuthnResponseEnvelope_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibAuthnResponseEnvelope_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_authnResponse(self):
        t = _lasso.LibAuthnResponseEnvelope_authnResponse_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_authnResponse(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibAuthnResponseEnvelope_authnResponse_set(self._cptr, value)
    authnResponse = property(get_authnResponse, set_authnResponse)

    def get_assertionConsumerServiceUrl(self):
        t = _lasso.LibAuthnResponseEnvelope_assertionConsumerServiceUrl_get(self._cptr)
        return t;
    def set_assertionConsumerServiceUrl(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnResponseEnvelope_assertionConsumerServiceUrl_set(self._cptr, value)
    assertionConsumerServiceUrl = property(get_assertionConsumerServiceUrl, set_assertionConsumerServiceUrl)
    assertionConsumerServiceURL = assertionConsumerServiceUrl


class LibIDPEntries(Node):
    def __init__(self, ):
        self._cptr = _lasso.lib_idp_entries_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_idpEntry(self):
        t = _lasso.LibIDPEntries_idpEntry_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_idpEntry(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.LibIDPEntries_idpEntry_set(self._cptr, value)
    idpEntry = property(get_idpEntry, set_idpEntry)
    iDPEntry = idpEntry


class LibIDPEntry(Node):
    def __init__(self, ):
        self._cptr = _lasso.lib_idp_entry_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_providerId(self):
        t = _lasso.LibIDPEntry_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibIDPEntry_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_providerName(self):
        t = _lasso.LibIDPEntry_providerName_get(self._cptr)
        return t;
    def set_providerName(self, value):
        value = str2lasso(value)
        _lasso.LibIDPEntry_providerName_set(self._cptr, value)
    providerName = property(get_providerName, set_providerName)

    def get_loc(self):
        t = _lasso.LibIDPEntry_loc_get(self._cptr)
        return t;
    def set_loc(self, value):
        value = str2lasso(value)
        _lasso.LibIDPEntry_loc_set(self._cptr, value)
    loc = property(get_loc, set_loc)


class LibIDPList(Node):
    def __init__(self, ):
        self._cptr = _lasso.lib_idp_list_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_idpEntries(self):
        t = _lasso.LibIDPList_idpEntries_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_idpEntries(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibIDPList_idpEntries_set(self._cptr, value)
    idpEntries = property(get_idpEntries, set_idpEntries)
    iDPEntries = idpEntries

    def get_getComplete(self):
        t = _lasso.LibIDPList_getComplete_get(self._cptr)
        return t;
    def set_getComplete(self, value):
        value = str2lasso(value)
        _lasso.LibIDPList_getComplete_set(self._cptr, value)
    getComplete = property(get_getComplete, set_getComplete)


class LibRequestAuthnContext(Node):
    def __init__(self, ):
        self._cptr = _lasso.lib_request_authn_context_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_authnContextClassRef(self):
        t = _lasso.LibRequestAuthnContext_authnContextClassRef_get(self._cptr)
        return t;
    def set_authnContextClassRef(self, value):
        _lasso.LibRequestAuthnContext_authnContextClassRef_set(self._cptr, value)
    authnContextClassRef = property(get_authnContextClassRef, set_authnContextClassRef)

    def get_authnContextStatementRef(self):
        t = _lasso.LibRequestAuthnContext_authnContextStatementRef_get(self._cptr)
        return t;
    def set_authnContextStatementRef(self, value):
        _lasso.LibRequestAuthnContext_authnContextStatementRef_set(self._cptr, value)
    authnContextStatementRef = property(get_authnContextStatementRef, set_authnContextStatementRef)

    def get_authnContextComparison(self):
        t = _lasso.LibRequestAuthnContext_authnContextComparison_get(self._cptr)
        return t;
    def set_authnContextComparison(self, value):
        value = str2lasso(value)
        _lasso.LibRequestAuthnContext_authnContextComparison_set(self._cptr, value)
    authnContextComparison = property(get_authnContextComparison, set_authnContextComparison)


class LibScoping(Node):
    def __init__(self, ):
        self._cptr = _lasso.lib_scoping_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_proxyCount(self):
        t = _lasso.LibScoping_proxyCount_get(self._cptr)
        return t;
    def set_proxyCount(self, value):
        _lasso.LibScoping_proxyCount_set(self._cptr, value)
    proxyCount = property(get_proxyCount, set_proxyCount)

    def get_idpList(self):
        t = _lasso.LibScoping_idpList_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_idpList(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibScoping_idpList_set(self._cptr, value)
    idpList = property(get_idpList, set_idpList)
    iDPList = idpList


class MiscTextNode(Node):
    def __init__(self, ):
        self._cptr = _lasso.misc_text_node_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newWithString(cls, content):
         return cptrToPy(_lasso.misc_text_node_new_with_string(str2lasso(content)))

    @classmethod
    def newWithXmlNode(cls, xml_node):
         return cptrToPy(_lasso.misc_text_node_new_with_xml_node(xml_node))

    def get_content(self):
        t = _lasso.MiscTextNode_content_get(self._cptr)
        return t;
    def set_content(self, value):
        value = str2lasso(value)
        _lasso.MiscTextNode_content_set(self._cptr, value)
    content = property(get_content, set_content)

    def get_name(self):
        t = _lasso.MiscTextNode_name_get(self._cptr)
        return t;
    def set_name(self, value):
        value = str2lasso(value)
        _lasso.MiscTextNode_name_set(self._cptr, value)
    name = property(get_name, set_name)

    def get_nsHref(self):
        t = _lasso.MiscTextNode_nsHref_get(self._cptr)
        return t;
    def set_nsHref(self, value):
        value = str2lasso(value)
        _lasso.MiscTextNode_nsHref_set(self._cptr, value)
    nsHref = property(get_nsHref, set_nsHref)

    def get_nsPrefix(self):
        t = _lasso.MiscTextNode_nsPrefix_get(self._cptr)
        return t;
    def set_nsPrefix(self, value):
        value = str2lasso(value)
        _lasso.MiscTextNode_nsPrefix_set(self._cptr, value)
    nsPrefix = property(get_nsPrefix, set_nsPrefix)

    def get_textChild(self):
        t = _lasso.MiscTextNode_textChild_get(self._cptr)
        return t;
    def set_textChild(self, value):
        _lasso.MiscTextNode_textChild_set(self._cptr, value)
    textChild = property(get_textChild, set_textChild)

    def setXmlContent(self, node):
        '''
        Set the xml content of this L{MiscTextNode}
        '''
        _lasso.misc_text_node_set_xml_content(self._cptr, node)

    def getXmlContent(self):
        '''
        Return the xml content in this node.
        
        @return: an #xmlNode or None.
        '''
        return _lasso.misc_text_node_get_xml_content(self._cptr)

    xmlContent = property(getXmlContent, setXmlContent)

class PaosRequest(Node):
    def __init__(self, responseConsumerURL = None, messageID = None):
        self._cptr = _lasso.paos_request_new(str2lasso(responseConsumerURL), str2lasso(messageID))
        if self._cptr is None:
            raise Error('failed to create object')

    def get_responseConsumerURL(self):
        t = _lasso.PaosRequest_responseConsumerURL_get(self._cptr)
        return t;
    def set_responseConsumerURL(self, value):
        value = str2lasso(value)
        _lasso.PaosRequest_responseConsumerURL_set(self._cptr, value)
    responseConsumerURL = property(get_responseConsumerURL, set_responseConsumerURL)

    def get_messageId(self):
        t = _lasso.PaosRequest_messageId_get(self._cptr)
        return t;
    def set_messageId(self, value):
        value = str2lasso(value)
        _lasso.PaosRequest_messageId_set(self._cptr, value)
    messageId = property(get_messageId, set_messageId)

    def get_service(self):
        t = _lasso.PaosRequest_service_get(self._cptr)
        return t;
    def set_service(self, value):
        value = str2lasso(value)
        _lasso.PaosRequest_service_set(self._cptr, value)
    service = property(get_service, set_service)

    def get_mustUnderstand(self):
        t = _lasso.PaosRequest_mustUnderstand_get(self._cptr)
        return t;
    def set_mustUnderstand(self, value):
        _lasso.PaosRequest_mustUnderstand_set(self._cptr, value)
    mustUnderstand = property(get_mustUnderstand, set_mustUnderstand)

    def get_actor(self):
        t = _lasso.PaosRequest_actor_get(self._cptr)
        return t;
    def set_actor(self, value):
        value = str2lasso(value)
        _lasso.PaosRequest_actor_set(self._cptr, value)
    actor = property(get_actor, set_actor)

    def validate(self):
        '''
        Validates the object conforms to required values.
        
         - <listitem>responseConsumerURL must be non-None</listitem>
           <listitem>mustUnderstand must be TRUE</listitem>   <listitem>actor
           must be equal to #LASSO_SOAP_ENV_ACTOR</listitem>
           <listitem>service must be equal to #LASSO_ECP_HREF</listitem>
        
        Returns: 0 on success, error code otherwise
        '''
        return _lasso.paos_request_validate(self._cptr)


class PaosResponse(Node):
    def __init__(self, refToMessageID = None):
        self._cptr = _lasso.paos_response_new(str2lasso(refToMessageID))
        if self._cptr is None:
            raise Error('failed to create object')

    def get_refToMessageId(self):
        t = _lasso.PaosResponse_refToMessageId_get(self._cptr)
        return t;
    def set_refToMessageId(self, value):
        value = str2lasso(value)
        _lasso.PaosResponse_refToMessageId_set(self._cptr, value)
    refToMessageId = property(get_refToMessageId, set_refToMessageId)

    def get_mustUnderstand(self):
        t = _lasso.PaosResponse_mustUnderstand_get(self._cptr)
        return t;
    def set_mustUnderstand(self, value):
        _lasso.PaosResponse_mustUnderstand_set(self._cptr, value)
    mustUnderstand = property(get_mustUnderstand, set_mustUnderstand)

    def get_actor(self):
        t = _lasso.PaosResponse_actor_get(self._cptr)
        return t;
    def set_actor(self, value):
        value = str2lasso(value)
        _lasso.PaosResponse_actor_set(self._cptr, value)
    actor = property(get_actor, set_actor)

    def validate(self):
        '''
        Validates the object conforms to required values.
        
         - <listitem>mustUnderstand must be TRUE</listitem>   <listitem>actor
           must be equal to #LASSO_SOAP_ENV_ACTOR</listitem>
        
        Returns: 0 on success, error code otherwise
        '''
        return _lasso.paos_response_validate(self._cptr)


class SamlAdvice(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_advice_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_assertionIdReference(self):
        t = _lasso.SamlAdvice_assertionIdReference_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertionIdReference(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SamlAdvice_assertionIdReference_set(self._cptr, value)
    assertionIdReference = property(get_assertionIdReference, set_assertionIdReference)

    def get_assertion(self):
        t = _lasso.SamlAdvice_assertion_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_assertion(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlAdvice_assertion_set(self._cptr, value)
    assertion = property(get_assertion, set_assertion)


class SamlAssertion(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_assertion_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_conditions(self):
        t = _lasso.SamlAssertion_conditions_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_conditions(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlAssertion_conditions_set(self._cptr, value)
    conditions = property(get_conditions, set_conditions)

    def get_advice(self):
        t = _lasso.SamlAssertion_advice_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_advice(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlAssertion_advice_set(self._cptr, value)
    advice = property(get_advice, set_advice)

    def get_subjectStatement(self):
        t = _lasso.SamlAssertion_subjectStatement_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subjectStatement(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlAssertion_subjectStatement_set(self._cptr, value)
    subjectStatement = property(get_subjectStatement, set_subjectStatement)

    def get_authenticationStatement(self):
        t = _lasso.SamlAssertion_authenticationStatement_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_authenticationStatement(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlAssertion_authenticationStatement_set(self._cptr, value)
    authenticationStatement = property(get_authenticationStatement, set_authenticationStatement)

    def get_attributeStatement(self):
        t = _lasso.SamlAssertion_attributeStatement_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_attributeStatement(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlAssertion_attributeStatement_set(self._cptr, value)
    attributeStatement = property(get_attributeStatement, set_attributeStatement)

    def get_majorVersion(self):
        t = _lasso.SamlAssertion_majorVersion_get(self._cptr)
        return t;
    def set_majorVersion(self, value):
        _lasso.SamlAssertion_majorVersion_set(self._cptr, value)
    majorVersion = property(get_majorVersion, set_majorVersion)

    def get_minorVersion(self):
        t = _lasso.SamlAssertion_minorVersion_get(self._cptr)
        return t;
    def set_minorVersion(self, value):
        _lasso.SamlAssertion_minorVersion_set(self._cptr, value)
    minorVersion = property(get_minorVersion, set_minorVersion)

    def get_assertionId(self):
        t = _lasso.SamlAssertion_assertionId_get(self._cptr)
        return t;
    def set_assertionId(self, value):
        value = str2lasso(value)
        _lasso.SamlAssertion_assertionId_set(self._cptr, value)
    assertionId = property(get_assertionId, set_assertionId)

    def get_issuer(self):
        t = _lasso.SamlAssertion_issuer_get(self._cptr)
        return t;
    def set_issuer(self, value):
        value = str2lasso(value)
        _lasso.SamlAssertion_issuer_set(self._cptr, value)
    issuer = property(get_issuer, set_issuer)

    def get_issueInstant(self):
        t = _lasso.SamlAssertion_issueInstant_get(self._cptr)
        return t;
    def set_issueInstant(self, value):
        value = str2lasso(value)
        _lasso.SamlAssertion_issueInstant_set(self._cptr, value)
    issueInstant = property(get_issueInstant, set_issueInstant)

    def get_signType(self):
        t = _lasso.SamlAssertion_signType_get(self._cptr)
        return t;
    def set_signType(self, value):
        _lasso.SamlAssertion_signType_set(self._cptr, value)
    signType = property(get_signType, set_signType)

    def get_signMethod(self):
        t = _lasso.SamlAssertion_signMethod_get(self._cptr)
        return t;
    def set_signMethod(self, value):
        _lasso.SamlAssertion_signMethod_set(self._cptr, value)
    signMethod = property(get_signMethod, set_signMethod)

    def get_privateKeyFile(self):
        t = _lasso.SamlAssertion_privateKeyFile_get(self._cptr)
        return t;
    def set_privateKeyFile(self, value):
        value = str2lasso(value)
        _lasso.SamlAssertion_privateKeyFile_set(self._cptr, value)
    privateKeyFile = property(get_privateKeyFile, set_privateKeyFile)

    def get_certificateFile(self):
        t = _lasso.SamlAssertion_certificateFile_get(self._cptr)
        return t;
    def set_certificateFile(self, value):
        value = str2lasso(value)
        _lasso.SamlAssertion_certificateFile_set(self._cptr, value)
    certificateFile = property(get_certificateFile, set_certificateFile)


class LibAssertion(SamlAssertion):
    def __init__(self, ):
        self._cptr = _lasso.lib_assertion_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, issuer, requestID, audience, notBefore, notOnOrAfter):
         return cptrToPy(_lasso.lib_assertion_new_full(str2lasso(issuer), str2lasso(requestID), str2lasso(audience), str2lasso(notBefore), str2lasso(notOnOrAfter)))

    def get_inResponseTo(self):
        t = _lasso.LibAssertion_inResponseTo_get(self._cptr)
        return t;
    def set_inResponseTo(self, value):
        value = str2lasso(value)
        _lasso.LibAssertion_inResponseTo_set(self._cptr, value)
    inResponseTo = property(get_inResponseTo, set_inResponseTo)


class SamlAttributeDesignator(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_attribute_designator_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_attributeName(self):
        t = _lasso.SamlAttributeDesignator_attributeName_get(self._cptr)
        return t;
    def set_attributeName(self, value):
        value = str2lasso(value)
        _lasso.SamlAttributeDesignator_attributeName_set(self._cptr, value)
    attributeName = property(get_attributeName, set_attributeName)

    def get_attributeNamespace(self):
        t = _lasso.SamlAttributeDesignator_attributeNamespace_get(self._cptr)
        return t;
    def set_attributeNamespace(self, value):
        value = str2lasso(value)
        _lasso.SamlAttributeDesignator_attributeNamespace_set(self._cptr, value)
    attributeNamespace = property(get_attributeNamespace, set_attributeNamespace)


class SamlAttribute(SamlAttributeDesignator):
    def __init__(self, ):
        self._cptr = _lasso.saml_attribute_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_attributeName(self):
        t = _lasso.SamlAttribute_attributeName_get(self._cptr)
        return t;
    def set_attributeName(self, value):
        value = str2lasso(value)
        _lasso.SamlAttribute_attributeName_set(self._cptr, value)
    attributeName = property(get_attributeName, set_attributeName)

    def get_attributeNameSpace(self):
        t = _lasso.SamlAttribute_attributeNameSpace_get(self._cptr)
        return t;
    def set_attributeNameSpace(self, value):
        value = str2lasso(value)
        _lasso.SamlAttribute_attributeNameSpace_set(self._cptr, value)
    attributeNameSpace = property(get_attributeNameSpace, set_attributeNameSpace)

    def get_attributeValue(self):
        t = _lasso.SamlAttribute_attributeValue_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_attributeValue(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SamlAttribute_attributeValue_set(self._cptr, value)
    attributeValue = property(get_attributeValue, set_attributeValue)


class SamlAttributeValue(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_attribute_value_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_any(self):
        t = _lasso.SamlAttributeValue_any_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_any(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SamlAttributeValue_any_set(self._cptr, value)
    any = property(get_any, set_any)


class SamlAuthorityBinding(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_authority_binding_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_authorityKind(self):
        t = _lasso.SamlAuthorityBinding_authorityKind_get(self._cptr)
        return t;
    def set_authorityKind(self, value):
        value = str2lasso(value)
        _lasso.SamlAuthorityBinding_authorityKind_set(self._cptr, value)
    authorityKind = property(get_authorityKind, set_authorityKind)

    def get_location(self):
        t = _lasso.SamlAuthorityBinding_location_get(self._cptr)
        return t;
    def set_location(self, value):
        value = str2lasso(value)
        _lasso.SamlAuthorityBinding_location_set(self._cptr, value)
    location = property(get_location, set_location)

    def get_binding(self):
        t = _lasso.SamlAuthorityBinding_binding_get(self._cptr)
        return t;
    def set_binding(self, value):
        value = str2lasso(value)
        _lasso.SamlAuthorityBinding_binding_set(self._cptr, value)
    binding = property(get_binding, set_binding)


class SamlConditionAbstract(Node):
    pass

class SamlAudienceRestrictionCondition(SamlConditionAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml_audience_restriction_condition_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, audience):
         return cptrToPy(_lasso.saml_audience_restriction_condition_new_full(str2lasso(audience)))

    def get_audience(self):
        t = _lasso.SamlAudienceRestrictionCondition_audience_get(self._cptr)
        return t;
    def set_audience(self, value):
        _lasso.SamlAudienceRestrictionCondition_audience_set(self._cptr, value)
    audience = property(get_audience, set_audience)


class SamlConditions(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_conditions_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_condition(self):
        t = _lasso.SamlConditions_condition_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_condition(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SamlConditions_condition_set(self._cptr, value)
    condition = property(get_condition, set_condition)

    def get_audienceRestrictionCondition(self):
        t = _lasso.SamlConditions_audienceRestrictionCondition_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_audienceRestrictionCondition(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SamlConditions_audienceRestrictionCondition_set(self._cptr, value)
    audienceRestrictionCondition = property(get_audienceRestrictionCondition, set_audienceRestrictionCondition)

    def get_notBefore(self):
        t = _lasso.SamlConditions_notBefore_get(self._cptr)
        return t;
    def set_notBefore(self, value):
        value = str2lasso(value)
        _lasso.SamlConditions_notBefore_set(self._cptr, value)
    notBefore = property(get_notBefore, set_notBefore)

    def get_notOnOrAfter(self):
        t = _lasso.SamlConditions_notOnOrAfter_get(self._cptr)
        return t;
    def set_notOnOrAfter(self, value):
        value = str2lasso(value)
        _lasso.SamlConditions_notOnOrAfter_set(self._cptr, value)
    notOnOrAfter = property(get_notOnOrAfter, set_notOnOrAfter)


class SamlNameIdentifier(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_name_identifier_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromXmlNode(cls, xmlnode):
         return cptrToPy(_lasso.saml_name_identifier_new_from_xmlNode(xmlnode))

    def get_nameQualifier(self):
        t = _lasso.SamlNameIdentifier_nameQualifier_get(self._cptr)
        return t;
    def set_nameQualifier(self, value):
        value = str2lasso(value)
        _lasso.SamlNameIdentifier_nameQualifier_set(self._cptr, value)
    nameQualifier = property(get_nameQualifier, set_nameQualifier)

    def get_format(self):
        t = _lasso.SamlNameIdentifier_format_get(self._cptr)
        return t;
    def set_format(self, value):
        value = str2lasso(value)
        _lasso.SamlNameIdentifier_format_set(self._cptr, value)
    format = property(get_format, set_format)

    def get_content(self):
        t = _lasso.SamlNameIdentifier_content_get(self._cptr)
        return t;
    def set_content(self, value):
        value = str2lasso(value)
        _lasso.SamlNameIdentifier_content_set(self._cptr, value)
    content = property(get_content, set_content)

    def equals(self, b):
        return _lasso.saml_name_identifier_equals(self._cptr, b and b._cptr)


class SamlStatementAbstract(Node):
    pass

class SamlSubject(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_subject_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_nameIdentifier(self):
        t = _lasso.SamlSubject_nameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlSubject_nameIdentifier_set(self._cptr, value)
    nameIdentifier = property(get_nameIdentifier, set_nameIdentifier)

    def get_subjectConfirmation(self):
        t = _lasso.SamlSubject_subjectConfirmation_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subjectConfirmation(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlSubject_subjectConfirmation_set(self._cptr, value)
    subjectConfirmation = property(get_subjectConfirmation, set_subjectConfirmation)

    def get_encryptedNameIdentifier(self):
        t = _lasso.SamlSubject_encryptedNameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_encryptedNameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlSubject_encryptedNameIdentifier_set(self._cptr, value)
    encryptedNameIdentifier = property(get_encryptedNameIdentifier, set_encryptedNameIdentifier)


class LibSubject(SamlSubject):
    def __init__(self, ):
        self._cptr = _lasso.lib_subject_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_idpProvidedNameIdentifier(self):
        t = _lasso.LibSubject_idpProvidedNameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_idpProvidedNameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibSubject_idpProvidedNameIdentifier_set(self._cptr, value)
    idpProvidedNameIdentifier = property(get_idpProvidedNameIdentifier, set_idpProvidedNameIdentifier)
    iDPProvidedNameIdentifier = idpProvidedNameIdentifier


class SamlSubjectConfirmation(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_subject_confirmation_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_confirmationMethod(self):
        t = _lasso.SamlSubjectConfirmation_confirmationMethod_get(self._cptr)
        return t;
    def set_confirmationMethod(self, value):
        _lasso.SamlSubjectConfirmation_confirmationMethod_set(self._cptr, value)
    confirmationMethod = property(get_confirmationMethod, set_confirmationMethod)

    def get_subjectConfirmationData(self):
        t = _lasso.SamlSubjectConfirmation_subjectConfirmationData_get(self._cptr)
        return t;
    def set_subjectConfirmationData(self, value):
        value = str2lasso(value)
        _lasso.SamlSubjectConfirmation_subjectConfirmationData_set(self._cptr, value)
    subjectConfirmationData = property(get_subjectConfirmationData, set_subjectConfirmationData)

    def get_keyInfo(self):
        t = _lasso.SamlSubjectConfirmation_keyInfo_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_keyInfo(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlSubjectConfirmation_keyInfo_set(self._cptr, value)
    keyInfo = property(get_keyInfo, set_keyInfo)


class SamlSubjectLocality(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml_subject_locality_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_ipAddress(self):
        t = _lasso.SamlSubjectLocality_ipAddress_get(self._cptr)
        return t;
    def set_ipAddress(self, value):
        value = str2lasso(value)
        _lasso.SamlSubjectLocality_ipAddress_set(self._cptr, value)
    ipAddress = property(get_ipAddress, set_ipAddress)
    iPAddress = ipAddress

    def get_dnsAddress(self):
        t = _lasso.SamlSubjectLocality_dnsAddress_get(self._cptr)
        return t;
    def set_dnsAddress(self, value):
        value = str2lasso(value)
        _lasso.SamlSubjectLocality_dnsAddress_set(self._cptr, value)
    dnsAddress = property(get_dnsAddress, set_dnsAddress)
    dNSAddress = dnsAddress


class SamlSubjectStatementAbstract(SamlStatementAbstract):
    def get_subject(self):
        t = _lasso.SamlSubjectStatementAbstract_subject_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subject(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlSubjectStatementAbstract_subject_set(self._cptr, value)
    subject = property(get_subject, set_subject)


class SamlAttributeStatement(SamlSubjectStatementAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml_attribute_statement_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_attribute(self):
        t = _lasso.SamlAttributeStatement_attribute_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_attribute(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SamlAttributeStatement_attribute_set(self._cptr, value)
    attribute = property(get_attribute, set_attribute)


class SamlAuthenticationStatement(SamlSubjectStatementAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml_authentication_statement_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_subjectLocality(self):
        t = _lasso.SamlAuthenticationStatement_subjectLocality_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subjectLocality(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlAuthenticationStatement_subjectLocality_set(self._cptr, value)
    subjectLocality = property(get_subjectLocality, set_subjectLocality)

    def get_authorityBinding(self):
        t = _lasso.SamlAuthenticationStatement_authorityBinding_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_authorityBinding(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SamlAuthenticationStatement_authorityBinding_set(self._cptr, value)
    authorityBinding = property(get_authorityBinding, set_authorityBinding)

    def get_authenticationMethod(self):
        t = _lasso.SamlAuthenticationStatement_authenticationMethod_get(self._cptr)
        return t;
    def set_authenticationMethod(self, value):
        value = str2lasso(value)
        _lasso.SamlAuthenticationStatement_authenticationMethod_set(self._cptr, value)
    authenticationMethod = property(get_authenticationMethod, set_authenticationMethod)

    def get_authenticationInstant(self):
        t = _lasso.SamlAuthenticationStatement_authenticationInstant_get(self._cptr)
        return t;
    def set_authenticationInstant(self, value):
        value = str2lasso(value)
        _lasso.SamlAuthenticationStatement_authenticationInstant_set(self._cptr, value)
    authenticationInstant = property(get_authenticationInstant, set_authenticationInstant)


class LibAuthenticationStatement(SamlAuthenticationStatement):
    def __init__(self, ):
        self._cptr = _lasso.lib_authentication_statement_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, authenticationMethod, authenticationInstant, reauthenticateOnOrAfter, sp_identifier, idp_identifier):
         return cptrToPy(_lasso.lib_authentication_statement_new_full(str2lasso(authenticationMethod), str2lasso(authenticationInstant), str2lasso(reauthenticateOnOrAfter), sp_identifier and sp_identifier._cptr, idp_identifier and idp_identifier._cptr))

    def get_authnContext(self):
        t = _lasso.LibAuthenticationStatement_authnContext_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_authnContext(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibAuthenticationStatement_authnContext_set(self._cptr, value)
    authnContext = property(get_authnContext, set_authnContext)

    def get_reauthenticateOnOrAfter(self):
        t = _lasso.LibAuthenticationStatement_reauthenticateOnOrAfter_get(self._cptr)
        return t;
    def set_reauthenticateOnOrAfter(self, value):
        value = str2lasso(value)
        _lasso.LibAuthenticationStatement_reauthenticateOnOrAfter_set(self._cptr, value)
    reauthenticateOnOrAfter = property(get_reauthenticateOnOrAfter, set_reauthenticateOnOrAfter)

    def get_sessionIndex(self):
        t = _lasso.LibAuthenticationStatement_sessionIndex_get(self._cptr)
        return t;
    def set_sessionIndex(self, value):
        value = str2lasso(value)
        _lasso.LibAuthenticationStatement_sessionIndex_set(self._cptr, value)
    sessionIndex = property(get_sessionIndex, set_sessionIndex)


class SamlSubjectStatement(SamlSubjectStatementAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml_subject_statement_new()
        if self._cptr is None:
            raise Error('failed to create object')


class SamlpRequestAbstract(Node):
    def get_respondWith(self):
        t = _lasso.SamlpRequestAbstract_respondWith_get(self._cptr)
        return t;
    def set_respondWith(self, value):
        _lasso.SamlpRequestAbstract_respondWith_set(self._cptr, value)
    respondWith = property(get_respondWith, set_respondWith)

    def get_requestId(self):
        t = _lasso.SamlpRequestAbstract_requestId_get(self._cptr)
        return t;
    def set_requestId(self, value):
        value = str2lasso(value)
        _lasso.SamlpRequestAbstract_requestId_set(self._cptr, value)
    requestId = property(get_requestId, set_requestId)

    def get_majorVersion(self):
        t = _lasso.SamlpRequestAbstract_majorVersion_get(self._cptr)
        return t;
    def set_majorVersion(self, value):
        _lasso.SamlpRequestAbstract_majorVersion_set(self._cptr, value)
    majorVersion = property(get_majorVersion, set_majorVersion)

    def get_minorVersion(self):
        t = _lasso.SamlpRequestAbstract_minorVersion_get(self._cptr)
        return t;
    def set_minorVersion(self, value):
        _lasso.SamlpRequestAbstract_minorVersion_set(self._cptr, value)
    minorVersion = property(get_minorVersion, set_minorVersion)

    def get_issueInstant(self):
        t = _lasso.SamlpRequestAbstract_issueInstant_get(self._cptr)
        return t;
    def set_issueInstant(self, value):
        value = str2lasso(value)
        _lasso.SamlpRequestAbstract_issueInstant_set(self._cptr, value)
    issueInstant = property(get_issueInstant, set_issueInstant)

    def get_signType(self):
        t = _lasso.SamlpRequestAbstract_signType_get(self._cptr)
        return t;
    def set_signType(self, value):
        _lasso.SamlpRequestAbstract_signType_set(self._cptr, value)
    signType = property(get_signType, set_signType)

    def get_signMethod(self):
        t = _lasso.SamlpRequestAbstract_signMethod_get(self._cptr)
        return t;
    def set_signMethod(self, value):
        _lasso.SamlpRequestAbstract_signMethod_set(self._cptr, value)
    signMethod = property(get_signMethod, set_signMethod)

    def get_privateKeyFile(self):
        t = _lasso.SamlpRequestAbstract_privateKeyFile_get(self._cptr)
        return t;
    def set_privateKeyFile(self, value):
        value = str2lasso(value)
        _lasso.SamlpRequestAbstract_privateKeyFile_set(self._cptr, value)
    privateKeyFile = property(get_privateKeyFile, set_privateKeyFile)

    def get_certificateFile(self):
        t = _lasso.SamlpRequestAbstract_certificateFile_get(self._cptr)
        return t;
    def set_certificateFile(self, value):
        value = str2lasso(value)
        _lasso.SamlpRequestAbstract_certificateFile_set(self._cptr, value)
    certificateFile = property(get_certificateFile, set_certificateFile)


class LibAuthnRequest(SamlpRequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.lib_authn_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_extension(self):
        t = _lasso.LibAuthnRequest_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibAuthnRequest_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_providerId(self):
        t = _lasso.LibAuthnRequest_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequest_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_affiliationId(self):
        t = _lasso.LibAuthnRequest_affiliationId_get(self._cptr)
        return t;
    def set_affiliationId(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequest_affiliationId_set(self._cptr, value)
    affiliationId = property(get_affiliationId, set_affiliationId)

    def get_nameIdPolicy(self):
        t = _lasso.LibAuthnRequest_nameIdPolicy_get(self._cptr)
        return t;
    def set_nameIdPolicy(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequest_nameIdPolicy_set(self._cptr, value)
    nameIdPolicy = property(get_nameIdPolicy, set_nameIdPolicy)

    def get_forceAuthn(self):
        t = _lasso.LibAuthnRequest_forceAuthn_get(self._cptr)
        return t;
    def set_forceAuthn(self, value):
        _lasso.LibAuthnRequest_forceAuthn_set(self._cptr, value)
    forceAuthn = property(get_forceAuthn, set_forceAuthn)

    def get_isPassive(self):
        t = _lasso.LibAuthnRequest_isPassive_get(self._cptr)
        return t;
    def set_isPassive(self, value):
        _lasso.LibAuthnRequest_isPassive_set(self._cptr, value)
    isPassive = property(get_isPassive, set_isPassive)

    def get_protocolProfile(self):
        t = _lasso.LibAuthnRequest_protocolProfile_get(self._cptr)
        return t;
    def set_protocolProfile(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequest_protocolProfile_set(self._cptr, value)
    protocolProfile = property(get_protocolProfile, set_protocolProfile)

    def get_assertionConsumerServiceId(self):
        t = _lasso.LibAuthnRequest_assertionConsumerServiceId_get(self._cptr)
        return t;
    def set_assertionConsumerServiceId(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequest_assertionConsumerServiceId_set(self._cptr, value)
    assertionConsumerServiceId = property(get_assertionConsumerServiceId, set_assertionConsumerServiceId)

    def get_requestAuthnContext(self):
        t = _lasso.LibAuthnRequest_requestAuthnContext_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_requestAuthnContext(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibAuthnRequest_requestAuthnContext_set(self._cptr, value)
    requestAuthnContext = property(get_requestAuthnContext, set_requestAuthnContext)

    def get_relayState(self):
        t = _lasso.LibAuthnRequest_relayState_get(self._cptr)
        return t;
    def set_relayState(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequest_relayState_set(self._cptr, value)
    relayState = property(get_relayState, set_relayState)

    def get_scoping(self):
        t = _lasso.LibAuthnRequest_scoping_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_scoping(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibAuthnRequest_scoping_set(self._cptr, value)
    scoping = property(get_scoping, set_scoping)

    def get_consent(self):
        t = _lasso.LibAuthnRequest_consent_get(self._cptr)
        return t;
    def set_consent(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnRequest_consent_set(self._cptr, value)
    consent = property(get_consent, set_consent)


class LibFederationTerminationNotification(SamlpRequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.lib_federation_termination_notification_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, providerID, nameIdentifier, sign_type, sign_method):
         return cptrToPy(_lasso.lib_federation_termination_notification_new_full(str2lasso(providerID), nameIdentifier and nameIdentifier._cptr, sign_type, sign_method))

    def get_extension(self):
        t = _lasso.LibFederationTerminationNotification_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibFederationTerminationNotification_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_providerId(self):
        t = _lasso.LibFederationTerminationNotification_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibFederationTerminationNotification_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_nameIdentifier(self):
        t = _lasso.LibFederationTerminationNotification_nameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibFederationTerminationNotification_nameIdentifier_set(self._cptr, value)
    nameIdentifier = property(get_nameIdentifier, set_nameIdentifier)

    def get_consent(self):
        t = _lasso.LibFederationTerminationNotification_consent_get(self._cptr)
        return t;
    def set_consent(self, value):
        value = str2lasso(value)
        _lasso.LibFederationTerminationNotification_consent_set(self._cptr, value)
    consent = property(get_consent, set_consent)

    def get_relayState(self):
        t = _lasso.LibFederationTerminationNotification_relayState_get(self._cptr)
        return t;
    def set_relayState(self, value):
        value = str2lasso(value)
        _lasso.LibFederationTerminationNotification_relayState_set(self._cptr, value)
    relayState = property(get_relayState, set_relayState)


class LibLogoutRequest(SamlpRequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.lib_logout_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, providerID, nameIdentifier, sign_type, sign_method):
         return cptrToPy(_lasso.lib_logout_request_new_full(str2lasso(providerID), nameIdentifier and nameIdentifier._cptr, sign_type, sign_method))

    def get_extension(self):
        t = _lasso.LibLogoutRequest_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibLogoutRequest_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_providerId(self):
        t = _lasso.LibLogoutRequest_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibLogoutRequest_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_nameIdentifier(self):
        t = _lasso.LibLogoutRequest_nameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibLogoutRequest_nameIdentifier_set(self._cptr, value)
    nameIdentifier = property(get_nameIdentifier, set_nameIdentifier)

    def get_sessionIndex(self):
        t = _lasso.LibLogoutRequest_sessionIndex_get(self._cptr)
        return t;
    def set_sessionIndex(self, value):
        value = str2lasso(value)
        _lasso.LibLogoutRequest_sessionIndex_set(self._cptr, value)
    sessionIndex = property(get_sessionIndex, set_sessionIndex)

    def get_relayState(self):
        t = _lasso.LibLogoutRequest_relayState_get(self._cptr)
        return t;
    def set_relayState(self, value):
        value = str2lasso(value)
        _lasso.LibLogoutRequest_relayState_set(self._cptr, value)
    relayState = property(get_relayState, set_relayState)

    def get_consent(self):
        t = _lasso.LibLogoutRequest_consent_get(self._cptr)
        return t;
    def set_consent(self, value):
        value = str2lasso(value)
        _lasso.LibLogoutRequest_consent_set(self._cptr, value)
    consent = property(get_consent, set_consent)

    def get_notOnOrAfter(self):
        t = _lasso.LibLogoutRequest_notOnOrAfter_get(self._cptr)
        return t;
    def set_notOnOrAfter(self, value):
        value = str2lasso(value)
        _lasso.LibLogoutRequest_notOnOrAfter_set(self._cptr, value)
    notOnOrAfter = property(get_notOnOrAfter, set_notOnOrAfter)

    def setSessionIndexes(self, session_indexes):
        '''
        Set the SessionIndex node for this idff:LogoutRequest.
        
        @param session_indexes:  a list of session indexes
        '''
        _lasso.lib_logout_request_set_session_indexes(self._cptr, session_indexes)

    def getSessionIndexes(self):
        '''
        Get the SessionIndex node for this idff:LogoutRequest.
        
        @return: a list of strings
        '''
        return _lasso.lib_logout_request_get_session_indexes(self._cptr)

    sessionIndexes = property(getSessionIndexes, setSessionIndexes)

class LibNameIdentifierMappingRequest(SamlpRequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.lib_name_identifier_mapping_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, providerID, nameIdentifier, targetNamespace, sign_type, sign_method):
         return cptrToPy(_lasso.lib_name_identifier_mapping_request_new_full(str2lasso(providerID), nameIdentifier and nameIdentifier._cptr, str2lasso(targetNamespace), sign_type, sign_method))

    def get_extension(self):
        t = _lasso.LibNameIdentifierMappingRequest_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibNameIdentifierMappingRequest_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_providerId(self):
        t = _lasso.LibNameIdentifierMappingRequest_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibNameIdentifierMappingRequest_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_nameIdentifier(self):
        t = _lasso.LibNameIdentifierMappingRequest_nameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibNameIdentifierMappingRequest_nameIdentifier_set(self._cptr, value)
    nameIdentifier = property(get_nameIdentifier, set_nameIdentifier)

    def get_targetNamespace(self):
        t = _lasso.LibNameIdentifierMappingRequest_targetNamespace_get(self._cptr)
        return t;
    def set_targetNamespace(self, value):
        value = str2lasso(value)
        _lasso.LibNameIdentifierMappingRequest_targetNamespace_set(self._cptr, value)
    targetNamespace = property(get_targetNamespace, set_targetNamespace)

    def get_consent(self):
        t = _lasso.LibNameIdentifierMappingRequest_consent_get(self._cptr)
        return t;
    def set_consent(self, value):
        value = str2lasso(value)
        _lasso.LibNameIdentifierMappingRequest_consent_set(self._cptr, value)
    consent = property(get_consent, set_consent)


class LibRegisterNameIdentifierRequest(SamlpRequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.lib_register_name_identifier_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, providerID, idpNameIdentifier, spNameIdentifier, oldNameIdentifier, sign_type, sign_method):
         return cptrToPy(_lasso.lib_register_name_identifier_request_new_full(str2lasso(providerID), idpNameIdentifier and idpNameIdentifier._cptr, spNameIdentifier and spNameIdentifier._cptr, oldNameIdentifier and oldNameIdentifier._cptr, sign_type, sign_method))

    def get_extension(self):
        t = _lasso.LibRegisterNameIdentifierRequest_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibRegisterNameIdentifierRequest_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_providerId(self):
        t = _lasso.LibRegisterNameIdentifierRequest_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibRegisterNameIdentifierRequest_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_idpProvidedNameIdentifier(self):
        t = _lasso.LibRegisterNameIdentifierRequest_idpProvidedNameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_idpProvidedNameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibRegisterNameIdentifierRequest_idpProvidedNameIdentifier_set(self._cptr, value)
    idpProvidedNameIdentifier = property(get_idpProvidedNameIdentifier, set_idpProvidedNameIdentifier)
    iDPProvidedNameIdentifier = idpProvidedNameIdentifier

    def get_spProvidedNameIdentifier(self):
        t = _lasso.LibRegisterNameIdentifierRequest_spProvidedNameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_spProvidedNameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibRegisterNameIdentifierRequest_spProvidedNameIdentifier_set(self._cptr, value)
    spProvidedNameIdentifier = property(get_spProvidedNameIdentifier, set_spProvidedNameIdentifier)
    sPProvidedNameIdentifier = spProvidedNameIdentifier

    def get_oldProvidedNameIdentifier(self):
        t = _lasso.LibRegisterNameIdentifierRequest_oldProvidedNameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_oldProvidedNameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibRegisterNameIdentifierRequest_oldProvidedNameIdentifier_set(self._cptr, value)
    oldProvidedNameIdentifier = property(get_oldProvidedNameIdentifier, set_oldProvidedNameIdentifier)

    def get_relayState(self):
        t = _lasso.LibRegisterNameIdentifierRequest_relayState_get(self._cptr)
        return t;
    def set_relayState(self, value):
        value = str2lasso(value)
        _lasso.LibRegisterNameIdentifierRequest_relayState_set(self._cptr, value)
    relayState = property(get_relayState, set_relayState)


class SamlpRequest(SamlpRequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_assertionArtifact(self):
        t = _lasso.SamlpRequest_assertionArtifact_get(self._cptr)
        return t;
    def set_assertionArtifact(self, value):
        value = str2lasso(value)
        _lasso.SamlpRequest_assertionArtifact_set(self._cptr, value)
    assertionArtifact = property(get_assertionArtifact, set_assertionArtifact)


class SamlpResponseAbstract(Node):
    def get_responseId(self):
        t = _lasso.SamlpResponseAbstract_responseId_get(self._cptr)
        return t;
    def set_responseId(self, value):
        value = str2lasso(value)
        _lasso.SamlpResponseAbstract_responseId_set(self._cptr, value)
    responseId = property(get_responseId, set_responseId)

    def get_inResponseTo(self):
        t = _lasso.SamlpResponseAbstract_inResponseTo_get(self._cptr)
        return t;
    def set_inResponseTo(self, value):
        value = str2lasso(value)
        _lasso.SamlpResponseAbstract_inResponseTo_set(self._cptr, value)
    inResponseTo = property(get_inResponseTo, set_inResponseTo)

    def get_majorVersion(self):
        t = _lasso.SamlpResponseAbstract_majorVersion_get(self._cptr)
        return t;
    def set_majorVersion(self, value):
        _lasso.SamlpResponseAbstract_majorVersion_set(self._cptr, value)
    majorVersion = property(get_majorVersion, set_majorVersion)

    def get_minorVersion(self):
        t = _lasso.SamlpResponseAbstract_minorVersion_get(self._cptr)
        return t;
    def set_minorVersion(self, value):
        _lasso.SamlpResponseAbstract_minorVersion_set(self._cptr, value)
    minorVersion = property(get_minorVersion, set_minorVersion)

    def get_issueInstant(self):
        t = _lasso.SamlpResponseAbstract_issueInstant_get(self._cptr)
        return t;
    def set_issueInstant(self, value):
        value = str2lasso(value)
        _lasso.SamlpResponseAbstract_issueInstant_set(self._cptr, value)
    issueInstant = property(get_issueInstant, set_issueInstant)

    def get_recipient(self):
        t = _lasso.SamlpResponseAbstract_recipient_get(self._cptr)
        return t;
    def set_recipient(self, value):
        value = str2lasso(value)
        _lasso.SamlpResponseAbstract_recipient_set(self._cptr, value)
    recipient = property(get_recipient, set_recipient)

    def get_signType(self):
        t = _lasso.SamlpResponseAbstract_signType_get(self._cptr)
        return t;
    def set_signType(self, value):
        _lasso.SamlpResponseAbstract_signType_set(self._cptr, value)
    signType = property(get_signType, set_signType)

    def get_signMethod(self):
        t = _lasso.SamlpResponseAbstract_signMethod_get(self._cptr)
        return t;
    def set_signMethod(self, value):
        _lasso.SamlpResponseAbstract_signMethod_set(self._cptr, value)
    signMethod = property(get_signMethod, set_signMethod)

    def get_privateKeyFile(self):
        t = _lasso.SamlpResponseAbstract_privateKeyFile_get(self._cptr)
        return t;
    def set_privateKeyFile(self, value):
        value = str2lasso(value)
        _lasso.SamlpResponseAbstract_privateKeyFile_set(self._cptr, value)
    privateKeyFile = property(get_privateKeyFile, set_privateKeyFile)

    def get_certificateFile(self):
        t = _lasso.SamlpResponseAbstract_certificateFile_get(self._cptr)
        return t;
    def set_certificateFile(self, value):
        value = str2lasso(value)
        _lasso.SamlpResponseAbstract_certificateFile_set(self._cptr, value)
    certificateFile = property(get_certificateFile, set_certificateFile)

    def fill(self, InResponseTo, Recipient):
        _lasso.samlp_response_abstract_fill(self._cptr, str2lasso(InResponseTo), str2lasso(Recipient))


class LibNameIdentifierMappingResponse(SamlpResponseAbstract):
    def __init__(self, ):
        self._cptr = _lasso.lib_name_identifier_mapping_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, provideRID, statusCodeValue, request, sign_type, sign_method):
         return cptrToPy(_lasso.lib_name_identifier_mapping_response_new_full(str2lasso(provideRID), str2lasso(statusCodeValue), request and request._cptr, sign_type, sign_method))

    def get_extension(self):
        t = _lasso.LibNameIdentifierMappingResponse_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibNameIdentifierMappingResponse_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_providerId(self):
        t = _lasso.LibNameIdentifierMappingResponse_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibNameIdentifierMappingResponse_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_status(self):
        t = _lasso.LibNameIdentifierMappingResponse_status_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_status(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibNameIdentifierMappingResponse_status_set(self._cptr, value)
    status = property(get_status, set_status)

    def get_nameIdentifier(self):
        t = _lasso.LibNameIdentifierMappingResponse_nameIdentifier_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameIdentifier(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibNameIdentifierMappingResponse_nameIdentifier_set(self._cptr, value)
    nameIdentifier = property(get_nameIdentifier, set_nameIdentifier)


class LibStatusResponse(SamlpResponseAbstract):
    def __init__(self, ):
        self._cptr = _lasso.lib_status_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_extension(self):
        t = _lasso.LibStatusResponse_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibStatusResponse_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_providerId(self):
        t = _lasso.LibStatusResponse_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibStatusResponse_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_status(self):
        t = _lasso.LibStatusResponse_status_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_status(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.LibStatusResponse_status_set(self._cptr, value)
    status = property(get_status, set_status)

    def get_relayState(self):
        t = _lasso.LibStatusResponse_relayState_get(self._cptr)
        return t;
    def set_relayState(self, value):
        value = str2lasso(value)
        _lasso.LibStatusResponse_relayState_set(self._cptr, value)
    relayState = property(get_relayState, set_relayState)


class LibLogoutResponse(LibStatusResponse):
    def __init__(self, ):
        self._cptr = _lasso.lib_logout_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, providerID, statusCodeValue, request, sign_type, sign_method):
         return cptrToPy(_lasso.lib_logout_response_new_full(str2lasso(providerID), str2lasso(statusCodeValue), request and request._cptr, sign_type, sign_method))


class LibRegisterNameIdentifierResponse(LibStatusResponse):
    def __init__(self, ):
        self._cptr = _lasso.lib_register_name_identifier_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFull(cls, providerID, statusCodeValue, request, sign_type, sign_method):
         return cptrToPy(_lasso.lib_register_name_identifier_response_new_full(str2lasso(providerID), str2lasso(statusCodeValue), request and request._cptr, sign_type, sign_method))


class SamlpResponse(SamlpResponseAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_status(self):
        t = _lasso.SamlpResponse_status_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_status(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlpResponse_status_set(self._cptr, value)
    status = property(get_status, set_status)

    def get_assertion(self):
        t = _lasso.SamlpResponse_assertion_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertion(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SamlpResponse_assertion_set(self._cptr, value)
    assertion = property(get_assertion, set_assertion)


class LibAuthnResponse(SamlpResponse):
    def __init__(self, providerID, request):
        self._cptr = _lasso.lib_authn_response_new(str2lasso(providerID), request and request._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    def get_extension(self):
        t = _lasso.LibAuthnResponse_extension_get(self._cptr)
        return t;
    def set_extension(self, value):
        _lasso.LibAuthnResponse_extension_set(self._cptr, value)
    extension = property(get_extension, set_extension)

    def get_providerId(self):
        t = _lasso.LibAuthnResponse_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnResponse_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_relayState(self):
        t = _lasso.LibAuthnResponse_relayState_get(self._cptr)
        return t;
    def set_relayState(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnResponse_relayState_set(self._cptr, value)
    relayState = property(get_relayState, set_relayState)

    def get_consent(self):
        t = _lasso.LibAuthnResponse_consent_get(self._cptr)
        return t;
    def set_consent(self, value):
        value = str2lasso(value)
        _lasso.LibAuthnResponse_consent_set(self._cptr, value)
    consent = property(get_consent, set_consent)


class SamlpStatus(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp_status_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_statusCode(self):
        t = _lasso.SamlpStatus_statusCode_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_statusCode(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlpStatus_statusCode_set(self._cptr, value)
    statusCode = property(get_statusCode, set_statusCode)

    def get_statusMessage(self):
        t = _lasso.SamlpStatus_statusMessage_get(self._cptr)
        return t;
    def set_statusMessage(self, value):
        value = str2lasso(value)
        _lasso.SamlpStatus_statusMessage_set(self._cptr, value)
    statusMessage = property(get_statusMessage, set_statusMessage)


class SamlpStatusCode(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp_status_code_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_statusCode(self):
        t = _lasso.SamlpStatusCode_statusCode_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_statusCode(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SamlpStatusCode_statusCode_set(self._cptr, value)
    statusCode = property(get_statusCode, set_statusCode)

    def get_value(self):
        t = _lasso.SamlpStatusCode_value_get(self._cptr)
        return t;
    def set_value(self, value):
        value = str2lasso(value)
        _lasso.SamlpStatusCode_value_set(self._cptr, value)
    value = property(get_value, set_value)


class DsKeyInfo(Node):
    def __init__(self, ):
        self._cptr = _lasso.ds_key_info_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_keyValue(self):
        t = _lasso.DsKeyInfo_keyValue_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_keyValue(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.DsKeyInfo_keyValue_set(self._cptr, value)
    keyValue = property(get_keyValue, set_keyValue)


class DsKeyValue(Node):
    def __init__(self, ):
        self._cptr = _lasso.ds_key_value_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_rsaKeyValue(self):
        t = _lasso.DsKeyValue_rsaKeyValue_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_rsaKeyValue(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.DsKeyValue_rsaKeyValue_set(self._cptr, value)
    rsaKeyValue = property(get_rsaKeyValue, set_rsaKeyValue)
    rSAKeyValue = rsaKeyValue

    def getX509Data(self):
        '''
        Get the X509 Data node if there is one.
        
        @return: the internal value of the X509Data field
        '''
        return cptrToPy(_lasso.ds_key_value_get_x509_data(self._cptr))

    def setX509Data(self, x509_data):
        '''
        Set the X509 Data node.
        '''
        _lasso.ds_key_value_set_x509_data(self._cptr, x509_data and x509_data._cptr)

    x509Data = property(getX509Data, setX509Data)

class DsRsaKeyValue(Node):
    def __init__(self, ):
        self._cptr = _lasso.ds_rsa_key_value_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_modulus(self):
        t = _lasso.DsRsaKeyValue_modulus_get(self._cptr)
        return t;
    def set_modulus(self, value):
        value = str2lasso(value)
        _lasso.DsRsaKeyValue_modulus_set(self._cptr, value)
    modulus = property(get_modulus, set_modulus)

    def get_exponent(self):
        t = _lasso.DsRsaKeyValue_exponent_get(self._cptr)
        return t;
    def set_exponent(self, value):
        value = str2lasso(value)
        _lasso.DsRsaKeyValue_exponent_set(self._cptr, value)
    exponent = property(get_exponent, set_exponent)


class DsX509Data(Node):
    def __init__(self, ):
        self._cptr = _lasso.ds_x509_data_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def getCertificate(self):
        '''
        Return the content of the X509Certificate sub-element, it should be a
        base64 encoded string.
        
        @return: the string currently set in the X509Certificate private field
            of the L{DsX509Data} structure.
        '''
        return _lasso.ds_x509_data_get_certificate(self._cptr)

    def setCertificate(self, certificate):
        '''
        Set the content of the X509Certificate sub-element, it should be a
        base64 encoded string.
        
        @param certificate:  a base64 encoded string of the DER representation
            of the X509 certificate
        '''
        _lasso.ds_x509_data_set_certificate(self._cptr, str2lasso(certificate))

    def getSubjectName(self):
        '''
        Return the content of the X509SubjectName sub-element, it should be a
        base64 encoded string.
        
        @return: the string currently set in the X509SubjectName private field
            of the L{DsX509Data} structure.
        '''
        return _lasso.ds_x509_data_get_subject_name(self._cptr)

    def setSubjectName(self, subject_name):
        '''
        Set the content of the X509SubjectName sub-element, it should be a
        base64 encoded string.
        
        @param subject_name:  a base64 encoded string of the DER
            representation of the X509 subject_name
        '''
        _lasso.ds_x509_data_set_subject_name(self._cptr, str2lasso(subject_name))

    def getCrl(self):
        '''
        Return the content of the X509CRL sub-element, it should be a base64
        encoded string.
        
        @return: the string currently set in the X509CRL private field of the
            L{DsX509Data} structure.
        '''
        return _lasso.ds_x509_data_get_crl(self._cptr)

    def setCrl(self, crl):
        '''
        Set the content of the X509CRL sub-element, it should be a base64
        encoded string.
        
        @param crl:  a base64 encoded string of the DER representation of the
            X509 CRL
        '''
        _lasso.ds_x509_data_set_crl(self._cptr, str2lasso(crl))

    certificate = property(getCertificate, setCertificate)
    subjectName = property(getSubjectName, setSubjectName)
    crl = property(getCrl, setCrl)

class EcpRelayState(Node):
    def __init__(self, RelayState = None):
        self._cptr = _lasso.ecp_relay_state_new(str2lasso(RelayState))
        if self._cptr is None:
            raise Error('failed to create object')

    def get_relayState(self):
        t = _lasso.EcpRelayState_relayState_get(self._cptr)
        return t;
    def set_relayState(self, value):
        value = str2lasso(value)
        _lasso.EcpRelayState_relayState_set(self._cptr, value)
    relayState = property(get_relayState, set_relayState)

    def get_mustUnderstand(self):
        t = _lasso.EcpRelayState_mustUnderstand_get(self._cptr)
        return t;
    def set_mustUnderstand(self, value):
        _lasso.EcpRelayState_mustUnderstand_set(self._cptr, value)
    mustUnderstand = property(get_mustUnderstand, set_mustUnderstand)

    def get_actor(self):
        t = _lasso.EcpRelayState_actor_get(self._cptr)
        return t;
    def set_actor(self, value):
        value = str2lasso(value)
        _lasso.EcpRelayState_actor_set(self._cptr, value)
    actor = property(get_actor, set_actor)

    def validate(self):
        '''
        Validates the L{EcpRelayState} object conforms to required values.
        
         - <listitem>RelayState must be non-None</listitem>
           <listitem>mustUnderstand must be TRUE</listitem>   <listitem>actor
           must be equal to #LASSO_SOAP_ENV_ACTOR</listitem>
        
        Returns: 0 on success, error code otherwise
        '''
        return _lasso.ecp_relay_state_validate(self._cptr)


class EcpRequest(Node):
    def __init__(self, Issuer, IsPassive, ProviderName, IDPList = None):
        self._cptr = _lasso.ecp_request_new(str2lasso(Issuer), IsPassive, str2lasso(ProviderName), IDPList and IDPList._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    def get_issuer(self):
        t = _lasso.EcpRequest_issuer_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_issuer(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.EcpRequest_issuer_set(self._cptr, value)
    issuer = property(get_issuer, set_issuer)

    def get_idpList(self):
        t = _lasso.EcpRequest_idpList_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_idpList(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.EcpRequest_idpList_set(self._cptr, value)
    idpList = property(get_idpList, set_idpList)
    iDPList = idpList

    def get_mustUnderstand(self):
        t = _lasso.EcpRequest_mustUnderstand_get(self._cptr)
        return t;
    def set_mustUnderstand(self, value):
        _lasso.EcpRequest_mustUnderstand_set(self._cptr, value)
    mustUnderstand = property(get_mustUnderstand, set_mustUnderstand)

    def get_actor(self):
        t = _lasso.EcpRequest_actor_get(self._cptr)
        return t;
    def set_actor(self, value):
        value = str2lasso(value)
        _lasso.EcpRequest_actor_set(self._cptr, value)
    actor = property(get_actor, set_actor)

    def get_providerName(self):
        t = _lasso.EcpRequest_providerName_get(self._cptr)
        return t;
    def set_providerName(self, value):
        value = str2lasso(value)
        _lasso.EcpRequest_providerName_set(self._cptr, value)
    providerName = property(get_providerName, set_providerName)

    def get_isPassive(self):
        t = _lasso.EcpRequest_isPassive_get(self._cptr)
        return t;
    def set_isPassive(self, value):
        _lasso.EcpRequest_isPassive_set(self._cptr, value)
    isPassive = property(get_isPassive, set_isPassive)

    def validate(self):
        '''
        Validates the L{EcpRequest} object conforms to required values.
        
         - <listitem>mustUnderstand must be TRUE</listitem>   <listitem>actor
           must be equal to #LASSO_SOAP_ENV_ACTOR</listitem>
        
        Returns: 0 on success, error code otherwise
        '''
        return _lasso.ecp_request_validate(self._cptr)


class EcpResponse(Node):
    def __init__(self, AssertionConsumerServiceURL = None):
        self._cptr = _lasso.ecp_response_new(str2lasso(AssertionConsumerServiceURL))
        if self._cptr is None:
            raise Error('failed to create object')

    def get_mustUnderstand(self):
        t = _lasso.EcpResponse_mustUnderstand_get(self._cptr)
        return t;
    def set_mustUnderstand(self, value):
        _lasso.EcpResponse_mustUnderstand_set(self._cptr, value)
    mustUnderstand = property(get_mustUnderstand, set_mustUnderstand)

    def get_actor(self):
        t = _lasso.EcpResponse_actor_get(self._cptr)
        return t;
    def set_actor(self, value):
        value = str2lasso(value)
        _lasso.EcpResponse_actor_set(self._cptr, value)
    actor = property(get_actor, set_actor)

    def get_assertionConsumerServiceUrl(self):
        t = _lasso.EcpResponse_assertionConsumerServiceUrl_get(self._cptr)
        return t;
    def set_assertionConsumerServiceUrl(self, value):
        value = str2lasso(value)
        _lasso.EcpResponse_assertionConsumerServiceUrl_set(self._cptr, value)
    assertionConsumerServiceUrl = property(get_assertionConsumerServiceUrl, set_assertionConsumerServiceUrl)
    assertionConsumerServiceURL = assertionConsumerServiceUrl

    def validate(self):
        '''
        Validates the L{EcpResponse} object conforms to required values.
        
         - <listitem>AssertionConsumerServiceURL must be non-None</listitem>
           <listitem>mustUnderstand must be TRUE</listitem>   <listitem>actor
           must be equal to #LASSO_SOAP_ENV_ACTOR</listitem>
        
        Returns: 0 on success, error code otherwise
        '''
        return _lasso.ecp_response_validate(self._cptr)


class Saml2Action(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_action_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newWithString(cls, content):
         return cptrToPy(_lasso.saml2_action_new_with_string(str2lasso(content)))

    def get_content(self):
        t = _lasso.Saml2Action_content_get(self._cptr)
        return t;
    def set_content(self, value):
        value = str2lasso(value)
        _lasso.Saml2Action_content_set(self._cptr, value)
    content = property(get_content, set_content)

    def get_namespace(self):
        t = _lasso.Saml2Action_namespace_get(self._cptr)
        return t;
    def set_namespace(self, value):
        value = str2lasso(value)
        _lasso.Saml2Action_namespace_set(self._cptr, value)
    namespace = property(get_namespace, set_namespace)


class Saml2Advice(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_advice_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_assertionIdRef(self):
        t = _lasso.Saml2Advice_assertionIdRef_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertionIdRef(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Advice_assertionIdRef_set(self._cptr, value)
    assertionIdRef = property(get_assertionIdRef, set_assertionIdRef)

    def get_assertionUriRef(self):
        t = _lasso.Saml2Advice_assertionUriRef_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertionUriRef(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Advice_assertionUriRef_set(self._cptr, value)
    assertionUriRef = property(get_assertionUriRef, set_assertionUriRef)
    assertionURIRef = assertionUriRef

    def get_assertion(self):
        t = _lasso.Saml2Advice_assertion_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertion(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Advice_assertion_set(self._cptr, value)
    assertion = property(get_assertion, set_assertion)

    def get_encryptedAssertion(self):
        t = _lasso.Saml2Advice_encryptedAssertion_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_encryptedAssertion(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Advice_encryptedAssertion_set(self._cptr, value)
    encryptedAssertion = property(get_encryptedAssertion, set_encryptedAssertion)


class Saml2Assertion(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_assertion_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_issuer(self):
        t = _lasso.Saml2Assertion_issuer_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_issuer(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2Assertion_issuer_set(self._cptr, value)
    issuer = property(get_issuer, set_issuer)

    def get_subject(self):
        t = _lasso.Saml2Assertion_subject_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subject(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2Assertion_subject_set(self._cptr, value)
    subject = property(get_subject, set_subject)

    def get_conditions(self):
        t = _lasso.Saml2Assertion_conditions_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_conditions(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2Assertion_conditions_set(self._cptr, value)
    conditions = property(get_conditions, set_conditions)

    def get_advice(self):
        t = _lasso.Saml2Assertion_advice_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_advice(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2Assertion_advice_set(self._cptr, value)
    advice = property(get_advice, set_advice)

    def get_statement(self):
        t = _lasso.Saml2Assertion_statement_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_statement(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Assertion_statement_set(self._cptr, value)
    statement = property(get_statement, set_statement)

    def get_authnStatement(self):
        t = _lasso.Saml2Assertion_authnStatement_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_authnStatement(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Assertion_authnStatement_set(self._cptr, value)
    authnStatement = property(get_authnStatement, set_authnStatement)

    def get_authzDecisionStatement(self):
        t = _lasso.Saml2Assertion_authzDecisionStatement_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_authzDecisionStatement(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Assertion_authzDecisionStatement_set(self._cptr, value)
    authzDecisionStatement = property(get_authzDecisionStatement, set_authzDecisionStatement)

    def get_attributeStatement(self):
        t = _lasso.Saml2Assertion_attributeStatement_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_attributeStatement(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Assertion_attributeStatement_set(self._cptr, value)
    attributeStatement = property(get_attributeStatement, set_attributeStatement)

    def get_version(self):
        t = _lasso.Saml2Assertion_version_get(self._cptr)
        return t;
    def set_version(self, value):
        value = str2lasso(value)
        _lasso.Saml2Assertion_version_set(self._cptr, value)
    version = property(get_version, set_version)

    def get_id(self):
        t = _lasso.Saml2Assertion_id_get(self._cptr)
        return t;
    def set_id(self, value):
        value = str2lasso(value)
        _lasso.Saml2Assertion_id_set(self._cptr, value)
    id = property(get_id, set_id)
    iD = id

    def get_issueInstant(self):
        t = _lasso.Saml2Assertion_issueInstant_get(self._cptr)
        return t;
    def set_issueInstant(self, value):
        value = str2lasso(value)
        _lasso.Saml2Assertion_issueInstant_set(self._cptr, value)
    issueInstant = property(get_issueInstant, set_issueInstant)

    def hasAudienceRestriction(self):
        '''
        Verify that a L{Saml2AudienceRestriction} is present in the assertion.
        
        @return: TRUE if a L{Saml2AudienceRestriction} is present in the
            Conditions of the L{Saml2Assertion}.
        '''
        return _lasso.saml2_assertion_has_audience_restriction(self._cptr)

    def isAudienceRestricted(self, providerID):
        '''
        Verify that the assertion is restricted to the given providerID.
        
        @param providerID:  the providerID that will be compared to the
            audience restriction declarations.
        @return: TRUE if C{providerID} is part of a
            L{Saml2AudienceRestriction} element in the assertion, FALSE
            otherwise.
        '''
        return _lasso.saml2_assertion_is_audience_restricted(self._cptr, str2lasso(providerID))

    def setSubjectNameId(self, node):
        '''
        Set the subject NameID, which can be a simple L{Saml2NameID} object or
        an encrypted L{Saml2NameID} as a L{Saml2EncryptedElement}.
        
        @param node:  a L{Saml2NameID} or L{Saml2EncryptedElement}
        '''
        _lasso.saml2_assertion_set_subject_name_id(self._cptr, node and node._cptr)

    def setSubjectConfirmationNameId(self, node):
        '''
        Set the subject NameID, which can be a simple L{Saml2NameID} object or
        an encrypted L{Saml2NameID} as a L{Saml2EncryptedElement}.
        
        @param node:  a L{Saml2NameID} or L{Saml2EncryptedElement}
        '''
        _lasso.saml2_assertion_set_subject_confirmation_name_id(self._cptr, node and node._cptr)

    def setSubjectConfirmationData(self, tolerance, length, Recipient, InResponseTo, Address):
        _lasso.saml2_assertion_set_subject_confirmation_data(self._cptr, tolerance, length, str2lasso(Recipient), str2lasso(InResponseTo), str2lasso(Address))

    def setBasicConditions(self, tolerance = -1, length = -1, one_time_use = False):
        '''
        Set conditions limiting usage of the assertion.
        
        C{tolerance} and C{length} are time quantity measured in seconds, it
        defines the time range in which the assertion is valid, it is computed
        as [now()-tolerance, now()+length+tolerance]. C{one_time_use} allows
        the issuer to limit caching of the assertion. C{proxy_count} specify
        how many proxy hop can be traversed before this assertion should lose
        any trust.
        
        @param length:  length of the range of time when the assertion is
            valid
        @param one_time_use:  can the assertion be kept or should it be used
            immediately
        '''
        _lasso.saml2_assertion_set_basic_conditions(self._cptr, tolerance, length, one_time_use)

    def addAudienceRestriction(self, providerID):
        '''
        Add an audience restriction to a L{Saml2Assertion}.
        
        @param providerId:  the provider id to restrict audience to
        '''
        _lasso.saml2_assertion_add_audience_restriction(self._cptr, str2lasso(providerID))

    def addProxyLimit(self, proxy_count = -1, proxy_audiences = None):
        '''
        A L{Saml2ProxyRestriction} to the conditions of consumption of
        C{self}.
        
        @param proxy_count:  the number of hops in the proxy chain, a negative
            value means no limitation
        @param proxy_audiences:  a list of audience restriction for newly
            issued assertion based on the C{self} assertion. An empty list
            means no audience restriction.
        '''
        _lasso.saml2_assertion_add_proxy_limit(self._cptr, proxy_count, proxy_audiences)

    def validateConditions(self, relaying_party_providerID = None):
        '''
        Check the validation of the assertion with respect to the conditions
        of consumption that it contains. System functions are used for getting
        current time and checking eventual time constraints.
        
        @param relaying_party_providerID:  the providerID of the current
            relaying party, use to check for audience restrictions.
        @return: LASSO_SAML2_ASSERTION_VALID if the assertion is valid,
            LASSO_SAML2_ASSERTION_INVALID is some check failed,
            LASSO_SAML2_ASSERTION_INDETERMINATE if somehting was impossible to
            eveluate.
        '''
        return _lasso.saml2_assertion_validate_conditions(self._cptr, str2lasso(relaying_party_providerID))

    def getIssuerProvider(self, server):
        '''
        Return the L{Provider} object for the provider who created this
        assertion.
        
        @param server:  a L{Server} object
        @return: a L{Provider} object, or None if the Issuer element is
            missing, or the given provider unknown to the L{Server} object.
        '''
        return cptrToPy(_lasso.saml2_assertion_get_issuer_provider(self._cptr, server and server._cptr))

    def addAttributeWithNode(self, name, nameformat, content):
        '''
        Add a new attribute declaration and set this node as the content.
        
        @param name:  the attribute name
        @param name_format:  the attribute name format (the namespace of the
            name)
        @param content:  a L{Node} object to put as content of the attribute
        @return: 0 if successful, an error code otherwise.
        '''
        rc = _lasso.saml2_assertion_add_attribute_with_node(self._cptr, str2lasso(name), str2lasso(nameformat), content and content._cptr)
        Error.raise_on_rc(rc)

    def getSubjectConfirmationData(self, create):
        return cptrToPy(_lasso.saml2_assertion_get_subject_confirmation_data(self._cptr, create))

    def getInResponseTo(self):
        '''
        Return the ID of the request this assertion respond to.
        
        @return: the InResponseTo attribute content of the
            SubjectConfirmationData if found
        '''
        return _lasso.saml2_assertion_get_in_response_to(self._cptr)

    def decryptSubject(self, server):
        '''
        Decipher (if needed) the EncryptedID of the Subject.
        
        @param server:  a L{Server} object
        @return: 0 if successful, an error code otherwise. See
            lasso_saml2_encrypted_element_server_decrypt().
        '''
        rc = _lasso.saml2_assertion_decrypt_subject(self._cptr, server and server._cptr)
        Error.raise_on_rc(rc)

    def validateTimeChecks(self, tolerance, now = 0):
        '''
        Check if the C{self} conditions about NotBefore and NotOnOrAfter are
        valid with respect to the C{now} time or the current time.
        C{tolerance} allows to loosely check for validatity, i.e. start time
        is decreased of C{tolerance} seconds and end time is increased of
        C{tolerance} seconds.
        
        @param tolerance:  a duration as seconds
        @param now:  the current time as seconds since EPOCH or 0 to use the
            system time.
        @return: a value among L{Saml2AssertionValidationState}.
        '''
        return _lasso.saml2_assertion_validate_time_checks(self._cptr, tolerance, now)

    def validateAudience(self, audience):
        '''
        Check if the C{self} is directed to a given C{audience}.
        
        @param audience:  the name of an entity
        @return: a value among L{Saml2AssertionValidationState} enumeration.
        '''
        return _lasso.saml2_assertion_validate_audience(self._cptr, str2lasso(audience))

    def hasOneTimeUse(self):
        '''
        Return whether this assertion has the OneTimeUse property.
        
        In this case the relaying party must add the assertion ID to a
        OneTimeUser cache and discards any assertion received in the future
        with the same ID.
        
        @return: TRUE if this assertion has the property OneTimeUse, FALSE
            otherwise.
        '''
        return _lasso.saml2_assertion_has_one_time_use(self._cptr)

    def allowsProxying(self):
        '''
        <para>Test whether this C{self} allows to mint new assertion on the
        basis of it.</para> <para>It verifies that the proxying count is
        positive (or absent).</para>
        
        @return: a value among L{Saml2AssertionValidationState} enumeration.
            #LASSO_SAML2_ASSERTION_INDETERMINATE usually means that an element
            was not conform to the XML Schema for SAML 2.0.
        '''
        return _lasso.saml2_assertion_allows_proxying(self._cptr)

    def allowsProxyingTo(self, audience = None):
        '''
        <para>Test whether this C{self} allows to mint new assertion on the
        basis of it targetted for C{audience}. </para><para>It verifies that
        if C{audience} is non-None it is part of the proxy Audience
        restriction. If C{audience} is None, it checks that no proxying
        Audience restriction is present.</para>
        
        @param audience:  the relaying party which we want to proxy to
        @return: a value among L{Saml2AssertionValidationState} enumeration.
            #LASSO_SAML2_ASSERTION_INDETERMINATE usually means that an element
            was not conform to the XML Schema for SAML 2.0.
        '''
        return _lasso.saml2_assertion_allows_proxying_to(self._cptr, str2lasso(audience))

    def setOneTimeUse(self, one_time_use):
        '''
        Set the one time use condition on this assertion.
        
        @param one_time_use:  is this assertion to be used one time only ?
        '''
        _lasso.saml2_assertion_set_one_time_use(self._cptr, one_time_use)

    inResponseTo = property(getInResponseTo)

class Saml2Attribute(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_attribute_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_attributeValue(self):
        t = _lasso.Saml2Attribute_attributeValue_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_attributeValue(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Attribute_attributeValue_set(self._cptr, value)
    attributeValue = property(get_attributeValue, set_attributeValue)

    def get_name(self):
        t = _lasso.Saml2Attribute_name_get(self._cptr)
        return t;
    def set_name(self, value):
        value = str2lasso(value)
        _lasso.Saml2Attribute_name_set(self._cptr, value)
    name = property(get_name, set_name)

    def get_nameFormat(self):
        t = _lasso.Saml2Attribute_nameFormat_get(self._cptr)
        return t;
    def set_nameFormat(self, value):
        value = str2lasso(value)
        _lasso.Saml2Attribute_nameFormat_set(self._cptr, value)
    nameFormat = property(get_nameFormat, set_nameFormat)

    def get_friendlyName(self):
        t = _lasso.Saml2Attribute_friendlyName_get(self._cptr)
        return t;
    def set_friendlyName(self, value):
        value = str2lasso(value)
        _lasso.Saml2Attribute_friendlyName_set(self._cptr, value)
    friendlyName = property(get_friendlyName, set_friendlyName)


class Saml2AttributeValue(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_attribute_value_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_any(self):
        t = _lasso.Saml2AttributeValue_any_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_any(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2AttributeValue_any_set(self._cptr, value)
    any = property(get_any, set_any)


class Saml2AuthnContext(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_authn_context_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_authnContextClassRef(self):
        t = _lasso.Saml2AuthnContext_authnContextClassRef_get(self._cptr)
        return t;
    def set_authnContextClassRef(self, value):
        value = str2lasso(value)
        _lasso.Saml2AuthnContext_authnContextClassRef_set(self._cptr, value)
    authnContextClassRef = property(get_authnContextClassRef, set_authnContextClassRef)

    def get_authnContextDeclRef(self):
        t = _lasso.Saml2AuthnContext_authnContextDeclRef_get(self._cptr)
        return t;
    def set_authnContextDeclRef(self, value):
        value = str2lasso(value)
        _lasso.Saml2AuthnContext_authnContextDeclRef_set(self._cptr, value)
    authnContextDeclRef = property(get_authnContextDeclRef, set_authnContextDeclRef)

    def get_authenticatingAuthority(self):
        t = _lasso.Saml2AuthnContext_authenticatingAuthority_get(self._cptr)
        return t;
    def set_authenticatingAuthority(self, value):
        value = str2lasso(value)
        _lasso.Saml2AuthnContext_authenticatingAuthority_set(self._cptr, value)
    authenticatingAuthority = property(get_authenticatingAuthority, set_authenticatingAuthority)


class Saml2BaseIDAbstract(Node):
    def get_nameQualifier(self):
        t = _lasso.Saml2BaseIDAbstract_nameQualifier_get(self._cptr)
        return t;
    def set_nameQualifier(self, value):
        value = str2lasso(value)
        _lasso.Saml2BaseIDAbstract_nameQualifier_set(self._cptr, value)
    nameQualifier = property(get_nameQualifier, set_nameQualifier)

    def get_spNameQualifier(self):
        t = _lasso.Saml2BaseIDAbstract_spNameQualifier_get(self._cptr)
        return t;
    def set_spNameQualifier(self, value):
        value = str2lasso(value)
        _lasso.Saml2BaseIDAbstract_spNameQualifier_set(self._cptr, value)
    spNameQualifier = property(get_spNameQualifier, set_spNameQualifier)
    sPNameQualifier = spNameQualifier


class Saml2ConditionAbstract(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_condition_abstract_new()
        if self._cptr is None:
            raise Error('failed to create object')


class Saml2AudienceRestriction(Saml2ConditionAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml2_audience_restriction_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_audience(self):
        t = _lasso.Saml2AudienceRestriction_audience_get(self._cptr)
        return t;
    def set_audience(self, value):
        value = str2lasso(value)
        _lasso.Saml2AudienceRestriction_audience_set(self._cptr, value)
    audience = property(get_audience, set_audience)


class Saml2Conditions(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_conditions_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_condition(self):
        t = _lasso.Saml2Conditions_condition_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_condition(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Conditions_condition_set(self._cptr, value)
    condition = property(get_condition, set_condition)

    def get_audienceRestriction(self):
        t = _lasso.Saml2Conditions_audienceRestriction_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_audienceRestriction(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Conditions_audienceRestriction_set(self._cptr, value)
    audienceRestriction = property(get_audienceRestriction, set_audienceRestriction)

    def get_oneTimeUse(self):
        t = _lasso.Saml2Conditions_oneTimeUse_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_oneTimeUse(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Conditions_oneTimeUse_set(self._cptr, value)
    oneTimeUse = property(get_oneTimeUse, set_oneTimeUse)

    def get_proxyRestriction(self):
        t = _lasso.Saml2Conditions_proxyRestriction_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_proxyRestriction(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Conditions_proxyRestriction_set(self._cptr, value)
    proxyRestriction = property(get_proxyRestriction, set_proxyRestriction)

    def get_notBefore(self):
        t = _lasso.Saml2Conditions_notBefore_get(self._cptr)
        return t;
    def set_notBefore(self, value):
        value = str2lasso(value)
        _lasso.Saml2Conditions_notBefore_set(self._cptr, value)
    notBefore = property(get_notBefore, set_notBefore)

    def get_notOnOrAfter(self):
        t = _lasso.Saml2Conditions_notOnOrAfter_get(self._cptr)
        return t;
    def set_notOnOrAfter(self, value):
        value = str2lasso(value)
        _lasso.Saml2Conditions_notOnOrAfter_set(self._cptr, value)
    notOnOrAfter = property(get_notOnOrAfter, set_notOnOrAfter)


class Saml2EncryptedElement(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_encrypted_element_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_encryptedData(self):
        t = _lasso.Saml2EncryptedElement_encryptedData_get(self._cptr)
        return t;
    def set_encryptedData(self, value):
        _lasso.Saml2EncryptedElement_encryptedData_set(self._cptr, value)
    encryptedData = property(get_encryptedData, set_encryptedData)

    def get_encryptedKey(self):
        t = _lasso.Saml2EncryptedElement_encryptedKey_get(self._cptr)
        return t;
    def set_encryptedKey(self, value):
        _lasso.Saml2EncryptedElement_encryptedKey_set(self._cptr, value)
    encryptedKey = property(get_encryptedKey, set_encryptedKey)

    def get_originalData(self):
        t = _lasso.Saml2EncryptedElement_originalData_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_originalData(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2EncryptedElement_originalData_set(self._cptr, value)
    originalData = property(get_originalData, set_originalData)

    def serverDecrypt(self, server):
        '''
        Decrypt the given encrypted element using the encryption private key
        of the C{server} object
        
        @param server:  a L{Server} object
        @param decrypted_node:  an output arg for a L{Node}
        @return: 0 if successful, an error code otherwise. See
            lasso_saml2_encrypted_element_server_decrypt().
        '''
        _decrypted_node_out = list((None,))
        rc = _lasso.saml2_encrypted_element_server_decrypt(self._cptr, server and server._cptr, _decrypted_node_out)
        Error.raise_on_rc(rc)
        return _decrypted_node_out[0]


class Saml2Evidence(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_evidence_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_assertionIdRef(self):
        t = _lasso.Saml2Evidence_assertionIdRef_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertionIdRef(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Evidence_assertionIdRef_set(self._cptr, value)
    assertionIdRef = property(get_assertionIdRef, set_assertionIdRef)

    def get_assertionUriRef(self):
        t = _lasso.Saml2Evidence_assertionUriRef_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertionUriRef(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Evidence_assertionUriRef_set(self._cptr, value)
    assertionUriRef = property(get_assertionUriRef, set_assertionUriRef)
    assertionURIRef = assertionUriRef

    def get_assertion(self):
        t = _lasso.Saml2Evidence_assertion_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertion(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Evidence_assertion_set(self._cptr, value)
    assertion = property(get_assertion, set_assertion)

    def get_encryptedAssertion(self):
        t = _lasso.Saml2Evidence_encryptedAssertion_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_encryptedAssertion(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2Evidence_encryptedAssertion_set(self._cptr, value)
    encryptedAssertion = property(get_encryptedAssertion, set_encryptedAssertion)


class Saml2KeyInfoConfirmationData(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_key_info_confirmation_data_new()
        if self._cptr is None:
            raise Error('failed to create object')


class Saml2NameID(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_name_id_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newWithPersistentFormat(cls, id, idpID, providerID):
         return cptrToPy(_lasso.saml2_name_id_new_with_persistent_format(str2lasso(id), str2lasso(idpID), str2lasso(providerID)))

    @classmethod
    def newWithString(cls, content):
         return cptrToPy(_lasso.saml2_name_id_new_with_string(str2lasso(content)))

    def get_content(self):
        t = _lasso.Saml2NameID_content_get(self._cptr)
        return t;
    def set_content(self, value):
        value = str2lasso(value)
        _lasso.Saml2NameID_content_set(self._cptr, value)
    content = property(get_content, set_content)

    def get_format(self):
        t = _lasso.Saml2NameID_format_get(self._cptr)
        return t;
    def set_format(self, value):
        value = str2lasso(value)
        _lasso.Saml2NameID_format_set(self._cptr, value)
    format = property(get_format, set_format)

    def get_spProvidedId(self):
        t = _lasso.Saml2NameID_spProvidedId_get(self._cptr)
        return t;
    def set_spProvidedId(self, value):
        value = str2lasso(value)
        _lasso.Saml2NameID_spProvidedId_set(self._cptr, value)
    spProvidedId = property(get_spProvidedId, set_spProvidedId)
    sPProvidedId = spProvidedId

    def get_nameQualifier(self):
        t = _lasso.Saml2NameID_nameQualifier_get(self._cptr)
        return t;
    def set_nameQualifier(self, value):
        value = str2lasso(value)
        _lasso.Saml2NameID_nameQualifier_set(self._cptr, value)
    nameQualifier = property(get_nameQualifier, set_nameQualifier)

    def get_spNameQualifier(self):
        t = _lasso.Saml2NameID_spNameQualifier_get(self._cptr)
        return t;
    def set_spNameQualifier(self, value):
        value = str2lasso(value)
        _lasso.Saml2NameID_spNameQualifier_set(self._cptr, value)
    spNameQualifier = property(get_spNameQualifier, set_spNameQualifier)
    sPNameQualifier = spNameQualifier

    def equals(self, other_name_id):
        '''
        Return TRUE if C{self} equals C{other_name_id}.
        
        @param other_name_id:  another L{Saml2NameID} object
        @return: TRUE if the two NameID are equal and are L{Saml2NameID}
            objects, FALSE otherwise.
        '''
        return _lasso.saml2_name_id_equals(self._cptr, other_name_id and other_name_id._cptr)


class Saml2OneTimeUse(Saml2ConditionAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml2_one_time_use_new()
        if self._cptr is None:
            raise Error('failed to create object')


class Saml2ProxyRestriction(Saml2ConditionAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml2_proxy_restriction_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_audience(self):
        t = _lasso.Saml2ProxyRestriction_audience_get(self._cptr)
        return t;
    def set_audience(self, value):
        value = str2lasso(value)
        _lasso.Saml2ProxyRestriction_audience_set(self._cptr, value)
    audience = property(get_audience, set_audience)

    def get_count(self):
        t = _lasso.Saml2ProxyRestriction_count_get(self._cptr)
        return t;
    def set_count(self, value):
        value = str2lasso(value)
        _lasso.Saml2ProxyRestriction_count_set(self._cptr, value)
    count = property(get_count, set_count)


class Saml2StatementAbstract(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_statement_abstract_new()
        if self._cptr is None:
            raise Error('failed to create object')


class Saml2AttributeStatement(Saml2StatementAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml2_attribute_statement_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_attribute(self):
        t = _lasso.Saml2AttributeStatement_attribute_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_attribute(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2AttributeStatement_attribute_set(self._cptr, value)
    attribute = property(get_attribute, set_attribute)

    def get_encryptedAttribute(self):
        t = _lasso.Saml2AttributeStatement_encryptedAttribute_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_encryptedAttribute(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Saml2AttributeStatement_encryptedAttribute_set(self._cptr, value)
    encryptedAttribute = property(get_encryptedAttribute, set_encryptedAttribute)


class Saml2AuthnStatement(Saml2StatementAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml2_authn_statement_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_subjectLocality(self):
        t = _lasso.Saml2AuthnStatement_subjectLocality_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subjectLocality(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2AuthnStatement_subjectLocality_set(self._cptr, value)
    subjectLocality = property(get_subjectLocality, set_subjectLocality)

    def get_authnContext(self):
        t = _lasso.Saml2AuthnStatement_authnContext_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_authnContext(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2AuthnStatement_authnContext_set(self._cptr, value)
    authnContext = property(get_authnContext, set_authnContext)

    def get_authnInstant(self):
        t = _lasso.Saml2AuthnStatement_authnInstant_get(self._cptr)
        return t;
    def set_authnInstant(self, value):
        value = str2lasso(value)
        _lasso.Saml2AuthnStatement_authnInstant_set(self._cptr, value)
    authnInstant = property(get_authnInstant, set_authnInstant)

    def get_sessionIndex(self):
        t = _lasso.Saml2AuthnStatement_sessionIndex_get(self._cptr)
        return t;
    def set_sessionIndex(self, value):
        value = str2lasso(value)
        _lasso.Saml2AuthnStatement_sessionIndex_set(self._cptr, value)
    sessionIndex = property(get_sessionIndex, set_sessionIndex)

    def get_sessionNotOnOrAfter(self):
        t = _lasso.Saml2AuthnStatement_sessionNotOnOrAfter_get(self._cptr)
        return t;
    def set_sessionNotOnOrAfter(self, value):
        value = str2lasso(value)
        _lasso.Saml2AuthnStatement_sessionNotOnOrAfter_set(self._cptr, value)
    sessionNotOnOrAfter = property(get_sessionNotOnOrAfter, set_sessionNotOnOrAfter)


class Saml2AuthzDecisionStatement(Saml2StatementAbstract):
    def __init__(self, ):
        self._cptr = _lasso.saml2_authz_decision_statement_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_action(self):
        t = _lasso.Saml2AuthzDecisionStatement_action_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_action(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2AuthzDecisionStatement_action_set(self._cptr, value)
    action = property(get_action, set_action)

    def get_evidence(self):
        t = _lasso.Saml2AuthzDecisionStatement_evidence_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_evidence(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2AuthzDecisionStatement_evidence_set(self._cptr, value)
    evidence = property(get_evidence, set_evidence)

    def get_resource(self):
        t = _lasso.Saml2AuthzDecisionStatement_resource_get(self._cptr)
        return t;
    def set_resource(self, value):
        value = str2lasso(value)
        _lasso.Saml2AuthzDecisionStatement_resource_set(self._cptr, value)
    resource = property(get_resource, set_resource)

    def get_decision(self):
        t = _lasso.Saml2AuthzDecisionStatement_decision_get(self._cptr)
        return t;
    def set_decision(self, value):
        value = str2lasso(value)
        _lasso.Saml2AuthzDecisionStatement_decision_set(self._cptr, value)
    decision = property(get_decision, set_decision)


class Saml2Subject(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_subject_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_baseId(self):
        t = _lasso.Saml2Subject_baseId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_baseId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2Subject_baseId_set(self._cptr, value)
    baseId = property(get_baseId, set_baseId)

    def get_nameId(self):
        t = _lasso.Saml2Subject_nameId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2Subject_nameId_set(self._cptr, value)
    nameId = property(get_nameId, set_nameId)

    def get_encryptedId(self):
        t = _lasso.Saml2Subject_encryptedId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_encryptedId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2Subject_encryptedId_set(self._cptr, value)
    encryptedId = property(get_encryptedId, set_encryptedId)

    def get_subjectConfirmation(self):
        t = _lasso.Saml2Subject_subjectConfirmation_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subjectConfirmation(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2Subject_subjectConfirmation_set(self._cptr, value)
    subjectConfirmation = property(get_subjectConfirmation, set_subjectConfirmation)


class Saml2SubjectConfirmation(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_subject_confirmation_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_baseId(self):
        t = _lasso.Saml2SubjectConfirmation_baseId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_baseId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2SubjectConfirmation_baseId_set(self._cptr, value)
    baseId = property(get_baseId, set_baseId)

    def get_nameId(self):
        t = _lasso.Saml2SubjectConfirmation_nameId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2SubjectConfirmation_nameId_set(self._cptr, value)
    nameId = property(get_nameId, set_nameId)

    def get_encryptedId(self):
        t = _lasso.Saml2SubjectConfirmation_encryptedId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_encryptedId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2SubjectConfirmation_encryptedId_set(self._cptr, value)
    encryptedId = property(get_encryptedId, set_encryptedId)

    def get_subjectConfirmationData(self):
        t = _lasso.Saml2SubjectConfirmation_subjectConfirmationData_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subjectConfirmationData(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Saml2SubjectConfirmation_subjectConfirmationData_set(self._cptr, value)
    subjectConfirmationData = property(get_subjectConfirmationData, set_subjectConfirmationData)

    def get_method(self):
        t = _lasso.Saml2SubjectConfirmation_method_get(self._cptr)
        return t;
    def set_method(self, value):
        value = str2lasso(value)
        _lasso.Saml2SubjectConfirmation_method_set(self._cptr, value)
    method = property(get_method, set_method)


class Saml2SubjectConfirmationData(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_subject_confirmation_data_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_notBefore(self):
        t = _lasso.Saml2SubjectConfirmationData_notBefore_get(self._cptr)
        return t;
    def set_notBefore(self, value):
        value = str2lasso(value)
        _lasso.Saml2SubjectConfirmationData_notBefore_set(self._cptr, value)
    notBefore = property(get_notBefore, set_notBefore)

    def get_notOnOrAfter(self):
        t = _lasso.Saml2SubjectConfirmationData_notOnOrAfter_get(self._cptr)
        return t;
    def set_notOnOrAfter(self, value):
        value = str2lasso(value)
        _lasso.Saml2SubjectConfirmationData_notOnOrAfter_set(self._cptr, value)
    notOnOrAfter = property(get_notOnOrAfter, set_notOnOrAfter)

    def get_recipient(self):
        t = _lasso.Saml2SubjectConfirmationData_recipient_get(self._cptr)
        return t;
    def set_recipient(self, value):
        value = str2lasso(value)
        _lasso.Saml2SubjectConfirmationData_recipient_set(self._cptr, value)
    recipient = property(get_recipient, set_recipient)

    def get_inResponseTo(self):
        t = _lasso.Saml2SubjectConfirmationData_inResponseTo_get(self._cptr)
        return t;
    def set_inResponseTo(self, value):
        value = str2lasso(value)
        _lasso.Saml2SubjectConfirmationData_inResponseTo_set(self._cptr, value)
    inResponseTo = property(get_inResponseTo, set_inResponseTo)

    def get_address(self):
        t = _lasso.Saml2SubjectConfirmationData_address_get(self._cptr)
        return t;
    def set_address(self, value):
        value = str2lasso(value)
        _lasso.Saml2SubjectConfirmationData_address_set(self._cptr, value)
    address = property(get_address, set_address)


class Saml2KeyInfoConfirmationDataType(Saml2SubjectConfirmationData):
    def __init__(self, ):
        self._cptr = _lasso.saml2_key_info_confirmation_data_type_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def getKeyInfo(self):
        '''
        Return the list of KeyInfo node contained in the
        saml2:SubjectConfirmationData of type
        saml2:KeyInfoConfirmationDataType.
        
        @return: a list of L{DsKeyInfo} objects.
        '''
        value = _lasso.saml2_key_info_confirmation_data_type_get_key_info(self._cptr)
        if value is not None:
            value = tuple([cptrToPy(x) for x in value])
        return value

    def setKeyInfo(self, key_infos):
        '''
        Set the list of ds:KeyInfo nodes for the saml2:SubjectConfirmationData
        of type saml2:KeyInfoConfirmationDataType.
        
        @param key_infos:  a list of L{DsKeyInfo} object.
        '''
        _lasso.saml2_key_info_confirmation_data_type_set_key_info(self._cptr, key_infos)

    keyInfo = property(getKeyInfo, setKeyInfo)

class Saml2SubjectLocality(Node):
    def __init__(self, ):
        self._cptr = _lasso.saml2_subject_locality_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_address(self):
        t = _lasso.Saml2SubjectLocality_address_get(self._cptr)
        return t;
    def set_address(self, value):
        value = str2lasso(value)
        _lasso.Saml2SubjectLocality_address_set(self._cptr, value)
    address = property(get_address, set_address)

    def get_dnsName(self):
        t = _lasso.Saml2SubjectLocality_dnsName_get(self._cptr)
        return t;
    def set_dnsName(self, value):
        value = str2lasso(value)
        _lasso.Saml2SubjectLocality_dnsName_set(self._cptr, value)
    dnsName = property(get_dnsName, set_dnsName)
    dNSName = dnsName


class Samlp2Extensions(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_extensions_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def getAny(self):
        '''
        Return the list of contained XML nodes.
        
        @return: a #GList of xmlNode.
        '''
        return _lasso.samlp2_extensions_get_any(self._cptr)

    def setAny(self, any = None):
        '''
        Set the list of contained XML nodes.
        '''
        _lasso.samlp2_extensions_set_any(self._cptr, any)

    def getAttributes(self):
        '''
        Return the list of contained XML nodes.
        
        @return: a #GList of xmlNode.
        '''
        return _lasso.samlp2_extensions_get_attributes(self._cptr)

    def setAttributes(self, attributes):
        '''
        Set the table of XML attributes.
        '''
        _lasso.samlp2_extensions_set_attributes(self._cptr, attributes)

    any = property(getAny, setAny)
    attributes = property(getAttributes, setAttributes)

class Samlp2IDPEntry(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_idp_entry_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_providerId(self):
        t = _lasso.Samlp2IDPEntry_providerId_get(self._cptr)
        return t;
    def set_providerId(self, value):
        value = str2lasso(value)
        _lasso.Samlp2IDPEntry_providerId_set(self._cptr, value)
    providerId = property(get_providerId, set_providerId)

    def get_name(self):
        t = _lasso.Samlp2IDPEntry_name_get(self._cptr)
        return t;
    def set_name(self, value):
        value = str2lasso(value)
        _lasso.Samlp2IDPEntry_name_set(self._cptr, value)
    name = property(get_name, set_name)

    def get_loc(self):
        t = _lasso.Samlp2IDPEntry_loc_get(self._cptr)
        return t;
    def set_loc(self, value):
        value = str2lasso(value)
        _lasso.Samlp2IDPEntry_loc_set(self._cptr, value)
    loc = property(get_loc, set_loc)


class Samlp2IDPList(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_idp_list_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_idpEntry(self):
        t = _lasso.Samlp2IDPList_idpEntry_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_idpEntry(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Samlp2IDPList_idpEntry_set(self._cptr, value)
    idpEntry = property(get_idpEntry, set_idpEntry)
    iDPEntry = idpEntry

    def get_getComplete(self):
        t = _lasso.Samlp2IDPList_getComplete_get(self._cptr)
        return t;
    def set_getComplete(self, value):
        value = str2lasso(value)
        _lasso.Samlp2IDPList_getComplete_set(self._cptr, value)
    getComplete = property(get_getComplete, set_getComplete)


class Samlp2NameIDPolicy(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_name_id_policy_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_format(self):
        t = _lasso.Samlp2NameIDPolicy_format_get(self._cptr)
        return t;
    def set_format(self, value):
        value = str2lasso(value)
        _lasso.Samlp2NameIDPolicy_format_set(self._cptr, value)
    format = property(get_format, set_format)

    def get_spNameQualifier(self):
        t = _lasso.Samlp2NameIDPolicy_spNameQualifier_get(self._cptr)
        return t;
    def set_spNameQualifier(self, value):
        value = str2lasso(value)
        _lasso.Samlp2NameIDPolicy_spNameQualifier_set(self._cptr, value)
    spNameQualifier = property(get_spNameQualifier, set_spNameQualifier)
    sPNameQualifier = spNameQualifier

    def get_allowCreate(self):
        t = _lasso.Samlp2NameIDPolicy_allowCreate_get(self._cptr)
        return t;
    def set_allowCreate(self, value):
        _lasso.Samlp2NameIDPolicy_allowCreate_set(self._cptr, value)
    allowCreate = property(get_allowCreate, set_allowCreate)


class Samlp2RequestAbstract(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_request_abstract_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_issuer(self):
        t = _lasso.Samlp2RequestAbstract_issuer_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_issuer(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2RequestAbstract_issuer_set(self._cptr, value)
    issuer = property(get_issuer, set_issuer)

    def get_extensions(self):
        t = _lasso.Samlp2RequestAbstract_extensions_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_extensions(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2RequestAbstract_extensions_set(self._cptr, value)
    extensions = property(get_extensions, set_extensions)

    def get_id(self):
        t = _lasso.Samlp2RequestAbstract_id_get(self._cptr)
        return t;
    def set_id(self, value):
        value = str2lasso(value)
        _lasso.Samlp2RequestAbstract_id_set(self._cptr, value)
    id = property(get_id, set_id)
    iD = id

    def get_version(self):
        t = _lasso.Samlp2RequestAbstract_version_get(self._cptr)
        return t;
    def set_version(self, value):
        value = str2lasso(value)
        _lasso.Samlp2RequestAbstract_version_set(self._cptr, value)
    version = property(get_version, set_version)

    def get_issueInstant(self):
        t = _lasso.Samlp2RequestAbstract_issueInstant_get(self._cptr)
        return t;
    def set_issueInstant(self, value):
        value = str2lasso(value)
        _lasso.Samlp2RequestAbstract_issueInstant_set(self._cptr, value)
    issueInstant = property(get_issueInstant, set_issueInstant)

    def get_destination(self):
        t = _lasso.Samlp2RequestAbstract_destination_get(self._cptr)
        return t;
    def set_destination(self, value):
        value = str2lasso(value)
        _lasso.Samlp2RequestAbstract_destination_set(self._cptr, value)
    destination = property(get_destination, set_destination)

    def get_consent(self):
        t = _lasso.Samlp2RequestAbstract_consent_get(self._cptr)
        return t;
    def set_consent(self, value):
        value = str2lasso(value)
        _lasso.Samlp2RequestAbstract_consent_set(self._cptr, value)
    consent = property(get_consent, set_consent)


class Samlp2ArtifactResolve(Samlp2RequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_artifact_resolve_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_artifact(self):
        t = _lasso.Samlp2ArtifactResolve_artifact_get(self._cptr)
        return t;
    def set_artifact(self, value):
        value = str2lasso(value)
        _lasso.Samlp2ArtifactResolve_artifact_set(self._cptr, value)
    artifact = property(get_artifact, set_artifact)


class Samlp2AssertionIDRequest(Samlp2RequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_assertion_id_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_assertionIdRef(self):
        t = _lasso.Samlp2AssertionIDRequest_assertionIdRef_get(self._cptr)
        return t;
    def set_assertionIdRef(self, value):
        value = str2lasso(value)
        _lasso.Samlp2AssertionIDRequest_assertionIdRef_set(self._cptr, value)
    assertionIdRef = property(get_assertionIdRef, set_assertionIdRef)


class Samlp2AuthnRequest(Samlp2RequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_authn_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_subject(self):
        t = _lasso.Samlp2AuthnRequest_subject_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subject(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2AuthnRequest_subject_set(self._cptr, value)
    subject = property(get_subject, set_subject)

    def get_nameIdPolicy(self):
        t = _lasso.Samlp2AuthnRequest_nameIdPolicy_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameIdPolicy(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2AuthnRequest_nameIdPolicy_set(self._cptr, value)
    nameIdPolicy = property(get_nameIdPolicy, set_nameIdPolicy)

    def get_conditions(self):
        t = _lasso.Samlp2AuthnRequest_conditions_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_conditions(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2AuthnRequest_conditions_set(self._cptr, value)
    conditions = property(get_conditions, set_conditions)

    def get_requestedAuthnContext(self):
        t = _lasso.Samlp2AuthnRequest_requestedAuthnContext_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_requestedAuthnContext(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2AuthnRequest_requestedAuthnContext_set(self._cptr, value)
    requestedAuthnContext = property(get_requestedAuthnContext, set_requestedAuthnContext)

    def get_scoping(self):
        t = _lasso.Samlp2AuthnRequest_scoping_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_scoping(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2AuthnRequest_scoping_set(self._cptr, value)
    scoping = property(get_scoping, set_scoping)

    def get_forceAuthn(self):
        t = _lasso.Samlp2AuthnRequest_forceAuthn_get(self._cptr)
        return t;
    def set_forceAuthn(self, value):
        _lasso.Samlp2AuthnRequest_forceAuthn_set(self._cptr, value)
    forceAuthn = property(get_forceAuthn, set_forceAuthn)

    def get_isPassive(self):
        t = _lasso.Samlp2AuthnRequest_isPassive_get(self._cptr)
        return t;
    def set_isPassive(self, value):
        _lasso.Samlp2AuthnRequest_isPassive_set(self._cptr, value)
    isPassive = property(get_isPassive, set_isPassive)

    def get_protocolBinding(self):
        t = _lasso.Samlp2AuthnRequest_protocolBinding_get(self._cptr)
        return t;
    def set_protocolBinding(self, value):
        value = str2lasso(value)
        _lasso.Samlp2AuthnRequest_protocolBinding_set(self._cptr, value)
    protocolBinding = property(get_protocolBinding, set_protocolBinding)

    def get_assertionConsumerServiceIndex(self):
        t = _lasso.Samlp2AuthnRequest_assertionConsumerServiceIndex_get(self._cptr)
        return t;
    def set_assertionConsumerServiceIndex(self, value):
        _lasso.Samlp2AuthnRequest_assertionConsumerServiceIndex_set(self._cptr, value)
    assertionConsumerServiceIndex = property(get_assertionConsumerServiceIndex, set_assertionConsumerServiceIndex)

    def get_assertionConsumerServiceUrl(self):
        t = _lasso.Samlp2AuthnRequest_assertionConsumerServiceUrl_get(self._cptr)
        return t;
    def set_assertionConsumerServiceUrl(self, value):
        value = str2lasso(value)
        _lasso.Samlp2AuthnRequest_assertionConsumerServiceUrl_set(self._cptr, value)
    assertionConsumerServiceUrl = property(get_assertionConsumerServiceUrl, set_assertionConsumerServiceUrl)
    assertionConsumerServiceURL = assertionConsumerServiceUrl

    def get_attributeConsumingServiceIndex(self):
        t = _lasso.Samlp2AuthnRequest_attributeConsumingServiceIndex_get(self._cptr)
        return t;
    def set_attributeConsumingServiceIndex(self, value):
        _lasso.Samlp2AuthnRequest_attributeConsumingServiceIndex_set(self._cptr, value)
    attributeConsumingServiceIndex = property(get_attributeConsumingServiceIndex, set_attributeConsumingServiceIndex)

    def get_providerName(self):
        t = _lasso.Samlp2AuthnRequest_providerName_get(self._cptr)
        return t;
    def set_providerName(self, value):
        value = str2lasso(value)
        _lasso.Samlp2AuthnRequest_providerName_set(self._cptr, value)
    providerName = property(get_providerName, set_providerName)


class Samlp2LogoutRequest(Samlp2RequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_logout_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_baseId(self):
        t = _lasso.Samlp2LogoutRequest_baseId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_baseId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2LogoutRequest_baseId_set(self._cptr, value)
    baseId = property(get_baseId, set_baseId)

    def get_nameId(self):
        t = _lasso.Samlp2LogoutRequest_nameId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2LogoutRequest_nameId_set(self._cptr, value)
    nameId = property(get_nameId, set_nameId)

    def get_encryptedId(self):
        t = _lasso.Samlp2LogoutRequest_encryptedId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_encryptedId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2LogoutRequest_encryptedId_set(self._cptr, value)
    encryptedId = property(get_encryptedId, set_encryptedId)

    def get_sessionIndex(self):
        t = _lasso.Samlp2LogoutRequest_sessionIndex_get(self._cptr)
        return t;
    def set_sessionIndex(self, value):
        value = str2lasso(value)
        _lasso.Samlp2LogoutRequest_sessionIndex_set(self._cptr, value)
    sessionIndex = property(get_sessionIndex, set_sessionIndex)

    def get_reason(self):
        t = _lasso.Samlp2LogoutRequest_reason_get(self._cptr)
        return t;
    def set_reason(self, value):
        value = str2lasso(value)
        _lasso.Samlp2LogoutRequest_reason_set(self._cptr, value)
    reason = property(get_reason, set_reason)

    def get_notOnOrAfter(self):
        t = _lasso.Samlp2LogoutRequest_notOnOrAfter_get(self._cptr)
        return t;
    def set_notOnOrAfter(self, value):
        value = str2lasso(value)
        _lasso.Samlp2LogoutRequest_notOnOrAfter_set(self._cptr, value)
    notOnOrAfter = property(get_notOnOrAfter, set_notOnOrAfter)

    def getSessionIndexes(self):
        '''
        If the logout request contains more than one SessionIndex element,
        this method must be used to retrieve due to historical circonstances.
        It will a return a list of the content of the SessionIndex elements.
        
        @return: a #GList of sessions index.
        '''
        return _lasso.samlp2_logout_request_get_session_indexes(self._cptr)

    def setSessionIndexes(self, session_index):
        '''
        If you want to set more than one SessionIndex on a LogoutRequest, use
        this method. Beware that the public field named SessionIndex
        corresponds to the last element in this list. This is an symptom of
        the way elements are parsed by Lasso.
        
        @param session_index:  a list of session index
        '''
        _lasso.samlp2_logout_request_set_session_indexes(self._cptr, session_index)

    sessionIndexes = property(getSessionIndexes, setSessionIndexes)

class Samlp2ManageNameIDRequest(Samlp2RequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_manage_name_id_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_nameId(self):
        t = _lasso.Samlp2ManageNameIDRequest_nameId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2ManageNameIDRequest_nameId_set(self._cptr, value)
    nameId = property(get_nameId, set_nameId)

    def get_encryptedId(self):
        t = _lasso.Samlp2ManageNameIDRequest_encryptedId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_encryptedId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2ManageNameIDRequest_encryptedId_set(self._cptr, value)
    encryptedId = property(get_encryptedId, set_encryptedId)

    def get_newId(self):
        t = _lasso.Samlp2ManageNameIDRequest_newId_get(self._cptr)
        return t;
    def set_newId(self, value):
        value = str2lasso(value)
        _lasso.Samlp2ManageNameIDRequest_newId_set(self._cptr, value)
    newId = property(get_newId, set_newId)

    def get_newEncryptedId(self):
        t = _lasso.Samlp2ManageNameIDRequest_newEncryptedId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_newEncryptedId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2ManageNameIDRequest_newEncryptedId_set(self._cptr, value)
    newEncryptedId = property(get_newEncryptedId, set_newEncryptedId)

    def get_terminate(self):
        t = _lasso.Samlp2ManageNameIDRequest_terminate_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_terminate(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2ManageNameIDRequest_terminate_set(self._cptr, value)
    terminate = property(get_terminate, set_terminate)


class Samlp2NameIDMappingRequest(Samlp2RequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_name_id_mapping_request_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_baseId(self):
        t = _lasso.Samlp2NameIDMappingRequest_baseId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_baseId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2NameIDMappingRequest_baseId_set(self._cptr, value)
    baseId = property(get_baseId, set_baseId)

    def get_nameId(self):
        t = _lasso.Samlp2NameIDMappingRequest_nameId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2NameIDMappingRequest_nameId_set(self._cptr, value)
    nameId = property(get_nameId, set_nameId)

    def get_encryptedId(self):
        t = _lasso.Samlp2NameIDMappingRequest_encryptedId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_encryptedId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2NameIDMappingRequest_encryptedId_set(self._cptr, value)
    encryptedId = property(get_encryptedId, set_encryptedId)

    def get_nameIdPolicy(self):
        t = _lasso.Samlp2NameIDMappingRequest_nameIdPolicy_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameIdPolicy(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2NameIDMappingRequest_nameIdPolicy_set(self._cptr, value)
    nameIdPolicy = property(get_nameIdPolicy, set_nameIdPolicy)


class Samlp2RequestedAuthnContext(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_requested_authn_context_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_authnContextClassRef(self):
        t = _lasso.Samlp2RequestedAuthnContext_authnContextClassRef_get(self._cptr)
        return t;
    def set_authnContextClassRef(self, value):
        _lasso.Samlp2RequestedAuthnContext_authnContextClassRef_set(self._cptr, value)
    authnContextClassRef = property(get_authnContextClassRef, set_authnContextClassRef)

    def get_authnContextDeclRef(self):
        t = _lasso.Samlp2RequestedAuthnContext_authnContextDeclRef_get(self._cptr)
        return t;
    def set_authnContextDeclRef(self, value):
        _lasso.Samlp2RequestedAuthnContext_authnContextDeclRef_set(self._cptr, value)
    authnContextDeclRef = property(get_authnContextDeclRef, set_authnContextDeclRef)

    def get_comparison(self):
        t = _lasso.Samlp2RequestedAuthnContext_comparison_get(self._cptr)
        return t;
    def set_comparison(self, value):
        value = str2lasso(value)
        _lasso.Samlp2RequestedAuthnContext_comparison_set(self._cptr, value)
    comparison = property(get_comparison, set_comparison)


class Samlp2Scoping(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_scoping_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_idpList(self):
        t = _lasso.Samlp2Scoping_idpList_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_idpList(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2Scoping_idpList_set(self._cptr, value)
    idpList = property(get_idpList, set_idpList)
    iDPList = idpList

    def get_requesterId(self):
        t = _lasso.Samlp2Scoping_requesterId_get(self._cptr)
        return t;
    def set_requesterId(self, value):
        value = str2lasso(value)
        _lasso.Samlp2Scoping_requesterId_set(self._cptr, value)
    requesterId = property(get_requesterId, set_requesterId)

    def get_proxyCount(self):
        t = _lasso.Samlp2Scoping_proxyCount_get(self._cptr)
        return t;
    def set_proxyCount(self, value):
        value = str2lasso(value)
        _lasso.Samlp2Scoping_proxyCount_set(self._cptr, value)
    proxyCount = property(get_proxyCount, set_proxyCount)


class Samlp2Status(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_status_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_statusCode(self):
        t = _lasso.Samlp2Status_statusCode_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_statusCode(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2Status_statusCode_set(self._cptr, value)
    statusCode = property(get_statusCode, set_statusCode)

    def get_statusMessage(self):
        t = _lasso.Samlp2Status_statusMessage_get(self._cptr)
        return t;
    def set_statusMessage(self, value):
        value = str2lasso(value)
        _lasso.Samlp2Status_statusMessage_set(self._cptr, value)
    statusMessage = property(get_statusMessage, set_statusMessage)

    def get_statusDetail(self):
        t = _lasso.Samlp2Status_statusDetail_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_statusDetail(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2Status_statusDetail_set(self._cptr, value)
    statusDetail = property(get_statusDetail, set_statusDetail)


class Samlp2StatusCode(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_status_code_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_statusCode(self):
        t = _lasso.Samlp2StatusCode_statusCode_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_statusCode(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2StatusCode_statusCode_set(self._cptr, value)
    statusCode = property(get_statusCode, set_statusCode)

    def get_value(self):
        t = _lasso.Samlp2StatusCode_value_get(self._cptr)
        return t;
    def set_value(self, value):
        value = str2lasso(value)
        _lasso.Samlp2StatusCode_value_set(self._cptr, value)
    value = property(get_value, set_value)


class Samlp2StatusDetail(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_status_detail_new()
        if self._cptr is None:
            raise Error('failed to create object')


class Samlp2StatusResponse(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_status_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_issuer(self):
        t = _lasso.Samlp2StatusResponse_issuer_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_issuer(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2StatusResponse_issuer_set(self._cptr, value)
    issuer = property(get_issuer, set_issuer)

    def get_extensions(self):
        t = _lasso.Samlp2StatusResponse_extensions_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_extensions(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2StatusResponse_extensions_set(self._cptr, value)
    extensions = property(get_extensions, set_extensions)

    def get_status(self):
        t = _lasso.Samlp2StatusResponse_status_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_status(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2StatusResponse_status_set(self._cptr, value)
    status = property(get_status, set_status)

    def get_id(self):
        t = _lasso.Samlp2StatusResponse_id_get(self._cptr)
        return t;
    def set_id(self, value):
        value = str2lasso(value)
        _lasso.Samlp2StatusResponse_id_set(self._cptr, value)
    id = property(get_id, set_id)
    iD = id

    def get_inResponseTo(self):
        t = _lasso.Samlp2StatusResponse_inResponseTo_get(self._cptr)
        return t;
    def set_inResponseTo(self, value):
        value = str2lasso(value)
        _lasso.Samlp2StatusResponse_inResponseTo_set(self._cptr, value)
    inResponseTo = property(get_inResponseTo, set_inResponseTo)

    def get_version(self):
        t = _lasso.Samlp2StatusResponse_version_get(self._cptr)
        return t;
    def set_version(self, value):
        value = str2lasso(value)
        _lasso.Samlp2StatusResponse_version_set(self._cptr, value)
    version = property(get_version, set_version)

    def get_issueInstant(self):
        t = _lasso.Samlp2StatusResponse_issueInstant_get(self._cptr)
        return t;
    def set_issueInstant(self, value):
        value = str2lasso(value)
        _lasso.Samlp2StatusResponse_issueInstant_set(self._cptr, value)
    issueInstant = property(get_issueInstant, set_issueInstant)

    def get_destination(self):
        t = _lasso.Samlp2StatusResponse_destination_get(self._cptr)
        return t;
    def set_destination(self, value):
        value = str2lasso(value)
        _lasso.Samlp2StatusResponse_destination_set(self._cptr, value)
    destination = property(get_destination, set_destination)

    def get_consent(self):
        t = _lasso.Samlp2StatusResponse_consent_get(self._cptr)
        return t;
    def set_consent(self, value):
        value = str2lasso(value)
        _lasso.Samlp2StatusResponse_consent_set(self._cptr, value)
    consent = property(get_consent, set_consent)


class Samlp2ArtifactResponse(Samlp2StatusResponse):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_artifact_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_any(self):
        t = _lasso.Samlp2ArtifactResponse_any_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_any(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2ArtifactResponse_any_set(self._cptr, value)
    any = property(get_any, set_any)


class Samlp2LogoutResponse(Samlp2StatusResponse):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_logout_response_new()
        if self._cptr is None:
            raise Error('failed to create object')


class Samlp2ManageNameIDResponse(Samlp2StatusResponse):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_manage_name_id_response_new()
        if self._cptr is None:
            raise Error('failed to create object')


class Samlp2NameIDMappingResponse(Samlp2StatusResponse):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_name_id_mapping_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_nameId(self):
        t = _lasso.Samlp2NameIDMappingResponse_nameId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_nameId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2NameIDMappingResponse_nameId_set(self._cptr, value)
    nameId = property(get_nameId, set_nameId)

    def get_encryptedId(self):
        t = _lasso.Samlp2NameIDMappingResponse_encryptedId_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_encryptedId(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2NameIDMappingResponse_encryptedId_set(self._cptr, value)
    encryptedId = property(get_encryptedId, set_encryptedId)


class Samlp2Response(Samlp2StatusResponse):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_response_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_assertion(self):
        t = _lasso.Samlp2Response_assertion_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_assertion(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Samlp2Response_assertion_set(self._cptr, value)
    assertion = property(get_assertion, set_assertion)

    def get_encryptedAssertion(self):
        t = _lasso.Samlp2Response_encryptedAssertion_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_encryptedAssertion(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Samlp2Response_encryptedAssertion_set(self._cptr, value)
    encryptedAssertion = property(get_encryptedAssertion, set_encryptedAssertion)


class Samlp2SubjectQueryAbstract(Samlp2RequestAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_subject_query_abstract_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_subject(self):
        t = _lasso.Samlp2SubjectQueryAbstract_subject_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_subject(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2SubjectQueryAbstract_subject_set(self._cptr, value)
    subject = property(get_subject, set_subject)


class Samlp2AttributeQuery(Samlp2SubjectQueryAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_attribute_query_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_attribute(self):
        t = _lasso.Samlp2AttributeQuery_attribute_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_attribute(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.Samlp2AttributeQuery_attribute_set(self._cptr, value)
    attribute = property(get_attribute, set_attribute)


class Samlp2AuthnQuery(Samlp2SubjectQueryAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_authn_query_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_requestedAuthnContext(self):
        t = _lasso.Samlp2AuthnQuery_requestedAuthnContext_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_requestedAuthnContext(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2AuthnQuery_requestedAuthnContext_set(self._cptr, value)
    requestedAuthnContext = property(get_requestedAuthnContext, set_requestedAuthnContext)

    def get_sessionIndex(self):
        t = _lasso.Samlp2AuthnQuery_sessionIndex_get(self._cptr)
        return t;
    def set_sessionIndex(self, value):
        value = str2lasso(value)
        _lasso.Samlp2AuthnQuery_sessionIndex_set(self._cptr, value)
    sessionIndex = property(get_sessionIndex, set_sessionIndex)


class Samlp2AuthzDecisionQuery(Samlp2SubjectQueryAbstract):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_authz_decision_query_new()
        if self._cptr is None:
            raise Error('failed to create object')

    def get_action(self):
        t = _lasso.Samlp2AuthzDecisionQuery_action_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_action(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2AuthzDecisionQuery_action_set(self._cptr, value)
    action = property(get_action, set_action)

    def get_evidence(self):
        t = _lasso.Samlp2AuthzDecisionQuery_evidence_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_evidence(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.Samlp2AuthzDecisionQuery_evidence_set(self._cptr, value)
    evidence = property(get_evidence, set_evidence)

    def get_resource(self):
        t = _lasso.Samlp2AuthzDecisionQuery_resource_get(self._cptr)
        return t;
    def set_resource(self, value):
        value = str2lasso(value)
        _lasso.Samlp2AuthzDecisionQuery_resource_set(self._cptr, value)
    resource = property(get_resource, set_resource)


class Samlp2Terminate(Node):
    def __init__(self, ):
        self._cptr = _lasso.samlp2_terminate_new()
        if self._cptr is None:
            raise Error('failed to create object')


class SoapBody(Node):
    def __init__(self, ):
        self._cptr = _lasso.soap_body_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromMessage(cls, message):
         return cptrToPy(_lasso.soap_body_new_from_message(str2lasso(message)))

    def get_any(self):
        t = _lasso.SoapBody_any_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_any(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SoapBody_any_set(self._cptr, value)
    any = property(get_any, set_any)

    def get_id(self):
        t = _lasso.SoapBody_id_get(self._cptr)
        return t;
    def set_id(self, value):
        value = str2lasso(value)
        _lasso.SoapBody_id_set(self._cptr, value)
    id = property(get_id, set_id)


class SoapDetail(Node):
    def __init__(self, ):
        self._cptr = _lasso.soap_detail_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromMessage(cls, message):
         return cptrToPy(_lasso.soap_detail_new_from_message(str2lasso(message)))

    def get_any(self):
        t = _lasso.SoapDetail_any_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_any(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SoapDetail_any_set(self._cptr, value)
    any = property(get_any, set_any)


class SoapEnvelope(Node):
    def __init__(self, body):
        self._cptr = _lasso.soap_envelope_new(body and body._cptr)
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromMessage(cls, message):
         return cptrToPy(_lasso.soap_envelope_new_from_message(str2lasso(message)))

    @classmethod
    def newFull(cls, ):
         return cptrToPy(_lasso.soap_envelope_new_full())

    def get_header(self):
        t = _lasso.SoapEnvelope_header_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_header(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SoapEnvelope_header_set(self._cptr, value)
    header = property(get_header, set_header)

    def get_body(self):
        t = _lasso.SoapEnvelope_body_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_body(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SoapEnvelope_body_set(self._cptr, value)
    body = property(get_body, set_body)


class SoapFault(Node):
    def __init__(self, ):
        self._cptr = _lasso.soap_fault_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromMessage(cls, message):
         return cptrToPy(_lasso.soap_fault_new_from_message(str2lasso(message)))

    @classmethod
    def newFull(cls, faultcode, faultstring):
         return cptrToPy(_lasso.soap_fault_new_full(str2lasso(faultcode), str2lasso(faultstring)))

    def get_faultcode(self):
        t = _lasso.SoapFault_faultcode_get(self._cptr)
        return t;
    def set_faultcode(self, value):
        value = str2lasso(value)
        _lasso.SoapFault_faultcode_set(self._cptr, value)
    faultcode = property(get_faultcode, set_faultcode)

    def get_faultstring(self):
        t = _lasso.SoapFault_faultstring_get(self._cptr)
        return t;
    def set_faultstring(self, value):
        value = str2lasso(value)
        _lasso.SoapFault_faultstring_set(self._cptr, value)
    faultstring = property(get_faultstring, set_faultstring)

    def get_faultactor(self):
        t = _lasso.SoapFault_faultactor_get(self._cptr)
        return t;
    def set_faultactor(self, value):
        _lasso.SoapFault_faultactor_set(self._cptr, value)
    faultactor = property(get_faultactor, set_faultactor)

    def get_detail(self):
        t = _lasso.SoapFault_detail_get(self._cptr)
        t = cptrToPy(t)
        return t;
    def set_detail(self, value):
        if value is not None:
            value = value and value._cptr
        _lasso.SoapFault_detail_set(self._cptr, value)
    detail = property(get_detail, set_detail)


class SoapHeader(Node):
    def __init__(self, ):
        self._cptr = _lasso.soap_header_new()
        if self._cptr is None:
            raise Error('failed to create object')

    @classmethod
    def newFromMessage(cls, message):
         return cptrToPy(_lasso.soap_header_new_from_message(str2lasso(message)))

    def get_other(self):
        t = _lasso.SoapHeader_other_get(self._cptr)
        if not t: return t
        t = tuple([cptrToPy(x) for x in t])
        return t;
    def set_other(self, value):
        if value is not None:
            value = tuple([x._cptr for x in value])
        _lasso.SoapHeader_other_set(self._cptr, value)
    other = property(get_other, set_other)


strError = _lasso.strError
init = _lasso.init
shutdown = _lasso.shutdown
checkVersion = _lasso.check_version
setFlag = _lasso.set_flag
getRequestTypeFromSoapMsg = _lasso.get_request_type_from_soap_msg
isLibertyQuery = _lasso.isLibertyQuery
profileGetIssuer = _lasso.profile_get_issuer
profileGetInResponseTo = _lasso.profile_get_in_response_to
isSamlQuery = _lasso.isSamlQuery
saml2NameIdBuildPersistent = _lasso.saml2_name_id_build_persistent
saml2EncryptedElementBuildEncryptedPersistentNameId = _lasso.saml2_encrypted_element_build_encrypted_persistent_name_id
buildUniqueId = _lasso.build_unique_id
registerDstService = _lasso.register_dst_service
getPrefixForDstServiceHref = _lasso.get_prefix_for_dst_service_href
registerIdwsf2DstService = _lasso.register_idwsf2_dst_service
getPrefixForIdwsf2DstServiceHref = _lasso.get_prefix_for_idwsf2_dst_service_href


def _profileGetIssuer(cls, *args, **kwargs):
    return profileGetIssuer(*args, **kwargs)

Profile.getIssuer = classmethod(_profileGetIssuer)

import lasso

# backward compatibility with the SWIG binding

WSF_SUPPORT = WSF_ENABLED

Profile.isIdentityDirty = property(Profile.hasDirtyIdentity)
Profile.isSessionDirty = property(Profile.hasDirtySession)

def identity_get_provider_ids(self):
    return self.federations.keys()
Identity.providerIds = property(identity_get_provider_ids)

def server_get_provider_ids(self):
    return self.providers.keys()
Server.providerIds = property(server_get_provider_ids)

def session_get_provider_ids(self):
    return self.assertions.keys()
Session.providerIds = property(session_get_provider_ids)

def LassoNode__getstate__(self):
    return { '__dump__': self.dump() }

def LassoNode__setstate__(self, d):
    self._cptr = _lasso.node_new_from_dump(d.pop('__dump__'))

Node.__getstate__ = LassoNode__getstate__
Node.__setstate__ = LassoNode__setstate__

Samlp2AuthnRequest.nameIDPolicy = Samlp2AuthnRequest.nameIdPolicy
LibAuthnRequest.nameIDPolicy = LibAuthnRequest.nameIdPolicy
Saml2Subject.nameID = Saml2Subject.nameId
MiscTextNode.text_child = MiscTextNode.textChild
NodeList = list
StringList = list
StringDict = dict
registerIdWsf2DstService = registerIdwsf2DstService

if WSF_SUPPORT:
    DiscoDescription_newWithBriefSoapHttpDescription = DiscoDescription.newWithBriefSoapHttpDescription
    Discovery.buildRequestMsg = Discovery.buildSoapRequestMsg
    InteractionProfileService.buildRequestMsg = InteractionProfileService.buildSoapRequestMsg
    InteractionProfileService.buildResponseMsg = InteractionProfileService.buildSoapResponseMsg
    DataService.buildRequestMsg = DataService.buildSoapRequestMsg
    DiscoModifyResponse.newEntryIds = DiscoModifyResponse.newEntryIDs

