'''OpenGL extension ARM.shader_framebuffer_fetch_depth_stencil

This module customises the behaviour of the 
OpenGL.raw.GLES2.ARM.shader_framebuffer_fetch_depth_stencil to provide a more 
Python-friendly API

Overview (from the spec)
	
	Existing extensions, such as EXT_shader_framebuffer_fetch, allow fragment
	shaders to read existing framebuffer color data as input. This enables
	use-cases such as programmable blending, and other operations that may not
	be possible to implement with fixed-function blending.
	
	This extension adds similar capabilities for depth and stencil values.
	
	One use-case for this is soft depth-blending of particles. Normally, this
	would require two render passes: one that writes out the depth values of the
	background geometry to a depth texture, and one that renders the particles
	while reading from the depth texture to do the blending. This extension
	allows this to be done in a single pass.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARM/shader_framebuffer_fetch_depth_stencil.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.ARM.shader_framebuffer_fetch_depth_stencil import *
from OpenGL.raw.GLES2.ARM.shader_framebuffer_fetch_depth_stencil import _EXTENSION_NAME

def glInitShaderFramebufferFetchDepthStencilARM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION