# NOTE: Derived from web_diary_dir/lib/DateTime/Time.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package DateTime::Time;

#line 205 "web_diary_dir/lib/DateTime/Time.pm (autosplit into web_diary_dir/lib/auto/DateTime/Time/Decrement.al)"
sub Decrement ($$)
{
    my ($self, $quantity) = @_;
    if (ref $quantity){                # blessed
	return $self->GetTime - $quantity->GetTime;
    }
    my ($num, $unit) = $quantity =~ /^(\d+)([hms])$/;
    if ($quantity eq '1'){
	$num = 1;
	$unit = 's';
    }
    if ($unit eq 's'){
	my $sec = $self->sec;
	$sec -= $num;
	if ($sec < 0){
	    my $min = int($sec*(-1)/60)+1;
#	    print "min:$min, sec: $sec\n";
	    $self->Decrement("${min}m");
	}
	$self->sec($sec % 60);
    } elsif ($unit eq 'm'){
	my $min = $self->min;
	$min -= $num;
	if ($min < 0){
	    my $hour = int($min*(-1)/60)+1;
	    $self->Decrement("${hour}h");
	}
	$self->min($min % 60);
    } elsif ($unit eq 'h'){
	my $hour = $self->hour;
	$hour -= $num;
	if ($hour < 0){
	    my $day = int($hour*(-1)/24)+1;
	    $self->SUPER::Decrement("${day}D");
	}
	$self->hour($hour%24);
    } else {
	$self->SUPER::Decrement($quantity);
    }
    $self;
}

# end of DateTime::Time::Decrement
1;
