/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.channels;

import gnu.java.nio.FileLockImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class FileChannelImpl
extends FileChannel {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int APPEND = 4;
    public static final int EXCL = 8;
    public static final int SYNC = 16;
    public static final int DSYNC = 32;
    public static FileChannelImpl in;
    public static FileChannelImpl out;
    public static FileChannelImpl err;
    private int fd;
    private int mode;
    final String description;

    private static final native void init();

    public static final FileChannelImpl create(File file, int n) throws FileNotFoundException {
        return new FileChannelImpl(file, n);
    }

    private final native int open(String var1, int var2) throws FileNotFoundException;

    public final native int available() throws IOException;

    private final native long implPosition() throws IOException;

    private final native void seek(long var1) throws IOException;

    private final native void implTruncate(long var1) throws IOException;

    public final native void unlock(long var1, long var3) throws IOException;

    public final native long size() throws IOException;

    protected final native void implCloseChannel() throws IOException;

    protected final void finalize() throws IOException {
        if (this.fd != -1) {
            this.close();
        }
    }

    public final int read(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[byteBuffer.remaining()];
        int n = this.read(byArray, 0, byArray.length);
        if (n > 0) {
            byteBuffer.put(byArray, 0, n);
        }
        return n;
    }

    public final int read(ByteBuffer byteBuffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("position: " + l);
        }
        long l2 = this.implPosition();
        this.position(l);
        int n = this.read(byteBuffer);
        this.position(l2);
        return n;
    }

    public final native int read() throws IOException;

    public final native int read(byte[] var1, int var2, int var3) throws IOException;

    public final long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        int n3 = n;
        while (n3 < n + n2) {
            l += (long)this.read(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    public final int write(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.write(byArray, byteBuffer.arrayOffset() + byteBuffer.position(), n);
            byteBuffer.position(byteBuffer.position() + n);
        } else {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, 0, n);
            this.write(byArray, 0, n);
        }
        return n;
    }

    public final int write(ByteBuffer byteBuffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("position: " + l);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        long l2 = this.implPosition();
        this.seek(l);
        int n = this.write(byteBuffer);
        this.seek(l2);
        return n;
    }

    public final native void write(byte[] var1, int var2, int var3) throws IOException;

    public final native void write(int var1) throws IOException;

    public final long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        int n3 = n;
        while (n3 < n + n2) {
            l += (long)this.write(byteBufferArray[n3]);
            ++n3;
        }
        return l;
    }

    public final native MappedByteBuffer mapImpl(char var1, long var2, int var4) throws IOException;

    public final MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        char c = '\u0000';
        if (mapMode == FileChannel.MapMode.READ_ONLY) {
            c = 'r';
            if ((this.mode & 1) == 0) {
                throw new NonReadableChannelException();
            }
        } else if (mapMode == FileChannel.MapMode.READ_WRITE || mapMode == FileChannel.MapMode.PRIVATE) {
            char c2 = c = mapMode == FileChannel.MapMode.READ_WRITE ? (char)'+' : 'c';
            if ((this.mode & 2) != 2) {
                throw new NonWritableChannelException();
            }
            if ((this.mode & 1) != 1) {
                throw new NonReadableChannelException();
            }
        } else {
            throw new IllegalArgumentException("mode: " + mapMode);
        }
        if (l < 0L || l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position: " + l + ", size: " + l2);
        }
        return this.mapImpl(c, l, (int)l2);
    }

    public final void force(boolean bl) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.force();
    }

    private final native void force();

    private final int smallTransferTo(long l, int n, WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.map(FileChannel.MapMode.READ_ONLY, l, n);
        }
        catch (IOException iOException) {
            byteBuffer = ByteBuffer.allocate(n);
            this.read(byteBuffer, l);
            byteBuffer.flip();
        }
        return writableByteChannel.write(byteBuffer);
    }

    public final long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("position: " + l + ", count: " + l2);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        long l3 = 0L;
        while (l2 > 0L) {
            int n = this.smallTransferTo(l, (int)Math.min(l2, 65536L), writableByteChannel);
            if (n < 0) break;
            l3 += (long)n;
            l += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    private final int smallTransferFrom(ReadableByteChannel readableByteChannel, long l, int n) throws IOException {
        ByteBuffer byteBuffer = null;
        if (readableByteChannel instanceof FileChannel) {
            try {
                byteBuffer = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, l, n);
            }
            catch (IOException iOException) {}
        }
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(n);
            readableByteChannel.read(byteBuffer);
            byteBuffer.flip();
        }
        return this.write(byteBuffer, l);
    }

    public final long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("position: " + l + ", count: " + l2);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        long l3 = 0L;
        while (l2 > 0L) {
            int n = this.smallTransferFrom(readableByteChannel, l, (int)Math.min(l2, 65536L));
            if (n < 0) break;
            l3 += (long)n;
            l += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    private final void lockCheck(long l, long l2, boolean bl) throws IOException {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("position: " + l + ", size: " + l2);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (bl && (this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        if (!bl && (this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        FileLockImpl fileLockImpl;
        this.lockCheck(l, l2, bl);
        boolean bl2 = false;
        try {
            this.begin();
            boolean bl3 = this.lock(l, l2, bl, false);
            bl2 = true;
            fileLockImpl = bl3 ? new FileLockImpl(this, l, l2, bl) : null;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.end(bl2);
            throw throwable;
        }
        this.end(bl2);
        return fileLockImpl;
    }

    private final native boolean lock(long var1, long var3, boolean var5, boolean var6) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileLock lock(long l, long l2, boolean bl) throws IOException {
        FileLockImpl fileLockImpl;
        this.lockCheck(l, l2, bl);
        boolean bl2 = false;
        try {
            boolean bl3 = this.lock(l, l2, bl, true);
            bl2 = true;
            fileLockImpl = bl3 ? new FileLockImpl(this, l, l2, bl) : null;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.end(bl2);
            throw throwable;
        }
        this.end(bl2);
        return fileLockImpl;
    }

    public final long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition();
    }

    public final FileChannel position(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("newPosition: " + l);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.seek(l);
        return this;
    }

    public final FileChannel truncate(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("size: " + l);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        if (l < this.size()) {
            this.implTruncate(l);
        }
        return this;
    }

    public final String toString() {
        return this.getClass() + "[fd=" + this.fd + ",mode=" + this.mode + ',' + this.description + ']';
    }

    private final /* synthetic */ void this() {
        this.fd = -1;
    }

    private FileChannelImpl(File file, int n) throws FileNotFoundException {
        String string;
        this.this();
        this.description = string = file.getPath();
        this.fd = this.open(string, n);
        this.mode = n;
        if (file.isDirectory()) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
            throw new FileNotFoundException(this.description + " is a directory");
        }
    }

    FileChannelImpl(int n, int n2) {
        this.this();
        this.fd = n;
        this.mode = n2;
        this.description = "descriptor(" + n + ')';
    }

    static {
        System.loadLibrary("javanio");
        FileChannelImpl.init();
        in = new FileChannelImpl(0, 1);
        out = new FileChannelImpl(1, 2);
        err = new FileChannelImpl(2, 2);
    }
}

