/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import lts.Alphabet;
import lts.CompactState;
import lts.CompositeState;
import lts.EventClient;
import lts.EventManager;
import lts.LTSEvent;
import lts.LTSOutput;

public class AlphabetWindow
extends JSplitPane
implements LTSOutput,
EventClient {
    public static boolean fontFlag = false;
    JTextArea output;
    JList list;
    JScrollPane left;
    JScrollPane right;
    EventManager eman;
    int Nmach;
    int selectedMachine = 0;
    Alphabet current = null;
    int expandLevel = 0;
    CompactState[] sm;
    Font f1 = new Font("Monospaced", 0, 12);
    Font f2 = new Font("Monospaced", 1, 18);
    Font f3 = new Font("SansSerif", 0, 12);
    Font f4 = new Font("SansSerif", 1, 18);
    AlphabetWindow thisWindow;
    private static final int MAXPRINT = 400;

    public AlphabetWindow(CompositeState compositeState, EventManager eventManager) {
        this.eman = eventManager;
        this.thisWindow = this;
        this.output = new JTextArea(23, 50);
        this.output.setEditable(false);
        this.right = new JScrollPane(this.output, 20, 30);
        this.output.setBackground(Color.white);
        this.output.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new PrintAction());
        this.left = new JScrollPane(this.list, 20, 30);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", this.right);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setOrientation(1);
        jPanel.add("West", jToolBar);
        jToolBar.add(this.createTool("icon/expanded.gif", "Expand Most", new ExpandMostAction()));
        jToolBar.add(this.createTool("icon/expand.gif", "Expand", new ExpandMoreAction()));
        jToolBar.add(this.createTool("icon/collapse.gif", "Collapse", new ExpandLessAction()));
        jToolBar.add(this.createTool("icon/collapsed.gif", "Most Concise", new ExpandLeastAction()));
        if (eventManager != null) {
            eventManager.addClient(this);
        }
        this.new_machines(compositeState);
        this.setLeftComponent(this.left);
        this.setRightComponent(jPanel);
        this.setDividerLocation(150);
        this.setBigFont(fontFlag);
        this.validate();
    }

    public void ltsAction(LTSEvent lTSEvent) {
        switch (lTSEvent.kind) {
            case 0: {
                break;
            }
            case 1: {
                this.new_machines((CompositeState)lTSEvent.info);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void out(String string) {
        this.output.append(string);
    }

    public void outln(String string) {
        this.output.append(string + "\n");
    }

    public void clearOutput() {
        this.output.setText("");
    }

    private void new_machines(CompositeState compositeState) {
        int n;
        Object object;
        int n2;
        int n3 = n2 = compositeState != null && compositeState.composition != null ? 1 : 0;
        if (compositeState != null && compositeState.machines != null && compositeState.machines.size() > 0) {
            this.sm = new CompactState[compositeState.machines.size() + n2];
            object = compositeState.machines.elements();
            n = 0;
            while (object.hasMoreElements()) {
                this.sm[n] = (CompactState)object.nextElement();
                ++n;
            }
            this.Nmach = this.sm.length;
            if (n2 == 1) {
                this.sm[this.Nmach - 1] = compositeState.composition;
            }
        } else {
            this.Nmach = 0;
        }
        object = new DefaultListModel<String>();
        n = 0;
        while (n < this.Nmach) {
            if (n2 == 1 && n == this.Nmach - 1) {
                ((DefaultListModel)object).addElement("||" + this.sm[n].name);
            } else {
                ((DefaultListModel)object).addElement(this.sm[n].name);
            }
            ++n;
        }
        this.list.setModel(object);
        if (this.selectedMachine >= this.Nmach) {
            this.selectedMachine = 0;
        }
        this.current = null;
        this.clearOutput();
    }

    protected JButton createTool(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton((Icon)new ImageIcon(this.getClass().getResource(string))){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        jButton.setRequestFocusEnabled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public void setBigFont(boolean bl) {
        fontFlag = bl;
        if (fontFlag) {
            this.output.setFont(this.f2);
            this.list.setFont(this.f4);
        } else {
            this.output.setFont(this.f1);
            this.list.setFont(this.f3);
        }
    }

    public void removeClient() {
        if (this.eman != null) {
            this.eman.removeClient(this);
        }
    }

    public void copy() {
        this.output.copy();
    }

    public void saveFile() {
        int n;
        String string;
        FileDialog fileDialog = new FileDialog((Frame)this.getTopLevelAncestor(), "Save text in:", 1);
        if (this.Nmach > 0) {
            string = this.sm[this.selectedMachine].name;
            n = string.indexOf(58, 0);
            if (n > 0) {
                string = string.substring(0, n);
            }
            fileDialog.setFile(string + ".txt");
        }
        fileDialog.show();
        string = fileDialog.getFile();
        if (string != null) {
            try {
                n = string.indexOf(46, 0);
                string = string.substring(0, n) + "." + "txt";
                FileOutputStream fileOutputStream = new FileOutputStream(fileDialog.getDirectory() + string);
                PrintStream printStream = new PrintStream(fileOutputStream);
                String string2 = this.output.getText();
                printStream.print(string2);
                printStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                this.outln("Error saving file: " + iOException);
            }
        }
    }

    class PrintAction
    implements ListSelectionListener {
        PrintAction() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = AlphabetWindow.this.list.getSelectedIndex();
            if (n < 0 || n >= AlphabetWindow.this.Nmach) {
                return;
            }
            AlphabetWindow.this.selectedMachine = n;
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current = new Alphabet(AlphabetWindow.this.sm[n]);
            if (AlphabetWindow.this.expandLevel > AlphabetWindow.this.current.maxLevel) {
                AlphabetWindow.this.expandLevel = AlphabetWindow.this.current.maxLevel;
            }
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }

    class ExpandLeastAction
    implements ActionListener {
        ExpandLeastAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AlphabetWindow.this.current == null) {
                return;
            }
            AlphabetWindow.this.expandLevel = 0;
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }

    class ExpandMostAction
    implements ActionListener {
        ExpandMostAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AlphabetWindow.this.current == null) {
                return;
            }
            AlphabetWindow.this.expandLevel = AlphabetWindow.this.current.maxLevel;
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }

    class ExpandLessAction
    implements ActionListener {
        ExpandLessAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AlphabetWindow.this.current == null) {
                return;
            }
            if (AlphabetWindow.this.expandLevel > 0) {
                --AlphabetWindow.this.expandLevel;
            }
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }

    class ExpandMoreAction
    implements ActionListener {
        ExpandMoreAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AlphabetWindow.this.current == null) {
                return;
            }
            if (AlphabetWindow.this.expandLevel < AlphabetWindow.this.current.maxLevel) {
                ++AlphabetWindow.this.expandLevel;
            }
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }
}

