/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

public class ColorUtils {
    static final float OFFSET_180 = 180.0f;
    static final float OFFSET_100 = 100.0f;

    public static Color getDerivedColor(Color color, float ratio) {
        if (color != null) {
            float[] hsl = ColorUtils.RGBtoHSL(color);
            if ((double)hsl[2] < 0.4) {
                hsl[2] = 0.4f;
            }
            hsl[2] = (double)ratio > 0.5 ? (float)((double)hsl[2] + (double)((1.0f - hsl[2]) * 2.0f) * ((double)ratio - 0.5)) : (float)((double)hsl[2] - (double)(hsl[2] * 2.0f) * (0.5 - (double)ratio));
            int colorRGB = ColorUtils.HSLtoRGB(hsl);
            return new ColorUIResource(colorRGB);
        }
        return null;
    }

    public static float[] RGBtoHSL(Color colorRGB) {
        float l;
        float s2;
        float h2;
        float r = (float)colorRGB.getRed() / 256.0f;
        float g2 = (float)colorRGB.getGreen() / 256.0f;
        float b = (float)colorRGB.getBlue() / 256.0f;
        float maxColor = Math.max(r, Math.max(g2, b));
        float minColor = Math.min(r, Math.min(g2, b));
        if (r == g2 && g2 == b) {
            h2 = 0.0f;
            s2 = 0.0f;
            l = r;
        } else {
            l = (minColor + maxColor) / 2.0f;
            s2 = (double)l < 0.5 ? (maxColor - minColor) / (maxColor + minColor) : (maxColor - minColor) / (2.0f - maxColor - minColor);
            h2 = r == maxColor ? (g2 - b) / (maxColor - minColor) : (g2 == maxColor ? 2.0f + (b - r) / (maxColor - minColor) : 4.0f + (r - g2) / (maxColor - minColor));
            if ((h2 /= 6.0f) < 0.0f) {
                h2 += 1.0f;
            }
        }
        float[] hsl = new float[]{h2, s2, l};
        return hsl;
    }

    public static int HSLtoRGB(float[] hsl) {
        float r;
        float g2;
        float b;
        float h2 = hsl[0];
        float s2 = hsl[1];
        float l = hsl[2];
        if (s2 == 0.0f) {
            g2 = b = l;
            r = b;
        } else {
            float temp2 = (double)l < 0.5 ? l * (1.0f + s2) : l + s2 - l * s2;
            float temp1 = 2.0f * l - temp2;
            float tempr = h2 + 0.33333334f;
            if (tempr > 1.0f) {
                tempr -= 1.0f;
            }
            float tempg = h2;
            float tempb = h2 - 0.33333334f;
            if (tempb < 0.0f) {
                tempb += 1.0f;
            }
            r = (double)tempr < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempr : ((double)tempr < 0.5 ? temp2 : ((double)tempr < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempr) * 6.0f : temp1));
            g2 = (double)tempg < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempg : ((double)tempg < 0.5 ? temp2 : ((double)tempg < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempg) * 6.0f : temp1));
            b = (double)tempb < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempb : ((double)tempb < 0.5 ? temp2 : ((double)tempb < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempb) * 6.0f : temp1));
        }
        int result = 0;
        result += ((int)(r * 255.0f) & 0xFF) << 16;
        result += ((int)(g2 * 255.0f) & 0xFF) << 8;
        return result += (int)(b * 255.0f) & 0xFF;
    }

    public static int[] calculateDifferent(float[] from, float[] to) {
        int[] diff = new int[]{ColorUtils.floatToInteger(from[0], to[0], 180.0f, true), ColorUtils.floatToInteger(from[1], to[1], 100.0f, false), ColorUtils.floatToInteger(from[2], to[2], 100.0f, false)};
        return diff;
    }

    public static float[] applyDifference(float[] from, int[] diff) {
        float[] to = new float[]{ColorUtils.integerToFloat(from[0], diff[0], 180.0f, true), ColorUtils.integerToFloat(from[1], diff[1], 100.0f, false), ColorUtils.integerToFloat(from[2], diff[2], 100.0f, false)};
        return to;
    }

    private static int floatToInteger(float f, float f2, float offset, boolean rotate) {
        if (rotate) {
            int i = (int)((f2 - f) * 2.0f * offset);
            if ((float)i > offset) {
                return i - (int)(2.0f * offset);
            }
            if ((float)i < -offset) {
                return i + (int)(2.0f * offset);
            }
            return i;
        }
        if (f != 0.0f) {
            return (int)((f2 - f) * offset / f);
        }
        return (int)((f2 - f) * offset);
    }

    private static float integerToFloat(float f, int i, float offset, boolean rotate) {
        if (rotate) {
            float v = f + (float)i / (2.0f * offset);
            if (v < 0.0f) {
                return v + 1.0f;
            }
            if (v > 1.0f) {
                return v - 1.0f;
            }
            return v;
        }
        if (i > 0) {
            return f + (1.0f - f) * (float)i / offset;
        }
        return f + f * (float)i / offset;
    }

    public static Color[] toColors(boolean hasAlpha, int ... colors) {
        Color[] result = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            result[i] = new Color(colors[i], hasAlpha);
        }
        return result;
    }

    public static Color toGrayscale(Color c) {
        int gray = (int)((double)c.getRed() * 0.3 + (double)c.getGreen() * 0.59 + (double)c.getBlue() * 0.11);
        return new Color(gray, gray, gray);
    }
}

