/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipFile;

final class VMClassLoader {
    static final HashMap definedPackages = new HashMap();
    static final HashMap bootjars;

    static final Class defineClass(ClassLoader cl, String name, byte[] data, int offset, int len, ProtectionDomain pd) throws ClassFormatError {
        return VMClassLoader.nativeDefineClass(cl.vmData, name.replace('.', '/'), data, offset, len, pd);
    }

    static final native Class nativeDefineClass(byte[] var0, String var1, byte[] var2, int var3, int var4, ProtectionDomain var5) throws ClassFormatError;

    static final Class defineArray(ClassLoader cl, String name, Class element) throws ClassFormatError {
        return VMClassLoader.nativeDefineArray(cl.vmData, name.replace('.', '/'), element);
    }

    static final native Class nativeDefineArray(byte[] var0, String var1, Class var2) throws ClassFormatError;

    static final native byte[] newClassLoaderVmData(ClassLoader var0);

    static final native Class getArray(Class var0);

    static final native Class getPrimitiveArray(char var0);

    static final Class defineClass(ClassLoader cl, String name, byte[] data, int offset, int len) throws ClassFormatError {
        return VMClassLoader.defineClass(cl, name, data, offset, len, null);
    }

    static final native void linkClass(Class var0);

    static final native void initializeClass(Class var0);

    static final Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return VMClassLoader.nativeLoadClass(name.replace('.', '/'), resolve);
        }
        catch (Error e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    static final Class createArray(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return VMClassLoader.nativeCreateArray(name.replace('.', '/'), resolve);
        }
        catch (Error e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private static final native Class nativeLoadClass(String var0, boolean var1);

    private static final native Class nativeCreateArray(String var0, boolean var1);

    private static final native String nativeGetResource(String var0);

    static final URL getResource(String name) {
        URL result = null;
        String path = VMClassLoader.nativeGetResource(name);
        if (path == null) {
            return null;
        }
        try {
            result = new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final Enumeration getResources(String name) {
        StringTokenizer st = new StringTokenizer(SystemProperties.getProperty("java.boot.class.path", "."), File.pathSeparator);
        Vector v = new Vector();
        while (st.hasMoreTokens()) {
            String zname;
            ZipFile zip;
            File file;
            block14: {
                file = new File(st.nextToken());
                if (file.isDirectory()) {
                    File fullFile = new File(file, name);
                    if (!fullFile.exists() || !fullFile.isFile()) continue;
                    try {
                        v.add(new URL("file://" + fullFile.getAbsolutePath()));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new Error(e);
                    }
                }
                if (!file.isFile()) continue;
                HashMap hashMap = bootjars;
                synchronized (hashMap) {
                    zip = (ZipFile)bootjars.get(file.getName());
                    // MONITOREXIT @DISABLED, blocks:[1, 5, 12] lbl19 : MonitorExitStatement: MONITOREXIT : var5_5
                    if (zip != null) break block14;
                }
                try {
                    zip = new ZipFile(file);
                    HashMap hashMap2 = bootjars;
                    synchronized (hashMap2) {
                        bootjars.put(file.getName(), zip);
                    }
                }
                catch (IOException e) {
                    continue;
                }
            }
            String string = zname = name.startsWith("/") ? name.substring(1) : name;
            if (zip.getEntry(zname) == null) continue;
            try {
                v.add(new URL("jar:file://" + file.getAbsolutePath() + "!/" + zname));
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
        }
        return v.elements();
    }

    private static final String[] getBootPackages() {
        return new String[0];
    }

    static final Package getPackage(String name) {
        return (Package)definedPackages.get(name);
    }

    static final Package[] getPackages() {
        Object[] packages = new Package[definedPackages.size()];
        definedPackages.values().toArray(packages);
        return packages;
    }

    static final native Class getPrimitiveClass(char var0);

    static final boolean defaultAssertionStatus() {
        return true;
    }

    static final Map packageAssertionStatus() {
        return new HashMap();
    }

    static final Map classAssertionStatus() {
        return new HashMap();
    }

    static final ClassLoader getSystemClassLoader() {
        return ClassLoader.defaultGetSystemClassLoader();
    }

    static final native Class findLoadedClass(ClassLoader var0, String var1);

    VMClassLoader() {
    }

    static {
        String[] packages = VMClassLoader.getBootPackages();
        if (packages != null) {
            String specName = SystemProperties.getProperty("java.specification.name");
            String vendor = SystemProperties.getProperty("java.specification.vendor");
            String version = SystemProperties.getProperty("java.specification.version");
            int i = 0;
            while (i < packages.length) {
                Package p = new Package(packages[i], specName, vendor, version, "GNU Classpath", "GNU", "1.13", null);
                definedPackages.put(packages[i], p);
                ++i;
            }
        }
        bootjars = new HashMap();
    }
}

