/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public class PopupFactory {
    private static PopupFactory sharedFactory;

    public static void setSharedInstance(PopupFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        sharedFactory = factory;
    }

    public static PopupFactory getSharedInstance() {
        if (sharedFactory == null) {
            sharedFactory = new PopupFactory();
        }
        return sharedFactory;
    }

    public Popup getPopup(Component owner, Component contents, int x, int y) {
        Popup popup = null;
        boolean lightweightEnabled = true;
        if (contents instanceof JPopupMenu) {
            JPopupMenu menu = (JPopupMenu)contents;
            lightweightEnabled = menu.isLightWeightPopupEnabled();
        }
        JRootPane root = SwingUtilities.getRootPane(owner);
        Point rootLoc = root.getLocationOnScreen();
        Dimension contentsSize = contents.getSize();
        Dimension rootSize = root.getSize();
        popup = x >= rootLoc.x && y > rootLoc.y && x - rootLoc.x + contentsSize.width < rootSize.width && y - rootLoc.y + contentsSize.height < rootSize.height ? new Popup.LightweightPopup(owner, contents, x, y) : new Popup.JWindowPopup(owner, contents, x, y);
        return popup;
    }
}

