/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColInputDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;

public final class SelectAmountDialog
extends FreeColInputDialog<Integer> {
    private static final Logger logger = Logger.getLogger(SelectAmountDialog.class.getName());
    private static final int SELECT_CANCEL = -1;
    private static final int[] amounts = new int[]{20, 40, 50, 60, 80, 100};
    private final JComboBox<Integer> comboBox;

    public SelectAmountDialog(FreeColClient freeColClient, JFrame frame, GoodsType goodsType, int available, int defaultAmount, boolean pay) {
        super(freeColClient, frame);
        int index;
        if (pay) {
            Player player = this.getMyPlayer();
            int gold = player.getGold();
            int price = player.getMarket().getCostToBuy(goodsType);
            available = Math.min(available, gold / price);
        }
        JTextArea question = Utility.localizedTextArea("selectAmountDialog.text");
        int defaultIndex = -1;
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (index = 0; index < amounts.length; ++index) {
            if (amounts[index] < available) {
                if (amounts[index] == defaultAmount) {
                    defaultIndex = index;
                }
            } else {
                if (available == defaultAmount) {
                    defaultIndex = index;
                }
                values.add(available);
                break;
            }
            values.add(amounts[index]);
        }
        if (defaultAmount > 0 && defaultIndex < 0) {
            for (index = 0; index < values.size(); ++index) {
                if (defaultAmount >= (Integer)values.get(index)) continue;
                values.add(index, defaultAmount);
                defaultIndex = index;
                break;
            }
        }
        this.comboBox = new JComboBox<Integer>(values.toArray(new Integer[0]));
        this.comboBox.setEditable(true);
        if (defaultIndex >= 0) {
            this.comboBox.setSelectedIndex(defaultIndex);
        }
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "", ""));
        panel.add(question);
        panel.add(this.comboBox, "wrap 20, growx");
        panel.setSize(panel.getPreferredSize());
        this.initializeInputDialog(frame, true, panel, null, "ok", "cancel");
    }

    @Override
    protected Integer getInputValue() {
        Object value = this.comboBox.getSelectedItem();
        return value instanceof Integer ? (Integer)value : -1;
    }

    @Override
    public void requestFocus() {
        this.comboBox.requestFocus();
    }
}

