/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class CloseTransactionMessage
extends DOMMessage {
    private final String unitId;
    private final String settlementId;

    public CloseTransactionMessage(Unit unit, Settlement settlement) {
        super(CloseTransactionMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
    }

    public CloseTransactionMessage(Game game, Element element) {
        super(CloseTransactionMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Settlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            settlement = unit.getAdjacentSettlementSafely(this.settlementId);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().closeTransaction(serverPlayer, unit, settlement);
    }

    @Override
    public Element toXMLElement() {
        return CloseTransactionMessage.createMessage(CloseTransactionMessage.getXMLElementTagName(), "unit", this.unitId, "settlement", this.settlementId);
    }

    public static String getXMLElementTagName() {
        return "closeTransaction";
    }
}

