=begin
= sample of WebUnit( test_digit_view.rb )
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_digit_view.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'

class TestDigitView < WebUnit::TestCase

  def setup
    super
    @url = "webunit/sample/conv/digit.cgi"
  end

  def test_initial

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )

    assert_equals( 1, response.forms.size )
    assert_equals( 1, response.tables.size )

    form = response.form
    assert_urls( @url, form.action )
    assert_equals( 'post', form.method )

    parameters = form.parameters #=> array
    assert_equals( 6, parameters.size )
    i = -1

    assert_input( 'toct', 'text', '0', parameters[i+=1] )
    assert_input( 'tdec', 'text', '0', parameters[i+=1] )
    assert_input( 'thex', 'text', '0x0', parameters[i+=1] )
    assert_input( 'boct', 'submit', '8=&gt;', parameters[i+=1] )
    assert_input( 'bdec', 'submit', '10=&gt;', parameters[i+=1] )
    assert_input( 'bhex', 'submit', '16=&gt;', parameters[i+=1] )

    table = response.table
    params = form.params #=> hash
    c = 0

    assert_include( params['toct'], table.at(1,c+=1) )
    assert_include( params['boct'], table.at(2,c) )
    assert_equals( 'center', table.at(2,c).attrs['align'] )

    assert_include( params['tdec'], table.at(1,c+=1) )
    assert_include( params['bdec'], table.at(2,c) )
    assert_equals( 'center', table.at(2,c).attrs['align'] )

    assert_include( params['thex'], table.at(1,c+=1) )
    assert_include( params['bhex'], table.at(2,c) )
    assert_equals( 'center', table.at(2,c).attrs['align'] )

  end

  def test_links

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )
    assert_equals( 3, response.links.size )

    links = response.links
    i = -1

    link_ruby = links[i+=1]
    assert_equals( 'Ruby', link_ruby.data )
    url = 'http://www.ruby-lang.org/ja/'
    assert_urls( url, link_ruby.href )

    link_rubyunit = links[i+=1]
    assert_equals( 'RubyUnit', link_rubyunit.data )
    url = 'http://homepage1.nifty.com/markey/ruby/rubyunit/index.html'
    assert_urls( url, link_rubyunit.href )

    link_webunit = links[i+=1]
    assert_equals( 'WebUnit', link_webunit.data )
    url = 'http://www.jbt.co.jp/user/yuichi/ruby/webunit/index-ja.html'
    assert_urls( url, link_webunit.href )

  end

  def test_8_to

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )

    form = response.form
    params = form.params

    params['toct'].value = '017'
    response = form.submit( 'boct' )

    params = response.form.params
    assert_equals( '15', params['tdec'].value )
    assert_equals( '0xF', params['thex'].value )

  end

  def test_10_to

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )

    form = response.form
    params = form.params

    params['tdec'].value = '10'
    response = form.submit( 'bdec' )

    params = response.form.params
    assert_equals( '012', params['toct'].value )
    assert_equals( '0xA', params['thex'].value )

  end

  def test_16_to

    response = Response::get( @url )
    assert_title( 'Digit - WebUnit Sample -', response )

    form = response.form
    params = form.params

    params['thex'].value = '0x1A'
    response = form.submit( 'bhex' )

    params = response.form.params
    assert_equals( '032', params['toct'].value )
    assert_equals( '26', params['tdec'].value )

  end

end
