/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitution;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionState;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public abstract class GlyphSubstitutionSubtable
extends GlyphSubtable
implements GlyphSubstitution {
    protected GlyphSubstitutionSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage) {
        super(id, sequence, flags, format, coverage);
    }

    public int getTableType() {
        return 1;
    }

    public String getTypeName() {
        return GlyphSubstitutionTable.getLookupTypeName(this.getType());
    }

    public boolean isCompatible(GlyphSubtable subtable) {
        return subtable instanceof GlyphSubstitutionSubtable;
    }

    public boolean usesReverseScan() {
        return false;
    }

    public boolean substitute(GlyphSubstitutionState ss) {
        return false;
    }

    public static final GlyphSequence substitute(GlyphSubstitutionState ss, GlyphSubstitutionSubtable[] sta, int sequenceIndex) {
        int sequenceStart = ss.getPosition();
        boolean appliedOneShot = false;
        while (ss.hasNext()) {
            boolean applied = false;
            if (!appliedOneShot && ss.maybeApplicable()) {
                int n = sta.length;
                for (int i = 0; !applied && i < n; ++i) {
                    if (sequenceIndex < 0) {
                        applied = ss.apply(sta[i]);
                        continue;
                    }
                    if (ss.getPosition() != sequenceStart + sequenceIndex || !(applied = ss.apply(sta[i]))) continue;
                    appliedOneShot = true;
                }
            }
            if (!applied || !ss.didConsume()) {
                ss.applyDefault();
            }
            ss.next();
        }
        return ss.getOutput();
    }

    public static final GlyphSequence substitute(GlyphSequence gs, String script, String language, String feature, GlyphSubstitutionSubtable[] sta, ScriptContextTester sct) {
        return GlyphSubstitutionSubtable.substitute(new GlyphSubstitutionState(gs, script, language, feature, sct), sta, -1);
    }
}

