/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.StyleConverter;
import writer2latex.latex.style.TableFormatter;
import writer2latex.office.TableGridModel;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;

public class TableStyleConverter
extends StyleConverter {
    private boolean bNeedLongtable = false;
    private boolean bContainsTables = false;

    public TableStyleConverter(WriterStyleCollection wsc, Config config, ConverterPalette palette) {
        super(wsc, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedLongtable) {
            pack.append("\\usepackage{longtable}").nl();
        }
        if (this.bContainsTables) {
            decl.append("\\setlength\\tabcolsep{1mm}").nl();
            decl.append("\\renewcommand\\arraystretch{1.3}").nl();
        }
    }

    public TableFormatter getTableFormatter(TableGridModel table, boolean bAllowLongtable, boolean bApplyCellFormat) {
        TableFormatter formatter = new TableFormatter(this.wsc, table, bAllowLongtable, bApplyCellFormat);
        this.bContainsTables = true;
        this.bNeedLongtable |= formatter.isLongtable();
        return formatter;
    }
}

