/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.OfficeDocument;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import writer2latex.Application;
import writer2latex.office.ImageLoader;
import writer2latex.office.MetaData;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.L10n;
import writer2latex.util.Misc;
import writer2latex.xhtml.DrawConverter;
import writer2latex.xhtml.LinkDescriptor;
import writer2latex.xhtml.MathConverter;
import writer2latex.xhtml.StyleConverter;
import writer2latex.xhtml.TableConverter;
import writer2latex.xhtml.TextConverter;
import writer2latex.xhtml.XhtmlDocument;
import writer2latex.xmerge.SxiDocument;

public class DocumentSerializerImpl
implements DocumentSerializer {
    private Config config;
    private L10n l10n;
    private OfficeDocument oooDoc;
    private org.w3c.dom.Document styleDOM;
    private org.w3c.dom.Document contentDOM;
    private WriterStyleCollection wsc;
    private MetaData metaData;
    private ImageLoader imageLoader;
    private boolean bWriter;
    private boolean bCalc;
    private boolean bImpress;
    private StyleConverter styleCv;
    private TextConverter textCv;
    private TableConverter tableCv;
    private DrawConverter drawCv;
    private MathConverter mathCv;
    private String sOutFileName;
    private ConvertData cd;
    Vector outFiles = new Vector();
    protected int nType = 0;
    private int nOutFileIndex = -1;
    private XhtmlDocument htmlDoc;
    private org.w3c.dom.Document htmlDOM;
    private Element htmlHead;
    private Element htmlBody;
    private Element htmlBodyContent;
    Hashtable targets = new Hashtable();
    LinkedList links = new LinkedList();
    private ExportNameCollection targetNames = new ExportNameCollection(true);

    public DocumentSerializerImpl(Document doc, int nType, String sConfigFileName) {
        File f;
        this.config = new Config();
        if (sConfigFileName != null && (f = new File(sConfigFileName)).exists()) {
            this.config.read(sConfigFileName);
        }
        this.oooDoc = (OfficeDocument)doc;
        this.sOutFileName = this.oooDoc.getName();
        this.bCalc = this.oooDoc instanceof SxcDocument;
        this.bImpress = this.oooDoc instanceof SxiDocument;
        this.bWriter = !this.bCalc && !this.bImpress;
        this.nType = nType;
        this.styleDOM = this.oooDoc.getStyleDOM();
        this.contentDOM = this.oooDoc.getContentDOM();
        this.wsc = new WriterStyleCollection();
        this.wsc.loadStylesFromDOM(this.styleDOM, this.contentDOM);
    }

    public void setOutFileName(String s) {
        this.sOutFileName = Misc.trimDocumentName(s, XhtmlDocument.getExtension(this.nType));
    }

    protected ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    protected StyleConverter getStyleCv() {
        return this.styleCv;
    }

    protected TextConverter getTextCv() {
        return this.textCv;
    }

    protected TableConverter getTableCv() {
        return this.tableCv;
    }

    protected DrawConverter getDrawCv() {
        return this.drawCv;
    }

    protected MathConverter getMathCv() {
        return this.mathCv;
    }

    protected EmbeddedObject getEmbeddedObject(String sHref) {
        return this.oooDoc.getEmbeddedObject(sHref);
    }

    protected boolean isWriter() {
        return this.bWriter;
    }

    protected boolean isCalc() {
        return this.bCalc;
    }

    protected boolean isImpress() {
        return this.bImpress;
    }

    protected int getOutFileIndex() {
        return this.nOutFileIndex;
    }

    protected void addDocument(Document doc) {
        this.cd.addDocument(doc);
    }

    protected Element createElement(String s) {
        return this.htmlDOM.createElement(s);
    }

    protected Text createTextNode(String s) {
        return this.htmlDOM.createTextNode(s);
    }

    protected Node importNode(Node node, boolean bDeep) {
        return this.htmlDOM.importNode(node, bDeep);
    }

    public ConvertData serialize() throws IOException, ConvertException {
        block24: {
            org.w3c.dom.Document dom;
            block23: {
                NodeList list;
                int nLen;
                StyleWithProperties style;
                this.l10n = new L10n();
                this.metaData = new MetaData(this.oooDoc);
                this.imageLoader = new ImageLoader(this.oooDoc, this.sOutFileName, true);
                this.styleCv = new StyleConverter(this.wsc, this.config, this, this.nType);
                this.textCv = new TextConverter(this.wsc, this.config, this);
                this.tableCv = new TableConverter(this.wsc, this.config, this);
                this.drawCv = new DrawConverter(this.wsc, this.config, this);
                this.mathCv = new MathConverter(this.wsc, this.config, this, this.nType != 0);
                this.cd = new ConvertData();
                StyleWithProperties styleWithProperties = style = this.bCalc ? this.wsc.getDefaultCellStyle() : this.wsc.getDefaultParStyle();
                if (style != null) {
                    String sLang = style.getProperty("fo:language");
                    String sCountry = style.getProperty("fo:country");
                    if (sLang != null) {
                        if (sCountry == null) {
                            this.l10n.setLocale(sLang);
                        } else {
                            this.l10n.setLocale(sLang + "-" + sCountry);
                        }
                    }
                }
                if ((nLen = (list = this.contentDOM.getElementsByTagName("office:body")).getLength()) > 0) {
                    Element body = (Element)list.item(0);
                    if (this.bCalc) {
                        this.tableCv.convertTableContent(body);
                    } else if (this.bImpress) {
                        this.drawCv.convertDrawContent(body);
                    } else {
                        this.textCv.convertTextContent(body);
                    }
                }
                this.textCv.insertFootnotes(this.htmlBody);
                this.textCv.insertEndnotes(this.htmlBody);
                ListIterator iter = this.links.listIterator();
                while (iter.hasNext()) {
                    LinkDescriptor ld = (LinkDescriptor)iter.next();
                    Integer targetIndex = (Integer)this.targets.get(ld.sId);
                    if (targetIndex == null) continue;
                    int nTargetIndex = targetIndex;
                    if (nTargetIndex == ld.nIndex) {
                        ld.element.setAttribute("href", "#" + this.targetNames.getExportName(ld.sId));
                        continue;
                    }
                    ld.element.setAttribute("href", this.getOutFileName(nTargetIndex, true) + "#" + this.targetNames.getExportName(ld.sId));
                }
                if (!this.config.xhtmlIgnoreStyles()) {
                    int i = 0;
                    while (i <= this.nOutFileIndex) {
                        dom = ((XhtmlDocument)this.outFiles.get(i)).getContentDOM();
                        NodeList hlist = dom.getElementsByTagName("head");
                        hlist.item(0).appendChild(this.styleCv.exportStyles(dom));
                        ++i;
                    }
                }
                if (!this.bCalc) break block23;
                int i = 0;
                while (i <= this.nOutFileIndex) {
                    dom = ((XhtmlDocument)this.outFiles.get(i)).getContentDOM();
                    NodeList hlist = dom.getElementsByTagName("div");
                    Node header = hlist.item(0);
                    Node footer = hlist.item(hlist.getLength() - 1);
                    String sTitle = this.metaData.getTitle();
                    if (sTitle != null) {
                        Element title = dom.createElement("h1");
                        header.appendChild(title);
                        title.appendChild(dom.createTextNode(sTitle));
                    }
                    Element headerPar = dom.createElement("p");
                    header.appendChild(headerPar);
                    header.appendChild(dom.createElement("hr"));
                    footer.appendChild(dom.createElement("hr"));
                    Element footerPar = dom.createElement("p");
                    footer.appendChild(footerPar);
                    int nSheets = this.tableCv.sheetNames.size();
                    int j = 0;
                    while (j < nSheets) {
                        if (this.config.xhtmlCalcSplit()) {
                            this.addNavigationLink(dom, headerPar, (String)this.tableCv.sheetNames.get(j), j);
                            this.addNavigationLink(dom, footerPar, (String)this.tableCv.sheetNames.get(j), j);
                        } else {
                            this.addInternalNavigationLink(dom, headerPar, (String)this.tableCv.sheetNames.get(j), "tableheading" + j);
                            this.addInternalNavigationLink(dom, footerPar, (String)this.tableCv.sheetNames.get(j), "tableheading" + j);
                        }
                        ++j;
                    }
                    ++i;
                }
                break block24;
            }
            if (!this.bImpress && this.config.getXhtmlSplitLevel() <= 0) break block24;
            int i = 0;
            while (i <= this.nOutFileIndex) {
                dom = ((XhtmlDocument)this.outFiles.get(i)).getContentDOM();
                NodeList hlist = dom.getElementsByTagName("div");
                Node header = hlist.item(0);
                Node footer = hlist.item(hlist.getLength() - 1);
                this.addNavigationLink(dom, header, this.l10n.get(0), 0);
                this.addNavigationLink(dom, header, this.l10n.get(1), i - 1);
                this.addNavigationLink(dom, header, this.l10n.get(2), i + 1);
                this.addNavigationLink(dom, header, this.l10n.get(3), this.nOutFileIndex);
                if (this.textCv.getTocIndex() >= 0) {
                    this.addNavigationLink(dom, header, this.l10n.get(4), this.textCv.getTocIndex());
                }
                if (this.textCv.getAlphabeticalIndex() >= 0) {
                    this.addNavigationLink(dom, header, this.l10n.get(5), this.textCv.getAlphabeticalIndex());
                }
                header.appendChild(dom.createElement("hr"));
                footer.appendChild(dom.createElement("hr"));
                this.addNavigationLink(dom, footer, this.l10n.get(0), 0);
                this.addNavigationLink(dom, footer, this.l10n.get(1), i - 1);
                this.addNavigationLink(dom, footer, this.l10n.get(2), i + 1);
                this.addNavigationLink(dom, footer, this.l10n.get(3), this.nOutFileIndex);
                if (this.textCv.getTocIndex() >= 0) {
                    this.addNavigationLink(dom, footer, this.l10n.get(4), this.textCv.getTocIndex());
                }
                if (this.textCv.getAlphabeticalIndex() >= 0) {
                    this.addNavigationLink(dom, footer, this.l10n.get(5), this.textCv.getAlphabeticalIndex());
                }
                ++i;
            }
        }
        return this.cd;
    }

    private void addNavigationLink(org.w3c.dom.Document dom, Node node, String s, int nIndex) {
        if (nIndex >= 0 && nIndex <= this.nOutFileIndex) {
            Element a = dom.createElement("a");
            a.setAttribute("href", this.getOutFileName(nIndex, true));
            a.appendChild(dom.createTextNode(s));
            node.appendChild(dom.createTextNode("["));
            node.appendChild(a);
            node.appendChild(dom.createTextNode("] "));
        } else {
            node.appendChild(dom.createTextNode("[" + s + "] "));
        }
    }

    private void addInternalNavigationLink(org.w3c.dom.Document dom, Node node, String s, String sLink) {
        Element a = dom.createElement("a");
        a.setAttribute("href", "#" + sLink);
        a.appendChild(dom.createTextNode(s));
        node.appendChild(dom.createTextNode("["));
        node.appendChild(a);
        node.appendChild(dom.createTextNode("] "));
    }

    public void handleOfficeAnnotation(Node onode, Node hnode) {
        Element paragraph = Misc.getChildByTagName(onode, "text:p");
        if (paragraph != null && paragraph.hasChildNodes()) {
            StringBuffer buf = new StringBuffer();
            NodeList nl = paragraph.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                if (nl.item(i).getNodeType() == 3) {
                    buf.append(nl.item(i).getNodeValue());
                }
                ++i;
            }
            Comment commentNode = this.htmlDOM.createComment(buf.toString());
            hnode.appendChild(commentNode);
        }
    }

    private String getOutFileName(int nIndex, boolean bWithExt) {
        return this.sOutFileName + (nIndex > 0 ? Integer.toString(nIndex) : "") + (bWithExt ? this.htmlDoc.getFileExtension() : "");
    }

    public Element nextOutFile() {
        if (this.nOutFileIndex >= 0) {
            this.textCv.insertFootnotes(this.htmlBodyContent);
        }
        this.htmlDoc = new XhtmlDocument(this.getOutFileName(++this.nOutFileIndex, false), this.nType);
        this.htmlDoc.setNoDoctype(this.config.xhtmlNoDoctype());
        this.outFiles.add(this.nOutFileIndex, this.htmlDoc);
        this.cd.addDocument(this.htmlDoc);
        this.htmlDOM = this.htmlDoc.getContentDOM();
        Element rootElement = this.htmlDOM.getDocumentElement();
        this.styleCv.applyDefaultLanguage(rootElement);
        rootElement.appendChild(this.htmlDOM.createComment("This file was converted to xhtml by " + (this.bWriter ? "Writer" : (this.bCalc ? "Calc" : "Impress")) + "2xhtml ver. " + Application.getVersion() + ". See http://www.hj-gym.dk/~hj/writer2latex for more info."));
        this.htmlHead = this.htmlDOM.createElement("head");
        rootElement.appendChild(this.htmlHead);
        this.htmlBody = this.htmlDOM.createElement("body");
        rootElement.appendChild(this.htmlBody);
        this.styleCv.applyPageStyle(this.wsc.getFirstMasterPageName(), this.htmlBody);
        Element title = this.htmlDOM.createElement("title");
        this.htmlHead.appendChild(title);
        String sTitle = this.metaData.getTitle();
        if (sTitle == null) {
            sTitle = this.htmlDoc.getFileName();
        }
        title.appendChild(this.htmlDOM.createTextNode(sTitle));
        if (this.nType == 0) {
            Element meta = this.htmlDOM.createElement("meta");
            meta.setAttribute("http-equiv", "Content-Type");
            meta.setAttribute("content", "text/html; charset=utf-8");
            this.htmlHead.appendChild(meta);
        }
        this.createMeta("description", this.metaData.getDescription());
        this.createMeta("keywords", this.metaData.getKeywords());
        if (this.config.xhtmlUseDublinCore()) {
            this.htmlHead.setAttribute("profile", "http://dublincore.org/documents/dcq-html/");
            Element dclink = this.htmlDOM.createElement("link");
            dclink.setAttribute("rel", "schema.DC");
            dclink.setAttribute("href", "http://purl.org/dc/elements/1.1/");
            this.htmlHead.appendChild(dclink);
            this.createMeta("DC.title", this.metaData.getTitle());
            this.createMeta("DC.subject", this.metaData.getSubject());
            this.createMeta("DC.description", this.metaData.getDescription());
            this.createMeta("DC.creator", this.metaData.getCreator());
            this.createMeta("DC.date", this.metaData.getDate());
            this.createMeta("DC.language", this.metaData.getLanguage());
        }
        if (this.config.xhtmlCustomStylesheet().length() > 0) {
            Element htmlStyle = this.htmlDOM.createElement("link");
            htmlStyle.setAttribute("rel", "stylesheet");
            htmlStyle.setAttribute("type", "text/css");
            htmlStyle.setAttribute("media", "all");
            htmlStyle.setAttribute("href", this.config.xhtmlCustomStylesheet());
            this.htmlHead.appendChild(htmlStyle);
        }
        if (this.bCalc || this.bImpress || this.config.getXhtmlSplitLevel() >= 1) {
            Element header = this.htmlDOM.createElement("div");
            header.setAttribute("id", "header");
            this.htmlBody.appendChild(header);
            this.htmlBodyContent = this.htmlDOM.createElement("div");
            this.htmlBodyContent.setAttribute("id", "content");
            this.htmlBody.appendChild(this.htmlBodyContent);
            Element footer = this.htmlDOM.createElement("div");
            footer.setAttribute("id", "footer");
            this.htmlBody.appendChild(footer);
        } else {
            this.htmlBodyContent = this.htmlBody;
        }
        if (!this.textCv.sections.isEmpty()) {
            Iterator iter = this.textCv.sections.iterator();
            while (iter.hasNext()) {
                Element section = (Element)iter.next();
                String sStyleName = Misc.getAttribute(section, "text:style-name");
                Element div = this.htmlDOM.createElement("div");
                this.htmlBodyContent.appendChild(div);
                this.htmlBodyContent = div;
                this.styleCv.applySectionStyle(sStyleName, div);
            }
        }
        return this.htmlBodyContent;
    }

    public Element createTarget(String sId) {
        Element a = this.htmlDOM.createElement("a");
        a.setAttribute("id", this.targetNames.getExportName(sId));
        this.targets.put(sId, new Integer(this.nOutFileIndex));
        return a;
    }

    public void addTarget(Element node, String sId) {
        node.setAttribute("id", this.targetNames.getExportName(sId));
        this.targets.put(sId, new Integer(this.nOutFileIndex));
    }

    public Element createLink(String sId) {
        Element a = this.htmlDOM.createElement("a");
        LinkDescriptor ld = new LinkDescriptor();
        ld.element = a;
        ld.sId = sId;
        ld.nIndex = this.nOutFileIndex;
        this.links.add(ld);
        return a;
    }

    private void createMeta(String sName, String sValue) {
        if (sValue == null) {
            return;
        }
        Element meta = this.htmlDOM.createElement("meta");
        meta.setAttribute("name", sName);
        meta.setAttribute("content", sValue);
        this.htmlHead.appendChild(meta);
    }
}

