# Copyright (C) 2008 Aaron Bentley
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from bzrlib.transform import TreeTransform

def link_tree(target_tree, source_tree):
    tt = TreeTransform(target_tree)
    try:
        for (file_id, paths, changed_content, versioned, parent, name, kind,
             executable) in target_tree.iter_changes(source_tree,
             include_unchanged=True):
            if changed_content:
                continue
            if kind != ('file', 'file'):
                continue
            if executable[0] != executable[1]:
                continue
            trans_id = tt.trans_id_tree_file_id(file_id)
            tt.delete_contents(trans_id)
            tt.create_hardlink(source_tree.id2abspath(file_id), trans_id)
        tt.apply()
    finally:
        tt.finalize()
