/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Certificate;
import java.security.IdentityScope;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Vector;

public abstract class Identity
implements Principal,
Serializable {
    private static final long serialVersionUID = 3609922007826600659L;
    private String name;
    private IdentityScope scope;
    private PublicKey publicKey;
    private String info;
    private Vector certificates;

    public final String getName() {
        return this.name;
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) throws KeyManagementException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setIdentityPublicKey");
        }
        this.publicKey = publicKey;
    }

    public void setInfo(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setIdentityInfo");
        }
        this.info = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void addCertificate(Certificate certificate) throws KeyManagementException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("addIdentityCertificate");
        }
        if (this.certificates.size() > 0 && ((Certificate)this.certificates.firstElement()).getPublicKey() != this.publicKey) {
            throw new KeyManagementException("Public key does not match");
        }
        this.certificates.addElement(certificate);
    }

    public void removeCertificate(Certificate certificate) throws KeyManagementException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("removeIdentityCertificate");
        }
        if (!this.certificates.contains(certificate)) {
            throw new KeyManagementException("Certificate not found");
        }
        this.certificates.removeElement(certificate);
    }

    public Certificate[] certificates() {
        Certificate[] certificateArray = new Certificate[this.certificates.size()];
        int n = this.certificates.size();
        int n2 = 0;
        while (n2 < n) {
            certificateArray[n2] = (Certificate)this.certificates.elementAt(n2);
            ++n2;
        }
        return certificateArray;
    }

    public final boolean equals(Object object) {
        if (object instanceof Identity) {
            if (object == this) {
                return true;
            }
            if (((Identity)object).getName().equals(this.name) && ((Identity)object).getScope().equals(this.scope)) {
                return true;
            }
            return this.identityEquals((Identity)object);
        }
        return false;
    }

    protected boolean identityEquals(Identity identity) {
        boolean bl = false;
        if (identity.getName().equals(this.name) && identity.getPublicKey().equals(this.publicKey)) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("printIdentity");
        }
        return this.name + ":@" + this.scope + " Public Key: " + this.publicKey;
    }

    public String toString(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("printIdentity");
        }
        if (bl) {
            return this.name + ":@" + this.scope + " Public Key: " + this.publicKey;
        }
        return this.name + ":@" + this.scope + " Public Key: " + this.publicKey;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        if (this.publicKey != null) {
            n |= this.publicKey.hashCode();
        }
        if (this.scope != null) {
            n |= this.scope.hashCode();
        }
        if (this.info != null) {
            n |= this.info.hashCode();
        }
        if (this.certificates != null) {
            n |= this.certificates.hashCode();
        }
        return n;
    }

    protected Identity() {
    }

    public Identity(String string, IdentityScope identityScope) throws KeyManagementException {
        this.name = string;
        this.scope = identityScope;
    }

    public Identity(String string) {
        this.name = string;
        this.scope = null;
    }
}

