/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.lowlevel.esd.EsdStream;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.TVolumeUtils;
import org.tritonus.share.sampled.mixer.TBaseDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EsdSourceDataLine
extends TBaseDataLine
implements SourceDataLine {
    private EsdStream m_esdStream;
    private boolean m_bSwapBytes;
    private byte[] m_abSwapBuffer;
    private int m_nBytesPerSample;
    private boolean m_bMuted;
    private float m_fGain;
    private float m_fPan;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    protected void openImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.openImpl(): called.");
        }
        this.checkOpen();
        AudioFormat audioFormat = this.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        boolean bl = audioFormat.isBigEndian();
        this.m_bSwapBytes = false;
        if (audioFormat.getSampleSizeInBits() == 16 && bl) {
            this.m_bSwapBytes = true;
            bl = false;
        } else if (audioFormat.getSampleSizeInBits() == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.m_bSwapBytes = true;
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (System.getProperty("os.arch").equals("ppc") && audioFormat.getSampleSizeInBits() == 16) {
            this.m_bSwapBytes ^= true;
        }
        if (this.m_bSwapBytes) {
            audioFormat = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), bl);
            this.m_nBytesPerSample = audioFormat.getFrameSize() / audioFormat.getChannels();
        }
        int n = 0x1000 | EsdUtils.getEsdFormat(audioFormat);
        this.m_esdStream = new EsdStream();
        this.m_esdStream.open(n, (int)audioFormat.getSampleRate());
    }

    public int available() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int write(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.write(): called.");
        }
        if (this.m_bSwapBytes) {
            if (this.m_abSwapBuffer == null || this.m_abSwapBuffer.length < var2_2 + var3_3) {
                this.m_abSwapBuffer = new byte[var2_2 + var3_3];
            }
            TConversionTool.changeOrderOrSign(var1_1, var2_2, this.m_abSwapBuffer, var2_2, var3_3, this.m_nBytesPerSample);
            var1_1 = this.m_abSwapBuffer;
        }
        if (var3_3 > 0 && !this.isActive()) {
            this.start();
        }
        var4_4 = var3_3;
        if (true) ** GOTO lbl22
        do {
            var5_5 = this;
            // MONITORENTER : var5_5
            {
                if (!this.isOpen()) {
                    // MONITOREXIT : var5_5
                    return var3_3 - var4_4;
                }
                var8_6 = this.m_esdStream.write(var1_1, var2_2, var4_4);
                var2_2 += var8_6;
                var4_4 -= var8_6;
                // MONITOREXIT : var5_5
            }
lbl22:
            // 2 sources

            if (var4_4 <= 0) return var3_3;
        } while (this.isOpen());
        return var3_3;
    }

    protected void closeImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.closeImpl(): called.");
        }
        this.m_esdStream.close();
    }

    public void drain() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.drain(): called.");
        }
    }

    public void flush() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.flush(): called.");
        }
    }

    private final void setGain(float f) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setGain(): gain: " + f);
        }
        this.m_fGain = f;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    private final void setPan(float f) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setPan(): pan: " + f);
        }
        this.m_fPan = f;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    private final void setMuted(boolean bl) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setMuted(): muted: " + bl);
        }
        this.m_bMuted = bl;
        if (!this.m_bMuted) {
            this.setGainImpl();
        }
    }

    private final void setGainImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("EsdSourceDataLine.setGainImpl(): called: ");
        }
        float f = this.m_fGain + this.m_fPan * 15.0f;
        float f2 = this.m_fGain - this.m_fPan * 15.0f;
        float f3 = (float)TVolumeUtils.log2lin(f);
        float f4 = (float)TVolumeUtils.log2lin(f2);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public EsdSourceDataLine(TMixer tMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        Class clazz = class$javax$sound$sampled$SourceDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$SourceDataLine = EsdSourceDataLine.class("[Ljavax.sound.sampled.SourceDataLine;", false);
        }
        super(tMixer, new DataLine.Info(clazz, audioFormat, n));
        this.addControl(new EsdSourceDataLineGainControl());
        this.addControl(new EsdSourceDataLinePanControl());
        this.addControl(new EsdSourceDataLineMuteControl());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EsdSourceDataLineGainControl
    extends FloatControl {
        public void setValue(float f) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out("EsdSourceDataLineGainControl.setValue(): gain: " + f);
            }
            float f2 = this.getValue();
            super.setValue(f);
            if ((double)Math.abs(f2 - this.getValue()) > 1.0E-9) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLineGainControl.setValue(): really changing gain");
                }
                EsdSourceDataLine.this.setGain(this.getValue());
            }
        }

        EsdSourceDataLineGainControl() {
            super(FloatControl.Type.MASTER_GAIN, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EsdSourceDataLinePanControl
    extends FloatControl {
        public void setValue(float f) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out("EsdSourceDataLinePanControl.setValue(): pan: " + f);
            }
            float f2 = this.getValue();
            super.setValue(f);
            if ((double)Math.abs(f2 - this.getValue()) > 1.0E-9) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLinePanControl.setValue(): really changing pan");
                }
                EsdSourceDataLine.this.setPan(this.getValue());
            }
        }

        EsdSourceDataLinePanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.01f, 0, 0.0f, "??", "left", "center", "right");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EsdSourceDataLineMuteControl
    extends BooleanControl {
        public void setValue(boolean bl) {
            if (TDebug.TraceSourceDataLine) {
                TDebug.out("EsdSourceDataLineMuteControl.setValue(): muted: " + bl);
            }
            if (bl != this.getValue()) {
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out("EsdSourceDataLineMuteControl.setValue(): really changing mute status");
                }
                super.setValue(bl);
                EsdSourceDataLine.this.setMuted(this.getValue());
            }
        }

        EsdSourceDataLineMuteControl() {
            super(BooleanControl.Type.MUTE, false, "muted", "unmuted");
        }
    }
}

