/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.Type;
import org.xbill.DNS.TypedObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Cache {
    private static final int defaultMaxEntries = 50000;
    private CacheMap data;
    private int maxncache;
    private int maxcache;
    private int dclass;

    private static final int limitExpire(long l, long l2) {
        int n;
        if (l2 >= 0L && l2 < l) {
            l = l2;
        }
        if ((n = (int)(System.currentTimeMillis() / 1000L + l)) < 0 || n > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    private final synchronized Object exactName(Name name) {
        return this.data.get(name);
    }

    private final synchronized void removeName(Name name) {
        this.data.remove(name);
    }

    private final synchronized Element[] allElements(Object object) {
        if (object instanceof List) {
            List list2 = (List)object;
            int n = list2.size();
            return (Element[])list2.toArray(new Element[n]);
        }
        Element element = (Element)object;
        return new Element[]{element};
    }

    private final synchronized Element oneElement(Name name, Object object, int n, int n2) {
        Element element = null;
        if (n == 255) {
            throw new IllegalArgumentException("oneElement(ANY)");
        }
        if (object instanceof List) {
            List list2 = (List)object;
            int n3 = 0;
            while (n3 < list2.size()) {
                Element element2 = (Element)list2.get(n3);
                if (element2.getType() == n) {
                    element = element2;
                    break;
                }
                ++n3;
            }
        } else {
            Element element3 = (Element)object;
            if (element3.getType() == n) {
                element = element3;
            }
        }
        if (element == null) {
            return null;
        }
        if (element.expired()) {
            this.removeElement(name, n);
            return null;
        }
        if (element.compareCredibility(n2) < 0) {
            return null;
        }
        return element;
    }

    private final synchronized Element findElement(Name name, int n, int n2) {
        Object object = this.exactName(name);
        if (object == null) {
            return null;
        }
        return this.oneElement(name, object, n, n2);
    }

    private final synchronized void addElement(Name name, Element element) {
        Object object = this.data.get(name);
        if (object == null) {
            this.data.put(name, element);
            return;
        }
        int n = element.getType();
        if (object instanceof List) {
            List list2 = (List)object;
            int n2 = 0;
            while (n2 < list2.size()) {
                Element element2 = (Element)list2.get(n2);
                if (element2.getType() == n) {
                    list2.set(n2, element);
                    return;
                }
                ++n2;
            }
            list2.add(element);
        } else {
            Element element3 = (Element)object;
            if (element3.getType() == n) {
                this.data.put(name, element);
            } else {
                LinkedList linkedList = new LinkedList();
                linkedList.add(element3);
                linkedList.add(element);
                this.data.put(name, linkedList);
            }
        }
    }

    private final synchronized void removeElement(Name name, int n) {
        Object object = this.data.get(name);
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            List list2 = (List)object;
            int n2 = 0;
            while (n2 < list2.size()) {
                Element element = (Element)list2.get(n2);
                if (element.getType() == n) {
                    list2.remove(n2);
                    if (list2.size() == 0) {
                        this.data.remove(name);
                    }
                    return;
                }
                ++n2;
            }
        } else {
            Element element = (Element)object;
            if (element.getType() != n) {
                return;
            }
            this.data.remove(name);
        }
    }

    public synchronized void clearCache() {
        this.data.clear();
    }

    public synchronized void addRecord(Record record, int n, Object object) {
        Name name = record.getName();
        int n2 = record.getRRsetType();
        if (!Type.isRR(n2)) {
            return;
        }
        Element element = this.findElement(name, n2, n);
        if (element == null) {
            CacheRRset cacheRRset = new CacheRRset(record, n, (long)this.maxcache);
            this.addRRset(cacheRRset, n);
        } else if (element.compareCredibility(n) == 0 && element instanceof CacheRRset) {
            CacheRRset cacheRRset = (CacheRRset)element;
            cacheRRset.addRR(record);
        }
    }

    public synchronized void addRRset(RRset rRset, int n) {
        long l = rRset.getTTL();
        Name name = rRset.getName();
        int n2 = rRset.getType();
        Element element = this.findElement(name, n2, 0);
        if (l == 0L) {
            System.out.println("adding RRset, element = " + element);
            if (element != null && element.compareCredibility(n) <= 0) {
                this.removeElement(name, n2);
            }
        } else {
            if (element != null && element.compareCredibility(n) <= 0) {
                element = null;
            }
            if (element == null) {
                CacheRRset cacheRRset = rRset instanceof CacheRRset ? (CacheRRset)rRset : new CacheRRset(rRset, n, (long)this.maxcache);
                this.addElement(name, cacheRRset);
            }
        }
    }

    public synchronized void addNegative(Name name, int n, SOARecord sOARecord, int n2) {
        long l = 0L;
        if (sOARecord != null) {
            l = sOARecord.getTTL();
        }
        Element element = this.findElement(name, n, 0);
        if (l == 0L) {
            if (element != null && element.compareCredibility(n2) <= 0) {
                this.removeElement(name, n);
            }
        } else {
            if (element != null && element.compareCredibility(n2) <= 0) {
                element = null;
            }
            if (element == null) {
                this.addElement(name, new NegativeElement(name, n, sOARecord, n2, this.maxncache));
            }
        }
    }

    protected synchronized SetResponse lookup(Name name, int n, int n2) {
        int n3;
        int n4 = n3 = name.labels();
        while (n4 >= 1) {
            Name name2;
            Object object;
            boolean bl;
            boolean bl2 = false;
            if (n4 == 1) {
                bl2 = true;
            }
            boolean bl3 = bl2;
            boolean bl4 = false;
            if (n4 == n3) {
                bl4 = bl = true;
            }
            if ((object = this.data.get(name2 = bl3 ? Name.root : (bl ? name : new Name(name, n3 - n4)))) != null) {
                Element element;
                SetResponse setResponse;
                if (bl && n == 255) {
                    setResponse = new SetResponse(6);
                    Element[] elementArray = this.allElements(object);
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < elementArray.length) {
                        element = elementArray[n6];
                        if (element.expired()) {
                            this.removeElement(name2, element.getType());
                        } else if (element instanceof CacheRRset && element.compareCredibility(n2) >= 0) {
                            setResponse.addRRset((CacheRRset)element);
                            ++n5;
                        }
                        ++n6;
                    }
                    if (n5 > 0) {
                        return setResponse;
                    }
                }
                if ((element = this.oneElement(name2, object, 2, n2)) != null && element instanceof CacheRRset) {
                    return new SetResponse(3, (CacheRRset)element);
                }
                if (bl) {
                    element = this.oneElement(name2, object, n, n2);
                    if (element != null && element instanceof CacheRRset) {
                        setResponse = new SetResponse(6);
                        setResponse.addRRset((CacheRRset)element);
                        return setResponse;
                    }
                    if (element != null) {
                        setResponse = new SetResponse(2);
                        return setResponse;
                    }
                    element = this.oneElement(name2, object, 5, n2);
                    if (element != null && element instanceof CacheRRset) {
                        return new SetResponse(4, (CacheRRset)element);
                    }
                } else {
                    element = this.oneElement(name2, object, 39, n2);
                    if (element != null && element instanceof CacheRRset) {
                        return new SetResponse(5, (CacheRRset)element);
                    }
                }
                if (bl && (element = this.oneElement(name2, object, 0, n2)) != null) {
                    return SetResponse.ofType(1);
                }
            }
            --n4;
        }
        return SetResponse.ofType(0);
    }

    public SetResponse lookupRecords(Name name, int n, int n2) {
        return this.lookup(name, n, n2);
    }

    private final RRset[] findRecords(Name name, int n, int n2) {
        SetResponse setResponse = this.lookupRecords(name, n, n2);
        if (setResponse.isSuccessful()) {
            return setResponse.answers();
        }
        return null;
    }

    public RRset[] findRecords(Name name, int n) {
        return this.findRecords(name, n, 3);
    }

    public RRset[] findAnyRecords(Name name, int n) {
        return this.findRecords(name, n, 2);
    }

    private final int getCred(int n, boolean bl) {
        if (n == 1) {
            if (bl) {
                return 4;
            }
            return 3;
        }
        if (n == 2) {
            if (bl) {
                return 4;
            }
            return 3;
        }
        if (n == 3) {
            return 1;
        }
        throw new IllegalArgumentException("getCred: invalid section");
    }

    private static final void markAdditional(RRset rRset, Set set) {
        Record record = rRset.first();
        if (record.getAdditionalName() == null) {
            return;
        }
        Iterator iterator = rRset.rrs();
        while (iterator.hasNext()) {
            Record record2 = (Record)iterator.next();
            Name name = record2.getAdditionalName();
            if (name == null) continue;
            set.add(name);
        }
    }

    public SetResponse addMessage(Message message) {
        Record record;
        int n;
        boolean bl = message.getHeader().getFlag(5);
        Record record2 = message.getQuestion();
        int n2 = message.getHeader().getRcode();
        boolean bl2 = false;
        boolean bl3 = false;
        SetResponse setResponse = null;
        boolean bl4 = Options.check("verbosecache");
        if (n2 != 0 && n2 != 3 || record2 == null) {
            return null;
        }
        Name name = record2.getName();
        int n3 = record2.getType();
        int n4 = record2.getDClass();
        Name name2 = name;
        HashSet hashSet = new HashSet();
        RRset[] rRsetArray = message.getSectionRRsets(1);
        int n5 = 0;
        while (n5 < rRsetArray.length) {
            if (rRsetArray[n5].getDClass() == n4) {
                int n6 = rRsetArray[n5].getType();
                Name name3 = rRsetArray[n5].getName();
                n = this.getCred(1, bl);
                if ((n6 == n3 || n3 == 255) && name3.equals(name2)) {
                    this.addRRset(rRsetArray[n5], n);
                    bl3 = true;
                    bl2 = true;
                    if (name2 == name) {
                        if (setResponse == null) {
                            setResponse = new SetResponse(6);
                        }
                        setResponse.addRRset(rRsetArray[n5]);
                    }
                    Cache.markAdditional(rRsetArray[n5], hashSet);
                } else if (n6 == 5 && name3.equals(name2)) {
                    this.addRRset(rRsetArray[n5], n);
                    if (name2 == name) {
                        setResponse = new SetResponse(4, rRsetArray[n5]);
                    }
                    record = (CNAMERecord)rRsetArray[n5].first();
                    name2 = ((CNAMERecord)record).getTarget();
                    bl2 = true;
                } else if (n6 == 39 && name2.subdomain(name3)) {
                    this.addRRset(rRsetArray[n5], n);
                    if (name2 == name) {
                        setResponse = new SetResponse(5, rRsetArray[n5]);
                    }
                    record = (DNAMERecord)rRsetArray[n5].first();
                    try {
                        name2 = name2.fromDNAME((DNAMERecord)record);
                    }
                    catch (NameTooLongException nameTooLongException) {
                        break;
                    }
                    bl2 = true;
                }
            }
            ++n5;
        }
        RRset[] rRsetArray2 = message.getSectionRRsets(2);
        RRset rRset = null;
        RRset rRset2 = null;
        int n7 = 0;
        while (n7 < rRsetArray2.length) {
            if (rRsetArray2[n7].getType() == 6 && name2.subdomain(rRsetArray2[n7].getName())) {
                rRset = rRsetArray2[n7];
            } else if (rRsetArray2[n7].getType() == 2 && name2.subdomain(rRsetArray2[n7].getName())) {
                rRset2 = rRsetArray2[n7];
            }
            ++n7;
        }
        if (!bl3) {
            int n8 = 0;
            if (n2 != 3) {
                n8 = n7 = n3;
            }
            if (rRset != null || rRset2 == null) {
                n = this.getCred(2, bl);
                record = null;
                if (rRset != null) {
                    record = (SOARecord)rRset.first();
                }
                this.addNegative(name2, n7, (SOARecord)record, n);
                if (setResponse == null) {
                    int n9 = n2 == 3 ? 1 : 2;
                    setResponse = SetResponse.ofType(n9);
                }
            } else {
                n = this.getCred(2, bl);
                this.addRRset(rRset2, n);
                Cache.markAdditional(rRset2, hashSet);
                if (setResponse == null) {
                    setResponse = new SetResponse(3, rRset2);
                }
            }
        } else if (n2 == 0 && rRset2 != null) {
            n = this.getCred(2, bl);
            this.addRRset(rRset2, n);
            Cache.markAdditional(rRset2, hashSet);
        }
        RRset[] rRsetArray3 = message.getSectionRRsets(3);
        n7 = 0;
        while (n7 < rRsetArray3.length) {
            Name name4;
            int n10 = rRsetArray3[n7].getType();
            if ((n10 == 1 || n10 == 28 || n10 == 38) && hashSet.contains(name4 = rRsetArray3[n7].getName())) {
                n = this.getCred(3, bl);
                this.addRRset(rRsetArray3[n7], n);
            }
            ++n7;
        }
        if (bl4) {
            System.out.println("addMessage: " + setResponse);
        }
        return setResponse;
    }

    public void flushSet(Name name, int n) {
        this.removeElement(name, n);
    }

    public void flushName(Name name) {
        this.removeName(name);
    }

    public void setMaxNCache(int n) {
        this.maxncache = n;
    }

    public int getMaxNCache() {
        return this.maxncache;
    }

    public void setMaxCache(int n) {
        this.maxcache = n;
    }

    public int getMaxCache() {
        return this.maxcache;
    }

    public int getSize() {
        return this.data.size();
    }

    public int getMaxEntries() {
        return this.data.getMaxSize();
    }

    public void setMaxEntries(int n) {
        this.data.setMaxSize(n);
    }

    public int getDClass() {
        return this.dclass;
    }

    public void setCleanInterval(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Cache cache = this;
        synchronized (cache) {
            Iterator iterator = this.data.values().iterator();
            block3: while (iterator.hasNext()) {
                Element[] elementArray = this.allElements(iterator.next());
                int n = 0;
                while (true) {
                    if (n >= elementArray.length) continue block3;
                    stringBuffer.append(elementArray[n]);
                    stringBuffer.append("\n");
                    ++n;
                }
                break;
            }
            return stringBuffer.toString();
        }
    }

    private final /* synthetic */ void this() {
        this.maxncache = -1;
        this.maxcache = -1;
    }

    public Cache(int n) {
        this.this();
        this.dclass = n;
        this.data = new CacheMap(50000);
    }

    public Cache(int n, int n2) {
        this(n);
    }

    public Cache() {
        this(1);
    }

    public Cache(String string) throws IOException {
        Record record;
        this.this();
        this.data = new CacheMap(50000);
        Master master = new Master(string);
        while ((record = master.nextRecord()) != null) {
            this.addRecord(record, 0, master);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class CacheMap
    extends LinkedHashMap {
        private int maxsize;

        int getMaxSize() {
            return this.maxsize;
        }

        void setMaxSize(int n) {
            this.maxsize = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            boolean bl = false;
            if (this.maxsize >= 0 && this.size() > this.maxsize) {
                bl = true;
            }
            return bl;
        }

        private final /* synthetic */ void this() {
            this.maxsize = -1;
        }

        CacheMap(int n) {
            super(16, 0.75f, true);
            this.this();
            this.maxsize = n;
        }
    }

    private static interface Element
    extends TypedObject {
        public boolean expired();

        public int compareCredibility(int var1);

        public int getType();
    }

    private static class CacheRRset
    extends RRset
    implements Element {
        int credibility;
        int expire;

        public final boolean expired() {
            int n = (int)(System.currentTimeMillis() / 1000L);
            boolean bl = false;
            if (n >= this.expire) {
                bl = true;
            }
            return bl;
        }

        public final int compareCredibility(int n) {
            return this.credibility - n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" cl = ");
            stringBuffer.append(this.credibility);
            return stringBuffer.toString();
        }

        public CacheRRset(Record record, int n, long l) {
            this.credibility = n;
            this.expire = Cache.limitExpire(record.getTTL(), l);
            this.addRR(record);
        }

        public CacheRRset(RRset rRset, int n, long l) {
            super(rRset);
            this.credibility = n;
            this.expire = Cache.limitExpire(rRset.getTTL(), l);
        }
    }

    private static class NegativeElement
    implements Element {
        int type;
        Name name;
        SOARecord soa;
        int credibility;
        int expire;

        public int getType() {
            return this.type;
        }

        public final boolean expired() {
            int n = (int)(System.currentTimeMillis() / 1000L);
            boolean bl = false;
            if (n >= this.expire) {
                bl = true;
            }
            return bl;
        }

        public final int compareCredibility(int n) {
            return this.credibility - n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.type == 0) {
                stringBuffer.append("NXDOMAIN " + this.name);
            } else {
                stringBuffer.append("NXRRSET " + this.name + ' ' + Type.string(this.type));
            }
            stringBuffer.append(" cl = ");
            stringBuffer.append(this.credibility);
            return stringBuffer.toString();
        }

        public NegativeElement(Name name, int n, SOARecord sOARecord, int n2, long l) {
            this.name = name;
            this.type = n;
            this.soa = sOARecord;
            long l2 = 0L;
            if (sOARecord != null) {
                l2 = sOARecord.getMinimum();
            }
            this.credibility = n2;
            this.expire = Cache.limitExpire(l2, l);
        }
    }
}

