/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.sgf;

import java.io.*;
import java.util.*;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import GoGrinder.Messages;
import GoGrinder.StringWorks;
import GoGrinder.Main;
import GoGrinder.FileWorks;
import GoGrinder.GS;
import GoGrinder.ui.SplashScreen;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
public class Validator{
    
    static int numFiles;
    static int numGood;
    static int numBad;
    private static int numIgnoredAll;
    private static boolean validateFromCLI = false;
    public static String currValidatorFile = "";
    public static String validateFolder = ""; // validateFolder is public, as we use it in SGFLog
    private static String validatorMsg = "";
    static int SZ = 0;
    static final String NL = Main.NEW_LINE;
    
    // checks the given (String sgf) for valid sgf data (got it from validate(File dir) see below)
    public static void validate(String sgf) throws Exception {

        SGFParser.sgfValiSZ = 0;
        ArrayList recs = SGFParser.parse(sgf);
        // now we should already have SZ in every recs.get(x)
        if(recs.size() > 1){ // Messages.getString("mult_probs")
            String validatorMsg = "Multiple problems in one file - consider to split the file or" + NL
                                + "you can only use the first problem of the file.";
            String stackTop = "" + new Exception().getStackTrace()[0];
            SGFLog.SGFLog2(0, validatorMsg, "", stackTop);
        }
        SGFNode root = (SGFNode)recs.get(0); // when SZ is not given... (see some lines below)
        // why did T.K. use "root" for this? it seems, that it just gives the first game or problem with recs.get(0)
        // "root" in sgf terminology is the first node of the game or problem with SZ[], GM[], AP[],... and the setup stones
        String size = root.getProperty("SZ"); //$NON-NLS-1$
        if(size != null){
          SGFParser.sgfValiSZ = Integer.parseInt(size);
        }
        else SGFParser.sgfValiSZ = 19;
        root.validatePoints(SGFParser.sgfValiSZ);
        if(root.getBounds() == null){ // would be nice to throw this from some levels up
            validatorMsg = "(No stones? - Check the file!)"; // Messages.getString("no_points")
            int sgfSize = sgf.length();
            String codeExample = "";
            if (sgfSize > 200){
                codeExample = sgf.substring(0, 190) + " ... (code example shortened from " + sgfSize + " to 190 bytes)";
            }
            else {
              codeExample = sgf;  }
            throw new SGFParseException(validatorMsg, codeExample); 
        }
    }

  // validate gets a directory as parameter
  // goes into the directory, scans for names, checks for subdirectories, loads every file (oops - no filter?),
  // reads the file to a StringBuffer, changes this to a String and gives that to validate(String sgf) (see above)
    void validate(File dir) {
        
        String statusMsg = " Parsing folder: ";
        String dirForStatus = dir.getPath();
        if (validateFromCLI || Main.DEBUG2) 
            System.out.println("\n###" + statusMsg +"\n \"" + dirForStatus + "\"\n"); // + " - getting files list"

        File [] files = dir.listFiles();
        int numIgnored = 0; // this counts only in this folder
        for(int i = 0; i < files.length; i++) {
            File f = files[i];
            if(f.isDirectory()){ // here: when we follow Linux links to directories, we cannot move defect files
              // if FILENAME is subdirectory: call this validate again
              // with subdirectory as parameter and validate files there
              validate(f);
              continue;
            }   
                // in Unix/Linux, with linked files/folders, validate will follow a link to a directory (in all diststributions?)
                // in FileWCpMv we have already caught a part of this
            else {
              numFiles++;
              if (f.toString().toLowerCase().endsWith("sgf")){
                Validator.currValidatorFile = f.toString(); 
                long fileSize = FileWorks.getFileSize(Validator.currValidatorFile); 
                if (fileSize > GS.getParserSGFMaxFileSize() ){ // isn't it enough to call this only once? and have this local?
                  validatorMsg = "File: \"" + Validator.currValidatorFile + NL 
                               + "File is very big: " + fileSize + " bytes. We bypass this file. You can change the maximum" + NL
                               + "size for sgf files manually in the settings file (no effect, if validating from command line;" + NL
                               + "use instead the system variable \"MYGG_SGF_MAX_SZ\") - default is ~100kby.";
                  SGFLog.SGFLog(validatorMsg);
                  System.out.println(validatorMsg);
                  numIgnored++;
                  continue;
                }
                try { // UTF-8 - do we need it be processed here?
                    BufferedReader in = new BufferedReader(new FileReader(f)); // --> FileWReadWrite but without utf8
                    String line;
                    StringBuffer sgf = new StringBuffer();
                    while((line = in.readLine()) != null)
                        sgf.append(line + NL); // an sgf parser should be able to process sgf data without new lines
                    in.close();                  // but o.k.: we usually need to preserve the new lines in the comments
                    validate(sgf.toString());
                    numGood++; // here we add only for correct/usable files
                    if (Main.DEBUG2) SGFLog.SGFLogFileOK(Validator.currValidatorFile);
                }
                // no catch (OutOfMemoryError ...) here? (like in SGFController)
                catch(IOException e){
                  numIgnored++;
                  validatorMsg = "Error with file: " + NL + "\"" 
                                + currValidatorFile + "\" " + NL 
                                + "IOException";
                  if (Main.DEBUG2) {
                     validatorMsg += " thrown down to: " + new Exception().getStackTrace()[0]
                                   + "from " + e.getStackTrace()[0];
                  }
                  validatorMsg += " - counted as \"ignored\"" + NL;
                }
                catch(SGFParseException e) { // Messages.getString("parsing")
                    numBad++;
                    // + ID badSGF = true??
                    // more noise in SGFController, because we give the user a message window there
                }
                catch(Exception e){
                  numBad++;
                  validatorMsg = "Common Exception (cannot yet say, what is wrong)";

                    validatorMsg += " thrown down to:" + NL
                                  + new Exception().getStackTrace()[0] + " (compare to grind-log.txt)" + NL
                                  + "from " + e.getStackTrace()[0];
                  // does this work as expected? is e.getSt... the original stacktrace?
                  new SGFParseException(e, validatorMsg, "");
                }
              } // it seems, I didn't implement move-defect-files here, but I 
                //   think, I can do this for folders inside Grinder's settings folder
                // need check with canonical file / canonical path
              else {
                numIgnored++;
                  SGFLog.SGFLog(NL + " ignored: " + f.getPath());
              }
            } // end no directory
        }
        if(numIgnored > 0) {
          System.out.println( "\n Counted " + numIgnored + " ignored files in: \n" 
                                            + dir.toString() + "\n");
        }
        numIgnoredAll+= numIgnored;
        Node.currMainBranchSZ = 0; // I fear, these workarounds will ...
        Node.szIsSet = false;      // ... break the wgf parsing
        SGFParser.sgfValiSZ = 0;
    }
    
  // command line switch "-validate" ...
  // even better, when we could give a directory to scan (e.g. -validate="c:\My Files\Problems\")
  // GGBundler (Closed Source) has some interesting code
    private static void setOptions(){} // NOT YET
    // settings, like moveFile(on/off) (and destination dir), logLevel, selectFolder, language for messages
    
    public void main(String[] folder) {
    // we need to initialize the run in SGFLog or SGFParser:
    // setOptions (temporary), NO MOVE FILE, WHEN WORKING FROM CLI check folders for canWrite (when moveFile=on)
    // writeBar, writeSettings + folder (all three in log file) and, when finished, we reset the settings 
          // I want splash (more: some kind of ProgressDialog) be visible, if validate is started from GUI!!
        validateFolder = folder[0]; // here we could hand over a path from the command line switch // 
        // validateFolder is public, as we use it in SGFLog
        if (validateFromCLI) {
//          GoGrinder.sgf.SGFParser.setMoveDefectFile(false); // settings folder not yet set // this will be in GS, later anytime
          Messages.initMessages(); // the older error messages are partly language dependent
          Messages.switchLocale("en"); // don't know, maybe we set this later in a settings window ...
        }
        SGFParser.VALIDATING = true; // -> no message windows except at the end
        setOptions(); // NOT YET, idea: set move, logBuffer, sgfMaxSize, loglevel, DEBUG2, language ...?
        SGFParser.checkingSGF = true; // this is for getting the right file name for the logs, 
                                      // as the WGF part uses the same routines (VALIDATING, checkingSGF - both needed?)
        SGFLog.beginLogging(); // write intro in sgf-log.txt
        numFiles = 0;
      // As this is (was) a separate starter for validating files without using 
      // the GoGrinder-gui, it would be good to use a separate method, which gets 
      // the complete path to validate.
        Validator v = new Validator();
        numIgnoredAll = 0;
        System.out.println("Folder to check for defect files:\n \"" + validateFolder + "\"\n");
        if (!validateFromCLI) 
          JOptionPane.showMessageDialog(null, "At the moment you need to start Grinder from a console to see the progress!");

        v.validate(new File(validateFolder)); //$NON-NLS-1$

        String filesMovedMsg = "";
        if (GS.getParserMoveDefectFile()) filesMovedMsg = " moved to folders \"defect\" resp. \"notsupported\"";
        validatorMsg = NL
                  + " ### Checked folder:" + NL
                  + " ### \"" + validateFolder + "\" " + NL
                  + " ### Total: " + v.numFiles + " files" + NL
                  + " ### " + v.numGood + " valid files" + NL
                  + " ### " + v.numBad + " defect or unusable files" + filesMovedMsg + NL
                  + " ### " + v.numIgnoredAll + " ignored files." + NL 
                  + " ### (If the numbers don't add up to the \"total\" count," + NL
                  + " ###    there is something wrong in Grinder's Java code.)" + NL;
        String finishBar = NL + " #############################################################################";
        String seeLog1 = NL + " ### Specific SGF error logs:" + NL 
                            + " ### >>> " + Main.sgfLogFilePath + " <<<" + NL;
        String seeLog2 = NL + " ### Common error logs, extended:" + NL
                            + " ### >>> " + Main.commonLogFilePath + " <<<" + NL;
        System.out.println(validatorMsg + seeLog1 + seeLog2 + finishBar);

        JOptionPane.showMessageDialog(null, validatorMsg + seeLog1 + seeLog2);

        if(Main.DEBUG2) GoGrinder.ExceptionHandler.log(validatorMsg + seeLog1); // this only in debug mode?
        SGFLog.finishLogging(validatorMsg + seeLog2+ finishBar);  // write summary in sgf-log.txt
        SGFParser.VALIDATING = false;
        SGFParser.checkingSGF = false;
        // --> if (!validateFromCLI)GoGrinder.sgf.SGFParser.resetMoveDefectFile();
    }

    public static boolean getValidateFromCLI(){return validateFromCLI;}
    public static void setValidateFromCLI(boolean fromCLI){validateFromCLI = fromCLI;}
}
