package org.cdavies.applerecords.table;

import javax.swing.table.AbstractTableModel;
import java.util.ArrayList;

import org.cdavies.itunes.Track;

public class TrackListTableModel extends AbstractTableModel {
	
	public final String[] _columnNames = {"Artist","Album","Title"};
	public ArrayList _data;
	
	public TrackListTableModel() {
		
		super();
		_data = new ArrayList();
		
	}
	
	public String getColumnName(int col) {
		
		return _columnNames[col];
		
	}
	
	public void clear() {
		
		_data = new ArrayList();
		
	}
	
	public void addRow(Track t) {
		
		/* Crude hack to prevent non-mp3 listing
		 * will be replaced with filtering next
		 * release (famous last words! :)
		 */
		 
		if (t.getFormat().equals("mp3")) {
		
		 	Object[] _a = new Object[4];
			_a[0] = t.getArtistName();
			_a[1] = t.getAlbumName();
			_a[2] = t.getTrackName();
			_a[3] = t;
			
			_data.add(_a);
		
		}
		
	}

	public int getRowCount() {
		
		return _data.size();
		
	}

	public int getColumnCount() {
		
		return _columnNames.length;
		
	}

	public Class getColumnClass(int c) {
		
		return getValueAt(0, c).getClass();
		
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		
		return ((Object[])_data.get(rowIndex))[columnIndex];
		
	}

}

