######################################################################
### This function creates the deailts window, where the
### user can select which pages he want's to load
###
### The details page works on the following variables.
### __textChildren: an associativ array, which maps from the index of
###                 the element to the indexes of all it's children
### __textParent:   an associativ array, which maps from the index of
###                 the element, to the index of it's parent
### __textFunction: an associativ array, which maps from the index of
###                 the element, to the name of the function, which have
###                 created the page.
### __loadFile:     an associativ array, which have the element indexes as
###                 keys, and as values, information about whether the page
###                 shall be loaded.
### __overWrite:    an associativ array from index to information wether
###                 the page shall overwrite or append.
######################################################################
proc createDetails {merge loadFile} {
  global __textLine __loadFile __overWrite __textFunction __language
  set w [toplevel .details]
  grabSet .details
  wm resizable $w 0 0

  label $w.label -text "$__language(details,1)[space 20]$__language(details,2)"
  pack $w.label -anchor w
  ### packing the menu page information
  pack [frame $w.frame] -fill both -expand 1
  set frame $w.frame
  text $frame.text -yscrollcommand "$frame.scroll set" -cursor left_ptr \
       -font [$w.label cget -font]
  $frame.text tag configure line -wrap none
  scrollbar $frame.scroll -command "$frame.text yview"
  pack $frame.text  -side left -fill both -expand 1
  pack $frame.scroll -side left -fill y -expand 0

  ### inserting the menus
  set __textLine -1
  insertMenus $frame.text 0 "" -1 $merge
  bindtags $frame.text None

  ### inserting the "load setup"
  set i [$frame.text index insert]
  $frame.text insert insert "_______________________________________________________________________________________________________________________________________________________________\n"
  $frame.text tag add line $i insert

  checkbutton $frame.text.loadSetup -variable __loadSetup \
      -text "Load Setup"
  $frame.text window create end -window $frame.text.loadSetup
  if {!$loadFile} {
    $frame.text.loadSetup configure -state disabled
  }
  
  ### packing the help text
  label $w.help -wraplength 500 -justify left -text $__language(details,3)
  pack $w.help -fill x -expand 1
  ### packing the OK button
  button $w.ok -text $__language(details,5) -command {destroy .details}
  button $w.helppage -text $__language(details,4) -command "help`gotoTag load_detail"
  pack $w.ok $w.helppage -side right

  ### taking the grab
  grabSet $w
  tkwait window $w
  set merge {}
  set overwrite {}
  foreach elm [array names __loadFile] {
    if {$__loadFile($elm) && [info exists __textFunction($elm)]} {
      if {$__overWrite($elm)} {
        lappend overwrite $__textFunction($elm)
      } else {
        lappend merge  $__textFunction($elm)
      }
    }
  }
  return [list $overwrite $merge]
}

######################################################################
### This function insert the element 'top' and all it's children
######################################################################
proc insertMenus {w level  top parent merge} {
  global __subPath __menu2funk __textLine __loadFile __textChildren __textParent
  global __textFunction __overWrite __language

  ### calculate the name of the menu
  set menuPath [split $top "/"]
  set name [lindex $menuPath  end]
  if {$name == ""} {
    set name $__language(details,8)
  }

  ### set the parrent
  incr __textLine
  set __textParent($__textLine) $parent
  set self $__textLine

  ### create the radio buttons
  if {![info exists __overWrite($__textLine)]} {
    set __overWrite($__textLine) 1
  } 
  radiobutton $w.merge_$__textLine -variable __overWrite($__textLine) -value 0\
      -command "radioSelect $__textLine 0 setFromCursor"
  radiobutton $w.overwrite_$__textLine -variable __overWrite($__textLine) \
      -value 1 -command "radioSelect $__textLine 1 setFromCursor"
  $w window create end -window $w.merge_$__textLine
  $w insert insert "  "
  $w window create end -window $w.overwrite_$__textLine
  if {!$merge} {
    set __overWrite($__textLine) 1
    foreach elm "$w.merge_$__textLine $w.overwrite_$__textLine" {
      bind $elm <1> {
        tk_dialog .error $__language(details,6) $__language(details,7) info 0 OK
      }
      $elm configure -state disabled
    }
  }
  
  ### insert the name into the text widget, and set the tag
  $w insert end [space $level]
  set index [$w index insert]
  $w insert end "$name"
  $w tag add tag$__textLine $index insert
  $w insert end \n
  $w tag bind tag$__textLine <1> "tagSelect $w $__textLine setFromCursor"
  if {![info exists __loadFile($__textLine)]} {
    set __loadFile($__textLine) 1
  }
  if {$__loadFile($__textLine) == 1} {
    $w tag configure tag$__textLine -background [$w cget -fg] \
        -foreground [$w cget -bg]
  } elseif {$__loadFile($__textLine) == -1} {
    $w tag configure tag$__textLine -background grey
  }

  ### insert all it's children
  set __textChildren($self) {}
  if {[info exists __subPath($top/)]} {
    ### The element is a menu
    foreach page $__subPath($top/) {
      set child [insertMenus $w [expr $level +4] $top/$page $self $merge]
      lappend __textChildren($self) $child
    }
    if {$level == 4} {
      set i [$w index insert]
      $w insert insert "_______________________________________________________________________________________________________________________________________________________________"
      $w tag add line $i insert
      $w insert insert \n\n
    }
  } else {
    set __textFunction($self) $__menu2funk($top)
  }
  return $self
}

######################################################################
### This function is called, when the mouse is pressed over an element
### It then calls recursive, to (un)set all the children of the element
### and to grey out all the parrents of the element.
######################################################################
proc tagSelect {w self type {value 0}} {
  global __loadFile __textChildren __textParent
  set fg [$w cget -fg]
  set bg [$w cget -bg]

  if {$type == "setFromCursor"} {
    set __loadFile($self) [expr ($__loadFile($self)+1)%2]
  } elseif {$type == "setFromParent"} {
    set __loadFile($self) $value
  } 

  ### set the color of the foreground and background
  if {$type == "setFromChild"} {
    set fg [$w cget -fg]
    set bg grey
    set __loadFile($self) -1
  } else {
    if {$__loadFile($self)} {
      set fg [$w cget -bg]
      set bg [$w cget -fg]
    } else {
      set fg [$w cget -fg]
      set bg [$w cget -bg]
    }
  }
  $w tag configure tag$self -foreground  $fg -background $bg

  ### call recursive
  if {$type != "setFromChild"} {
    foreach child $__textChildren($self) {
      tagSelect $w $child "setFromParent" $__loadFile($self)
    }
  }
  if {$type != "setFromParent"} {
    if {$__textParent($self) != -1} {
      tagSelect $w $__textParent($self) "setFromChild"
    }
  }
}

######################################################################
### This function is called when a radio element is selected.
### It then calls recursive to set all the children, and to
### unset all the parrent.
######################################################################
proc radioSelect {self value type} {
  global __overWrite __textChildren __textParent

  set __overWrite($self) $value

  if {$type != "setFromParent" && $__textParent($self) != -1} {
    radioSelect $__textParent($self) "" setFromChild
  }
  if {$type != "setFromChild"} {
    foreach child $__textChildren($self) {
      radioSelect $child $value setFromParent
    }
  }
}
