/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.Region;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;

public class BufferedPanel
extends Panel {
    protected boolean buffered;
    protected boolean autoFlushing;
    protected Image background;
    protected boolean windowCreated;
    protected transient Image buffer;
    protected transient Graphics bufferGraphics;
    protected transient Region damage;
    protected Object lock = new Object();

    public BufferedPanel(LayoutManager layout) {
        this.setLayout(layout);
        this.buffered = true;
        this.autoFlushing = true;
        this.background = null;
        this.windowCreated = false;
        this.buffer = null;
        this.bufferGraphics = null;
        this.damage = new Region();
    }

    public BufferedPanel() {
        this(null);
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean buffered) {
        if (buffered != this.buffered) {
            this.buffered = buffered;
            if (buffered) {
                this.repaint();
            }
        }
    }

    public boolean isAutoFlushing() {
        return this.autoFlushing;
    }

    public void setAutoFlushing(boolean flushing) {
        if (flushing != this.autoFlushing) {
            this.autoFlushing = flushing;
        }
    }

    public Image getBackgroundTile() {
        return this.background;
    }

    public void setBackgroundTile(Image background) {
        this.background = background;
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.windowCreated = true;
        if (this.buffered) {
            this.createBufferImage();
            this.repaint();
        }
    }

    public void reshape(int x, int y, int width, int height) {
        Rectangle old = this.getBounds();
        super.reshape(x, y, width, height);
        if (this.windowCreated && (width != old.width || height != old.height) && this.buffered) {
            this.createBufferImage();
            this.repaint();
        }
    }

    public void flushBuffer() {
        Dimension size = this.getSize();
        super.repaint(0L, 0, 0, size.width, size.height);
    }

    void createBufferImage() {
        Dimension size = this.getSize();
        if (size.width > 0 && size.height > 0) {
            this.buffer = this.createImage(size.width, size.height);
            if (this.buffer != null) {
                this.bufferGraphics = this.buffer.getGraphics();
            }
        }
    }

    protected void renderBuffer() {
        Region rects;
        if (this.damage.isEmpty()) {
            return;
        }
        if (this.buffer == null) {
            return;
        }
        Region region = this.damage;
        synchronized (region) {
            rects = this.damage;
            this.damage = new Region();
        }
        Enumeration e2 = rects.rectangles();
        while (e2.hasMoreElements()) {
            Rectangle rect = (Rectangle)e2.nextElement();
            this.render(rect);
        }
    }

    protected void render(Rectangle rect) {
        Component[] children = this.getComponents();
        Image image = this.buffer;
        synchronized (image) {
            this.bufferGraphics.setClip(rect);
            this.paintBackground(this.bufferGraphics);
            this.bufferGraphics.setColor(this.getForeground());
            int c2 = children.length - 1;
            while (c2 >= 0) {
                Rectangle clip;
                Component child = children[c2];
                if (this.isLightweight(child) && child.isVisible() && (clip = child.getBounds()).intersects(rect)) {
                    Graphics g2 = this.bufferGraphics.create(clip.x, clip.y, clip.width, clip.height);
                    child.paint(g2);
                    g2.dispose();
                }
                --c2;
            }
            this.bufferGraphics.setClip(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void paintBackground(Graphics g) {
        block4: {
            block3: {
                size = this.getSize();
                if (this.background != null) break block3;
                g.setColor(this.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                break block4;
            }
            tile = new Rectangle(0, 0, this.background.getWidth(this), this.background.getHeight(this));
            clip = g.getClipBounds();
            ** GOTO lbl18
            {
                if (clip == null || clip.intersects(tile)) {
                    g.drawImage(this.background, tile.x, tile.y, this);
                }
                tile.x += tile.width;
                do {
                    if (tile.x < size.width) continue block0;
                    tile.x = 0;
                    tile.y += tile.height;
lbl18:
                    // 2 sources

                } while (tile.y < size.height);
            }
        }
    }

    boolean isLightweight(Component comp) {
        return comp.getPeer() instanceof LightweightPeer;
    }

    public void repaint(long time, int x, int y, int width, int height) {
        if (this.buffered) {
            Region region = this.damage;
            synchronized (region) {
                this.damage.addRectangle(new Rectangle(x, y, width, height));
            }
            if (this.autoFlushing) {
                this.flushBuffer();
            }
        } else {
            super.repaint(time, x, y, width, height);
        }
    }

    public void update(Graphics g2) {
        if (this.buffered) {
            this.paint(g2);
        } else {
            super.update(g2);
        }
    }

    public void paint(Graphics g2) {
        if (this.buffered && this.buffer != null) {
            this.renderBuffer();
            g2.drawImage(this.buffer, 0, 0, this);
        } else {
            super.paint(g2);
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.damage = new Region();
    }
}

