/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public class Modifier {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    static final int SUPER = 32;
    static final int ALL_FLAGS = 4095;

    public static boolean isAbstract(int n) {
        boolean bl = false;
        if ((n & 0x400) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isFinal(int n) {
        boolean bl = false;
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInterface(int n) {
        boolean bl = false;
        if ((n & 0x200) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isNative(int n) {
        boolean bl = false;
        if ((n & 0x100) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPrivate(int n) {
        boolean bl = false;
        if ((n & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isProtected(int n) {
        boolean bl = false;
        if ((n & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPublic(int n) {
        boolean bl = false;
        if ((n & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isStatic(int n) {
        boolean bl = false;
        if ((n & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isStrict(int n) {
        boolean bl = false;
        if ((n & 0x800) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isSynchronized(int n) {
        boolean bl = false;
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isTransient(int n) {
        boolean bl = false;
        if ((n & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isVolatile(int n) {
        boolean bl = false;
        if ((n & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    public static String toString(int n) {
        return Modifier.toString(n, new StringBuffer()).toString();
    }

    static StringBuffer toString(int n, StringBuffer stringBuffer) {
        if (Modifier.isPublic(n)) {
            stringBuffer.append("public ");
        }
        if (Modifier.isProtected(n)) {
            stringBuffer.append("protected ");
        }
        if (Modifier.isPrivate(n)) {
            stringBuffer.append("private ");
        }
        if (Modifier.isAbstract(n)) {
            stringBuffer.append("abstract ");
        }
        if (Modifier.isStatic(n)) {
            stringBuffer.append("static ");
        }
        if (Modifier.isFinal(n)) {
            stringBuffer.append("final ");
        }
        if (Modifier.isTransient(n)) {
            stringBuffer.append("transient ");
        }
        if (Modifier.isVolatile(n)) {
            stringBuffer.append("volatile ");
        }
        if (Modifier.isSynchronized(n)) {
            stringBuffer.append("synchronized ");
        }
        if (Modifier.isNative(n)) {
            stringBuffer.append("native ");
        }
        if (Modifier.isStrict(n)) {
            stringBuffer.append("strictfp ");
        }
        if (Modifier.isInterface(n)) {
            stringBuffer.append("interface ");
        }
        if ((n & 0xFFF) != 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer;
    }
}

