/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_LIST_H__
#define __SG_LIST_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define SG_LIST(obj)        GTK_CHECK_CAST (obj, sg_list_get_type (), SGlist)
#define GTK_TYPE_SG_LIST        (sg_list_get_type ())
#define SG_LIST_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_list_get_type(), SGlistClass)
#define GTK_IS_SG_LIST(obj)     GTK_CHECK_TYPE (obj, sg_list_get_type ())


typedef struct _SGlist          SGlist;
typedef struct _SGlistClass     SGlistClass;
typedef struct _SGlistChild     SGlistChild;

struct _SGlistChild
{
  GObject *object;
  gchar *name;
  gint id;
};

struct _SGlist
{
  GObject object;

  GList *list;
  gint n;
};

struct _SGlistClass
{
  GObjectClass parent_class;
};


GType		sg_list_get_type	(void);
SGlist*		sg_list_new		(void);
SGlistChild *	sg_list_add		(SGlist *list,
					 GObject *object,
					 const gchar *name);
gboolean	sg_list_remove		(SGlist *list,
					 GObject *object);
gboolean	sg_list_set_name	(SGlist *list,
					 GObject *object,
					 const gchar *name);
SGlistChild*	sg_list_find		(SGlist *list,
					 GObject *object);
GObject*	sg_list_get		(SGlist *list,
					 const gchar *name);
GObject*	sg_list_get_by_id	(SGlist *list,
					 gint id);
void		sg_list_clear		(SGlist *set);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_LIST_H__ */
