# Configure paths for SG+
# Owen Taylor     1997-2001

dnl AM_PATH_SG_2_0([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for SG+, and define SG_CFLAGS and SG_LIBS, if gthread is specified in MODULES, 
dnl pass to pkg-config
dnl
AC_DEFUN([AM_PATH_SG_2_0],
[dnl 
dnl Get the cflags and libraries from pkg-config
dnl
AC_ARG_ENABLE(libscigraphicatest, [  --disable-libscigraphicatest       do not try to compile and run a test SG+ program],
		    , enable_libscigraphicatest=yes)

  pkg_config_args=libscigraphica-2.0
  for module in . $4
  do
      case "$module" in
         gthread) 
             pkg_config_args="$pkg_config_args gthread-2.0"
         ;;
      esac
  done

  no_libscigraphica=""

  AC_PATH_PROG(PKG_CONFIG, pkg-config, no)

  if test x$PKG_CONFIG != xno ; then
    if pkg-config --atleast-pkgconfig-version 0.7 ; then
      :
    else
      echo "*** pkg-config too old; version 0.7 or better required."
      no_libscigraphica=yes
      PKG_CONFIG=no
    fi
  else
    no_libscigraphica=yes
  fi

  min_libscigraphica_version=ifelse([$1], ,2.0.0,$1)
  AC_MSG_CHECKING(for SG+ - version >= $min_libscigraphica_version)

  if test x$PKG_CONFIG != xno ; then
    ## don't try to run the test against uninstalled libtool libs
    if $PKG_CONFIG --uninstalled $pkg_config_args; then
	  echo "Will use uninstalled version of SG+ found in PKG_CONFIG_PATH"
	  enable_libscigraphicatest=no
    fi

    if $PKG_CONFIG --atleast-version $min_libscigraphica_version $pkg_config_args; then
	  :
    else
	  no_libscigraphica=yes
    fi
  fi

  if test x"$no_libscigraphica" = x ; then
    SG_CFLAGS=`$PKG_CONFIG $pkg_config_args --cflags`
    SG_LIBS=`$PKG_CONFIG $pkg_config_args --libs`
    libscigraphica_config_major_version=`$PKG_CONFIG --modversion libscigraphica-2.0 | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    libscigraphica_config_minor_version=`$PKG_CONFIG --modversion libscigraphica-2.0 | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    libscigraphica_config_micro_version=`$PKG_CONFIG --modversion libscigraphica-2.0 | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_libscigraphicatest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $SG_CFLAGS"
      LIBS="$SG_LIBS $LIBS"
dnl
dnl Now check if the installed SG+ is sufficiently new. (Also sanity
dnl checks the results of pkg-config to some extent)
dnl
      rm -f conf.libscigraphicatest
      AC_TRY_RUN([
#include <libscigraphica/libscigraphica.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.libscigraphicatest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_libscigraphica_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_libscigraphica_version");
     exit(1);
   }

  if ((libscigraphica_major_version != $libscigraphica_config_major_version) ||
      (libscigraphica_minor_version != $libscigraphica_config_minor_version) ||
      (libscigraphica_micro_version != $libscigraphica_config_micro_version))
    {
      printf("\n*** 'pkg-config --modversion libscigraphica-2.0' returned %d.%d.%d, but SG+ (%d.%d.%d)\n", 
             $libscigraphica_config_major_version, $libscigraphica_config_minor_version, $libscigraphica_config_micro_version,
             libscigraphica_major_version, libscigraphica_minor_version, libscigraphica_micro_version);
      printf ("*** was found! If pkg-config was correct, then it is best\n");
      printf ("*** to remove the old version of SG+. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If pkg-config was wrong, set the environment variable PKG_CONFIG_PATH\n");
      printf("*** to point to the correct configuration files\n");
    } 
  else if ((libscigraphica_major_version != SG_MAJOR_VERSION) ||
	   (libscigraphica_minor_version != SG_MINOR_VERSION) ||
           (libscigraphica_micro_version != SG_MICRO_VERSION))
    {
      printf("*** SG+ header files (version %d.%d.%d) do not match\n",
	     SG_MAJOR_VERSION, SG_MINOR_VERSION, SG_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     libscigraphica_major_version, libscigraphica_minor_version, libscigraphica_micro_version);
    }
  else
    {
      if ((libscigraphica_major_version > major) ||
        ((libscigraphica_major_version == major) && (libscigraphica_minor_version > minor)) ||
        ((libscigraphica_major_version == major) && (libscigraphica_minor_version == minor) && (libscigraphica_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of SG+ (%d.%d.%d) was found.\n",
               libscigraphica_major_version, libscigraphica_minor_version, libscigraphica_micro_version);
        printf("*** You need a version of SG+ newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** SG+ is always available from ftp://ftp.libscigraphica.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the pkg-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of SG+, but you can also set the PKG_CONFIG environment to point to the\n");
        printf("*** correct copy of pkg-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_libscigraphica=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_libscigraphica" = x ; then
     AC_MSG_RESULT(yes (version $libscigraphica_config_major_version.$libscigraphica_config_minor_version.$libscigraphica_config_micro_version))
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$PKG_CONFIG" = "no" ; then
       echo "*** A new enough version of pkg-config was not found."
       echo "*** See http://pkgconfig.sourceforge.net"
     else
       if test -f conf.libscigraphicatest ; then
        :
       else
          echo "*** Could not run SG+ test program, checking why..."
	  ac_save_CFLAGS="$CFLAGS"
	  ac_save_LIBS="$LIBS"
          CFLAGS="$CFLAGS $SG_CFLAGS"
          LIBS="$LIBS $SG_LIBS"
          AC_TRY_LINK([
#include <libscigraphica/libscigraphica.h>
#include <stdio.h>
],      [ return ((libscigraphica_major_version) || (libscigraphica_minor_version) || (libscigraphica_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding SG+ or finding the wrong"
          echo "*** version of SG+. If it is not finding SG+, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means SG+ is incorrectly installed."])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     SG_CFLAGS=""
     SG_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(SG_CFLAGS)
  AC_SUBST(SG_LIBS)
  rm -f conf.libscigraphicatest
])
