/**
 * Competency picker.
 *
 * To handle 'save' events use: picker.on('save')
 * This will receive a object with either a single 'competencyId', or an array in 'competencyIds'
 * depending on the value of multiSelect.
 *
 * @module     tool_lp/competencypicker
 * @copyright  2015 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/competencypicker",["jquery","core/notification","core/ajax","core/templates","tool_lp/dialogue","core/str","tool_lp/tree","core/pending"],(function($,Notification,Ajax,Templates,Dialogue,Str,Tree,Pending){var Picker=function(pageContextId,singleFramework,pageContextIncludes,multiSelect){this._eventNode=$("<div></div>"),this._frameworks=[],this._reset(),this._pageContextId=pageContextId,this._pageContextIncludes=pageContextIncludes||"children",this._multiSelect=void 0===multiSelect||!0===multiSelect,singleFramework&&(this._frameworkId=singleFramework,this._singleFramework=!0)};return Picker.prototype._competencies=null,Picker.prototype._disallowedCompetencyIDs=null,Picker.prototype._eventNode=null,Picker.prototype._frameworks=null,Picker.prototype._frameworkId=null,Picker.prototype._pageContextId=null,Picker.prototype._pageContextIncludes=null,Picker.prototype._popup=null,Picker.prototype._searchText="",Picker.prototype._selectedCompetencies=null,Picker.prototype._singleFramework=!1,Picker.prototype._multiSelect=!0,Picker.prototype._onlyVisible=!0,Picker.prototype._afterRender=function(){var self=this,tree=new Tree(self._find("[data-enhance=linktree]"),self._multiSelect);self._find("[data-enhance=linktree]").show(),tree.on("selectionchanged",(function(evt,params){var selected=params.selected;evt.preventDefault();var validIds=[];$.each(selected,(function(index,item){var compId=$(item).data("id"),valid=!0;void 0===compId?valid=!1:$.each(self._disallowedCompetencyIDs,(function(i,id){id==compId&&(valid=!1)})),valid&&validIds.push(compId)})),self._selectedCompetencies=validIds,self._selectedCompetencies.length?self._find('[data-region="competencylinktree"] [data-action="add"]').removeAttr("disabled"):self._find('[data-region="competencylinktree"] [data-action="add"]').attr("disabled","disabled")})),self._singleFramework||self._find('[data-action="chooseframework"]').change((function(e){self._frameworkId=$(e.target).val(),self._loadCompetencies().then(self._refresh.bind(self)).catch(Notification.exception)})),self._find('[data-region="filtercompetencies"] button').click((function(e){return e.preventDefault(),$(e.target).attr("disabled","disabled"),self._searchText=self._find('[data-region="filtercompetencies"] input').val()||"",self._refresh().always((function(){$(e.target).removeAttr("disabled")}))})),self._find('[data-region="competencylinktree"] [data-action="cancel"]').click((function(e){e.preventDefault(),self.close()})),self._find('[data-region="competencylinktree"] [data-action="add"]').click((function(e){e.preventDefault();var pendingPromise=new Pending;self._selectedCompetencies.length&&(self._multiSelect?self._trigger("save",{competencyIds:self._selectedCompetencies}):self._trigger("save",{competencyId:self._selectedCompetencies[0]}),self.close(),pendingPromise.resolve())}));var currentItems=self._selectedCompetencies.slice(0);$.each(currentItems,(function(index,id){var node=self._find("[data-id="+id+"]");node.length&&(tree.toggleItem(node),tree.updateFocus(node))}))},Picker.prototype.close=function(){this._popup.close(),this._reset()},Picker.prototype.display=function(){var self=this;return $.when(Str.get_string("competencypicker","tool_lp"),self._render()).then((function(title,render){self._popup=new Dialogue(title,render[0],self._afterRender.bind(self))})).catch(Notification.exception)},Picker.prototype._fetchCompetencies=function(frameworkId,searchText){var self=this;return Ajax.call([{methodname:"core_competency_search_competencies",args:{searchtext:searchText,competencyframeworkid:frameworkId}}])[0].done((function(competencies){function addCompetencyChildren(parent,competencies){for(var i=0;i<competencies.length;i++)competencies[i].parentid==parent.id&&(parent.haschildren=!0,competencies[i].children=[],competencies[i].haschildren=!1,parent.children[parent.children.length]=competencies[i],addCompetencyChildren(competencies[i],competencies))}var i,comp,tree=[];for(i=0;i<competencies.length;i++)"0"==(comp=competencies[i]).parentid&&(comp.children=[],comp.haschildren=0,tree[tree.length]=comp,addCompetencyChildren(comp,competencies));self._competencies=tree})).fail(Notification.exception)},Picker.prototype._find=function(selector){return $(this._popup.getContent()).find(selector)},Picker.prototype._getFramework=function(fid){var frm;return $.each(this._frameworks,(function(i,f){f.id!=fid||(frm=f)})),frm},Picker.prototype._loadCompetencies=function(){return this._fetchCompetencies(this._frameworkId,this._searchText)},Picker.prototype._loadFrameworks=function(){var self=this;return self._frameworks.length>0?$.when():(self._singleFramework?Ajax.call([{methodname:"core_competency_read_competency_framework",args:{id:this._frameworkId}}])[0].then((function(framework){return[framework]})):Ajax.call([{methodname:"core_competency_list_competency_frameworks",args:{sort:"shortname",context:{contextid:self._pageContextId},includes:self._pageContextIncludes,onlyvisible:self._onlyVisible}}])[0]).done((function(frameworks){self._frameworks=frameworks})).fail(Notification.exception)},Picker.prototype.on=function(type,handler){this._eventNode.on(type,handler)},Picker.prototype._preRender=function(){var self=this;return self._loadFrameworks().then((function(){return!self._frameworkId&&self._frameworks.length>0&&(self._frameworkId=self._frameworks[0].id),self._frameworkId?self._loadCompetencies():(self._frameworks=[],$.when())}))},Picker.prototype._refresh=function(){var self=this;return self._render().then((function(html){self._find('[data-region="competencylinktree"]').replaceWith(html),self._afterRender()}))},Picker.prototype._render=function(){var self=this;return self._preRender().then((function(){self._singleFramework||$.each(self._frameworks,(function(i,framework){framework.id==self._frameworkId?framework.selected=!0:framework.selected=!1}));var context={competencies:self._competencies,framework:self._getFramework(self._frameworkId),frameworks:self._frameworks,search:self._searchText,singleFramework:self._singleFramework};return Templates.render("tool_lp/competency_picker",context)}))},Picker.prototype._reset=function(){this._competencies=[],this._disallowedCompetencyIDs=[],this._popup=null,this._searchText="",this._selectedCompetencies=[]},Picker.prototype.setDisallowedCompetencyIDs=function(ids){this._disallowedCompetencyIDs=ids},Picker.prototype._trigger=function(type,data){this._eventNode.trigger(type,[data])},Picker}));

//# sourceMappingURL=competencypicker.min.js.map