/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.ClosedShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.claribole.zvtm.glyphs.projection.ProjPolygon;

public class VPolygon
extends ClosedShape {
    long vs;
    ProjPolygon[] pc;
    double[] xcoords;
    double[] ycoords;
    double[] lxcoords;
    double[] lycoords;

    public VPolygon(LongPoint[] v, Color c) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.xcoords = new double[v.length];
        this.ycoords = new double[v.length];
        this.lxcoords = new double[v.length];
        this.lycoords = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.xcoords[i] = v[i].x;
            this.ycoords[i] = v[i].y;
        }
        this.orient = 0.0f;
        LongPoint ct = this.getCentroid();
        this.vx = ct.x;
        this.vy = ct.y;
        int i = 0;
        while (i < this.xcoords.length) {
            int n = i;
            this.xcoords[n] = this.xcoords[n] - (double)this.vx;
            int n2 = i++;
            this.ycoords[n2] = this.ycoords[n2] - (double)this.vy;
        }
        this.computeSize();
        this.setColor(c);
        this.setBorderColor(Color.black);
    }

    public VPolygon(LongPoint[] v, Color c, Color bc) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.xcoords = new double[v.length];
        this.ycoords = new double[v.length];
        this.lxcoords = new double[v.length];
        this.lycoords = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.xcoords[i] = v[i].x;
            this.ycoords[i] = v[i].y;
        }
        this.orient = 0.0f;
        LongPoint ct = this.getCentroid();
        this.vx = ct.x;
        this.vy = ct.y;
        int i = 0;
        while (i < this.xcoords.length) {
            int n = i;
            this.xcoords[n] = this.xcoords[n] - (double)this.vx;
            int n2 = i++;
            this.ycoords[n2] = this.ycoords[n2] - (double)this.vy;
        }
        this.computeSize();
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public VPolygon(LongPoint[] v, int z, Color c) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = z;
        this.xcoords = new double[v.length];
        this.ycoords = new double[v.length];
        this.lxcoords = new double[v.length];
        this.lycoords = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.xcoords[i] = v[i].x;
            this.ycoords[i] = v[i].y;
        }
        this.orient = 0.0f;
        LongPoint ct = this.getCentroid();
        this.vx = ct.x;
        this.vy = ct.y;
        int i = 0;
        while (i < this.xcoords.length) {
            int n = i;
            this.xcoords[n] = this.xcoords[n] - (double)this.vx;
            int n2 = i++;
            this.ycoords[n2] = this.ycoords[n2] - (double)this.vy;
        }
        this.computeSize();
        this.setColor(c);
        this.setBorderColor(Color.black);
    }

    public VPolygon(LongPoint[] v, int z, Color c, Color bc) {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = z;
        this.xcoords = new double[v.length];
        this.ycoords = new double[v.length];
        this.lxcoords = new double[v.length];
        this.lycoords = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.xcoords[i] = v[i].x;
            this.ycoords[i] = v[i].y;
        }
        this.orient = 0.0f;
        LongPoint ct = this.getCentroid();
        this.vx = ct.x;
        this.vy = ct.y;
        int i = 0;
        while (i < this.xcoords.length) {
            int n = i;
            this.xcoords[n] = this.xcoords[n] - (double)this.vx;
            int n2 = i++;
            this.ycoords[n2] = this.ycoords[n2] - (double)this.vy;
        }
        this.computeSize();
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public void initCams(int nbCam) {
        this.pc = new ProjPolygon[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjPolygon(this.xcoords.length);
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjPolygon[] ta = this.pc;
                this.pc = new ProjPolygon[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjPolygon(this.xcoords.length);
            } else {
                System.err.println("VPolygon:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjPolygon[1];
            this.pc[0] = new ProjPolygon(this.xcoords.length);
        } else {
            System.err.println("VPolygon:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return this.size;
    }

    synchronized void computeSize() {
        this.size = 0.0f;
        for (int i = 0; i < this.xcoords.length; ++i) {
            double f = Math.sqrt(Math.pow(this.xcoords[i], 2.0) + Math.pow(this.ycoords[i], 2.0));
            if (!(f > (double)this.size)) continue;
            this.size = (float)f;
        }
        this.vs = Math.round(this.size);
    }

    public synchronized void sizeTo(float radius) {
        double ratio = (double)radius / (double)this.size;
        this.size = 0.0f;
        for (int i = 0; i < this.xcoords.length; ++i) {
            this.xcoords[i] = this.xcoords[i] * ratio;
            this.ycoords[i] = this.ycoords[i] * ratio;
            double f = Math.sqrt(Math.pow(this.xcoords[i], 2.0) + Math.pow(this.ycoords[i], 2.0));
            if (!(f > (double)this.size)) continue;
            this.size = (float)f;
        }
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public synchronized void reSize(float factor) {
        this.size = 0.0f;
        for (int i = 0; i < this.xcoords.length; ++i) {
            this.xcoords[i] = this.xcoords[i] * (double)factor;
            this.ycoords[i] = this.ycoords[i] * (double)factor;
            double f = Math.sqrt(Math.pow(this.xcoords[i], 2.0) + Math.pow(this.ycoords[i], 2.0));
            if (!(f > (double)this.size)) continue;
            this.size = (float)f;
        }
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return this.pc[camIndex].p.contains(0, 0) && this.pc[camIndex].p.contains(w, 0.0) && this.pc[camIndex].p.contains(0.0, h) && this.pc[camIndex].p.contains(w, h);
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public LongPoint[] getVertices() {
        LongPoint[] res = new LongPoint[this.xcoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            res[i] = new LongPoint(Math.round(this.xcoords[i]), Math.round(this.ycoords[i]));
        }
        return res;
    }

    public LongPoint[] getAbsoluteVertices() {
        LongPoint[] res = new LongPoint[this.xcoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            res[i] = new LongPoint(Math.round(this.xcoords[i] + (double)this.vx), Math.round(this.ycoords[i] + (double)this.vy));
        }
        return res;
    }

    public String getVerticesAsText() {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < this.xcoords.length - 1; ++i) {
            res.append(Math.round(this.xcoords[i] + (double)this.vx) + "," + Math.round(this.ycoords[i] + (double)this.vy) + ";");
        }
        res.append(Math.round(this.xcoords[this.xcoords.length - 1] + (double)this.vx) + "," + Math.round(this.ycoords[this.ycoords.length - 1] + (double)this.vy));
        return res.toString();
    }

    public void project(Camera c, Dimension d) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cr = Math.round((float)this.vs * this.coef);
        for (j = 0; j < this.xcoords.length; ++j) {
            this.pc[i].xpcoords[j] = (int)Math.round((double)this.pc[i].cx + this.xcoords[j] * (double)this.coef);
            this.pc[i].ypcoords[j] = (int)Math.round((double)this.pc[i].cy - this.ycoords[j] * (double)this.coef);
        }
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(this.pc[i].xpcoords, this.pc[i].ypcoords, this.xcoords.length);
        } else {
            this.pc[i].p.npoints = this.xcoords.length;
            for (j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = this.pc[i].xpcoords[j];
                this.pc[i].p.ypoints[j] = this.pc[i].ypcoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcr = Math.round((float)this.vs * this.coef);
        for (j = 0; j < this.xcoords.length; ++j) {
            this.pc[i].lxpcoords[j] = (int)Math.round((double)this.pc[i].lcx + this.xcoords[j] * (double)this.coef);
            this.pc[i].lypcoords[j] = (int)Math.round((double)this.pc[i].lcy - this.ycoords[j] * (double)this.coef);
        }
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(this.pc[i].lxpcoords, this.pc[i].lypcoords, this.xcoords.length);
        } else {
            this.pc[i].lp.npoints = this.xcoords.length;
            for (j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = this.pc[i].lxpcoords[j];
                this.pc[i].lp.ypoints[j] = this.pc[i].lypcoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fillPolygon(this.pc[i].p);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fillPolygon(this.pc[i].lp);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.drawPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public double getArea() {
        double[] xcoordsForArea = new double[this.xcoords.length];
        double[] ycoordsForArea = new double[this.ycoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            xcoordsForArea[i] = (double)this.vx + this.xcoords[i];
            ycoordsForArea[i] = (double)this.vy + this.ycoords[i];
        }
        double res = 0.0;
        for (int j = 0; j < this.xcoords.length; ++j) {
            int k = (j + 1) % this.xcoords.length;
            res += xcoordsForArea[j] * ycoordsForArea[k] - ycoordsForArea[j] * xcoordsForArea[k];
        }
        return (res /= 2.0) < 0.0 ? -res : res;
    }

    public Point2D.Double getPreciseCentroid() {
        int k;
        int j;
        double[] xcoordsForArea = new double[this.xcoords.length];
        double[] ycoordsForArea = new double[this.ycoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            xcoordsForArea[i] = (double)this.vx + this.xcoords[i];
            ycoordsForArea[i] = (double)this.vy + this.ycoords[i];
        }
        double area = 0.0;
        for (j = 0; j < this.xcoords.length; ++j) {
            k = (j + 1) % this.xcoords.length;
            area += xcoordsForArea[j] * ycoordsForArea[k] - ycoordsForArea[j] * xcoordsForArea[k];
        }
        area /= 2.0;
        double factor = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        for (j = 0; j < this.xcoords.length; ++j) {
            k = (j + 1) % this.xcoords.length;
            factor = xcoordsForArea[j] * ycoordsForArea[k] - xcoordsForArea[k] * ycoordsForArea[j];
            cx += (xcoordsForArea[j] + xcoordsForArea[k]) * factor;
            cy += (ycoordsForArea[j] + ycoordsForArea[k]) * factor;
        }
        factor = 1.0 / (area *= 6.0);
        Point2D.Double res = new Point2D.Double(cx *= factor, cy *= factor);
        return res;
    }

    public LongPoint getCentroid() {
        Point2D.Double p2dd = this.getPreciseCentroid();
        return new LongPoint(Math.round(p2dd.getX()), Math.round(p2dd.getY()));
    }

    public Object clone() {
        LongPoint[] lps = new LongPoint[this.xcoords.length];
        for (int i = 0; i < lps.length; ++i) {
            lps[i] = new LongPoint(Math.round(this.xcoords[i] + (double)this.vx), Math.round(this.ycoords[i] + (double)this.vy));
        }
        VPolygon res = new VPolygon(lps, this.color);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

