/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.svg;

import com.xerox.VTM.svg.Context;
import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;

public class SVGStyle {
    public static short CSS_FONT_WEIGHT_NORMAL = 0;
    public static short CSS_FONT_WEIGHT_BOLD = 1;
    public static short CSS_FONT_WEIGHT_BOLDER = (short)2;
    public static short CSS_FONT_WEIGHT_LIGHTER = (short)3;
    public static short CSS_FONT_WEIGHT_100 = (short)4;
    public static short CSS_FONT_WEIGHT_200 = (short)5;
    public static short CSS_FONT_WEIGHT_300 = (short)6;
    public static short CSS_FONT_WEIGHT_400 = 0;
    public static short CSS_FONT_WEIGHT_500 = (short)7;
    public static short CSS_FONT_WEIGHT_600 = (short)8;
    public static short CSS_FONT_WEIGHT_700 = 1;
    public static short CSS_FONT_WEIGHT_800 = (short)9;
    public static short CSS_FONT_WEIGHT_900 = (short)10;
    public static short CSS_FONT_STYLE_NORMAL = 0;
    public static short CSS_FONT_STYLE_ITALIC = 1;
    public static short CSS_FONT_STYLE_OBLIQUE = (short)2;
    protected Color fillColor;
    protected Color strokeColor;
    protected boolean fillColorDefined = false;
    protected boolean strokeColorDefined = false;
    protected Float strokeWidth;
    protected float[] strokeDashArray;
    protected Float alphaValue;
    protected String font_family;
    protected String font_size;
    protected String font_weight;
    protected String font_style;

    public SVGStyle() {
    }

    public SVGStyle(Color c1, Color c2) {
        this.fillColor = c1;
        this.strokeColor = c2;
        this.fillColorDefined = this.fillColor != null;
        this.strokeColorDefined = this.strokeColor != null;
    }

    public SVGStyle(Color c1, Color c2, Float a) {
        this(c1, c2);
        this.alphaValue = a;
    }

    public boolean hasStylingInformation() {
        return this.hasFillColorInformation() || this.hasStrokeColorInformation() || this.hasTransparencyInformation() || this.requiresSpecialStroke() || this.font_family != null || this.font_size != null || this.font_weight != null || this.font_style != null;
    }

    public boolean hasTransparencyInformation() {
        return this.alphaValue != null;
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
        this.fillColorDefined = true;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public boolean hasFillColorInformation() {
        return this.fillColorDefined;
    }

    public void setStrokeColor(Color c) {
        this.strokeColor = c;
        this.strokeColorDefined = true;
    }

    public void setBorderColor(Color c) {
        this.setStrokeColor(c);
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public Color getBorderColor() {
        return this.getStrokeColor();
    }

    public boolean hasStrokeColorInformation() {
        return this.strokeColorDefined;
    }

    public boolean hasBorderColorInformation() {
        return this.hasStrokeColorInformation();
    }

    public void setAlphaTransparencyValue(Float f) {
        this.alphaValue = f;
    }

    public float getAlphaTransparencyValue() {
        if (this.alphaValue != null) {
            return this.alphaValue.floatValue();
        }
        return 1.0f;
    }

    public void setStrokeWidth(String width) {
        if (width != null && width.length() > 0) {
            if (width.endsWith("px")) {
                width = width.substring(0, width.length() - 2);
            }
            try {
                this.strokeWidth = new Float(width);
                if (this.strokeWidth.floatValue() == 1.0f) {
                    this.strokeWidth = null;
                }
            }
            catch (NumberFormatException ex) {
                this.strokeWidth = null;
            }
        } else {
            this.strokeWidth = null;
        }
    }

    public Float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeDashArray(String dashArray) {
        if (dashArray != null && !dashArray.equals("none")) {
            StringTokenizer st = new StringTokenizer(dashArray, ",");
            this.strokeDashArray = new float[st.countTokens()];
            int i = 0;
            String s = null;
            while (st.hasMoreTokens()) {
                try {
                    s = st.nextToken();
                    if (s.endsWith("px")) {
                        s = s.substring(0, s.length() - 2);
                    }
                    this.strokeDashArray[i++] = Float.parseFloat(s);
                }
                catch (NumberFormatException ex) {
                    this.strokeDashArray[i - 1] = 1.0f;
                    System.err.println("Style: Error while parsing a stroke dash array: " + s + " is not a positive float value");
                }
            }
            if (this.strokeDashArray.length == 0) {
                this.strokeDashArray = null;
            } else {
                if (this.strokeDashArray.length % 2 != 0) {
                    float[] tmpArray = new float[this.strokeDashArray.length * 2];
                    System.arraycopy(this.strokeDashArray, 0, tmpArray, 0, this.strokeDashArray.length);
                    System.arraycopy(this.strokeDashArray, 0, tmpArray, this.strokeDashArray.length, this.strokeDashArray.length);
                    this.strokeDashArray = tmpArray;
                }
                boolean nonZero = false;
                for (int j = 0; j < this.strokeDashArray.length; ++j) {
                    if (this.strokeDashArray[j] == 0.0f) continue;
                    nonZero = true;
                    break;
                }
                if (!nonZero) {
                    this.strokeDashArray = null;
                }
            }
        } else {
            this.strokeDashArray = null;
        }
    }

    public float[] getStrokeDashArray() {
        return this.strokeDashArray;
    }

    public boolean requiresSpecialStroke() {
        return this.strokeWidth != null || this.strokeDashArray != null;
    }

    public void setFontFamily(String family) {
        this.font_family = family;
    }

    public void setFontSize(String size) {
        this.font_size = size;
        if (this.font_size != null && this.font_size.endsWith("pt")) {
            this.font_size = this.font_size.substring(0, this.font_size.length() - 2);
        }
    }

    public void setFontWeight(String weight) {
        this.font_weight = weight;
    }

    public void setFontStyle(String style) {
        this.font_style = style;
    }

    Font getDefinedFont(Context ctx) {
        String rfont_weight;
        String rfont_style;
        int size;
        String fam;
        String string = this.font_family != null ? this.font_family : (fam = ctx != null ? ctx.font_family : null);
        if (fam == null) {
            fam = "Default";
        }
        if (this.font_size != null) {
            try {
                size = Math.round(Float.parseFloat(this.font_size));
            }
            catch (NumberFormatException ex) {
                System.err.println("Warning: Font size value not supported (using default): " + this.font_size);
                size = 10;
            }
        } else if (ctx != null && ctx.font_size != null) {
            try {
                size = Math.round(Float.parseFloat(ctx.font_size));
            }
            catch (NumberFormatException ex) {
                System.err.println("Warning: Font size value not supported (using default): " + ctx.font_size);
                size = 10;
            }
        } else {
            size = 10;
        }
        String string2 = this.font_style != null ? this.font_style : (rfont_style = ctx != null ? ctx.font_style : null);
        String string3 = this.font_weight != null ? this.font_weight : (rfont_weight = ctx != null ? ctx.font_weight : null);
        int style = rfont_style != null && rfont_style.equals("italic") ? (rfont_weight != null && rfont_weight.equals("bold") ? 3 : 2) : (rfont_weight != null && rfont_weight.equals("bold") ? 1 : 0);
        return SVGReader.getFont(fam, style, size);
    }
}

