/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VRectangleST;
import java.awt.Color;
import net.claribole.zvtm.engine.FadeIn;
import net.claribole.zvtm.engine.FadeOut;

public class TransitionManager {
    static final float[] fadeOutData = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    static final float[] fadeInData = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f};

    public static void fadeOut(View v, int duration, Color fadeColor, VirtualSpaceManager vsm) {
        TransitionManager.fadeOut(v, duration, fadeColor, vsm, null);
    }

    public static void fadeOut(View v, int duration, Color fadeColor, VirtualSpaceManager vsm, FadeOut actions) {
        if (v.isBlank() != null) {
            return;
        }
        Camera c = v.getCameraNumber(v.getLayerCount() - 1);
        long[] wnes = v.getVisibleRegion(c);
        VRectangleST fadeRect = new VRectangleST((wnes[0] + wnes[2]) / 2L, (wnes[1] + wnes[3]) / 2L, 0, (wnes[2] - wnes[0]) / 2L, (wnes[1] - wnes[3]) / 2L, fadeColor, fadeColor, 0.0f);
        fadeRect.setDrawBorder(false);
        vsm.addGlyph((Glyph)fadeRect, c.getOwningSpace());
        vsm.animator.createGlyphAnimation((long)duration, (short)9, fadeOutData, fadeRect.getID(), actions != null ? actions : new FadeOut(v, fadeColor, c.getOwningSpace()));
    }

    public static void fadeIn(View v, int duration, VirtualSpaceManager vsm) {
        TransitionManager.fadeIn(v, duration, vsm, null);
    }

    public static void fadeIn(View v, int duration, VirtualSpaceManager vsm, FadeIn actions) {
        Color fadeColor = v.isBlank();
        if (fadeColor == null) {
            return;
        }
        Camera c = v.getCameraNumber(v.getLayerCount() - 1);
        long[] wnes = v.getVisibleRegion(c);
        VRectangleST fadeRect = new VRectangleST((wnes[0] + wnes[2]) / 2L, (wnes[1] + wnes[3]) / 2L, 0, (wnes[2] - wnes[0]) / 2L, (wnes[1] - wnes[3]) / 2L, fadeColor, fadeColor, 1.0f);
        fadeRect.setDrawBorder(false);
        vsm.addGlyph((Glyph)fadeRect, c.getOwningSpace());
        v.setBlank(null);
        vsm.repaintNow();
        vsm.animator.createGlyphAnimation((long)duration, (short)9, fadeInData, fadeRect.getID(), actions != null ? actions : new FadeIn(v, c.getOwningSpace()));
    }
}

