/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import com.xerox.VTM.glyphs.Translucent;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;
import net.claribole.zvtm.engine.LowPassFilter;
import net.claribole.zvtm.glyphs.Translucency;
import net.claribole.zvtm.lens.LPDLTrailingTimer;
import net.claribole.zvtm.lens.LPFSGaussianLens;
import net.claribole.zvtm.lens.TemporalLens;

public class LPDGaussianLens
extends LPFSGaussianLens
implements TemporalLens {
    double frequency = -1.0;
    long mLastSampleTime = -1L;
    int xOffset = -10;
    int yOffset = 10;
    double maxDist = 2 * Math.abs(this.xOffset);
    LowPassFilter filter = new LowPassFilter();
    Point2D currentPos = new Point2D.Double(0.0, 0.0);
    Point2D parentPos = new Point2D.Double(0.0, 0.0);
    Point2D targetPos = new Point2D.Double(0.0, 0.0);
    Timer timer;
    LPDLTrailingTimer mouseStillUpdater;
    double cutoffParamA = 0.1;
    double cutoffParamB = 0.001;
    float a = 1.0f;
    float b = 0.0f;
    BasicStroke bs = new BasicStroke(2.0f);
    Stroke os;

    public LPDGaussianLens() {
        this.initTimer();
    }

    public LPDGaussianLens(float mm, float lp, float minLp, float maxLp) {
        super(mm, lp);
        this.computeLPFactors(minLp, maxLp);
        this.initTimer();
    }

    public LPDGaussianLens(float mm, float lp, float minLp, float maxLp, int outerRadius, int innerRadius) {
        super(mm, lp, outerRadius, innerRadius);
        this.computeLPFactors(minLp, maxLp);
        this.initTimer();
    }

    public LPDGaussianLens(float mm, float lp, float minLp, float maxLp, int outerRadius, int innerRadius, int x, int y) {
        super(mm, lp, outerRadius, innerRadius, x, y);
        this.computeLPFactors(minLp, maxLp);
        this.initTimer();
    }

    void computeLPFactors(float minLp, float maxLp) {
        this.a = maxLp - minLp;
        this.b = minLp;
    }

    void initTimer() {
        this.timer = new Timer();
        this.mouseStillUpdater = new LPDLTrailingTimer(this);
        this.timer.scheduleAtFixedRate((TimerTask)this.mouseStillUpdater, 40L, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAbsolutePosition(int ax, int ay, long absTime) {
        LPDGaussianLens lPDGaussianLens = this;
        synchronized (lPDGaussianLens) {
            super.setAbsolutePosition(ax, ay);
            this.updateFrequency(absTime);
            this.updateTimeBasedParams(ax, ay);
        }
    }

    public void updateFrequency() {
        this.updateFrequency(System.currentTimeMillis());
    }

    public void updateFrequency(long currentTime) {
        if (this.frequency == -1.0) {
            this.frequency = 1.0;
        } else if (currentTime != this.mLastSampleTime) {
            this.frequency = 1000.0 / (double)(currentTime - this.mLastSampleTime);
        }
        this.mLastSampleTime = currentTime;
    }

    public void updateTimeBasedParams(int cx, int cy) {
        this.parentPos.setLocation(cx, cy);
        this.updateTimeBasedParams();
    }

    public void updateTimeBasedParams() {
        this.targetPos.setLocation(this.parentPos.getX() + (double)this.xOffset, this.parentPos.getY() + (double)this.yOffset);
        double distAway = this.targetPos.distance(this.currentPos);
        double opacity = 1.0 - Math.min(1.0, distAway / this.maxDist);
        this.filter.setCutOffFrequency((1.0 - opacity) * this.cutoffParamA + this.cutoffParamB);
        this.currentPos = this.filter.apply(this.targetPos, this.frequency);
        int tx = (int)Math.round(this.currentPos.getX());
        int ty = (int)Math.round(this.currentPos.getY());
        tx = Math.max(tx, this.w / 2);
        ty = Math.min(ty, this.owningView.parent.getPanelSize().height - this.h / 2);
        float nLp = (float)opacity * this.a + this.b;
        if (Math.abs(nLp - this.P) > 0.01f) {
            this.setDistanceMetrics(nLp);
            this.owningView.parent.repaintNow();
        }
    }

    public void setCutoffFrequencyParameters(double a, double b) {
        this.cutoffParamA = a;
        this.cutoffParamB = b;
    }

    public void setNoUpdateWhenMouseStill(boolean b) {
        this.mouseStillUpdater.setEnabled(!b);
    }

    public void dispose() {
        super.dispose();
        this.timer.cancel();
    }

    public void drawBoundary(Graphics2D g2d) {
        g2d.setComposite(Translucency.acs[Math.round((1.0f - (this.P - this.b) / this.a) * 20.0f) - 1]);
        if (this.r1Color != null) {
            g2d.setColor(this.r1Color);
            this.os = g2d.getStroke();
            g2d.setStroke(this.bs);
            g2d.drawLine(this.lx + this.w / 2 - this.LR1, this.ly + this.h / 2, this.lx + this.w / 2 + this.LR1, this.ly + this.h / 2);
            g2d.drawLine(this.lx + this.w / 2, this.ly + this.h / 2 - this.LR1, this.lx + this.w / 2, this.ly + this.h / 2 + this.LR1);
            g2d.setStroke(this.os);
        }
        g2d.setComposite(Translucent.acO);
    }
}

